/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.gui.framework.Browser;
import net.yacy.kelondro.util.OS;
import net.yacy.search.Switchboard;

public final class Tray {
    private final Switchboard sb;
    private TrayIcon ti = null;
    private final String trayLabel;
    private static final boolean deutsch = System.getProperty("user.language", "").equals("de");
    private static final boolean french = System.getProperty("user.language", "").equals("fr");
    private boolean isShown = false;
    private boolean appIsReady = false;
    private boolean menuEnabled = true;
    private BufferedImage[] progressIcons = null;
    private final String iconPath;
    private MenuItem menuItemHeadline = null;
    private MenuItem menuItemSearch = null;
    private MenuItem menuItemAdministration = null;
    private MenuItem menuItemTerminate = null;
    private static Object applicationInstance;
    private static Method setDockIconImage;

    public Tray(Switchboard sb_par) {
        this.sb = sb_par;
        this.menuEnabled = this.sb.getConfigBool("tray.menu.enabled", true);
        this.trayLabel = this.sb.getConfig("tray.icon.label", "YaCy");
        this.iconPath = this.sb.getAppPath().toString() + "/addon/YaCy_TrayIcon.png".replace("/", File.separator);
        if (this.useTray()) {
            try {
                System.setProperty("java.awt.headless", "false");
                if (SystemTray.isSupported()) {
                    ActionListener al = e -> this.doubleClickAction();
                    ImageIO.setUseCache(false);
                    BufferedImage trayIcon = ImageIO.read(new File(this.iconPath));
                    BufferedImage progressBooting = ImageIO.read(new File(this.sb.getAppPath().toString() + "/addon/progress_booting.png".replace("/", File.separator)));
                    BufferedImage progress = this.getProgressImage();
                    this.progressIcons = new BufferedImage[4];
                    for (int i = 0; i < 4; ++i) {
                        this.progressIcons[i] = new BufferedImage(128, 128, 2);
                        Graphics2D h = this.progressIcons[i].createGraphics();
                        h.setBackground(Color.BLACK);
                        h.clearRect(0, 0, 128, 128);
                        h.drawImage(trayIcon, 0, 0, 128, 128 - progress.getHeight(), null);
                        h.drawImage((Image)progress.getSubimage(i * 7, 0, 128, progress.getHeight() / 2), 0, 128 - progress.getHeight() / 2, null);
                        h.drawImage((Image)progressBooting, 0, 128 - progress.getHeight(), null);
                        h.dispose();
                    }
                    PopupMenu menu = this.menuEnabled ? this.getPopupMenu() : null;
                    this.ti = new TrayIcon(trayIcon, this.trayLabel, menu);
                    if (OS.isMacArchitecture) {
                        Tray.setDockIcon(trayIcon);
                    }
                    this.ti.setImageAutoSize(true);
                    this.ti.addActionListener(al);
                    SystemTray.getSystemTray().add(this.ti);
                    this.isShown = true;
                    this.ti.setToolTip(this.startupMessage());
                    new TrayAnimation().start();
                } else {
                    System.setProperty("java.awt.headless", "true");
                }
            }
            catch (Throwable e2) {
                System.setProperty("java.awt.headless", "true");
            }
        }
    }

    private boolean useTray() {
        boolean trayIconEnabled = this.sb.getConfigBool("tray.icon.enabled", false);
        boolean trayIconForced = this.sb.getConfigBool("tray.icon.force", false);
        return trayIconEnabled && (OS.isWindows || OS.isMacArchitecture || trayIconForced);
    }

    private static void setDockIcon(Image icon) {
        if (!OS.isMacArchitecture || setDockIconImage == null || applicationInstance == null) {
            return;
        }
        try {
            setDockIconImage.invoke(applicationInstance, icon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setReady() {
        this.appIsReady = true;
        if (this.useTray()) {
            try {
                ImageIO.setUseCache(false);
                BufferedImage trayIcon = ImageIO.read(new File(this.iconPath));
                if (this.ti != null) {
                    this.ti.setImage(trayIcon);
                    this.ti.setToolTip(this.readyMessage());
                }
                Tray.setDockIcon(trayIcon);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            if (this.menuItemHeadline != null) {
                this.menuItemHeadline.setLabel(this.readyMessage());
            }
            if (this.menuItemSearch != null) {
                this.menuItemSearch.setEnabled(true);
            }
            if (this.menuItemAdministration != null) {
                this.menuItemAdministration.setEnabled(true);
            }
            if (this.menuItemTerminate != null) {
                this.menuItemTerminate.setEnabled(true);
            }
        }
    }

    public void setShutdown() {
        if (this.useTray()) {
            try {
                if (this.ti != null) {
                    ImageIO.setUseCache(false);
                    BufferedImage trayIcon = ImageIO.read(new File(this.iconPath));
                    BufferedImage progressShutdown = ImageIO.read(new File(this.sb.getAppPath().toString() + "/addon/progress_shutdown.png".replace("/", File.separator)));
                    BufferedImage progress = this.getProgressImage();
                    BufferedImage shutdownIcon = new BufferedImage(128, 128, 2);
                    Graphics2D h = shutdownIcon.createGraphics();
                    h.setBackground(Color.BLACK);
                    h.clearRect(0, 0, 128, 128);
                    h.drawImage(trayIcon, 0, 0, 128, 128 - progress.getHeight(), null);
                    h.drawImage((Image)progress.getSubimage(0, 0, 128, progress.getHeight() / 2), 0, 128 - progress.getHeight() / 2, null);
                    h.drawImage((Image)progressShutdown, 0, 128 - progress.getHeight(), null);
                    h.dispose();
                    this.ti.setImage(shutdownIcon);
                    Tray.setDockIcon(shutdownIcon);
                    this.ti.setToolTip(this.shutdownMessage());
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            if (this.menuItemHeadline != null) {
                this.menuItemHeadline.setLabel(this.shutdownMessage());
            }
            if (this.menuItemSearch != null) {
                this.menuItemSearch.setEnabled(false);
            }
            if (this.menuItemAdministration != null) {
                this.menuItemAdministration.setEnabled(false);
            }
            if (this.menuItemTerminate != null) {
                this.menuItemTerminate.setEnabled(false);
            }
        }
    }

    private BufferedImage getProgressImage() throws IOException {
        String progressPath = this.sb.getAppPath().toString() + "/addon/progressbar.png".replace("/", File.separator);
        ImageIO.setUseCache(false);
        BufferedImage progress_raw = ImageIO.read(new File(progressPath));
        BufferedImage progress = new BufferedImage(149, 56, 2);
        Graphics2D progressg = progress.createGraphics();
        progressg.drawImage((Image)progress_raw, 0, 0, null);
        progressg.dispose();
        return progress;
    }

    public void remove() {
        if (this.isShown) {
            SystemTray.getSystemTray().remove(this.ti);
            this.ti = null;
            this.isShown = false;
        }
    }

    private String startupMessage() {
        if (deutsch) {
            return "YaCy startet, bitte warten...";
        }
        if (french) {
            return "YaCy est en cours de d\u00e9marrage, veuillez patienter...";
        }
        return "YaCy is starting, please wait...";
    }

    private String readyMessage() {
        if (deutsch) {
            return "YaCy laeuft unter http://localhost:" + this.sb.getLocalPort();
        }
        if (french) {
            return "YaCy est en cours d'ex\u00e9cution \u00e0 l'adresse http://localhost:" + this.sb.getLocalPort();
        }
        return "YaCy is running at http://localhost:" + this.sb.getLocalPort();
    }

    private String shutdownMessage() {
        if (deutsch) {
            return "YaCy wird beendet, bitte warten...";
        }
        if (french) {
            return "YaCy est en cours d'arr\u00eat, veuillez patienter...";
        }
        return "YaCy will shut down, please wait...";
    }

    private void doubleClickAction() {
        if (!this.appIsReady) {
            String label = this.startupMessage();
            this.ti.displayMessage("YaCy", label, TrayIcon.MessageType.INFO);
        } else {
            this.openBrowserPage("");
        }
    }

    private void openBrowserPage(String browserPopUpPage) {
        if (!this.menuEnabled) {
            return;
        }
        Browser.openBrowser("http://localhost:" + this.sb.getConfig("port", "8090") + "/" + browserPopUpPage);
    }

    private PopupMenu getPopupMenu() {
        PopupMenu menu = new PopupMenu();
        this.menuItemHeadline = new MenuItem(this.startupMessage());
        this.menuItemHeadline.setEnabled(false);
        menu.add(this.menuItemHeadline);
        menu.addSeparator();
        String label = deutsch ? "YaCy Suche" : (french ? "Recherche YaCy" : "YaCy Search");
        this.menuItemSearch = new MenuItem(label);
        this.menuItemSearch.setEnabled(false);
        this.menuItemSearch.addActionListener(e -> this.openBrowserPage("index.html"));
        menu.add(this.menuItemSearch);
        label = deutsch ? "Administration" : (french ? "Administration" : "Administration");
        this.menuItemAdministration = new MenuItem(label);
        this.menuItemAdministration.setEnabled(false);
        this.menuItemAdministration.addActionListener(e -> this.openBrowserPage("Status.html"));
        menu.add(this.menuItemAdministration);
        menu.addSeparator();
        label = deutsch ? "YaCy Beenden" : (french ? "Arr\u00eater YaCy" : "Shutdown YaCy");
        this.menuItemTerminate = new MenuItem(label);
        this.menuItemTerminate.setEnabled(false);
        this.menuItemTerminate.addActionListener(e -> this.sb.terminate("shutdown from tray"));
        menu.add(this.menuItemTerminate);
        return menu;
    }

    static /* synthetic */ BufferedImage[] access$102(Tray x0, BufferedImage[] x1) {
        x0.progressIcons = x1;
        return x1;
    }

    static {
        Class<?> applicationClass = null;
        try {
            applicationClass = Class.forName("com.apple.eawt.Application");
            Method applicationGetApplication = applicationClass.getMethod("getApplication", new Class[0]);
            applicationInstance = applicationGetApplication.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            ConcurrentLog.logException(e);
        }
        if (applicationClass != null) {
            try {
                setDockIconImage = applicationClass.getMethod("setDockIconImage", Class.forName("java.awt.Image"));
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    private class TrayAnimation
    extends Thread {
        int ic;

        public TrayAnimation() {
            super(TrayAnimation.class.getSimpleName());
            this.ic = 0;
        }

        @Override
        public void run() {
            while (!Tray.this.appIsReady) {
                Tray.this.ti.setImage(Tray.this.progressIcons[this.ic]);
                if (OS.isMacArchitecture) {
                    Tray.setDockIcon(Tray.this.progressIcons[this.ic]);
                }
                ++this.ic;
                if (this.ic >= 4) {
                    this.ic = 0;
                }
                try {
                    Thread.sleep(80L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            try {
                ImageIO.setUseCache(false);
                BufferedImage trayIcon = ImageIO.read(new File(Tray.this.iconPath));
                Tray.this.ti.setImage(trayIcon);
                Tray.this.ti.setToolTip(Tray.this.readyMessage());
                Tray.setDockIcon(trayIcon);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            Tray.access$102(Tray.this, null);
        }
    }
}

