/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.TagValency;
import net.yacy.kelondro.util.FileUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class tarParser
extends AbstractParser
implements Parser {
    private static final String MAGIC = "ustar";

    public tarParser() {
        super("Tape Archive File Parser");
        this.SUPPORTED_EXTENSIONS.add("tar");
        this.SUPPORTED_MIME_TYPES.add("application/x-tar");
        this.SUPPORTED_MIME_TYPES.add("application/tar");
        this.SUPPORTED_MIME_TYPES.add("applicaton/x-gtar");
        this.SUPPORTED_MIME_TYPES.add("multipart/x-tar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        block12: {
            filename = location.getFileName();
            ext = MultiProtocolURL.getFileExtension(filename);
            parentTarURL = this.createParentTarURL(location);
            if (ext.equals("gz") || ext.equals("tgz")) {
                try {
                    source = new GZIPInputStream(source);
                }
                catch (IOException e) {
                    throw new Parser.Failure("tar parser: " + e.getMessage(), location);
                }
            }
            tis = new TarArchiveInputStream(source);
            maindoc = tarParser.createMainDocument(location, mimeType, charset, this);
            try {
                while (true) lbl-1000:
                // 6 sources

                {
                    tmp = null;
                    entry = tis.getNextTarEntry();
                    if (entry == null) break block12;
                    if (entry.isDirectory() || entry.getSize() <= 0L) continue;
                    name = entry.getName();
                    idx = name.lastIndexOf(46);
                    mime = TextParser.mimeOf(idx > -1 ? name.substring(idx + 1) : "");
                    try {
                        tmp = FileUtils.createTempFile(this.getClass(), name);
                        FileUtils.copy((InputStream)tis, tmp, entry.getSize());
                        subLocation = new DigestURL((MultiProtocolURL)parentTarURL, name);
                        subDocs = TextParser.parseSource(subLocation, mime, null, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, 999, tmp);
                        if (subDocs == null) ** GOTO lbl-1000
                        maindoc.addSubDocuments(subDocs);
                    }
                    catch (Parser.Failure e) {
                        AbstractParser.log.warn("tar parser entry " + name + ": " + e.getMessage());
                    }
                    finally {
                        if (tmp == null) continue;
                        FileUtils.deletedelete(tmp);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                AbstractParser.log.warn("tar parser:" + e.getMessage());
            }
            ** GOTO lbl-1000
        }
        return new Document[]{maindoc};
    }

    @Override
    public boolean isParseWithLimitsSupported() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document[] parseWithLimits(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source, int maxLinks, long maxBytes) throws Parser.Failure, InterruptedException, UnsupportedOperationException {
        DigestURL parentTarURL = this.createParentTarURL(location);
        TarArchiveInputStream tis = new TarArchiveInputStream(source);
        Document maindoc = tarParser.createMainDocument(location, mimeType, charset, this);
        int totalProcessedLinks = 0;
        try {
            TarArchiveEntry entry2;
            while ((entry2 = tis.getNextTarEntry()) != null) {
                if (tis.getBytesRead() >= maxBytes) {
                    maindoc.setPartiallyParsed(true);
                    return new Document[]{maindoc};
                }
                if (entry2.isDirectory() || entry2.getSize() <= 0L) continue;
                String name = entry2.getName();
                int idx2 = name.lastIndexOf(46);
                String mime = TextParser.mimeOf(idx2 > -1 ? name.substring(idx2 + 1) : "");
                try {
                    DigestURL subLocation = new DigestURL((MultiProtocolURL)parentTarURL, name);
                    Document[] subDocs = TextParser.parseWithLimits(subLocation, mime, null, timezoneOffset, 999, entry2.getSize(), (InputStream)tis, maxLinks - totalProcessedLinks, maxBytes - tis.getBytesRead());
                    if (subDocs == null) continue;
                    maindoc.addSubDocuments(subDocs);
                    for (Document subDoc : subDocs) {
                        if (subDoc.getAnchors() == null) continue;
                        totalProcessedLinks += subDoc.getAnchors().size();
                    }
                    if (!subDocs[0].isPartiallyParsed()) continue;
                    maindoc.setPartiallyParsed(true);
                    return new Document[]{maindoc};
                }
                catch (Parser.Failure e) {
                    AbstractParser.log.warn("tar parser entry " + name + ": " + e.getMessage());
                }
            }
            return new Document[]{maindoc};
        }
        catch (IOException e) {
            AbstractParser.log.warn("tar parser:" + e.getMessage());
        }
        return new Document[]{maindoc};
    }

    private DigestURL createParentTarURL(DigestURL tarURL) {
        DigestURL parentTarURL;
        String locationStr = tarURL.toNormalform(false);
        if (!locationStr.endsWith("/")) {
            locationStr = locationStr + "/";
        }
        try {
            parentTarURL = new DigestURL(locationStr);
        }
        catch (MalformedURLException e1) {
            parentTarURL = tarURL;
        }
        return parentTarURL;
    }

    public static Document createMainDocument(DigestURL location, String mimeType, String charset, tarParser parser) {
        String filename = location.getFileName();
        Document maindoc = new Document(location, mimeType, charset, parser, null, null, AbstractParser.singleList(filename.isEmpty() ? location.toTokens() : MultiProtocolURL.unescape(filename)), null, null, null, null, 0.0, 0.0, null, null, null, null, false, new Date());
        return maindoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isTar(File f) {
        if (!f.exists() || f.length() < 261L) {
            return false;
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            raf.seek(257L);
            byte[] b = new byte[5];
            raf.read(b);
            boolean bl = MAGIC.equals(UTF8.String(b));
            return bl;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

