/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.ArchiveExtractCallback;
import SevenZip.IInStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.TagValency;
import net.yacy.kelondro.util.FileUtils;

public class sevenzipParser
extends AbstractParser
implements Parser {
    public sevenzipParser() {
        super("7zip Archive Parser");
        this.SUPPORTED_EXTENSIONS.add("7z");
        this.SUPPORTED_MIME_TYPES.add("application/x-7z-compressed");
    }

    public Document parse(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, int timezoneOffset, IInStream source) throws Parser.Failure, InterruptedException {
        Handler archive;
        String filename = location.getFileName();
        Document doc = new Document(location, mimeType, charset, this, null, null, AbstractParser.singleList(filename.isEmpty() ? location.toTokens() : MultiProtocolURL.unescape(filename)), null, null, null, null, 0.0, 0.0, null, null, null, null, false, new Date());
        AbstractParser.log.fine("opening 7zip archive...");
        try {
            archive = new Handler(source);
        }
        catch (IOException e) {
            throw new Parser.Failure("error opening 7zip archive: " + e.getMessage(), location);
        }
        SZParserExtractCallback aec = new SZParserExtractCallback(AbstractParser.log, archive, doc, location.getFile(), defaultValency, valencySwitchTagNames, timezoneOffset);
        AbstractParser.log.fine("processing archive contents...");
        try {
            archive.Extract(null, -1, 0, aec);
            Document document = doc;
            return document;
        }
        catch (IOException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw (InterruptedException)e.getCause();
            }
            if (e.getCause() instanceof Parser.Failure) {
                throw (Parser.Failure)e.getCause();
            }
            throw new Parser.Failure("error processing 7zip archive at internal file " + aec.getCurrentFilePath() + ": " + e.getMessage(), location);
        }
        finally {
            try {
                archive.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Document parse(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, int timezoneOffset, byte[] source) throws Parser.Failure, InterruptedException {
        return this.parse(location, mimeType, charset, defaultValency, valencySwitchTagNames, timezoneOffset, new ByteArrayIInStream(source));
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        try {
            ByteArrayOutputStream cfos = new ByteArrayOutputStream();
            FileUtils.copy(source, (OutputStream)cfos);
            return new Document[]{this.parse(location, mimeType, charset, defaultValency, valencySwitchTagNames, timezoneOffset, cfos.toByteArray())};
        }
        catch (IOException e) {
            throw new Parser.Failure("error processing 7zip archive: " + e.getMessage(), location);
        }
    }

    private static class ByteArrayIInStream
    extends IInStream {
        private final SeekableByteArrayInputStream sbais;

        public ByteArrayIInStream(byte[] buffer) {
            this.sbais = new SeekableByteArrayInputStream(buffer);
        }

        @Override
        public long Seek(long offset, int origin) {
            switch (origin) {
                case 0: {
                    this.sbais.seekAbsolute((int)offset);
                    break;
                }
                case 1: {
                    this.sbais.seekRelative((int)offset);
                }
            }
            return this.sbais.getPosition();
        }

        @Override
        public int read() throws IOException {
            return this.sbais.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.sbais.read(b, off, len);
        }
    }

    private static class SeekableByteArrayInputStream
    extends ByteArrayInputStream {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public SeekableByteArrayInputStream(byte[] buf, int off, int len) {
            super(buf, off, len);
        }

        public int getPosition() {
            return this.pos;
        }

        public void seekRelative(int offset) {
            this.seekAbsolute(this.pos + offset);
        }

        public void seekAbsolute(int offset) {
            if (offset > this.count) {
                throw new IndexOutOfBoundsException(Integer.toString(offset));
            }
            this.pos = offset;
        }
    }

    private static class SZParserExtractCallback
    extends ArchiveExtractCallback {
        private final ConcurrentLog log;
        private ByteArrayOutputStream cfos = null;
        private final Document doc;
        private final String prefix;
        private final TagValency defaultValency;
        private Set<String> valencySwitchTagNames;
        private final int timezoneOffset;

        public SZParserExtractCallback(ConcurrentLog logger, IInArchive handler, Document doc, String prefix, TagValency defaultValency, Set<String> valencySwitchTagNames, int timezoneOffset) {
            super.Init(handler);
            this.log = logger;
            this.doc = doc;
            this.prefix = prefix;
            this.defaultValency = defaultValency;
            this.valencySwitchTagNames = valencySwitchTagNames;
            this.timezoneOffset = timezoneOffset;
        }

        @Override
        public void PrepareOperation(int arg0) {
            this.extractMode = arg0 == 0;
            switch (arg0) {
                case 0: {
                    this.log.fine("Extracting " + this.filePath);
                    break;
                }
                case 1: {
                    this.log.fine("Testing " + this.filePath);
                    break;
                }
                case 2: {
                    this.log.fine("Skipping " + this.filePath);
                }
            }
        }

        @Override
        public void SetOperationResult(int arg0) throws IOException {
            if (arg0 != 0) {
                ++this.NumErrors;
                switch (arg0) {
                    case 1: {
                        throw new IOException("Unsupported Method");
                    }
                    case 3: {
                        throw new IOException("CRC Failed");
                    }
                    case 2: {
                        throw new IOException("Data Error");
                    }
                }
            } else {
                try {
                    if (this.cfos != null) {
                        AnchorURL url = AnchorURL.newAnchor(this.doc.dc_source(), this.prefix + "/" + this.filePath);
                        String mime = TextParser.mimeOf(this.filePath.substring(this.filePath.lastIndexOf(46) + 1));
                        Document[] theDocs = TextParser.parseSource((DigestURL)url, mime, null, this.defaultValency, this.valencySwitchTagNames, new VocabularyScraper(), this.timezoneOffset, this.doc.getDepth() + 1, this.cfos.toByteArray());
                        this.doc.addSubDocuments(theDocs);
                    }
                }
                catch (Exception e) {
                    IOException ex = new IOException("error parsing extracted content of " + this.filePath + ": " + e.getMessage());
                    ex.initCause(e);
                    throw ex;
                }
            }
        }

        @Override
        public OutputStream GetStream(int index2, int askExtractMode) throws IOException {
            SevenZipEntry item = this.archiveHandler.getEntry(index2);
            this.filePath = item.getName();
            this.cfos = item.isDirectory() ? null : new ByteArrayOutputStream();
            return this.cfos;
        }

        public String getCurrentFilePath() {
            return this.filePath;
        }
    }
}

