/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.images;

import java.io.EOFException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.NumberTools;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.ImageEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class svgParser
extends AbstractParser
implements Parser {
    private static final ThreadLocal<SAXParser> tlSax = new ThreadLocal();

    public svgParser() {
        super("SVG Image Parser");
        this.SUPPORTED_EXTENSIONS.add("svg");
        this.SUPPORTED_MIME_TYPES.add("image/svg+xml");
    }

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        try {
            String docDescription;
            svgMetaDataHandler metaData;
            block9: {
                SAXParser saxParser = svgParser.getParser();
                metaData = new svgMetaDataHandler();
                try {
                    saxParser.parse(source, (DefaultHandler)metaData);
                }
                catch (SAXException e) {
                    if (e.getException() != null && e.getException() instanceof EOFException) break block9;
                    throw new Parser.Failure("Unexpected error while parsing svg file. " + e.getMessage(), location);
                }
            }
            String docTitle = metaData.getTitle();
            if (docTitle == null) {
                String string = docTitle = location.getFileName().isEmpty() ? location.toTokens() : MultiProtocolURL.unescape(location.getFileName());
            }
            if ((docDescription = metaData.getDescription()) == null) {
                docDescription = location.toTokens();
            }
            LinkedHashMap<DigestURL, ImageEntry> images = null;
            if (metaData.getHeight() != null && metaData.getWidth() != null) {
                images = new LinkedHashMap<DigestURL, ImageEntry>();
                images.put(location, new ImageEntry(location, "", metaData.getWidth(), metaData.getHeight(), -1L));
            }
            Document[] docs = new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, null, null, AbstractParser.singleList(docTitle), null, "", null, null, 0.0, 0.0, docDescription, null, null, images, false, null)};
            return docs;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            ConcurrentLog.logException(e);
            throw new Parser.Failure("Unexpected error while parsing svg file. " + e.getMessage(), location);
        }
    }

    public class svgMetaDataHandler
    extends DefaultHandler {
        private final StringBuilder buffer = new StringBuilder();
        private boolean scrapeMetaData = false;
        private boolean svgStartTagFound = false;
        private String docTitle = null;
        private String docDescription = null;
        private String imgWidth = null;
        private String imgHeight = null;

        @Override
        public void characters(char[] ch, int start, int length) {
            this.buffer.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String name, String tag, Attributes atts) throws SAXException {
            if (!this.scrapeMetaData && tag != null) {
                switch (tag) {
                    case "svg": {
                        this.svgStartTagFound = true;
                        this.imgHeight = atts.getValue("height");
                        this.imgWidth = atts.getValue("width");
                        break;
                    }
                    case "metadata": {
                        this.scrapeMetaData = true;
                        break;
                    }
                    case "g": 
                    case "line": 
                    case "path": 
                    case "rect": {
                        throw new SAXException("EOF svg Metadata", new EOFException());
                    }
                    default: {
                        if (this.svgStartTagFound) break;
                        throw new SAXException("not a svg file, start tag " + tag, new Parser.Failure());
                    }
                }
            }
            this.buffer.delete(0, this.buffer.length());
        }

        @Override
        public void endElement(String uri, String name, String tag) throws SAXException {
            if (this.scrapeMetaData) {
                if ("metadata".equals(tag)) {
                    this.scrapeMetaData = false;
                    this.buffer.delete(0, this.buffer.length());
                    throw new SAXException("EOF svg Metadata", new EOFException());
                }
            } else if ("title".equals(tag)) {
                this.docTitle = this.buffer.toString();
            } else if ("desc".equals(tag)) {
                this.docDescription = this.buffer.toString();
            }
            this.buffer.delete(0, this.buffer.length());
        }

        public String getTitle() {
            return this.docTitle;
        }

        public String getDescription() {
            return this.docDescription;
        }

        public Integer getWidth() {
            if (this.imgWidth != null && (this.imgWidth.indexOf("px") > 0 || this.imgWidth.charAt(this.imgWidth.length() - 1) >= '0' && this.imgWidth.charAt(this.imgWidth.length() - 1) <= '9')) {
                return NumberTools.parseIntDecSubstring(this.imgWidth);
            }
            return null;
        }

        public Integer getHeight() {
            if (this.imgHeight != null && (this.imgHeight.indexOf("px") > 0 || this.imgHeight.charAt(this.imgHeight.length() - 1) >= '0' && this.imgHeight.charAt(this.imgHeight.length() - 1) <= '9')) {
                return NumberTools.parseIntDecSubstring(this.imgHeight);
            }
            return null;
        }
    }
}

