/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.ContentScraper;
import net.yacy.kelondro.util.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;

public class audioTagParser
extends AbstractParser
implements Parser {
    private final Map<String, SupportedAudioFormat> ext2Format;
    private final Map<String, SupportedAudioFormat> mediaType2Format;
    private static final char SPACE_CHAR = ' ';
    private static final Set<FieldKey> COMMON_DESCRIPTION_FIELDS = Collections.unmodifiableSet(EnumSet.of(FieldKey.ARTIST, new FieldKey[]{FieldKey.ALBUM_ARTIST, FieldKey.ORIGINAL_ARTIST, FieldKey.COMPOSER, FieldKey.CONDUCTOR, FieldKey.LYRICIST, FieldKey.ORIGINAL_LYRICIST, FieldKey.ENGINEER, FieldKey.PRODUCER, FieldKey.MIXER, FieldKey.DJMIXER, FieldKey.ARRANGER, FieldKey.ARTISTS, FieldKey.GROUPING, FieldKey.RECORD_LABEL, FieldKey.REMIXER, FieldKey.ALBUM, FieldKey.ORIGINAL_ALBUM, FieldKey.TITLE, FieldKey.SUBTITLE, FieldKey.COMMENT, FieldKey.DISC_SUBTITLE, FieldKey.LYRICS, FieldKey.TAGS, FieldKey.GENRE, FieldKey.MOOD}));

    public audioTagParser() {
        super("Audio File Meta-Tag Parser");
        HashMap<String, SupportedAudioFormat> ext2Formats = new HashMap<String, SupportedAudioFormat>();
        HashMap<String, SupportedAudioFormat> mediaType2Formats = new HashMap<String, SupportedAudioFormat>();
        for (SupportedAudioFormat mediaType : SupportedAudioFormat.values()) {
            this.SUPPORTED_MIME_TYPES.add(mediaType.getMediaType());
            this.SUPPORTED_MIME_TYPES.addAll(mediaType.getAlternateMediaTypes());
            this.SUPPORTED_EXTENSIONS.addAll(mediaType.getFileExtensions());
            for (String fileExtension : mediaType.getFileExtensions()) {
                ext2Formats.put(fileExtension, mediaType);
            }
            mediaType2Formats.put(mediaType.getMediaType(), mediaType);
            for (String mediaTypeStr : mediaType.getAlternateMediaTypes()) {
                mediaType2Formats.put(mediaTypeStr, mediaType);
            }
        }
        this.ext2Format = Collections.unmodifiableMap(ext2Formats);
        this.mediaType2Format = Collections.unmodifiableMap(mediaType2Formats);
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        return this.parseWithLimits(location, mimeType, charset, scraper, timezoneOffset, source, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    @Override
    public Document[] parseWithLimits(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source, int maxLinks, long maxBytes) throws Parser.Failure, InterruptedException {
        String filename = location.getFileName();
        String fileExt = MultiProtocolURL.getFileExtension(filename);
        SupportedAudioFormat audioFormat = null;
        if (fileExt != null) {
            audioFormat = this.ext2Format.get(fileExt);
        }
        if (audioFormat == null) {
            audioFormat = this.mediaType2Format.get(mimeType);
        }
        String normalizedMediaType = mimeType;
        if (audioFormat != null) {
            normalizedMediaType = audioFormat.getMediaType();
            if (fileExt.isEmpty() || !this.ext2Format.containsKey(fileExt)) {
                fileExt = audioFormat.getFileExtensions().iterator().next();
            }
        }
        filename = filename.isEmpty() ? location.toTokens() : MultiProtocolURL.unescape(filename);
        File tempFile = null;
        try {
            Set<AnchorURL> detectedUrls;
            AudioFile f;
            boolean partiallyParsed = false;
            if (location.isFile()) {
                f = AudioFileIO.read((File)location.getFSFile());
            } else {
                tempFile = File.createTempFile(filename, "." + fileExt);
                long bytesCopied = FileUtils.copy(source, tempFile, maxBytes);
                partiallyParsed = bytesCopied == maxBytes && source.read() != -1;
                f = AudioFileIO.read((File)tempFile);
            }
            Tag tag = f.getTag();
            HashSet<String> lang = new HashSet<String>();
            if (tag != null) {
                lang.add(tag.getFirst(FieldKey.LANGUAGE));
            }
            ArrayList<String> titles = new ArrayList<String>();
            if (tag != null) {
                titles.add(tag.getFirst(FieldKey.TITLE));
                titles.add(tag.getFirst(FieldKey.SUBTITLE));
                titles.add(tag.getFirst(FieldKey.ALBUM));
            }
            titles.add(filename);
            ArrayList<String> descriptions = new ArrayList<String>(7);
            StringBuilder text = new StringBuilder(500);
            if (tag != null) {
                for (FieldKey field : COMMON_DESCRIPTION_FIELDS) {
                    this.processDescriptionTagField(field, tag, descriptions, text);
                }
            }
            text.append(location.toTokens());
            String[] subject = tag != null ? new String[]{tag.getFirst(FieldKey.GENRE)} : new String[]{};
            if (tag != null) {
                detectedUrls = new HashSet();
                boolean bl = partiallyParsed = partiallyParsed || this.extractUrlsFromTags(maxLinks, tag, detectedUrls);
                if (detectedUrls.isEmpty()) {
                    detectedUrls = Collections.emptySet();
                }
            } else {
                detectedUrls = Collections.emptySet();
            }
            Document doc = new Document(location, normalizedMediaType, charset, this, lang, subject, titles, tag != null ? tag.getFirst(FieldKey.ARTIST) : null, location.getHost(), null, descriptions, 0.0, 0.0, text.toString(), detectedUrls, null, null, false, new Date());
            doc.setPartiallyParsed(partiallyParsed);
            Document[] documentArray = new Document[]{doc};
            return documentArray;
        }
        catch (Exception e) {
            throw new Parser.Failure("Unexpected error while parsing audio file. " + e.getMessage(), location);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private boolean extractUrlsFromTags(int maxLinks, Tag tag, Set<AnchorURL> urls2) {
        long detectedUrls = 0L;
        HashSet<AnchorURL> additionalUrls = new HashSet<AnchorURL>();
        try {
            Iterator it = tag.getFields();
            while (it.hasNext() && (detectedUrls < (long)maxLinks || additionalUrls.isEmpty())) {
                TagField field = (TagField)it.next();
                if (field == null || field.isEmpty() || field.isBinary() || !(field instanceof TagTextField)) continue;
                String value = ((TagTextField)field).getContent();
                if (detectedUrls < (long)maxLinks) {
                    detectedUrls += ContentScraper.findAbsoluteURLs(value, urls2, null, (long)maxLinks - detectedUrls);
                    continue;
                }
                ContentScraper.findAbsoluteURLs(value, additionalUrls, null, 1L);
            }
        }
        catch (UnsupportedOperationException ignored) {
            FieldKey[] commonKeys = FieldKey.values();
            for (int keyIndex = 0; keyIndex < commonKeys.length && (detectedUrls < (long)maxLinks || additionalUrls.isEmpty()); ++keyIndex) {
                FieldKey key = commonKeys[keyIndex];
                List values = tag.getAll(key);
                if (values == null) continue;
                for (int valIndex = 0; valIndex < values.size() && (detectedUrls < (long)maxLinks || additionalUrls.isEmpty()); ++valIndex) {
                    String value = (String)values.get(valIndex);
                    if (!StringUtils.isNotBlank((String)value)) continue;
                    if (detectedUrls < (long)maxLinks) {
                        detectedUrls += ContentScraper.findAbsoluteURLs(value, urls2, null, (long)maxLinks - detectedUrls);
                        continue;
                    }
                    ContentScraper.findAbsoluteURLs(value, additionalUrls, null, 1L);
                }
            }
        }
        return !additionalUrls.isEmpty();
    }

    @Override
    public boolean isParseWithLimitsSupported() {
        return true;
    }

    private void processDescriptionTagField(FieldKey fieldKey, Tag tag, List<String> descriptions, StringBuilder text) {
        List fieldValues = tag.getAll(fieldKey);
        if (fieldValues != null) {
            for (String fieldValue : fieldValues) {
                if (!StringUtils.isNotBlank((String)fieldValue)) continue;
                descriptions.add(fieldKey.name() + ": " + fieldValue);
                text.append(fieldValue);
                text.append(' ');
            }
        }
    }

    public static enum SupportedAudioFormat {
        AIF("audio/aiff", new String[]{"audio/x-aiff"}, new String[]{SupportedFileFormat.AIF.getFilesuffix(), SupportedFileFormat.AIFC.getFilesuffix(), SupportedFileFormat.AIFF.getFilesuffix()}),
        MPEG("audio/mpeg", new String[]{"audio/MPA"}, new String[]{SupportedFileFormat.MP3.getFilesuffix()}),
        MPA("audio/MPA", new String[0]),
        MPA_ROBUST("audio/mpa-robust", new String[0]),
        MP4("audio/mp4", new String[]{SupportedFileFormat.M4A.getFilesuffix(), SupportedFileFormat.M4B.getFilesuffix(), SupportedFileFormat.M4P.getFilesuffix(), SupportedFileFormat.MP4.getFilesuffix()}),
        FLAC("audio/flac", new String[]{"audio/x-flac"}, new String[]{SupportedFileFormat.FLAC.getFilesuffix()}),
        OGG("audio/ogg", new String[]{SupportedFileFormat.OGG.getFilesuffix()}),
        WMA("audio/x-ms-wma", new String[]{"audio/x-ms-asf"}, new String[]{SupportedFileFormat.WMA.getFilesuffix()}),
        REAL_AUDIO("audio/vnd.rn-realaudio", new String[]{"audio/x-pn-realaudio"}, new String[]{SupportedFileFormat.RA.getFilesuffix(), SupportedFileFormat.RM.getFilesuffix()}),
        WAV("audio/vnd.wave", new String[]{"audio/wav", "audio/wave", "audio/x-wav"}, new String[]{SupportedFileFormat.WAV.getFilesuffix()});

        private final String mediaType;
        private final Set<String> alternateMediaTypes;
        private final Set<String> fileExtensions;

        private SupportedAudioFormat(String mediaType, String[] fileExtensions) {
            this(mediaType, new String[0], fileExtensions);
        }

        private SupportedAudioFormat(String mediaType, String[] alternateMediaTypes, String[] fileExtensions) {
            this.mediaType = mediaType.toLowerCase(Locale.ROOT);
            HashSet<String> alternates = new HashSet<String>();
            for (String alternateMediaType : alternateMediaTypes) {
                alternates.add(alternateMediaType.toLowerCase(Locale.ROOT));
            }
            this.alternateMediaTypes = alternates.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(alternates);
            HashSet<String> extensions = new HashSet<String>();
            for (String fileExtension : fileExtensions) {
                extensions.add(fileExtension.toLowerCase(Locale.ROOT));
            }
            this.fileExtensions = extensions.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(extensions);
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public Set<String> getAlternateMediaTypes() {
            return this.alternateMediaTypes;
        }

        public Set<String> getFileExtensions() {
            return this.fileExtensions;
        }

        public static Set<String> getAllMediaTypes() {
            HashSet<String> mediaTypes = new HashSet<String>();
            for (SupportedAudioFormat mediaType : SupportedAudioFormat.values()) {
                mediaTypes.add(mediaType.getMediaType());
                for (String mediaTypeString : mediaType.getAlternateMediaTypes()) {
                    mediaTypes.add(mediaTypeString);
                }
            }
            return mediaTypes;
        }

        public static Set<String> getAllFileExtensions() {
            HashSet<String> extensions = new HashSet<String>();
            for (SupportedAudioFormat mediaType : SupportedAudioFormat.values()) {
                extensions.addAll(mediaType.getFileExtensions());
            }
            return extensions;
        }
    }
}

