/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.importer;

import java.io.File;
import java.io.IOException;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.importer.OAIPMHImporter;
import net.yacy.document.importer.ResumptionToken;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.repository.LoaderDispatcher;

public class OAIPMHLoader {
    private final DigestURL source;
    private final ResumptionToken resumptionToken;

    public OAIPMHLoader(LoaderDispatcher loader, DigestURL source, File targetDir, ClientIdentification.Agent agent) throws IOException {
        this.source = source;
        ConcurrentLog.info("OAIPMHLoader", "loading record from " + source.toNormalform(true));
        Response response = null;
        IOException ee = null;
        for (int i = 0; i < 5; ++i) {
            try {
                response = loader.load(loader.request(source, false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, agent);
                break;
            }
            catch (IOException e) {
                ConcurrentLog.warn("OAIPMHLoader", "loading failed at attempt " + (i + 1) + ": " + source.toNormalform(true));
                ee = e;
                continue;
            }
        }
        if (response == null) {
            throw ee;
        }
        byte[] b = response.getContent();
        this.resumptionToken = new ResumptionToken(source, b);
        File f1 = new File(targetDir, OAIPMHImporter.filename4Source(source));
        File f0 = new File(targetDir, f1.getName() + ".tmp");
        FileUtils.copy(b, f0);
        f0.renameTo(f1);
    }

    public ResumptionToken getResumptionToken() {
        return this.resumptionToken;
    }

    public String source() {
        return this.source.toNormalform(true);
    }
}

