/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.importer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.importer.Importer;
import net.yacy.document.importer.OAIPMHLoader;
import net.yacy.document.importer.ResumptionToken;
import net.yacy.repository.LoaderDispatcher;
import net.yacy.search.Switchboard;

public class OAIPMHImporter
extends Thread
implements Importer,
Comparable<OAIPMHImporter> {
    private static int importerCounter = Integer.MAX_VALUE;
    private static final Object N = new Object();
    public static ConcurrentHashMap<OAIPMHImporter, Object> startedJobs = new ConcurrentHashMap();
    public static ConcurrentHashMap<OAIPMHImporter, Object> runningJobs = new ConcurrentHashMap();
    public static ConcurrentHashMap<OAIPMHImporter, Object> finishedJobs = new ConcurrentHashMap();
    private final LoaderDispatcher loader;
    private DigestURL source;
    private int recordsCount;
    private int chunkCount;
    private int completeListSize;
    private final long startTime;
    private long finishTime;
    private final ResumptionToken resumptionToken;
    private String message;
    private final int serialNumber;
    private final ClientIdentification.Agent agent;
    public static final char hostReplacementChar = '_';
    public static final char filenameSeparationChar = '.';
    public static final String filenamePrefix = "oaipmh";

    public OAIPMHImporter(LoaderDispatcher loader, ClientIdentification.Agent agent, DigestURL source) {
        super(OAIPMHImporter.class.getSimpleName());
        this.agent = agent;
        this.serialNumber = importerCounter--;
        this.loader = loader;
        this.recordsCount = 0;
        this.chunkCount = 0;
        this.completeListSize = 0;
        this.startTime = System.currentTimeMillis();
        this.finishTime = 0L;
        this.resumptionToken = null;
        this.message = "import initialized";
        String url = ResumptionToken.truncatedURL(source);
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        try {
            this.source = new DigestURL(url + "verb=ListRecords&metadataPrefix=oai_dc");
        }
        catch (MalformedURLException e) {
            ConcurrentLog.logException(e);
        }
        startedJobs.put(this, N);
    }

    @Override
    public int count() {
        return this.recordsCount;
    }

    public int chunkCount() {
        return this.chunkCount;
    }

    @Override
    public String status() {
        return this.message;
    }

    public ResumptionToken getResumptionToken() {
        return this.resumptionToken;
    }

    public int getCompleteListSize() {
        return this.completeListSize;
    }

    @Override
    public long remainingTime() {
        return this.isAlive() ? Long.MAX_VALUE : 0L;
    }

    @Override
    public long runningTime() {
        return this.isAlive() ? System.currentTimeMillis() - this.startTime : this.finishTime - this.startTime;
    }

    @Override
    public String source() {
        return this.source.toNormalform(true);
    }

    @Override
    public int speed() {
        return (int)(1000L * (long)this.count() / this.runningTime());
    }

    @Override
    public void run() {
        while (runningJobs.size() > 50) {
            try {
                Thread.sleep(10000L + 3000L * (System.currentTimeMillis() % 6L));
            }
            catch (InterruptedException interruptedException) {}
        }
        startedJobs.remove(this);
        runningJobs.put(this, N);
        this.message = "loading first part of records";
        try {
            while (true) {
                OAIPMHLoader oailoader = new OAIPMHLoader(this.loader, this.source, Switchboard.getSwitchboard().surrogatesInPath, this.agent);
                this.completeListSize = Math.max(this.completeListSize, oailoader.getResumptionToken().getCompleteListSize());
                ++this.chunkCount;
                this.recordsCount += oailoader.getResumptionToken().getRecordCounter();
                this.source = oailoader.getResumptionToken().resumptionURL();
                if (this.source == null) {
                    this.message = "import terminated with source = null";
                    break;
                }
                this.message = "loading next resumption fragment, cursor = " + oailoader.getResumptionToken().getCursor();
            }
        }
        catch (IOException e) {
            this.message = e.getMessage();
        }
        this.finishTime = System.currentTimeMillis();
        runningJobs.remove(this);
        finishedJobs.put(this, N);
    }

    public int hashCode() {
        return this.serialNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAIPMHImporter)) {
            return false;
        }
        OAIPMHImporter other = (OAIPMHImporter)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(OAIPMHImporter o) {
        if (this.serialNumber > o.serialNumber) {
            return 1;
        }
        if (this.serialNumber < o.serialNumber) {
            return -1;
        }
        return 0;
    }

    public static Map<String, Date> getLoadedOAIServer(File surrogatesIn, File surrogatesOut) {
        Map<String, Date> map = OAIPMHImporter.getLoadedOAIServer(surrogatesOut);
        map.putAll((Map)((Object)OAIPMHImporter.getLoadedOAIServer(surrogatesIn).entrySet()));
        return map;
    }

    private static Map<String, Date> getLoadedOAIServer(File surrogates) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        for (String s : surrogates.list()) {
            if (!s.startsWith(filenamePrefix) || !s.endsWith(".xml") || s.charAt(s.length() - 22) != '.') continue;
            try {
                Date fd = GenericFormatter.SHORT_MILSEC_FORMATTER.parse(s.substring(s.length() - 21, s.length() - 4), 0).getTime();
                String hostID = s.substring(7, s.length() - 22);
                Date md = map.get(hostID);
                if (md != null && !fd.after(md)) continue;
                map.put(hostID, fd);
            }
            catch (ParseException e) {
                ConcurrentLog.logException(e);
            }
        }
        return map;
    }

    public static final String hostID(DigestURL source) {
        String s = ResumptionToken.truncatedURL(source);
        if (s.endsWith("?")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.startsWith("https://")) {
            s = s.substring(8);
        }
        if (s.startsWith("http://")) {
            s = s.substring(7);
        }
        return s.replace('.', '_').replace('/', '_').replace(':', '_');
    }

    public static final String filename4Source(DigestURL source) {
        return "oaipmh." + OAIPMHImporter.hostID(source) + '.' + GenericFormatter.SHORT_MILSEC_FORMATTER.format() + ".xml";
    }
}

