/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.importer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.Response;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.repository.LoaderDispatcher;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAIListFriendsLoader
implements Serializable {
    private static final long serialVersionUID = -8705115274655024604L;
    private static final HashMap<String, File> listFriends = new HashMap();
    private static final ThreadLocal<SAXParser> tlSax = new ThreadLocal();

    public static void init(LoaderDispatcher loader, Map<String, File> moreFriends, ClientIdentification.Agent agent) {
        listFriends.putAll(moreFriends);
        if (loader != null) {
            for (Map.Entry<String, File> oaiFriend : listFriends.entrySet()) {
                try {
                    loader.loadIfNotExistBackground(new DigestURL(oaiFriend.getKey()), oaiFriend.getValue(), Integer.MAX_VALUE, null, agent);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }

    public static Map<String, File> loadListFriendsSources(File initFile, File dataPath) {
        Properties p = new Properties();
        HashMap<String, File> m = new HashMap<String, File>();
        try {
            p.loadFromXML(new FileInputStream(initFile));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return m;
        }
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            m.put((String)e.getKey(), new File(dataPath, (String)e.getValue()));
        }
        return m;
    }

    public Map<String, String> getListFriends(LoaderDispatcher loader, ClientIdentification.Agent agent) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry<String, File> oaiFriend : listFriends.entrySet()) {
            try {
                TreeMap m;
                byte[] b;
                if (!oaiFriend.getValue().exists()) {
                    Response response;
                    Response response2 = response = loader == null ? null : loader.load(loader.request(new DigestURL(oaiFriend.getKey()), false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, agent);
                    if (response != null) {
                        FileUtils.copy(response.getContent(), oaiFriend.getValue());
                    }
                }
                if (!oaiFriend.getValue().exists() || (b = FileUtils.read(oaiFriend.getValue())) == null || (m = new Parser(b).map) == null) continue;
                map.putAll(m);
            }
            catch (IOException iOException) {}
        }
        return map;
    }

    private SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    private class Parser
    extends DefaultHandler {
        private final StringBuilder buffer;
        private boolean parsingValue = false;
        private SAXParser saxParser;
        private final InputStream stream;
        private Attributes atts = null;
        private final TreeMap<String, String> map = new TreeMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Parser(byte[] b) {
            this.buffer = new StringBuilder();
            this.stream = new ByteArrayInputStream(b);
            try {
                this.saxParser = OAIListFriendsLoader.this.getParser();
                this.saxParser.parse(this.stream, (DefaultHandler)this);
            }
            catch (SAXException e) {
                ConcurrentLog.logException(e);
                ConcurrentLog.warn("OAIListFriendsLoader.Parser", "OAIListFriends was not parsed:\n" + UTF8.String(b));
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                ConcurrentLog.warn("OAIListFriendsLoader.Parser", "OAIListFriends was not parsed:\n" + UTF8.String(b));
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }

        @Override
        public void startElement(String uri, String name, String tag, Attributes atts) throws SAXException {
            if ("baseURL".equals(tag)) {
                this.parsingValue = true;
                this.atts = atts;
            }
        }

        @Override
        public void endElement(String uri, String name, String tag) {
            if (tag == null) {
                return;
            }
            if ("baseURL".equals(tag)) {
                this.map.put(this.buffer.toString(), this.atts.getValue("id"));
                this.buffer.setLength(0);
                this.parsingValue = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.parsingValue) {
                this.buffer.append(ch, start, length);
            }
        }
    }
}

