/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import net.yacy.cora.document.WordCache;
import net.yacy.cora.order.Base64Order;
import net.yacy.document.LargeNumberCache;
import net.yacy.document.SentenceReader;
import net.yacy.kelondro.data.word.Word;

public class WordTokenizer
implements Enumeration<StringBuilder> {
    private StringBuilder buffer = null;
    private unsievedWordsEnum e;
    private final WordCache meaningLib;

    public WordTokenizer(SentenceReader sr, WordCache meaningLib) {
        assert (sr != null);
        this.e = new unsievedWordsEnum(sr);
        this.buffer = this.nextElement0();
        this.meaningLib = meaningLib;
    }

    public void pre(boolean x) {
        this.e.pre(x);
    }

    private StringBuilder nextElement0() {
        if (this.e.hasMoreElements()) {
            StringBuilder s = this.e.nextElement();
            return s;
        }
        return null;
    }

    @Override
    public boolean hasMoreElements() {
        return this.buffer != null;
    }

    @Override
    public StringBuilder nextElement() {
        StringBuilder r = this.buffer == null ? null : this.buffer;
        this.buffer = this.nextElement0();
        if (this.meaningLib != null && r != null) {
            WordCache.learn(r);
        }
        return r;
    }

    public synchronized void close() {
        this.e.close();
        this.e = null;
        this.buffer = null;
    }

    public static StringBuilder trim(StringBuilder sb) {
        int i;
        for (i = 0; i < sb.length() && sb.charAt(i) <= ' '; ++i) {
        }
        if (i > 0) {
            sb.delete(0, i);
        }
        for (i = sb.length() - 1; i >= 0 && i < sb.length() && sb.charAt(i) <= ' '; --i) {
        }
        if (i > 0) {
            sb.delete(i + 1, sb.length());
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<byte[], Integer> hashSentence(String sentence, int maxlength) {
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Base64Order.enhancedCoder);
        WordTokenizer words = new WordTokenizer(new SentenceReader(sentence), null);
        try {
            int pos = 0;
            while (words.hasMoreElements() && maxlength-- > 0) {
                StringBuilder word = words.nextElement();
                byte[] hash = Word.word2hash(word);
                Integer oldpos = map.put(hash, LargeNumberCache.valueOf(pos));
                if (oldpos != null) {
                    map.put(hash, oldpos);
                }
                pos += word.length() + 1;
            }
            TreeMap<byte[], Integer> treeMap = map;
            return treeMap;
        }
        finally {
            words.close();
            words = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<String, Integer> tokenizeSentence(String sentence, int maxlength) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        WordTokenizer words = new WordTokenizer(new SentenceReader(sentence), null);
        try {
            int pos = 0;
            while (words.hasMoreElements() && maxlength-- > 0) {
                String word = words.nextElement().toString().toLowerCase(Locale.ENGLISH);
                Integer oldpos = map.put(word, LargeNumberCache.valueOf(pos));
                if (oldpos != null) {
                    map.put(word, oldpos);
                }
                pos += word.length() + 1;
            }
            TreeMap<String, Integer> treeMap = map;
            return treeMap;
        }
        finally {
            words.close();
            words = null;
        }
    }

    private class unsievedWordsEnum
    implements Enumeration<StringBuilder> {
        private StringBuilder buffer = null;
        private SentenceReader sr;
        private List<StringBuilder> s;
        private int sIndex;

        public unsievedWordsEnum(SentenceReader sr0) {
            assert (sr0 != null);
            this.sr = sr0;
            this.s = new ArrayList<StringBuilder>();
            this.sIndex = 0;
            this.buffer = this.nextElement0();
        }

        public void pre(boolean x) {
            this.sr.pre(x);
        }

        private StringBuilder nextElement0() {
            StringBuilder r;
            if (this.sIndex >= this.s.size()) {
                this.sIndex = 0;
                this.s.clear();
            }
            while (this.s.isEmpty()) {
                if (!this.sr.hasNext()) {
                    return null;
                }
                r = this.sr.next();
                if (r == null) {
                    return null;
                }
                r = WordTokenizer.trim(r);
                StringBuilder sb = new StringBuilder(20);
                for (int i = 0; i < r.length(); ++i) {
                    char c = r.charAt(i);
                    if (SentenceReader.punctuation(c)) {
                        if (sb.length() > 0) {
                            this.s.add(sb);
                            sb = new StringBuilder(1);
                        }
                        sb.append(c);
                        this.s.add(sb);
                        sb = new StringBuilder(20);
                        continue;
                    }
                    if (SentenceReader.invisible(c)) {
                        if (sb.length() <= 0) continue;
                        this.s.add(sb);
                        sb = new StringBuilder(20);
                        continue;
                    }
                    sb = sb.append(c);
                }
                if (sb.length() <= 0) continue;
                this.s.add(sb);
                sb = null;
            }
            r = this.s.get(this.sIndex++);
            return r;
        }

        @Override
        public boolean hasMoreElements() {
            return this.buffer != null;
        }

        @Override
        public StringBuilder nextElement() {
            StringBuilder r = this.buffer;
            this.buffer = this.nextElement0();
            return r;
        }

        public synchronized void close() {
            this.sIndex = 0;
            this.s.clear();
            this.s = null;
            this.sr.close();
            this.sr = null;
        }
    }
}

