/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.StrictLimitInputStream;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.GenericXMLParser;
import net.yacy.document.parser.XZParser;
import net.yacy.document.parser.apkParser;
import net.yacy.document.parser.audioTagParser;
import net.yacy.document.parser.bzipParser;
import net.yacy.document.parser.csvParser;
import net.yacy.document.parser.docParser;
import net.yacy.document.parser.genericParser;
import net.yacy.document.parser.gzipParser;
import net.yacy.document.parser.html.TagValency;
import net.yacy.document.parser.htmlParser;
import net.yacy.document.parser.images.genericImageParser;
import net.yacy.document.parser.images.metadataImageParser;
import net.yacy.document.parser.images.svgParser;
import net.yacy.document.parser.linkScraperParser;
import net.yacy.document.parser.mmParser;
import net.yacy.document.parser.odtParser;
import net.yacy.document.parser.ooxmlParser;
import net.yacy.document.parser.pdfParser;
import net.yacy.document.parser.pptParser;
import net.yacy.document.parser.psParser;
import net.yacy.document.parser.rssParser;
import net.yacy.document.parser.rtfParser;
import net.yacy.document.parser.sevenzipParser;
import net.yacy.document.parser.sidAudioParser;
import net.yacy.document.parser.tarParser;
import net.yacy.document.parser.torrentParser;
import net.yacy.document.parser.vcfParser;
import net.yacy.document.parser.vsdParser;
import net.yacy.document.parser.xlsParser;
import net.yacy.document.parser.zipParser;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import org.apache.commons.io.input.CloseShieldInputStream;

public final class TextParser {
    private static final Object v = new Object();
    private static final Parser genericIdiom = new genericParser();
    private static final Parser genericXMLIdiom = new GenericXMLParser();
    private static final Map<String, LinkedHashSet<Parser>> mime2parser = new ConcurrentHashMap<String, LinkedHashSet<Parser>>();
    private static final ConcurrentHashMap<String, LinkedHashSet<Parser>> ext2parser = new ConcurrentHashMap();
    private static final Map<String, String> ext2mime = new ConcurrentHashMap<String, String>();
    private static final Map<String, Object> denyMime = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> denyExtensionx = new ConcurrentHashMap<String, Object>();

    public static Set<Parser> parsers() {
        HashSet<Parser> c = new HashSet<Parser>();
        for (Set set : ext2parser.values()) {
            c.addAll(set);
        }
        for (Set set : mime2parser.values()) {
            c.addAll(set);
        }
        return c;
    }

    public static Set<String> supportedMimeTypes() {
        HashSet<String> mimeTypes = new HashSet<String>();
        mimeTypes.addAll(mime2parser.keySet());
        return mimeTypes;
    }

    private static void initParser(Parser parser) {
        String prototypeMime = null;
        for (String mime : parser.supportedMimeTypes()) {
            LinkedHashSet<Parser> p0;
            String mimeType = TextParser.normalizeMimeType(mime);
            if (prototypeMime == null) {
                prototypeMime = mimeType;
            }
            if ((p0 = mime2parser.get(mimeType)) == null) {
                p0 = new LinkedHashSet();
                mime2parser.put(mimeType, p0);
            }
            p0.add(parser);
            AbstractParser.log.info("Parser for mime type '" + mimeType + "': " + parser.getName());
        }
        if (prototypeMime != null) {
            for (String ext : parser.supportedExtensions()) {
                String s = ext2mime.get(ext = ext.toLowerCase(Locale.ROOT));
                if (s != null && !s.equals(prototypeMime)) {
                    AbstractParser.log.info("Parser for extension '" + ext + "' was set to mime '" + s + "', overwriting with new mime '" + prototypeMime + "'.");
                }
                ext2mime.put(ext, prototypeMime);
            }
        }
        for (String ext : parser.supportedExtensions()) {
            LinkedHashSet<Parser> p0 = ext2parser.get(ext = ext.toLowerCase(Locale.ROOT));
            if (p0 == null) {
                p0 = new LinkedHashSet();
                ext2parser.put(ext, p0);
            }
            p0.add(parser);
            AbstractParser.log.info("Parser for extension '" + ext + "': " + parser.getName());
        }
    }

    public static Document[] parseSource(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, int depth, File sourceFile) throws InterruptedException, Parser.Failure {
        BufferedInputStream sourceStream = null;
        Document[] docs = null;
        try {
            if (AbstractParser.log.isFine()) {
                AbstractParser.log.fine("Parsing '" + location + "' from file");
            }
            if (!sourceFile.exists() || !sourceFile.canRead() || sourceFile.length() == 0L) {
                String errorMsg = sourceFile.exists() ? "Empty resource file." : "No resource content available (2).";
                AbstractParser.log.info("Unable to parse '" + location + "'. " + errorMsg);
                throw new Parser.Failure(errorMsg, location);
            }
            sourceStream = new BufferedInputStream(new FileInputStream(sourceFile));
            docs = TextParser.parseSource(location, mimeType, charset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, depth, sourceFile.length(), sourceStream);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            AbstractParser.log.severe("Unexpected exception in parseSource from File: " + e.getMessage(), e);
            throw new Parser.Failure("Unexpected exception: " + e.getMessage(), location);
        }
        finally {
            if (sourceStream != null) {
                try {
                    sourceStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return docs;
    }

    public static Document[] parseSource(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, int depth, byte[] content) throws Parser.Failure {
        if (AbstractParser.log.isFine()) {
            AbstractParser.log.fine("Parsing '" + location + "' from byte-array");
        }
        mimeType = TextParser.normalizeMimeType(mimeType);
        Set<Parser> idioms = null;
        try {
            idioms = TextParser.parsers(location, mimeType);
        }
        catch (Parser.Failure e) {
            String errorMsg = "Parser Failure for extension '" + MultiProtocolURL.getFileExtension(location.getFileName()) + "' or mimetype '" + mimeType + "': " + e.getMessage();
            AbstractParser.log.warn(errorMsg);
            throw new Parser.Failure(errorMsg, location);
        }
        assert (!idioms.isEmpty()) : "no parsers applied for url " + location.toNormalform(true);
        Document[] docs = TextParser.parseSource(location, mimeType, idioms, charset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, depth, content, Integer.MAX_VALUE, Long.MAX_VALUE);
        return docs;
    }

    public static Document[] genericParseSource(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, int depth, byte[] content) throws Parser.Failure {
        if (AbstractParser.log.isFine()) {
            AbstractParser.log.fine("Parsing '" + location + "' from byte-array, applying only the generic parser");
        }
        mimeType = TextParser.normalizeMimeType(mimeType);
        HashSet<Parser> idioms = new HashSet<Parser>();
        idioms.add(genericIdiom);
        return TextParser.parseSource(location, mimeType, idioms, charset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, depth, content, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    private static Document[] parseSource(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, int depth, long contentLength, InputStream sourceStream, int maxLinks, long maxBytes) throws Parser.Failure {
        if (AbstractParser.log.isFine()) {
            AbstractParser.log.fine("Parsing '" + location + "' from stream");
        }
        mimeType = TextParser.normalizeMimeType(mimeType);
        Set<Parser> idioms = null;
        try {
            idioms = TextParser.parsers(location, mimeType);
        }
        catch (Parser.Failure e) {
            String errorMsg = "Parser Failure for extension '" + MultiProtocolURL.getFileExtension(location.getFileName()) + "' or mimetype '" + mimeType + "': " + e.getMessage();
            AbstractParser.log.warn(errorMsg);
            throw new Parser.Failure(errorMsg, location);
        }
        assert (!idioms.isEmpty()) : "no parsers applied for url " + location.toNormalform(true);
        boolean canStream = false;
        if (idioms.size() == 1) {
            canStream = true;
        } else if (idioms.size() == 2) {
            for (Parser idiom : idioms) {
                if (!(idiom instanceof genericParser)) continue;
                canStream = true;
            }
        } else if (sourceStream instanceof ByteArrayInputStream) {
            canStream = true;
        }
        if (canStream || contentLength > Integer.MAX_VALUE || contentLength > MemoryControl.available()) {
            try {
                int rewindSize = 10240;
                InputStream markableStream = sourceStream instanceof ByteArrayInputStream ? sourceStream : new BufferedInputStream(sourceStream, 10240);
                markableStream.mark(10240);
                for (Parser parser : idioms) {
                    CloseShieldInputStream nonCloseInputStream = new CloseShieldInputStream(markableStream);
                    try {
                        return TextParser.parseSource(location, mimeType, parser, charset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, (InputStream)nonCloseInputStream, maxLinks, maxBytes);
                    }
                    catch (Parser.Failure e) {
                        markableStream.reset();
                        if (!(parser instanceof gzipParser) || !(e.getCause() instanceof gzipParser.GZIPOpeningStreamException) || idioms.size() != 1 && (idioms.size() != 2 || !idioms.contains(genericIdiom))) continue;
                        gzipParser gzParser = (gzipParser)parser;
                        nonCloseInputStream = new CloseShieldInputStream(markableStream);
                        Document maindoc = gzipParser.createMainDocument(location, mimeType, charset, gzParser);
                        try {
                            Document[] docs = gzParser.parseCompressedInputStream(location, charset, timezoneOffset, depth, (InputStream)nonCloseInputStream, maxLinks, maxBytes);
                            if (docs != null) {
                                maindoc.addSubDocuments(docs);
                            }
                            return new Document[]{maindoc};
                        }
                        catch (Exception e1) {
                            markableStream.reset();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new Parser.Failure("Error reading source", location);
            }
        }
        int maxBytesToRead = -1;
        if (maxBytes < Integer.MAX_VALUE) {
            maxBytesToRead = (int)maxBytes + 1;
        }
        if (contentLength >= 0L && contentLength < (long)maxBytesToRead) {
            maxBytesToRead = (int)contentLength;
        }
        byte[] b = null;
        try {
            b = FileUtils.read(sourceStream, maxBytesToRead);
        }
        catch (IOException e) {
            throw new Parser.Failure(e.getMessage(), location);
        }
        Document[] docs = TextParser.parseSource(location, mimeType, idioms, charset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, depth, b, maxLinks, maxBytes);
        return docs;
    }

    public static Document[] parseSource(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, int depth, long contentLength, InputStream sourceStream) throws Parser.Failure {
        return TextParser.parseSource(location, mimeType, charset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, depth, contentLength, sourceStream, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    public static Document[] parseWithLimits(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, int timezoneOffset, int depth, long contentLength, InputStream sourceStream, int maxLinks, long maxBytes) throws Parser.Failure {
        return TextParser.parseSource(location, mimeType, charset, defaultValency, valencySwitchTagNames, new VocabularyScraper(), timezoneOffset, depth, contentLength, sourceStream, maxLinks, maxBytes);
    }

    public static Document[] parseWithLimits(DigestURL location, String mimeType, String charset, int timezoneOffset, int depth, long contentLength, InputStream sourceStream, int maxLinks, long maxBytes) throws Parser.Failure {
        return TextParser.parseSource(location, mimeType, charset, TagValency.EVAL, new HashSet<String>(), new VocabularyScraper(), timezoneOffset, depth, contentLength, sourceStream, maxLinks, maxBytes);
    }

    private static Document[] parseSource(DigestURL location, String mimeType, Parser parser, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, InputStream sourceStream, int maxLinks, long maxBytes) throws Parser.Failure {
        if (AbstractParser.log.isFine()) {
            AbstractParser.log.fine("Parsing '" + location + "' from stream");
        }
        String fileExt = MultiProtocolURL.getFileExtension(location.getFileName());
        String documentCharset = htmlParser.patchCharsetEncoding(charset);
        assert (parser != null);
        if (AbstractParser.log.isFine()) {
            AbstractParser.log.fine("Parsing " + location + " with mimeType '" + mimeType + "' and file extension '" + fileExt + "'.");
        }
        try {
            Document[] docs;
            if (parser.isParseWithLimitsSupported()) {
                docs = parser.parseWithLimits(location, mimeType, documentCharset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, sourceStream, maxLinks, maxBytes);
            } else {
                StrictLimitInputStream limitedSource = new StrictLimitInputStream(sourceStream, maxBytes);
                docs = parser.parse(location, mimeType, documentCharset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, limitedSource);
            }
            return docs;
        }
        catch (Parser.Failure e) {
            throw e;
        }
        catch (Exception e) {
            throw new Parser.Failure("parser failed: " + parser.getName(), location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document[] parseSource(DigestURL location, String mimeType, Set<Parser> parsers, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, int depth, byte[] sourceArray, int maxLinks, long maxBytes) throws Parser.Failure {
        String fileExt = MultiProtocolURL.getFileExtension(location.getFileName());
        if (AbstractParser.log.isFine()) {
            AbstractParser.log.fine("Parsing " + location + " with mimeType '" + mimeType + "' and file extension '" + fileExt + "' from byte[]");
        }
        String documentCharset = htmlParser.patchCharsetEncoding(charset);
        assert (!parsers.isEmpty());
        Document[] docs = null;
        HashMap<Parser, Parser.Failure> failedParser = new HashMap<Parser, Parser.Failure>();
        String origName = Thread.currentThread().getName();
        Thread.currentThread().setName("parsing + " + location.toString());
        for (Parser parser : parsers) {
            block37: {
                if (!MemoryControl.request(sourceArray.length * 6, false)) continue;
                ByteArrayInputStream bis = mimeType.equals("text/plain") && parser.getName().equals("HTML Parser") ? new ByteArrayInputStream(UTF8.getBytes("<html><head></head><body><h1>" + UTF8.String(sourceArray) + "</h1></body><html>")) : new ByteArrayInputStream(sourceArray);
                try {
                    if (parser.isParseWithLimitsSupported()) {
                        docs = parser.parseWithLimits(location, mimeType, documentCharset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, bis, maxLinks, maxBytes);
                    } else {
                        if ((long)sourceArray.length > maxBytes) {
                            throw new Parser.Failure("Content size is over maximum size of " + maxBytes + "", location);
                        }
                        docs = parser.parse(location, mimeType, documentCharset, defaultValency, valencySwitchTagNames, scraper, timezoneOffset, bis);
                    }
                }
                catch (Parser.Failure failure) {
                    if (parser instanceof gzipParser && failure.getCause() instanceof gzipParser.GZIPOpeningStreamException && (parsers.size() == 1 || parsers.size() == 2 && parsers.contains(genericIdiom))) {
                        gzipParser gzParser = (gzipParser)parser;
                        bis = new ByteArrayInputStream(sourceArray);
                        Document maindoc = gzipParser.createMainDocument(location, mimeType, charset, gzParser);
                        try {
                            docs = gzParser.parseCompressedInputStream(location, charset, timezoneOffset, depth, bis, maxLinks, maxBytes);
                            if (docs != null) {
                                maindoc.addSubDocuments(docs);
                            }
                            docs = new Document[]{maindoc};
                            break;
                        }
                        catch (Parser.Failure e1) {
                            failedParser.put(parser, e1);
                            break block37;
                        }
                        catch (Exception e2) {
                            failedParser.put(parser, new Parser.Failure(e2.getMessage(), location));
                            break block37;
                        }
                    }
                    failedParser.put(parser, failure);
                }
                catch (Exception exception) {
                    failedParser.put(parser, new Parser.Failure(exception.getMessage(), location));
                }
                finally {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (docs == null) continue;
            break;
        }
        Thread.currentThread().setName(origName);
        if (docs == null) {
            if (failedParser.isEmpty()) {
                String errorMsg = "Parsing content with file extension '" + fileExt + "' and mimetype '" + mimeType + "' failed.";
                throw new Parser.Failure(errorMsg, location);
            }
            String failedParsers = "";
            for (Map.Entry error : failedParser.entrySet()) {
                AbstractParser.log.warn("tried parser '" + ((Parser)error.getKey()).getName() + "' to parse " + location.toNormalform(true) + " but failed: " + ((Parser.Failure)error.getValue()).getMessage(), (Throwable)error.getValue());
                failedParsers = failedParsers + ((Parser)error.getKey()).getName() + " ";
            }
            throw new Parser.Failure("All parser failed: " + failedParsers, location);
        }
        for (Iterator<Parser> iterator : docs) {
            InputStream textStream = ((Document)((Object)iterator)).getTextStream();
            assert (textStream != null) : "mimeType = " + mimeType;
            try {
                if (textStream != null) {
                    textStream.close();
                }
            }
            catch (IOException e) {
                AbstractParser.log.warn("Could not close text input stream");
            }
            ((Document)((Object)iterator)).setDepth(depth);
        }
        return docs;
    }

    public static String supports(MultiProtocolURL url, String mimeType) {
        try {
            Set<Parser> idioms = TextParser.parsers(url, mimeType);
            return idioms == null || idioms.isEmpty() || idioms.size() == 1 && idioms.iterator().next().getName().equals(genericIdiom.getName()) ? "no parser found" : null;
        }
        catch (Parser.Failure e) {
            return e.getMessage();
        }
    }

    private static Set<Parser> parsers(MultiProtocolURL url, String mimeType1) throws Parser.Failure {
        String mimeType2;
        String ext;
        Set idiom;
        LinkedHashSet<Parser> idioms = new LinkedHashSet<Parser>(2);
        if (mimeType1 != null) {
            if (denyMime.containsKey(mimeType1 = TextParser.normalizeMimeType(mimeType1))) {
                throw new Parser.Failure("mime type '" + mimeType1 + "' is denied (1)", url);
            }
            idiom = mime2parser.get(mimeType1);
            if (idiom != null) {
                idioms.addAll(idiom);
            }
        }
        if ((ext = MultiProtocolURL.getFileExtension(url.getFileName())) != null && ext.length() > 0) {
            if (denyExtensionx.containsKey(ext) && (mimeType1 == null || mimeType1.equals(TextParser.mimeOf(ext)))) {
                throw new Parser.Failure("file extension '" + ext + "' is denied (1)", url);
            }
            idiom = ext2parser.get(ext);
            if (idiom != null && !idioms.containsAll(idiom)) {
                idioms.addAll(idiom);
            }
        }
        if ((mimeType2 = ext2mime.get(ext)) != null && (idiom = (Set)mime2parser.get(mimeType2)) != null && !idioms.containsAll(idiom)) {
            idioms.addAll(idiom);
        }
        if (idioms.isEmpty() && mimeType1 != null && mimeType1.endsWith("+xml")) {
            idioms.add(genericXMLIdiom);
        }
        idioms.add(genericIdiom);
        return idioms;
    }

    public static String supportsMime(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if (denyMime.containsKey(mimeType = TextParser.normalizeMimeType(mimeType))) {
            return "mime type '" + mimeType + "' is denied (2)";
        }
        if (mime2parser.get(mimeType) == null && !mimeType.endsWith("+xml")) {
            return "no parser for mime '" + mimeType + "' available";
        }
        return null;
    }

    public static String supportsExtension(String ext) {
        if (ext == null || ext.isEmpty()) {
            return null;
        }
        if (denyExtensionx.containsKey(ext)) {
            return "file extension '" + ext + "' is denied (2)";
        }
        String mimeType = ext2mime.get(ext);
        if (mimeType == null) {
            return "no parser available";
        }
        Set idiom = mime2parser.get(mimeType);
        assert (idiom != null);
        if (idiom == null || idiom.isEmpty()) {
            return "no parser available (internal error!)";
        }
        return null;
    }

    public static String supportsExtension(MultiProtocolURL url) {
        return TextParser.supportsExtension(MultiProtocolURL.getFileExtension(url.getFileName()));
    }

    public static String mimeOf(MultiProtocolURL url) {
        return TextParser.mimeOf(MultiProtocolURL.getFileExtension(url.getFileName()));
    }

    public static String mimeOf(String ext) {
        return ext2mime.get(ext.toLowerCase(Locale.ROOT));
    }

    public static String normalizeMimeType(String mimeType) {
        if (mimeType == null) {
            return "application/octet-stream";
        }
        int pos = (mimeType = mimeType.toLowerCase(Locale.ROOT)).indexOf(59);
        return pos < 0 ? mimeType.trim() : mimeType.substring(0, pos).trim();
    }

    public static void setDenyMime(String denyList) {
        denyMime.clear();
        for (String s : CommonPattern.COMMA.split(denyList)) {
            String n = TextParser.normalizeMimeType(s);
            if (n == null || n.length() <= 0) continue;
            denyMime.put(n, v);
        }
    }

    public static String getDenyMime() {
        String s = "";
        for (String d : denyMime.keySet()) {
            s = s + d + ",";
        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static void grantMime(String mime, boolean grant) {
        String n = TextParser.normalizeMimeType(mime);
        if (n == null || n.isEmpty()) {
            return;
        }
        if (grant) {
            denyMime.remove(n);
        } else {
            denyMime.put(n, v);
        }
    }

    public static void setDenyExtension(String denyList) {
        denyExtensionx.clear();
        for (String s : CommonPattern.COMMA.split(denyList)) {
            denyExtensionx.put(s.trim(), v);
        }
    }

    public static String getDenyExtension() {
        String s = "";
        for (String d : denyExtensionx.keySet()) {
            s = s + d + ",";
        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static void grantExtension(String ext, boolean grant) {
        if (ext == null || ext.isEmpty()) {
            return;
        }
        if (grant) {
            denyExtensionx.remove(ext);
        } else {
            denyExtensionx.put(ext, v);
        }
    }

    static {
        TextParser.initParser(new apkParser());
        TextParser.initParser(new bzipParser());
        TextParser.initParser(new XZParser());
        TextParser.initParser(new csvParser());
        TextParser.initParser(new docParser());
        TextParser.initParser(new gzipParser());
        TextParser.initParser(new htmlParser());
        TextParser.initParser(new genericImageParser());
        TextParser.initParser(new metadataImageParser());
        TextParser.initParser(new linkScraperParser());
        TextParser.initParser(new mmParser());
        TextParser.initParser(new odtParser());
        TextParser.initParser(new ooxmlParser());
        TextParser.initParser(new pdfParser());
        TextParser.initParser(new pptParser());
        TextParser.initParser(new psParser());
        TextParser.initParser(new rssParser());
        TextParser.initParser(new rtfParser());
        TextParser.initParser(new sevenzipParser());
        TextParser.initParser(new sidAudioParser());
        TextParser.initParser(new svgParser());
        TextParser.initParser(new tarParser());
        TextParser.initParser(new torrentParser());
        TextParser.initParser(new vcfParser());
        TextParser.initParser(new vsdParser());
        TextParser.initParser(new xlsParser());
        TextParser.initParser(new zipParser());
        TextParser.initParser(new audioTagParser());
        TextParser.initParser(genericXMLIdiom);
    }
}

