/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SentenceReader
implements Iterator<StringBuilder>,
Iterable<StringBuilder> {
    private StringBuilder buffer;
    private List<StringBuilder> parsedSentences;
    private int sentencesPos;
    private String text;
    private int pos;
    private boolean pre = false;

    public SentenceReader(String text) {
        this(new ArrayList<StringBuilder>(), text, false);
    }

    public SentenceReader(String text, boolean pre) {
        this(new ArrayList<StringBuilder>(), text, pre);
    }

    public SentenceReader(List<StringBuilder> parsedSentences, String text, boolean pre) {
        assert (text != null);
        this.text = text;
        this.pos = 0;
        this.pre = pre;
        this.parsedSentences = parsedSentences == null ? new ArrayList<StringBuilder>() : parsedSentences;
        this.sentencesPos = 0;
        this.buffer = this.nextElement0();
    }

    public void pre(boolean x) {
        this.pre = x;
    }

    private StringBuilder nextElement0() {
        char nextChar;
        if (this.sentencesPos < this.parsedSentences.size()) {
            StringBuilder element = this.parsedSentences.get(this.sentencesPos);
            ++this.sentencesPos;
            return element;
        }
        StringBuilder s = new StringBuilder(80);
        char lc = ' ';
        while (this.pos < this.text.length() && (nextChar = this.text.charAt(this.pos++)) > '\u0000') {
            char c = nextChar;
            if (this.pre && (nextChar == '\n' || nextChar == '\r')) break;
            if (c < ' ') {
                c = ' ';
            }
            if (lc == ' ' && c == ' ') continue;
            s.append(c);
            if (SentenceReader.punctuation(lc) && SentenceReader.invisible(c)) break;
            lc = c;
        }
        if (s.length() == 0) {
            return null;
        }
        if (s.charAt(s.length() - 1) == ' ') {
            s.trimToSize();
            s.deleteCharAt(s.length() - 1);
        }
        this.parsedSentences.add(s);
        ++this.sentencesPos;
        return s;
    }

    public static final boolean invisible(char c) {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return false;
        }
        int type = Character.getType(c);
        return type != 2 && type != 9 && type != 1 && type != 4 && type != 5 && type != 3 && !SentenceReader.punctuation(c);
    }

    public static final boolean punctuation(char c) {
        return c == '.' || c == '!' || c == '?';
    }

    @Override
    public boolean hasNext() {
        return this.buffer != null;
    }

    @Override
    public StringBuilder next() {
        if (this.buffer == null) {
            return null;
        }
        StringBuilder r = this.buffer;
        this.buffer = this.nextElement0();
        return r;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<StringBuilder> iterator() {
        return this;
    }

    public void reset() {
        this.sentencesPos = 0;
        this.buffer = this.nextElement0();
    }

    public synchronized void close() {
        this.text = null;
        this.parsedSentences = null;
    }

    public static void main(String[] args) {
        String s = "a b ccc d";
        SentenceReader sr = new SentenceReader(s);
        for (StringBuilder a : sr) {
            System.out.println(a);
        }
    }
}

