/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data.wiki;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.yacy.data.wiki.AbstractWikiParser;
import net.yacy.data.wiki.WikiParser;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.server.serverCore;

public class WikiCode
extends AbstractWikiParser
implements WikiParser {
    private static final String EMPTY = "";
    private static final String PIPE_ESCAPED = "&#124;";
    private static final Pattern REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private static final String HTML_OPEN_DEFINITION_DESCRIPTION = "<dd>";
    private static final String HTML_CLOSE_DEFINITION_DESCRIPTION = "</dd>";
    private static final String HTML_OPEN_DEFINITION_ITEM = "<dt>";
    private static final String HTML_CLOSE_DEFINITION_ITEM = "</dt>";
    private static final String HTML_OPEN_DEFINITION_LIST = "<dl>";
    private static final String HTML_CLOSE_DEFINITION_LIST = "</dl>";
    private static final String HTML_OPEN_UNORDERED_LIST = "<ul>";
    private static final String HTML_CLOSE_UNORDERED_LIST = "</ul>";
    private static final String HTML_CLOSE_BLOCKQUOTE = "</blockquote>";
    private static final String HTML_CLOSE_LIST_ELEMENT = "</li>";
    private static final String HTML_CLOSE_ORDERED_LIST = "</ol>";
    private static final String HTML_OPEN_BLOCKQUOTE = "<blockquote>";
    private static final String HTML_OPEN_LIST_ELEMENT = "<li>";
    private static final String HTML_OPEN_ORDERED_LIST = "<ol>";
    private static final String WIKI_CLOSE_LINK = "]]";
    private static final String WIKI_OPEN_LINK = "[[";
    private static final String WIKI_CLOSE_METADATA = "}}";
    private static final String WIKI_OPEN_METADATA = "{{";
    private static final String WIKI_CLOSE_EXTERNAL_LINK = "]";
    private static final String WIKI_OPEN_EXTERNAL_LINK = "[";
    private static final String WIKI_CLOSE_PRE_ESCAPED = "&lt;/pre&gt;";
    private static final String WIKI_HR_LINE = "----";
    private static final String WIKI_IMAGE = "Image:";
    private static final String WIKI_VIDEO_YOUTUBE = "Youtube:";
    private static final String WIKI_VIDEO_VIMEO = "Vimeo:";
    private static final String WIKI_OPEN_PRE_ESCAPED = "&lt;pre&gt;";
    private static final char ASTERISK = '*';
    private static final char ONE = '1';
    private static final char TWO = '2';
    private static final char THREE = '3';
    private static final char FOUR = '4';
    private static final char FIVE = '5';
    private static final char SIX = '6';
    private static final char WIKI_FORMATTED = ' ';
    private static final char WIKI_INDENTION = ':';
    private static final char WIKI_METADATA_PARAMETER_SEPARATOR = '|';
    private static final int LEN_WIKI_CLOSE_PRE_ESCAPED = "&lt;/pre&gt;".length();
    private static final int LEN_WIKI_OPEN_PRE_ESCAPED = "&lt;pre&gt;".length();
    private static final int LEN_WIKI_OPEN_LINK = "[[".length();
    private static final int LEN_WIKI_CLOSE_LINK = "]]".length();
    private static final int LEN_WIKI_IMAGE = "Image:".length();
    private static final int LEN_WIKI_VIDEO_YOUTUBE = "Youtube:".length();
    private static final int LEN_WIKI_VIDEO_VIMEO = "Vimeo:".length();
    private static final int LEN_WIKI_OPEN_EXTERNAL_LINK = "[".length();
    private static final int LEN_WIKI_CLOSE_EXTERNAL_LINK = "]".length();
    private static final int LEN_WIKI_HR_LINE = "----".length();
    private static final int LEN_PIPE_ESCAPED = "&#124;".length();
    private static final int LEN_WIKI_OPEN_METADATA = "{{".length();
    private static final int LEN_WIKI_CLOSE_METADATA = "}}".length();
    private static final String[] TABLE_PROPERTIES = new String[]{"rowspan", "colspan", "vspace", "hspace", "cellspacing", "cellpadding", "border"};
    private static final Map<String, String[]> PROPERTY_VALUES = new HashMap<String, String[]>();
    private static final String[] HEADLINE_TAGS = new String[]{Tags.HEADLINE_6.openWiki, Tags.HEADLINE_5.openWiki, Tags.HEADLINE_4.openWiki, Tags.HEADLINE_3.openWiki, Tags.HEADLINE_2.openWiki, Tags.HEADLINE_1.openWiki};
    private static final char[] HEADLINE_LEVEL = new char[]{'1', '2', '3', '4', '5', '6'};
    private final String tableStart = "&#123;&#124;";
    private final String newLine = "&#124;-";
    private final String cellDivider = "&#124;&#124;";
    private final String tableEnd = "&#124;&#125;";
    private final String attribDivider = "&#124;";
    private final int lenTableStart = this.tableStart.length();
    private final int lenCellDivider = this.cellDivider.length();
    private final int lenTableEnd = this.tableEnd.length();
    private final int lenAttribDivider = this.attribDivider.length();
    private String orderedListLevel = "";
    private String unorderedListLevel = "";
    private String defListLevel = "";
    private boolean processingCell = false;
    private boolean processingDefList = false;
    private final boolean escape = false;
    private final boolean escaped = false;
    private boolean newRowStart = false;
    private boolean noList = false;
    private boolean processingPreformattedText = false;
    private boolean preformattedSpanning = false;
    private boolean replacedHtmlAlready = false;
    private boolean processingTable = false;
    private int preindented = 0;
    private final TableOfContent tableOfContents = new TableOfContent();

    @Override
    protected String transform(String hostport, BufferedReader reader, int length) throws IOException {
        String line;
        StringBuilder out = new StringBuilder(length);
        while ((line = reader.readLine()) != null) {
            out.append(this.processLineOfWikiCode(hostport, line)).append(serverCore.CRLF_STRING);
        }
        out.insert(0, this.createTableOfContents());
        this.tableOfContents.clear();
        return out.toString();
    }

    private void processHeadline(StringBuilder input, int firstPosition, Tags tags, int secondPosition, String direlem) {
        direlem = input.substring(firstPosition + tags.openWikiLength, secondPosition);
        if (direlem != null) {
            int doubles = 0;
            Iterator<String> iterator = this.tableOfContents.iterator();
            while (iterator.hasNext()) {
                String element = iterator.next();
                assert (element != null);
                if (!element.substring(1).equals(direlem)) continue;
                ++doubles;
            }
            String anchor = REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN.matcher(SPACE_PATTERN.matcher(direlem).replaceAll("_")).replaceAll(EMPTY);
            if (doubles > 0) {
                anchor = anchor + "_" + (doubles + 1);
            }
            StringBuilder link = new StringBuilder();
            link.append("<a name=\"");
            link.append(anchor);
            link.append("\"></a>");
            link.append(tags.openHTML);
            link.append(direlem);
            link.append(tags.closeHTML);
            input.replace(firstPosition, secondPosition + tags.closeWikiLength, link.toString());
            if (Arrays.binarySearch(HEADLINE_TAGS, tags.openWiki) >= 0) {
                this.tableOfContents.add(tags.openWikiLength - 1 + direlem);
            }
        }
    }

    private String processTable(String line) {
        StringBuilder out = new StringBuilder();
        if (line.startsWith(this.tableStart) && !this.processingTable) {
            this.processingTable = true;
            this.newRowStart = true;
            out.append("<table");
            if (line.trim().length() > this.lenTableStart) {
                out.append((CharSequence)WikiCode.filterTableProperties(line.substring(this.lenTableStart).trim()));
            }
            out.append(">");
        } else if (line.startsWith(this.newLine) && this.processingTable) {
            if (!this.newRowStart) {
                out.append("\t</tr>\n");
            } else {
                this.newRowStart = false;
            }
            out.append("\t<tr>");
        } else if (line.startsWith(this.cellDivider) && this.processingTable) {
            out.append("\t\t<td");
            int cellEnd = line.indexOf(this.cellDivider, this.lenCellDivider) > 0 ? line.indexOf(this.cellDivider, this.lenCellDivider) : line.length();
            int propEnd = line.indexOf(this.attribDivider, this.lenCellDivider);
            int occImage = line.indexOf("[[Image:", this.lenCellDivider);
            int occEscape = line.indexOf("[=", this.lenCellDivider);
            propEnd = !(propEnd <= this.lenCellDivider || occImage <= propEnd && occImage >= 0 || occEscape <= propEnd && occEscape >= 0) ? line.indexOf(this.attribDivider, this.lenCellDivider) + this.lenAttribDivider : cellEnd;
            if (propEnd == cellEnd) {
                propEnd = this.lenCellDivider;
            } else {
                out.append((CharSequence)WikiCode.filterTableProperties(line.substring(this.lenCellDivider, propEnd - this.lenAttribDivider).trim()));
            }
            if (propEnd > cellEnd) {
                propEnd = this.lenCellDivider;
            }
            this.processingTable = false;
            this.processingCell = true;
            out.append(">");
            out.append(this.processTable(line.substring(propEnd, cellEnd).trim()));
            out.append("</td>");
            this.processingTable = true;
            this.processingCell = false;
            if (cellEnd < line.length()) {
                out.append("\n");
                out.append(this.processTable(line.substring(cellEnd)));
            }
        } else if (line.startsWith(this.tableEnd) && this.processingTable) {
            this.processingTable = false;
            out.append("\t</tr>\n</table>");
            out.append(line.substring(this.lenTableEnd));
        } else {
            out.append(line);
        }
        return out.toString();
    }

    private static StringBuilder filterTableProperties(String properties) {
        String[] values = properties.replaceAll("&quot;", EMPTY).split("[= ]");
        StringBuilder stringBuilder = new StringBuilder(properties.length());
        int numberOfValues = values.length;
        for (int i = 0; i < numberOfValues; ++i) {
            Object[] posVals;
            String key = values[i].trim();
            if ("nowrap".equals(key)) {
                WikiCode.appendKeyValuePair("nowrap", "nowrap", stringBuilder);
                continue;
            }
            if (i + 1 >= numberOfValues) continue;
            String value = values[++i].trim();
            if (!("summary".equals(key) || "bgcolor".equals(key) && value.matches("#{0,1}[0-9a-fA-F]{1,6}|[a-zA-Z]{3,}") || ("width".equals(key) || "height".equals(key)) && value.matches("\\d+%{0,1}") || (posVals = PROPERTY_VALUES.get(key)) != null && Arrays.binarySearch(posVals, value) >= 0) && (Arrays.binarySearch(TABLE_PROPERTIES, key) < 0 || !value.matches("\\d+"))) continue;
            WikiCode.appendKeyValuePair(key, value, stringBuilder);
        }
        return stringBuilder;
    }

    private static StringBuilder appendKeyValuePair(String key, String value, StringBuilder stringBuilder) {
        return stringBuilder.append(" ").append(key).append("=\"").append(value).append("\"");
    }

    private String processOrderedList(String line) {
        return this.processList(line, ListType.ORDERED);
    }

    private String processUnorderedList(String line) {
        return this.processList(line, ListType.UNORDERED);
    }

    private String processList(String line, ListType listType) {
        String ret;
        if (!this.noList) {
            String htmlCloseList;
            String htmlOpenList;
            char symbol;
            String listLevel;
            if (ListType.ORDERED.equals((Object)listType)) {
                listLevel = this.orderedListLevel;
                symbol = '#';
                htmlOpenList = HTML_OPEN_ORDERED_LIST;
                htmlCloseList = HTML_CLOSE_ORDERED_LIST;
            } else if (ListType.UNORDERED.equals((Object)listType)) {
                listLevel = this.unorderedListLevel;
                symbol = '*';
                htmlOpenList = HTML_OPEN_UNORDERED_LIST;
                htmlCloseList = HTML_CLOSE_UNORDERED_LIST;
            } else {
                throw new IllegalArgumentException("Unknown list type " + (Object)((Object)listType));
            }
            if (line.startsWith(listLevel + symbol)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(htmlOpenList);
                stringBuilder.append(serverCore.CRLF_STRING);
                stringBuilder.append(HTML_OPEN_LIST_ELEMENT);
                stringBuilder.append(line.substring(listLevel.length() + 1).trim());
                stringBuilder.append(HTML_CLOSE_LIST_ELEMENT);
                ret = stringBuilder.toString();
                listLevel = listLevel + symbol;
            } else if (!listLevel.isEmpty() && line.startsWith(listLevel)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(HTML_OPEN_LIST_ELEMENT);
                stringBuilder.append(line.substring(listLevel.length()).trim());
                stringBuilder.append(HTML_CLOSE_LIST_ELEMENT);
                ret = stringBuilder.toString();
            } else if (!listLevel.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder tmp = new StringBuilder();
                int i = listLevel.length();
                while (!line.startsWith(listLevel.substring(0, i))) {
                    tmp.append(htmlCloseList);
                    --i;
                }
                int startOfContent = (listLevel = listLevel.substring(0, i)).length();
                if (startOfContent > 0) {
                    stringBuilder.append((CharSequence)tmp);
                    stringBuilder.append(HTML_OPEN_LIST_ELEMENT);
                    stringBuilder.append(line.substring(startOfContent).trim());
                    stringBuilder.append(HTML_CLOSE_LIST_ELEMENT);
                } else {
                    stringBuilder.append((CharSequence)tmp);
                    stringBuilder.append(line.substring(startOfContent).trim());
                }
                ret = stringBuilder.toString();
            } else {
                ret = line;
            }
            if (ListType.ORDERED.equals((Object)listType)) {
                this.orderedListLevel = listLevel;
            } else if (ListType.UNORDERED.equals((Object)listType)) {
                this.unorderedListLevel = listLevel;
            }
        } else {
            ret = line;
        }
        return ret;
    }

    private String processDefinitionList(String line) {
        String ret;
        if (!this.noList) {
            if (line.startsWith(this.defListLevel + ";")) {
                String copyOfLine = line.substring(this.defListLevel.length() + 1);
                int positionOfOpeningTag = copyOfLine.indexOf(58, 0);
                if (positionOfOpeningTag > 0) {
                    String definitionItem = copyOfLine.substring(0, positionOfOpeningTag);
                    String definitionDescription = copyOfLine.substring(positionOfOpeningTag + 1);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(HTML_OPEN_DEFINITION_LIST);
                    stringBuilder.append(HTML_OPEN_DEFINITION_ITEM);
                    stringBuilder.append(definitionItem);
                    stringBuilder.append(HTML_CLOSE_DEFINITION_ITEM);
                    stringBuilder.append(HTML_OPEN_DEFINITION_DESCRIPTION);
                    stringBuilder.append(definitionDescription);
                    this.processingDefList = true;
                    ret = stringBuilder.toString();
                } else {
                    ret = line;
                }
                this.defListLevel = this.defListLevel + ";";
            } else if (!this.defListLevel.isEmpty() && line.startsWith(this.defListLevel)) {
                String copyOfLine = line.substring(this.defListLevel.length());
                int positionOfOpeningTag = copyOfLine.indexOf(58, 0);
                if (positionOfOpeningTag > 0) {
                    String definitionItem = copyOfLine.substring(0, positionOfOpeningTag);
                    String definitionDescription = copyOfLine.substring(positionOfOpeningTag + 1);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(HTML_OPEN_DEFINITION_ITEM);
                    stringBuilder.append(definitionItem);
                    stringBuilder.append(HTML_CLOSE_DEFINITION_ITEM);
                    stringBuilder.append(HTML_OPEN_DEFINITION_DESCRIPTION);
                    stringBuilder.append(definitionDescription);
                    this.processingDefList = true;
                    ret = stringBuilder.toString();
                } else {
                    ret = line;
                }
            } else if (!this.defListLevel.isEmpty()) {
                int i = this.defListLevel.length();
                String tmp = EMPTY;
                while (!line.startsWith(this.defListLevel.substring(0, i))) {
                    tmp = "</dd></dl>";
                    --i;
                }
                this.defListLevel = this.defListLevel.substring(0, i);
                int positionOfOpeningTag = this.defListLevel.length();
                if (!this.defListLevel.isEmpty()) {
                    String copyOfLine = line.substring(positionOfOpeningTag);
                    if ((positionOfOpeningTag = copyOfLine.indexOf(58, 0)) > 0) {
                        String definitionItem = copyOfLine.substring(0, positionOfOpeningTag);
                        String definitionDescription = copyOfLine.substring(positionOfOpeningTag + 1);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(tmp);
                        stringBuilder.append(HTML_OPEN_DEFINITION_ITEM);
                        stringBuilder.append(definitionItem);
                        stringBuilder.append(HTML_CLOSE_DEFINITION_ITEM);
                        stringBuilder.append(HTML_OPEN_DEFINITION_DESCRIPTION);
                        stringBuilder.append(definitionDescription);
                        this.processingDefList = true;
                        ret = stringBuilder.toString();
                    } else {
                        ret = line;
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(tmp);
                    stringBuilder.append(line.substring(positionOfOpeningTag));
                    ret = stringBuilder.toString();
                }
            } else {
                ret = line;
            }
        } else {
            ret = line;
        }
        return ret;
    }

    private static String processLinksAndImages(String hostport, String line) {
        int p;
        String kv;
        String kl;
        int positionOfClosingTag;
        int positionOfOpeningTag;
        int fromIndex = 0;
        while ((positionOfOpeningTag = line.indexOf(WIKI_OPEN_LINK, fromIndex)) >= 0 && (positionOfClosingTag = line.indexOf(WIKI_CLOSE_LINK, positionOfOpeningTag + LEN_WIKI_OPEN_LINK)) > positionOfOpeningTag) {
            kl = line.substring(positionOfOpeningTag + LEN_WIKI_OPEN_LINK, positionOfClosingTag);
            if (kl.startsWith(WIKI_IMAGE)) {
                String alt = EMPTY;
                String align = EMPTY;
                kv = EMPTY;
                p = (kl = kl.substring(LEN_WIKI_IMAGE)).indexOf(PIPE_ESCAPED);
                if (p > 0) {
                    kv = kl.substring(p + LEN_WIKI_IMAGE);
                    kl = kl.substring(0, p);
                    p = kv.indexOf(PIPE_ESCAPED);
                    if (p > 0) {
                        align = kv.substring(0, p);
                        align = "bottom".equals(align) || "center".equals(align) || "left".equals(align) || "middle".equals(align) || "right".equals(align) || "top".equals(align) ? " align=\"" + align + "\"" : EMPTY;
                        alt = " alt=\"" + kv.substring(p + LEN_WIKI_IMAGE) + "\"";
                    } else {
                        alt = " alt=\"" + kv + "\"";
                    }
                }
                if (kl.indexOf("://", 0) < 1 && hostport != null && !hostport.isEmpty()) {
                    kl = "http://" + hostport + "/" + kl;
                }
                line = line.substring(0, positionOfOpeningTag) + "<img src=\"" + kl + "\"" + align + alt + ">" + line.substring(positionOfClosingTag + LEN_WIKI_CLOSE_LINK);
                fromIndex = positionOfClosingTag + LEN_WIKI_CLOSE_LINK;
                continue;
            }
            if (kl.startsWith(WIKI_VIDEO_YOUTUBE)) {
                kl = kl.substring(LEN_WIKI_VIDEO_YOUTUBE);
                line = line.substring(0, positionOfOpeningTag) + "<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.youtube.com/v/" + kl + "\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.youtube.com/v/" + kl + "\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>";
                break;
            }
            if (kl.startsWith(WIKI_VIDEO_VIMEO)) {
                kl = kl.substring(LEN_WIKI_VIDEO_VIMEO);
                line = line.substring(0, positionOfOpeningTag) + "<iframe src=\"http://player.vimeo.com/video/" + kl + "\" width=\"425\" height=\"350\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>";
                break;
            }
            p = kl.indexOf(PIPE_ESCAPED);
            if (p > 0) {
                kv = kl.substring(p + LEN_PIPE_ESCAPED);
                kl = kl.substring(0, p);
            } else {
                kv = kl;
            }
            line = line.substring(0, positionOfOpeningTag) + "<a class=\"known\" href=\"Wiki.html?page=" + kl + "\">" + kv + "</a>" + line.substring(positionOfClosingTag + LEN_WIKI_CLOSE_LINK);
            fromIndex = positionOfClosingTag + LEN_WIKI_CLOSE_LINK;
        }
        fromIndex = 0;
        while ((positionOfOpeningTag = line.indexOf(WIKI_OPEN_EXTERNAL_LINK, fromIndex)) >= 0 && (positionOfClosingTag = line.indexOf(WIKI_CLOSE_EXTERNAL_LINK, positionOfOpeningTag + LEN_WIKI_OPEN_EXTERNAL_LINK)) > positionOfOpeningTag) {
            kl = line.substring(positionOfOpeningTag + LEN_WIKI_OPEN_EXTERNAL_LINK, positionOfClosingTag);
            p = kl.indexOf(32, 0);
            if (p > 0) {
                kv = kl.substring(p + 1);
                kl = kl.substring(0, p);
            } else {
                kv = kl;
            }
            if (kl.indexOf("://", 0) < 1 && hostport != null && !hostport.isEmpty()) {
                kl = "http://" + hostport + "/" + kl;
            }
            line = line.substring(0, positionOfOpeningTag) + "<a class=\"extern\" href=\"" + kl + "\">" + kv + "</a>" + line.substring(positionOfClosingTag + LEN_WIKI_CLOSE_EXTERNAL_LINK);
            fromIndex = positionOfClosingTag + LEN_WIKI_CLOSE_EXTERNAL_LINK;
        }
        return line;
    }

    private String processPreformattedText(String hostport, String line) {
        Objects.requireNonNull(this);
        int positionOfOpeningTag = line.indexOf(WIKI_OPEN_PRE_ESCAPED);
        int positionOfClosingTag = line.indexOf(WIKI_CLOSE_PRE_ESCAPED);
        if (positionOfOpeningTag >= 0 && positionOfClosingTag > 0) {
            if (positionOfOpeningTag < positionOfClosingTag) {
                StringBuilder preformattedText = new StringBuilder();
                preformattedText.append("<pre style=\"border:dotted;border-width:thin;\">");
                preformattedText.append(line.substring(positionOfOpeningTag + LEN_WIKI_OPEN_PRE_ESCAPED, positionOfClosingTag));
                preformattedText.append("</pre>");
                line = this.processLineOfWikiCode(hostport, line.substring(0, positionOfOpeningTag).replaceAll("!pre!", "!pre!!") + "!pre!txt!" + line.substring(positionOfClosingTag + LEN_WIKI_CLOSE_PRE_ESCAPED).replaceAll("!pre!", "!pre!!"));
                line = line.replace("!pre!txt!", preformattedText.toString().replaceAll("!pre!", "!pre!!"));
                line = line.replaceAll("!pre!!", "!pre!");
            } else {
                this.processingPreformattedText = true;
                String temp1 = this.processLineOfWikiCode(hostport, line.substring(0, positionOfOpeningTag - 1).replaceAll("!tmp!", "!tmp!!") + "!tmp!txt!");
                this.noList = true;
                String temp2 = this.processLineOfWikiCode(hostport, line.substring(positionOfOpeningTag));
                this.noList = false;
                line = temp1.replaceAll("!tmp!txt!", temp2);
                line = line.replaceAll("!tmp!!", "!tmp!");
                this.processingPreformattedText = false;
            }
        } else if (positionOfOpeningTag >= 0 && !this.preformattedSpanning) {
            this.processingPreformattedText = true;
            StringBuilder openBlockQuoteTags = new StringBuilder();
            String preformattedText = "<pre style=\"border:dotted;border-width:thin;\">" + line.substring(positionOfOpeningTag + LEN_WIKI_OPEN_PRE_ESCAPED);
            preformattedText = preformattedText.replaceAll("!pre!", "!pre!!");
            while (this.preindented < positionOfOpeningTag && positionOfOpeningTag < line.length() && line.substring(this.preindented, positionOfOpeningTag).charAt(0) == ':') {
                ++this.preindented;
                openBlockQuoteTags.append(HTML_OPEN_BLOCKQUOTE);
            }
            line = this.processLineOfWikiCode(hostport, line.substring(this.preindented, positionOfOpeningTag).replaceAll("!pre!", "!pre!!") + "!pre!txt!");
            line = openBlockQuoteTags + line.replace("!pre!txt!", preformattedText);
            line = line.replaceAll("!pre!!", "!pre!");
            this.preformattedSpanning = true;
        } else if (positionOfClosingTag >= 0 && this.preformattedSpanning) {
            this.preformattedSpanning = false;
            StringBuilder endBlockQuoteTags = new StringBuilder();
            String preformattedText = line.substring(0, positionOfClosingTag) + "</pre>";
            preformattedText = preformattedText.replaceAll("!pre!", "!pre!!");
            while (this.preindented > 0) {
                endBlockQuoteTags.append(HTML_CLOSE_BLOCKQUOTE);
                --this.preindented;
            }
            line = this.processLineOfWikiCode(hostport, "!pre!txt!" + line.substring(positionOfClosingTag + LEN_WIKI_CLOSE_PRE_ESCAPED).replaceAll("!pre!", "!pre!!"));
            line = line.replace("!pre!txt!", preformattedText) + endBlockQuoteTags;
            line = line.replaceAll("!pre!!", "!pre!");
            this.processingPreformattedText = false;
        } else if (positionOfOpeningTag >= 0 && !this.preformattedSpanning) {
            int posTag;
            while ((posTag = line.indexOf(WIKI_CLOSE_PRE_ESCAPED)) >= 0) {
                line = line.substring(0, posTag) + line.substring(posTag + LEN_WIKI_CLOSE_PRE_ESCAPED);
            }
            line = this.processLineOfWikiCode(hostport, line);
        }
        return line;
    }

    private StringBuilder createTableOfContents() {
        StringBuilder directory = new StringBuilder();
        int s = 0;
        int level = 1;
        int level1 = 0;
        int level2 = 0;
        int level3 = 0;
        int level4 = 0;
        int level5 = 0;
        int level6 = 0;
        int doubles = 0;
        String anchorext = EMPTY;
        s = this.tableOfContents.size();
        if (s > 2) {
            directory.append("<table><tr><td><div class=\"WikiTOCBox\">\n");
            for (int i = 0; i < s && i < this.tableOfContents.size(); ++i) {
                String element = this.tableOfContents.get(i);
                if (element == null) continue;
                doubles = 0;
                for (int j = 0; j < i && j < this.tableOfContents.size(); ++j) {
                    String b;
                    String a;
                    String d = this.tableOfContents.get(j);
                    if (d == null || d.isEmpty() || !(a = REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN.matcher(SPACE_PATTERN.matcher(d.substring(1)).replaceAll("_")).replaceAll(EMPTY)).equals(b = REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN.matcher(SPACE_PATTERN.matcher(element.substring(1)).replaceAll("_")).replaceAll(EMPTY))) continue;
                    ++doubles;
                }
                if (doubles > 0) {
                    anchorext = "_" + (doubles + 1);
                }
                char l = element.charAt(0);
                String temp = EMPTY;
                if (Arrays.binarySearch(HEADLINE_LEVEL, l) >= 0 && !element.isEmpty()) {
                    switch (l) {
                        case '6': {
                            if (level < 6) {
                                level = 6;
                                level6 = 0;
                            }
                            temp = element.substring(1);
                            element = level1 + "." + level2 + "." + level3 + "." + level4 + "." + level5 + "." + ++level6 + " " + temp;
                            directory.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '5': {
                            if (level == 1) {
                                level2 = 0;
                                level = 2;
                            }
                            if (level == 3) {
                                level = 2;
                            }
                            temp = element.substring(1);
                            element = level1 + "." + level2 + "." + level3 + "." + level4 + "." + ++level5 + " " + temp;
                            directory.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '4': {
                            if (level == 1) {
                                level2 = 0;
                                level = 2;
                            }
                            if (level == 3) {
                                level = 2;
                            }
                            temp = element.substring(1);
                            element = level1 + "." + level2 + "." + level3 + "." + ++level4 + " " + temp;
                            directory.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '3': {
                            if (level == 1) {
                                level2 = 0;
                                level = 2;
                            }
                            if (level == 3) {
                                level = 2;
                            }
                            temp = element.substring(1);
                            element = level1 + "." + level2 + "." + ++level3 + " " + temp;
                            directory.append("&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '2': {
                            if (level == 1) {
                                level2 = 0;
                                level = 2;
                            }
                            if (level == 3) {
                                level = 2;
                            }
                            temp = element.substring(1);
                            element = level1 + "." + ++level2 + " " + temp;
                            directory.append("&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '1': {
                            if (level > 1) {
                                level = 1;
                                level2 = 0;
                                level3 = 0;
                                level4 = 0;
                                level5 = 0;
                                level6 = 0;
                            }
                            temp = element.substring(1);
                            element = ++level1 + ". " + temp;
                            directory.append("<a href=\"#");
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("illegal headline level: " + l);
                        }
                    }
                    directory.append(REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN.matcher(SPACE_PATTERN.matcher(temp).replaceAll("_")).replaceAll(EMPTY));
                    directory.append(anchorext);
                    directory.append("\" class=\"WikiTOC\">");
                    directory.append(element);
                    directory.append("</a><br />\n");
                }
                anchorext = EMPTY;
            }
            directory.append("</div></td></tr></table>\n");
        }
        return directory;
    }

    private String tagReplace(String input, Tags tags) {
        String direlem = null;
        StringBuilder stringBuilder = new StringBuilder(input);
        int firstPosition = 0;
        int secondPosition = 0;
        while ((firstPosition = stringBuilder.indexOf(tags.openWiki, secondPosition)) >= 0 && (secondPosition = stringBuilder.indexOf(tags.closeWiki, firstPosition + tags.openWikiLength)) >= 0) {
            if (Arrays.binarySearch(HEADLINE_TAGS, tags.openWiki) >= 0) {
                boolean beginsWith = true;
                for (int i = 0; i < firstPosition; ++i) {
                    if (stringBuilder.charAt(i) <= ' ') continue;
                    beginsWith = false;
                    break;
                }
                if (!beginsWith) continue;
                this.processHeadline(stringBuilder, firstPosition, tags, secondPosition, direlem);
                continue;
            }
            int oldLength = stringBuilder.length();
            stringBuilder.replace(firstPosition, firstPosition + tags.openWikiLength, tags.openHTML);
            stringBuilder.replace(secondPosition += stringBuilder.length() - oldLength, secondPosition + tags.closeWikiLength, tags.closeHTML);
        }
        return stringBuilder.toString();
    }

    private String processLineOfWikiCode(String hostport, String line) {
        line = WikiCode.processMetadata(line);
        if ((!this.replacedHtmlAlready || this.preformattedSpanning) && line.indexOf(WIKI_CLOSE_PRE_ESCAPED) < 0) {
            line = CharacterCoding.unicode2html(line, true);
            this.replacedHtmlAlready = true;
        }
        if (line.indexOf(WIKI_OPEN_PRE_ESCAPED) >= 0 || line.indexOf(WIKI_CLOSE_PRE_ESCAPED) >= 0 || this.preformattedSpanning) {
            line = this.processPreformattedText(hostport, line);
        } else {
            if (!(line = this.processTable(line)).isEmpty() && line.charAt(0) == ' ') {
                line = "<tt>" + line.substring(1) + "</tt>";
            }
            if (line.startsWith(WIKI_HR_LINE)) {
                line = "<hr />" + line.substring(LEN_WIKI_HR_LINE);
            }
            if (!line.isEmpty() && line.charAt(0) == ':') {
                StringBuilder head = new StringBuilder();
                StringBuilder tail = new StringBuilder();
                while (!line.isEmpty() && line.charAt(0) == ':') {
                    head.append(HTML_OPEN_BLOCKQUOTE);
                    tail.append(HTML_CLOSE_BLOCKQUOTE);
                    line = line.substring(1);
                }
                line = head + line + tail;
            }
            line = this.tagReplace(line, Tags.HEADLINE_6);
            line = this.tagReplace(line, Tags.HEADLINE_5);
            line = this.tagReplace(line, Tags.HEADLINE_4);
            line = this.tagReplace(line, Tags.HEADLINE_3);
            line = this.tagReplace(line, Tags.HEADLINE_2);
            line = this.tagReplace(line, Tags.HEADLINE_1);
            line = this.tagReplace(line, Tags.EMPHASIZE_3);
            line = this.tagReplace(line, Tags.EMPHASIZE_2);
            line = this.tagReplace(line, Tags.EMPHASIZE_1);
            line = this.tagReplace(line, Tags.STRIKE);
            line = this.tagReplace(line, Tags.UNDERLINE);
            line = this.processUnorderedList(line);
            line = this.processOrderedList(line);
            line = this.processDefinitionList(line);
            line = WikiCode.processLinksAndImages(hostport, line);
        }
        if (!this.processingPreformattedText) {
            this.replacedHtmlAlready = false;
        }
        if (!line.endsWith(HTML_CLOSE_LIST_ELEMENT) && !this.processingDefList) {
            Objects.requireNonNull(this);
            if (!(this.processingPreformattedText || this.processingTable || this.processingCell)) {
                line = line + "<br />";
            }
        }
        return line;
    }

    protected static String processMetadata(String line) {
        int closeIndex;
        int openIndex;
        StringBuilder processedLine = new StringBuilder(line);
        int fromIndex = 0;
        while ((openIndex = processedLine.indexOf(WIKI_OPEN_METADATA, fromIndex)) >= 0) {
            closeIndex = processedLine.indexOf(WIKI_CLOSE_METADATA, openIndex + LEN_WIKI_OPEN_METADATA);
            int nextOpenIndex = processedLine.indexOf(WIKI_OPEN_METADATA, openIndex + LEN_WIKI_OPEN_METADATA);
            while (nextOpenIndex >= 0 && nextOpenIndex < closeIndex && (closeIndex = processedLine.indexOf(WIKI_CLOSE_METADATA, closeIndex + LEN_WIKI_CLOSE_METADATA)) >= 0) {
                nextOpenIndex = processedLine.indexOf(WIKI_OPEN_METADATA, nextOpenIndex + LEN_WIKI_OPEN_METADATA);
            }
            if (closeIndex > 0) {
                String processedContent;
                String content = processedLine.substring(openIndex + LEN_WIKI_OPEN_METADATA, closeIndex);
                if (content.toLowerCase(Locale.ROOT).startsWith("coordinate")) {
                    String[] b = content.split("\\|");
                    float lon = Float.NaN;
                    float lat = Float.NaN;
                    float lonm = 0.0f;
                    float latm = 0.0f;
                    String lono = "E";
                    String lato = "N";
                    String name = EMPTY;
                    try {
                        for (String c : b) {
                            float l;
                            String[] d;
                            if (c.toLowerCase(Locale.ROOT).startsWith("name=")) {
                                name = c.substring(5);
                            }
                            if (c.toUpperCase().startsWith("NS=")) {
                                d = c.substring(3).split("/");
                                if (d.length == 1) {
                                    l = Float.parseFloat(d[0]);
                                    if (l < 0.0f) {
                                        lato = "S";
                                        l = -l;
                                    }
                                    lat = (float)Math.floor(l);
                                    latm = 60.0f * (l - lat);
                                } else if (d.length > 1) {
                                    lat = Float.parseFloat(d[0]);
                                    if (!d[1].isEmpty()) {
                                        latm = Float.parseFloat(d[1]);
                                    }
                                    if (d.length >= 3 && !d[2].isEmpty()) {
                                        latm += Float.parseFloat(d[2]) / 60.0f;
                                    }
                                    if (d[d.length - 1].toUpperCase().equals("S")) {
                                        lato = "S";
                                    }
                                }
                            }
                            if (!c.toUpperCase().startsWith("EW=")) continue;
                            d = c.substring(3).split("/");
                            if (d.length == 1) {
                                l = Float.parseFloat(d[0]);
                                if (l < 0.0f) {
                                    lono = "W";
                                    l = -l;
                                }
                                lon = (float)Math.floor(l);
                                lonm = 60.0f * (l - lon);
                                continue;
                            }
                            if (d.length <= 1) continue;
                            lon = Float.parseFloat(d[0]);
                            if (!d[1].isEmpty()) {
                                lonm = Float.parseFloat(d[1]);
                            }
                            if (d.length >= 3 && !d[2].isEmpty()) {
                                lonm += Float.parseFloat(d[2]) / 60.0f;
                            }
                            if (!d[d.length - 1].toUpperCase().equals("W")) continue;
                            lono = "W";
                        }
                    }
                    catch (NumberFormatException nsExcept) {
                        processedLine.delete(closeIndex, closeIndex + LEN_WIKI_CLOSE_METADATA);
                        processedLine.delete(openIndex, openIndex + LEN_WIKI_OPEN_METADATA);
                        fromIndex = openIndex;
                        continue;
                    }
                    if (!Float.isNaN(lon) && !Float.isNaN(lat)) {
                        String htmlCoord = (name.length() > 0 ? " " + name : EMPTY) + ' ' + "<nobr> " + lato + " " + lat + "\u00b0 " + latm + "'</nobr><nobr>" + lono + " " + lon + "\u00b0 " + lonm + "'</nobr>" + ' ';
                        processedLine.replace(openIndex, closeIndex + LEN_WIKI_CLOSE_METADATA, htmlCoord);
                        fromIndex = openIndex;
                        continue;
                    }
                    fromIndex = closeIndex;
                    continue;
                }
                int nestedOpenTagIndex = content.indexOf(WIKI_OPEN_METADATA);
                int lastNestedCloseTagIndex = content.lastIndexOf(WIKI_CLOSE_METADATA);
                if (nestedOpenTagIndex >= 0 && lastNestedCloseTagIndex > 0) {
                    processedContent = ' ' + content.substring(0, nestedOpenTagIndex).replace('|', ' ').replace('=', ' ') + content.substring(nestedOpenTagIndex, lastNestedCloseTagIndex) + content.substring(lastNestedCloseTagIndex).replace('|', ' ').replace('=', ' ') + ' ';
                    fromIndex = openIndex;
                } else {
                    processedContent = ' ' + content.replace('|', ' ').replace('=', ' ') + ' ';
                    fromIndex = openIndex + processedContent.length();
                }
                processedLine.replace(openIndex, closeIndex + LEN_WIKI_CLOSE_METADATA, processedContent);
                continue;
            }
            int nestedOpenTagIndex = processedLine.indexOf(WIKI_OPEN_METADATA, openIndex + LEN_WIKI_OPEN_METADATA);
            if (nestedOpenTagIndex >= 0) {
                processedLine.replace(openIndex, nestedOpenTagIndex, ' ' + processedLine.substring(openIndex + LEN_WIKI_OPEN_METADATA, nestedOpenTagIndex).replace('|', ' ').replace('=', ' '));
                fromIndex = openIndex;
                continue;
            }
            processedLine.replace(openIndex, processedLine.length(), ' ' + processedLine.substring(openIndex + LEN_WIKI_OPEN_METADATA).replace('|', ' ').replace('=', ' '));
            break;
        }
        fromIndex = 0;
        while ((closeIndex = processedLine.indexOf(WIKI_CLOSE_METADATA, fromIndex)) >= 0) {
            processedLine.replace(fromIndex, closeIndex, processedLine.substring(fromIndex, closeIndex).replace('|', ' ').replace('=', ' '));
            processedLine.delete(closeIndex, closeIndex + LEN_WIKI_CLOSE_METADATA);
            fromIndex = closeIndex;
        }
        String result = processedLine.toString();
        if (result.matches("^\\s*\\|\\s*[^\\-\\}\\|].*")) {
            result = result.replace('|', ' ').replace('=', ' ');
        }
        return result;
    }

    static {
        Arrays.sort(HEADLINE_LEVEL);
        Arrays.sort(HEADLINE_TAGS);
        Arrays.sort(TABLE_PROPERTIES);
        Object[] array = new String[]{"void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box", "border"};
        Arrays.sort(array);
        PROPERTY_VALUES.put("frame", (String[])array);
        array = new String[]{"none", "groups", "rows", "cols", "all"};
        Arrays.sort(array);
        PROPERTY_VALUES.put("rules", (String[])array);
        array = new String[]{"top", "middle", "bottom", "baseline"};
        Arrays.sort(array);
        PROPERTY_VALUES.put("valign", (String[])array);
        array = new String[]{"left", "right", "center"};
        Arrays.sort(array);
        PROPERTY_VALUES.put("align", (String[])array);
    }

    private class TableOfContent {
        private final List<String> toc = new ArrayList<String>();

        private TableOfContent() {
        }

        int size() {
            return this.toc.size();
        }

        String get(int index2) {
            return this.toc.get(index2);
        }

        synchronized boolean add(String element) {
            return this.toc.add(element);
        }

        Iterator<String> iterator() {
            return this.toc.iterator();
        }

        void clear() {
            this.toc.clear();
        }
    }

    private static enum ListType {
        ORDERED,
        UNORDERED;

    }

    private static enum Tags {
        HEADLINE_1("=", "<h1>", "</h1>"),
        HEADLINE_2("==", "<h2>", "</h2>"),
        HEADLINE_3("===", "<h3>", "</h3>"),
        HEADLINE_4("====", "<h4>", "</h4>"),
        HEADLINE_5("=====", "<h5>", "</h5>"),
        HEADLINE_6("======", "<h6>", "</h6>"),
        EMPHASIZE_1("''", "<i>", "</i>"),
        EMPHASIZE_2("'''", "<b>", "</b>"),
        EMPHASIZE_3("'''''", "<b><i>", "</i></b>"),
        STRIKE("&lt;s&gt;", "&lt;/s&gt;", "<span class=\"strike\">", "</span>"),
        UNDERLINE("&lt;u&gt;", "&lt;/u&gt;", "<span class=\"underline\">", "</span>");

        final String openHTML;
        final String closeHTML;
        final String openWiki;
        final String closeWiki;
        final int openWikiLength;
        final int closeWikiLength;

        private Tags(String openWiki, String closeWiki, String openHTML, String closeHTML) {
            if (openHTML == null || closeHTML == null || openWiki == null || closeWiki == null) {
                throw new IllegalArgumentException("Parameter may not be null.");
            }
            this.openHTML = openHTML;
            this.closeHTML = closeHTML;
            this.openWiki = openWiki;
            this.closeWiki = closeWiki;
            this.openWikiLength = openWiki.length();
            this.closeWikiLength = closeWiki.length();
        }

        private Tags(String wiki, String openHTML, String closeHTML) {
            this(wiki, wiki, openHTML, closeHTML);
        }
    }
}

