/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.Cookie;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.Digest;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.MapHeap;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.kelondroException;
import net.yacy.search.Switchboard;

public final class UserDB {
    private static final int USERNAME_MIN_LENGTH = 4;
    private MapHeap userTable;
    private final File userTableFile;
    private final Map<String, String> ipUsers = new HashMap<String, String>();
    private final Map<String, Entry> cookieUsers = new HashMap<String, Entry>();

    public UserDB(File userTableFile) throws IOException {
        this.userTableFile = userTableFile;
        userTableFile.getParentFile().mkdirs();
        this.userTable = new MapHeap(userTableFile, 128, NaturalOrder.naturalOrder, 65536, 10, '_');
    }

    void resetDatabase() {
        if (this.userTable != null) {
            this.userTable.close();
        }
        FileUtils.deletedelete(this.userTableFile);
        this.userTableFile.getParentFile().mkdirs();
        try {
            this.userTable = new MapHeap(this.userTableFile, 128, NaturalOrder.naturalOrder, 65536, 10, '_');
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    public synchronized void close() {
        this.userTable.close();
    }

    public int size() {
        return this.userTable.size();
    }

    public void removeEntry(String hostName) {
        try {
            this.userTable.delete(UTF8.getBytes(hostName));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    public Entry getEntry(String userName) {
        if (userName.length() > 128) {
            userName = userName.substring(0, 127);
        }
        Map<String, String> record = null;
        try {
            record = this.userTable.get(UTF8.getBytes(userName));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        return record != null ? new Entry(userName, record) : null;
    }

    public Entry createEntry(String userName, Map<String, String> userProps) throws IllegalArgumentException {
        Entry entry2 = new Entry(userName, userProps);
        return entry2;
    }

    public String addEntry(Entry entry2) {
        try {
            this.userTable.insert(UTF8.getBytes(entry2.userName), entry2.mem);
            return entry2.userName;
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public Entry proxyAuth(RequestHeader header) {
        Principal authenticatedUser;
        Entry entry2 = null;
        if (header == null) {
            return entry2;
        }
        String authHeader = header.get("Authorization", "").trim();
        if (authHeader.toUpperCase(Locale.ROOT).startsWith("BASIC")) {
            String auth = authHeader.substring(6);
            String[] tmp = Base64Order.standardCoder.decodeString(auth.trim()).split(":");
            if (tmp.length == 2 && (entry2 = this.passwordAuth(tmp[0], tmp[1])) == null) {
                entry2 = this.md5Auth(tmp[0], tmp[1]);
            }
        } else if (authHeader.toUpperCase(Locale.ROOT).startsWith("DIGEST") && (authenticatedUser = header.getUserPrincipal()) != null && authenticatedUser.getName() != null) {
            entry2 = this.getEntry(authenticatedUser.getName());
        }
        return entry2;
    }

    public Entry getUser(RequestHeader header) {
        return this.getUser(header, header.getCookies());
    }

    public Entry getUser(RequestHeader header, Cookie[] cookies) {
        Entry entry2 = this.proxyAuth(header);
        if (entry2 == null && cookies != null) {
            entry2 = this.cookieAuth(cookies);
        }
        return entry2;
    }

    public boolean hasAdminRight(RequestHeader header, Cookie[] cookies) {
        Entry entry2 = this.getUser(header, cookies);
        return entry2 != null ? entry2.hasRight(AccessRight.ADMIN_RIGHT) : false;
    }

    public Entry proxyAuth(RequestHeader header, String ip) {
        Entry entry2 = this.proxyAuth(header);
        if (entry2 != null) {
            entry2.updateLastAccess(false);
            this.ipUsers.put(ip, entry2.getUserName());
        }
        return entry2;
    }

    public Entry ipAuth(String ip) {
        if (this.ipUsers.containsKey(ip)) {
            String user = this.ipUsers.get(ip);
            Entry entry2 = this.getEntry(user);
            Long entryTimestamp = entry2.getLastAccess();
            if (entryTimestamp == null || System.currentTimeMillis() - entryTimestamp > 600000L) {
                return null;
            }
            return entry2;
        }
        return null;
    }

    public Entry passwordAuth(String user, String password) {
        boolean authok;
        String md5pwd;
        Entry entry2 = this.getEntry(user);
        if (entry2 != null && (md5pwd = entry2.getMD5EncodedUserPwd()) != null && (authok = md5pwd.startsWith("MD5:") ? md5pwd.equals("MD5:" + Digest.encodeMD5Hex(user + ":" + Switchboard.getSwitchboard().getConfig("adminRealm", "YaCy") + ":" + password)) : md5pwd.equals(Digest.encodeMD5Hex(user + ":" + password)))) {
            entry2.updateLastAccess(false);
            return entry2;
        }
        return null;
    }

    public Entry passwordAuth(String user, String password, String ip) {
        Entry entry2 = this.passwordAuth(user, password);
        if (entry2 != null) {
            entry2.updateLastAccess(false);
            this.ipUsers.put(ip, entry2.getUserName());
        }
        return entry2;
    }

    public Entry md5Auth(String user, String md5) {
        Entry entry2 = this.getEntry(user);
        if (entry2 != null && entry2.getMD5EncodedUserPwd().endsWith(md5)) {
            entry2.updateLastAccess(false);
            return entry2;
        }
        return null;
    }

    public Entry cookieAuth(Cookie[] cookies) {
        String token = UserDB.getLoginToken(cookies);
        if (this.cookieUsers.containsKey(token)) {
            Entry entry2 = this.cookieUsers.get(token);
            return entry2;
        }
        return null;
    }

    public String getCookie(Entry entry2) {
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        this.cookieUsers.put(token, entry2);
        return token;
    }

    public static String getLoginToken(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals("login")) continue;
                return c.getValue().trim();
            }
        }
        return "";
    }

    public Iterator<Entry> iterator(boolean up) {
        try {
            return new userIterator(up);
        }
        catch (IOException e) {
            return new HashSet().iterator();
        }
    }

    public class userIterator
    implements Iterator<Entry> {
        CloneableIterator<byte[]> userIter;

        public userIterator(boolean up) throws IOException {
            this.userIter = UserDB.this.userTable.keys(up, false);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.userIter.hasNext();
            }
            catch (kelondroException e) {
                UserDB.this.resetDatabase();
                return false;
            }
        }

        @Override
        public Entry next() {
            try {
                return UserDB.this.getEntry(UTF8.String((byte[])this.userIter.next()));
            }
            catch (kelondroException e) {
                UserDB.this.resetDatabase();
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method not implemented yet.");
        }
    }

    public class Entry {
        public static final String MD5ENCODED_USERPWD_STRING = "MD5_user:pwd";
        public static final String USER_FIRSTNAME = "firstName";
        public static final String USER_LASTNAME = "lastName";
        public static final String USER_ADDRESS = "address";
        public static final String LAST_ACCESS = "lastAccess";
        public static final String TIME_USED = "timeUsed";
        public static final String TIME_LIMIT = "timeLimit";
        public static final String TRAFFIC_SIZE = "trafficSize";
        public static final String TRAFFIC_LIMIT = "trafficLimit";
        public static final int PROXY_ALLOK = 0;
        public static final int PROXY_ERROR = 1;
        public static final int PROXY_NORIGHT = 2;
        public static final int PROXY_TIMELIMIT_REACHED = 3;
        private Map<String, String> mem;
        private String userName;
        private final Calendar oldDate;
        private final Calendar newDate;

        public Entry(String userName, Map<String, String> mem) throws IllegalArgumentException {
            if (userName == null || userName.isEmpty()) {
                throw new IllegalArgumentException("Username needed.");
            }
            if (userName.length() > 128) {
                throw new IllegalArgumentException("Username too long!");
            }
            this.userName = userName.trim();
            if (this.userName.length() < 4) {
                throw new IllegalArgumentException("Username too short. Length should be >= 4");
            }
            this.mem = mem == null ? new HashMap() : mem;
            this.oldDate = Calendar.getInstance();
            this.newDate = Calendar.getInstance();
        }

        public String getUserName() {
            return this.userName;
        }

        public String getFirstName() {
            return this.mem.containsKey(USER_FIRSTNAME) ? this.mem.get(USER_FIRSTNAME) : null;
        }

        public String getLastName() {
            return this.mem.containsKey(USER_LASTNAME) ? this.mem.get(USER_LASTNAME) : null;
        }

        public String getAddress() {
            return this.mem.containsKey(USER_ADDRESS) ? this.mem.get(USER_ADDRESS) : null;
        }

        public long getTimeUsed() {
            long ret = 0L;
            String s = this.mem.get(TIME_USED);
            if (s != null && s.length() > 0) {
                try {
                    ret = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    ConcurrentLog.logException(e);
                }
            } else {
                try {
                    this.setProperty(TIME_USED, "0");
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
            }
            return ret;
        }

        public long getTimeLimit() {
            long ret = 0L;
            String s = this.mem.get(TIME_LIMIT);
            if (s != null && s.length() > 0) {
                try {
                    ret = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    ConcurrentLog.logException(e);
                }
            } else {
                try {
                    this.setProperty(TIME_LIMIT, "0");
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
            }
            return ret;
        }

        public long getTrafficSize() {
            long ret = 0L;
            String s = this.mem.get(TRAFFIC_SIZE);
            if (s != null && s.length() > 0) {
                try {
                    ret = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    ConcurrentLog.logException(e);
                }
            } else {
                try {
                    this.setProperty(TRAFFIC_SIZE, "0");
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
            }
            return ret;
        }

        public Long getTrafficLimit() {
            return this.mem.containsKey(TRAFFIC_LIMIT) ? Long.valueOf(this.mem.get(TRAFFIC_LIMIT)) : null;
        }

        public long updateTrafficSize(long responseSize) {
            if (responseSize < 0L) {
                throw new IllegalArgumentException("responseSize must be greater or equal zero.");
            }
            long currentTrafficSize = this.getTrafficSize();
            long newTrafficSize = currentTrafficSize + responseSize;
            try {
                this.setProperty(TRAFFIC_SIZE, Long.toString(newTrafficSize));
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            return newTrafficSize;
        }

        public Long getLastAccess() {
            return this.mem.containsKey(LAST_ACCESS) ? Long.valueOf(this.mem.get(LAST_ACCESS)) : null;
        }

        public int surfRight() {
            long timeUsed = this.updateLastAccess(true);
            int ret = !this.hasRight(AccessRight.PROXY_RIGHT) ? 2 : (this.getTimeLimit() > 0L && timeUsed >= this.getTimeLimit() ? 3 : 0);
            return ret;
        }

        public boolean canSurf() {
            return this.surfRight() == 0;
        }

        public long updateLastAccess(boolean incrementTimeUsed) {
            return this.updateLastAccess(System.currentTimeMillis(), incrementTimeUsed);
        }

        public long updateLastAccess(long timeStamp, boolean incrementTimeUsed) {
            if (timeStamp < 0L) {
                throw new IllegalArgumentException();
            }
            Long lastAccess = this.getLastAccess();
            long newTimeUsed = this.getTimeUsed();
            if (incrementTimeUsed) {
                if (lastAccess == null || timeStamp - lastAccess >= 60000L) {
                    ++newTimeUsed;
                    if (lastAccess != null) {
                        this.oldDate.setTime(new Date(lastAccess));
                        this.newDate.setTime(new Date(System.currentTimeMillis()));
                        if (this.oldDate.get(5) != this.newDate.get(5) || this.oldDate.get(2) != this.newDate.get(2) || this.oldDate.get(1) != this.newDate.get(1)) {
                            newTimeUsed = 0L;
                        }
                    } else {
                        newTimeUsed = 0L;
                    }
                    this.mem.put(TIME_USED, Long.toString(newTimeUsed));
                    this.mem.put(LAST_ACCESS, Long.toString(timeStamp));
                }
            } else {
                this.mem.put(LAST_ACCESS, Long.toString(timeStamp));
            }
            try {
                UserDB.this.userTable.insert(UTF8.getBytes(this.getUserName()), this.mem);
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            return newTimeUsed;
        }

        public String getMD5EncodedUserPwd() {
            return this.mem.containsKey(MD5ENCODED_USERPWD_STRING) ? this.mem.get(MD5ENCODED_USERPWD_STRING) : null;
        }

        public Map<String, String> getProperties() {
            return this.mem;
        }

        public void setProperty(String propName, String newValue) throws IOException, SpaceExceededException {
            this.mem.put(propName, newValue);
            UserDB.this.userTable.insert(UTF8.getBytes(this.getUserName()), this.mem);
        }

        public String getProperty(String propName, String defaultValue) {
            return this.mem.containsKey(propName) ? this.mem.get(propName) : defaultValue;
        }

        public boolean hasRight(AccessRight accessRight) {
            return this.mem.containsKey(accessRight.toString()) ? this.mem.get(accessRight.toString()).equals("true") : false;
        }

        public void logout(String ip, String logintoken) {
            this.logout(ip);
            if (UserDB.this.cookieUsers.containsKey(logintoken)) {
                UserDB.this.cookieUsers.remove(logintoken);
            }
        }

        public void logout(String ip) {
            try {
                if (UserDB.this.ipUsers.containsKey(ip)) {
                    UserDB.this.ipUsers.remove(ip);
                }
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(this.userName == null ? "null" : this.userName).append(": ");
            if (this.mem != null) {
                str.append(this.mem.toString());
            }
            return str.toString();
        }
    }

    public static enum AccessRight {
        UPLOAD_RIGHT("uploadRight", "Upload"),
        DOWNLOAD_RIGHT("downloadRight", "Download"),
        ADMIN_RIGHT("adminRight", "Admin"),
        PROXY_RIGHT("proxyRight", "Proxy usage"),
        BLOG_RIGHT("blogRight", "Blog"),
        WIKIADMIN_RIGHT("wikiAdminRight", "Wiki Admin"),
        BOOKMARK_RIGHT("bookmarkRight", "Bookmark"),
        EXTENDED_SEARCH_RIGHT("extendedSearchRight", "Extended Search");

        private String name;
        private String friendlyName;

        private AccessRight(String name, String friendlyName) {
            this.friendlyName = friendlyName;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }
}

