/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.ListManager;
import net.yacy.document.SentenceReader;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.Formatter;
import net.yacy.search.Switchboard;
import net.yacy.server.serverCore;
import net.yacy.server.serverSwitch;
import net.yacy.utils.translation.ExtensionsFileFilter;

public class Translator {
    public static final String LANG_FILENAME_FILTER = "^.*\\.lng$";

    public String translate(StringBuilder source, Map<String, String> translationTable) {
        Set<Map.Entry<String, String>> entries2 = translationTable.entrySet();
        StringBuilder builder = new StringBuilder(source);
        for (Map.Entry<String, String> entry2 : entries2) {
            String key = entry2.getKey();
            if (key == null || key.isEmpty()) continue;
            String translation = entry2.getValue();
            int index2 = builder.indexOf(key);
            if (index2 < 0 || translation == null) {
                if (!ConcurrentLog.isFine("TRANSLATOR")) continue;
                ConcurrentLog.fine("TRANSLATOR", "Unused String: " + key);
                continue;
            }
            while (index2 >= 0) {
                char c;
                boolean boundary;
                boolean bl = boundary = index2 + key.length() >= builder.length();
                if (!boundary) {
                    c = builder.charAt(index2 + key.length() - 1);
                    char lc = builder.charAt(index2 + key.length());
                    boundary |= SentenceReader.punctuation(c) || SentenceReader.invisible(c);
                    boundary |= SentenceReader.punctuation(lc) || SentenceReader.invisible(lc);
                }
                if (boundary && index2 > 0) {
                    c = builder.charAt(index2 - 1);
                    boundary = SentenceReader.punctuation(c) || SentenceReader.invisible(c);
                    char fc = builder.charAt(index2);
                    boundary |= SentenceReader.punctuation(fc) || SentenceReader.invisible(fc);
                }
                if (boundary) {
                    builder.replace(index2, index2 + key.length(), translation);
                    index2 = builder.indexOf(key, index2 + translation.length());
                    continue;
                }
                index2 = builder.indexOf(key, index2 + key.length());
            }
        }
        return builder.toString();
    }

    public Map<String, Map<String, String>> loadTranslationsLists(File translationFile) {
        HashMap<String, Map<String, String>> lists = new HashMap<String, Map<String, String>>();
        Map<String, String> translationList = new LinkedHashMap<String, String>();
        ArrayList<String> list2 = FileUtils.getListArray(translationFile);
        String forFile = "";
        for (String line : list2) {
            if (line.isEmpty()) continue;
            if (line.charAt(0) != '#') {
                String[] split = line.split("==", 2);
                if (split.length != 2) continue;
                translationList.put(split[0], split[1]);
                continue;
            }
            if (!line.startsWith("#File:")) continue;
            if (!forFile.isEmpty()) {
                lists.put(forFile, translationList);
            }
            if (lists.containsKey(forFile = line.substring(6).trim())) {
                translationList = (Map)lists.get(forFile);
                continue;
            }
            translationList = new LinkedHashMap();
        }
        lists.put(forFile, translationList);
        return lists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean translateFile(File sourceFile, File destFile, Map<String, String> translationList) {
        StringBuilder content = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), StandardCharsets.UTF_8));
            String line = null;
            while ((line = br.readLine()) != null) {
                content.append(line).append(serverCore.CRLF_STRING);
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        String processedContent = this.translate(content, translationList);
        try (FileOutputStream outStream = new FileOutputStream(destFile);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8));){
            bw.write(processedContent);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean translateFiles(File sourceDir, File destDir, File baseDir, Map<String, Map<String, String>> translationLists, String extensions) {
        File[] sourceFiles;
        destDir.mkdirs();
        Vector<String> exts = ListManager.string2vector(extensions);
        for (File sourceFile : sourceFiles = sourceDir.listFiles(new ExtensionsFileFilter(exts))) {
            String relativePath;
            try {
                relativePath = sourceFile.getAbsolutePath().substring(baseDir.getAbsolutePath().length() + 1);
                relativePath = relativePath.replace(File.separatorChar, '/');
            }
            catch (IndexOutOfBoundsException e) {
                ConcurrentLog.severe("TRANSLATOR", "Error creating relative Path for " + sourceFile.getAbsolutePath());
                relativePath = "wrong path";
            }
            if (!translationLists.containsKey(relativePath)) continue;
            ConcurrentLog.info("TRANSLATOR", "Translating file: " + relativePath);
            if (this.translateFile(sourceFile, new File(destDir, sourceFile.getName().replace('/', File.separatorChar)), translationLists.get(relativePath))) continue;
            ConcurrentLog.severe("TRANSLATOR", "File error while translating file " + relativePath);
        }
        return true;
    }

    public boolean translateFilesRecursive(File sourceDir, File destDir, File translationFile, String extensions, String notdir) {
        ArrayList<File> dirList = FileUtils.getDirsRecursive(sourceDir, notdir);
        dirList.add(sourceDir);
        Map<String, Map<String, String>> translationLists = this.loadTranslationsLists(translationFile);
        boolean erg = true;
        for (File file : dirList) {
            if (!file.isDirectory() || file.getName().equals(notdir)) continue;
            File file2 = new File(destDir, file.getPath().substring(sourceDir.getPath().length()));
            erg &= this.translateFiles(file, file2, sourceDir, translationLists, extensions);
        }
        return erg;
    }

    public static Map<String, String> langMap(serverSwitch env) {
        String[] ms = CommonPattern.COMMA.split("browser/Browser Language,default/English,de/Deutsch,fr/Fran&ccedil;ais,nl/Nederlands,it/Italiano,es/Espa&ntilde;ol,pt/Portug&ecirc;s,fi/Suomi,se/Svenska,dk/Dansk,el/E&lambda;&lambda;&eta;v&iota;&kappa;&alpha;,sk/Slovensky,zh/&#27721;&#35821;/&#28450;&#35486;,ru/&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;,uk/&#1059;&#1082;&#1088;&#1072;&#1111;&#1085;&#1089;&#1100;&#1082;&#1072;,hi/&#2361;&#2367;&#2344;&#2381;&#2342;&#2368;,ja/&#26085;&#26412;&#35486;");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String element : ms) {
            int p = element.indexOf(47);
            if (p <= 0) continue;
            map.put(element.substring(0, p), element.substring(p + 1));
        }
        return map;
    }

    public boolean changeLang(serverSwitch env, File langPath, String lang) {
        boolean ret = false;
        if ("default".equals(lang) || "default.lng".equals(lang)) {
            env.setConfig("locale.language", "default");
            ret = true;
        } else if ("browser".equals(lang) || "browser.lng".equals(lang)) {
            env.setConfig("locale.language", "browser");
            ret = true;
        } else {
            File translationFile;
            File destDir;
            String htRootPath = env.getConfig("htRootPath", "htroot");
            File sourceDir = new File(env.getAppPath(), htRootPath);
            if (this.translateFilesRecursive(sourceDir, destDir = new File(env.getDataPath("locale.translated_html", "DATA/LOCALE/htroot"), lang.substring(0, lang.length() - 4)), translationFile = new File(langPath, lang), "html,template,inc", "locale")) {
                env.setConfig("locale.language", lang.substring(0, lang.length() - 4));
                Formatter.setLocale(env.getConfig("locale.language", "en"));
                try {
                    BufferedWriter bw = new BufferedWriter(new PrintWriter(new FileWriter(new File(destDir, "version"))));
                    bw.write(env.getConfig("Version", "Error getting Version"));
                    bw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ret = true;
            }
        }
        return ret;
    }

    public static List<String> langFiles(File langPath) {
        return FileUtils.getDirListing(langPath, LANG_FILENAME_FILTER);
    }

    public static List<String> activeTranslations() {
        File[] list2;
        Switchboard sb = Switchboard.getSwitchboard();
        File localePath = sb != null ? sb.getDataPath("locale.translated_html", "DATA/LOCALE/htroot") : new File("DATA/LOCALE/htroot");
        ArrayList<String> dirlist = new ArrayList<String>();
        if (localePath.isDirectory() && (list2 = localePath.listFiles()) != null) {
            for (File f : list2) {
                if (!f.isDirectory()) continue;
                dirlist.add(f.getName());
            }
        }
        return dirlist;
    }
}

