/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.StringBuilderComparator;
import net.yacy.document.LibraryProvider;
import net.yacy.search.index.Segment;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;

public class DidYouMean {
    private static final ConcurrentLog logger;
    private static final int MinimumInputWordLength = 2;
    private static final int MinimumOutputWordLength = 4;
    private static final char[] ALPHABET_LATIN;
    private static final char[] ALPHABET_KANJI;
    private static final char[] ALPHABET_HIRAGANA;
    private static final char[] ALPHABET_KATAKANA;
    private static final char[] ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part1;
    private static final char[] ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part2;
    private static final char[] ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part3;
    private static final char[] ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part4;
    private static final char[][] ALPHABETS;
    public static final int AVAILABLE_CPU;
    private static final wordLengthComparator WORD_LENGTH_COMPARATOR;
    private final Segment segment;
    private final StringBuilder word;
    private final boolean endsWithSpace;
    private final int wordLen;
    private long timeLimit;
    private final SortedSet<StringBuilder> resultSet;
    private char[] alphabet;
    private boolean more;

    public DidYouMean(Segment segment, String word0) {
        this.endsWithSpace = word0.length() > 0 && word0.charAt(word0.length() - 1) == ' ';
        this.word = new StringBuilder(word0.trim());
        this.resultSet = Collections.synchronizedSortedSet(new TreeSet<StringBuilder>(new headMatchingComparator(this.word, WORD_LENGTH_COMPARATOR)));
        this.wordLen = this.word.length();
        this.segment = segment;
        boolean bl = this.more = segment.connectedRWI() && segment.RWICount() > 0L;
        if (this.word.length() > 0) {
            char testchar = this.word.charAt(0);
            if (testchar >= 'A' && testchar <= 'Z') {
                testchar = (char)(testchar + 32);
            }
            boolean alphafound = false;
            for (char[] alpha : ALPHABETS) {
                if (!DidYouMean.isAlphabet(alpha, testchar)) continue;
                this.alphabet = new char[alpha.length];
                System.arraycopy(alpha, 0, this.alphabet, 0, alpha.length);
                alphafound = true;
                break;
            }
            if (!alphafound && testchar < 'A') {
                this.alphabet = new char[ALPHABET_LATIN.length];
                System.arraycopy(ALPHABET_LATIN, 0, this.alphabet, 0, ALPHABET_LATIN.length);
                alphafound = true;
            }
            if (!alphafound) {
                int firstchar = (0xFF & testchar / 256) * 256;
                int lastchar = firstchar + 255;
                this.alphabet = new char[256];
                for (int a = firstchar; a <= lastchar; ++a) {
                    this.alphabet[0xFF & a - firstchar] = (char)a;
                }
            }
        }
    }

    private static final boolean isAlphabet(char[] alpha, char testchar) {
        for (char a : alpha) {
            if (a != testchar) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.resultSet.clear();
    }

    public Collection<StringBuilder> getSuggestions(long timeout, int preSortSelection, boolean askIndex) {
        if (this.word.length() < 2) {
            return this.resultSet;
        }
        long startTime = System.currentTimeMillis();
        long preSortTimeout = timeout >= 0L ? (long)((double)timeout * 0.8) : timeout;
        long totalTimeLimit = timeout >= 0L ? startTime + timeout : Long.MAX_VALUE;
        int lastIndexOfSpace = this.word.lastIndexOf(" ");
        Collection<StringBuilder> preSorted = askIndex && lastIndexOfSpace > 0 ? DidYouMean.getSuggestions(this.word.substring(0, lastIndexOfSpace), this.word.substring(lastIndexOfSpace + 1), preSortTimeout, preSortSelection, this.segment) : (this.endsWithSpace ? DidYouMean.getSuggestions(this.word.toString(), "", preSortTimeout, preSortSelection, this.segment) : this.getSuggestions(preSortTimeout, askIndex));
        ClusteredScoreMap<StringBuilder> scored = new ClusteredScoreMap<StringBuilder>(StringBuilderComparator.CASE_INSENSITIVE_ORDER);
        LinkedHashSet<StringBuilder> countSorted = new LinkedHashSet<StringBuilder>();
        if (this.more) {
            int wc = this.segment.getWordCountGuess(this.word.toString());
            try {
                for (StringBuilder s : preSorted) {
                    if (System.currentTimeMillis() > totalTimeLimit) {
                        logger.fine("Timeout while processing pre-sorted results.");
                    } else if (scored.sizeSmaller(2 * preSortSelection)) {
                        String s0 = s.toString();
                        int wcg = s0.indexOf(32) > 0 ? s0.length() * 100 : this.segment.getWordCountGuess(s0);
                        if (wcg <= wc) continue;
                        scored.inc(s, wcg);
                        continue;
                    }
                    break;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            Iterator i = scored.keys(false);
            while (i.hasNext()) {
                countSorted.add((StringBuilder)i.next());
            }
        } else {
            try {
                for (StringBuilder s : preSorted) {
                    if (!StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(s, this.word) && !StringBuilderComparator.CASE_INSENSITIVE_ORDER.endsWith(this.word, s)) continue;
                    countSorted.add(this.word);
                }
                for (StringBuilder s : preSorted) {
                    if (StringBuilderComparator.CASE_INSENSITIVE_ORDER.equals(s, this.word)) continue;
                    countSorted.add(s);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        if (logger.isInfo()) {
            logger.info("found " + preSorted.size() + " unsorted terms, returned " + countSorted.size() + " sorted suggestions; execution time: " + (System.currentTimeMillis() - startTime) + "ms;  timeout : " + timeout + "ms.");
        }
        return countSorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<StringBuilder> getSuggestions(String head, String tail, long timeout, int preSortSelection, Segment segment) {
        long solrResponseTime;
        long startTime = System.currentTimeMillis();
        long totalTimeLimit = timeout >= 0L ? startTime + timeout : Long.MAX_VALUE;
        TreeSet<StringBuilder> result = new TreeSet<StringBuilder>(StringBuilderComparator.CASE_INSENSITIVE_ORDER);
        int count = 30;
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setParam("defType", new String[]{"edismax"});
        solrQuery.setFacet(false);
        String q = "";
        String fq = "";
        if (head.length() == 0 && tail.length() > 0) {
            q = CollectionSchema.title.getSolrFieldName() + ":\"" + tail + "\"^1000.0 " + CollectionSchema.text_t.getSolrFieldName() + ":" + tail + "~";
            fq = null;
        }
        if (head.length() > 0 && tail.length() == 0) {
            q = CollectionSchema.title.getSolrFieldName() + ":\"" + head + " \"^1000.0 " + CollectionSchema.text_t.getSolrFieldName() + ":\"" + head + " \"";
            fq = CollectionSchema.text_t.getSolrFieldName() + ":\"" + head + " \"";
        }
        if (head.length() > 0 && tail.length() > 0) {
            q = CollectionSchema.text_t.getSolrFieldName() + ":(" + head + " " + tail + ")~";
            fq = CollectionSchema.text_t.getSolrFieldName() + ":\"" + head + "\"";
        }
        solrQuery.setQuery(q);
        if (head.length() > 0 && fq != null) {
            solrQuery.setFilterQueries(new String[]{fq});
        }
        solrQuery.setStart(Integer.valueOf(0));
        solrQuery.setRows(Integer.valueOf(count));
        solrQuery.setHighlight(true);
        solrQuery.setHighlightSimplePre("<b>");
        solrQuery.setHighlightSimplePost("</b>");
        solrQuery.setHighlightSnippets(5);
        solrQuery.addHighlightField(CollectionSchema.text_t.getSolrFieldName());
        solrQuery.setFields(new String[0]);
        if (timeout >= 0L) {
            long solrAllowedTime = (long)((double)timeout * 0.8);
            solrQuery.setTimeAllowed(Integer.valueOf(solrAllowedTime > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)solrAllowedTime));
        }
        OrderedScoreMap<String> snippets = new OrderedScoreMap<String>(null);
        try {
            QueryResponse response = segment.fulltext().getDefaultConnector().getResponseByParams((ModifiableSolrParams)solrQuery);
            if (System.currentTimeMillis() > totalTimeLimit) {
                logger.fine("Solr suggestions timeout. No more time to process raw snippets.");
                TreeSet<StringBuilder> treeSet = result;
                return treeSet;
            }
            Map rawsnippets = response.getHighlighting();
            if (rawsnippets != null) {
                for (Map re : rawsnippets.values()) {
                    for (List sl : re.values()) {
                        for (String s : sl) {
                            s = s.replaceAll("</b> <b>", " ");
                            int snippetOpen = s.indexOf("<b>");
                            int snippetClose = s.indexOf("</b>");
                            if (snippetOpen < 0 || snippetClose <= snippetOpen) continue;
                            String snippet = s.substring(snippetOpen + 3, snippetClose);
                            String afterSnippet = s.substring(snippetClose + 4).trim();
                            s = snippet + (afterSnippet.length() > 0 ? " " + afterSnippet : "");
                            for (int i = 0; i < s.length(); ++i) {
                                char c = s.charAt(i);
                                if (c >= 'A') continue;
                                s = s.replace(c, ' ');
                            }
                            s = s.replaceAll("<b>", " ").replaceAll("</b>", " ").replaceAll("  ", " ").trim();
                            String[] sx = CommonPattern.SPACES.split(s);
                            StringBuilder sb = new StringBuilder(s.length());
                            for (String x : sx) {
                                if (x.length() <= 1 || sb.length() >= 28) break;
                                sb.append(x).append(' ');
                            }
                            s = sb.toString().trim();
                            if (s.length() <= 0) continue;
                            snippets.inc(s, count--);
                        }
                    }
                }
            }
        }
        catch (SolrException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            solrResponseTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() > totalTimeLimit) {
            if (logger.isFine()) {
                logger.fine("Solr suggestions timeout. No more time to filter " + snippets.size() + " sorted snippets.");
            }
            return result;
        }
        Iterator si = snippets.keys(false);
        while (si.hasNext()) {
            String testsnippet = ((String)si.next()).toLowerCase();
            if (testsnippet.length() <= head.length() + tail.length() + 1) continue;
            Iterator sin = snippets.keys(false);
            while (sin.hasNext()) {
                String snippetx = (String)sin.next();
                if (snippetx.length() == testsnippet.length() || !snippetx.toLowerCase().startsWith(testsnippet)) continue;
                snippets.delete(snippetx);
            }
        }
        si = snippets.keys(false);
        while (si.hasNext() && result.size() < preSortSelection) {
            result.add(new StringBuilder((String)si.next()));
        }
        if (logger.isFine()) {
            logger.fine("Solr suggestions response processed in " + (System.currentTimeMillis() - solrResponseTime) + "ms");
        }
        return result;
    }

    private Collection<StringBuilder> getSuggestions(long timeout, boolean askIndex) {
        long startTime = System.currentTimeMillis();
        this.timeLimit = timeout >= 0L ? startTime + timeout : Long.MAX_VALUE;
        Thread[] producers = null;
        if (this.more) {
            producers = new Thread[]{new ChangingOneLetter(), new AddingOneLetter(), new DeletingOneLetter(), new ReversingTwoConsecutiveLetters()};
            for (Thread t : producers) {
                t.start();
            }
        }
        this.test(this.word);
        if (askIndex) {
            this.resultSet.addAll(DidYouMean.getSuggestions("", this.word.toString(), timeout, 10, this.segment));
        }
        if (this.more) {
            for (Thread t : producers) {
                long wait = this.timeLimit - System.currentTimeMillis();
                if (wait <= 0L) continue;
                try {
                    t.join(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.resultSet.remove(this.word);
        return this.resultSet;
    }

    private void test(StringBuilder s) {
        Set<StringBuilder> libr = LibraryProvider.dymLib.recommend(s);
        libr.addAll(LibraryProvider.geoLoc.recommend(s));
        for (StringBuilder t : libr) {
            if (t.length() < 4) continue;
            this.resultSet.add(t);
        }
    }

    static {
        int a;
        logger = new ConcurrentLog("DidYouMean");
        ALPHABET_LATIN = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
        ALPHABET_KANJI = new char[512];
        ALPHABET_HIRAGANA = new char[96];
        ALPHABET_KATAKANA = new char[96];
        ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part1 = new char[5376];
        ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part2 = new char[5376];
        ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part3 = new char[5376];
        ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part4 = new char[4864];
        for (a = 13312; a <= 13567; a = (int)((char)(a + 1))) {
            DidYouMean.ALPHABET_KANJI[0xFF & a - 13312] = a;
        }
        for (a = 19968; a <= 20223; a = (int)((char)(a + 1))) {
            DidYouMean.ALPHABET_KANJI[0xFF & a - 19968 + 256] = a;
        }
        for (a = 12352; a <= 12447; a = (int)((char)(a + 1))) {
            DidYouMean.ALPHABET_HIRAGANA[0xFF & a - 12352] = a;
        }
        for (a = 12448; a <= 12543; a = (int)((char)(a + 1))) {
            DidYouMean.ALPHABET_KATAKANA[0xFF & a - 12448] = a;
        }
        for (a = 19968; a <= 25343; a = (int)((char)(a + 1))) {
            DidYouMean.ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part1[0xFF & a - 19968] = a;
        }
        for (a = 25344; a <= 30719; a = (int)((char)(a + 1))) {
            DidYouMean.ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part2[0xFF & a - 25344] = a;
        }
        for (a = 30720; a <= 36095; a = (int)((char)(a + 1))) {
            DidYouMean.ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part3[0xFF & a - 30720] = a;
        }
        for (a = 36096; a <= 40959; a = (int)((char)(a + 1))) {
            DidYouMean.ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part4[0xFF & a - 36096] = a;
        }
        ALPHABETS = new char[][]{ALPHABET_LATIN, ALPHABET_KANJI, ALPHABET_HIRAGANA, ALPHABET_KATAKANA, ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part1, ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part2, ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part3, ALPHABET_CJK_UNIFIED_IDEOGRAPHS_Part4};
        AVAILABLE_CPU = Runtime.getRuntime().availableProcessors();
        WORD_LENGTH_COMPARATOR = new wordLengthComparator();
    }

    private static class headMatchingComparator
    implements Comparator<StringBuilder> {
        private final StringBuilder head;
        private final Comparator<StringBuilder> secondaryComparator;

        public headMatchingComparator(StringBuilder head, Comparator<StringBuilder> secondaryComparator) {
            this.head = head;
            this.secondaryComparator = secondaryComparator;
        }

        @Override
        public int compare(StringBuilder o1, StringBuilder o2) {
            boolean o1m = StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(o1, this.head);
            boolean o2m = StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(o2, this.head);
            if (o1m && o2m || !o1m && !o2m) {
                return this.secondaryComparator.compare(o1, o2);
            }
            return o1m ? -1 : 1;
        }
    }

    private static class wordLengthComparator
    implements Comparator<StringBuilder> {
        private wordLengthComparator() {
        }

        @Override
        public int compare(StringBuilder o1, StringBuilder o2) {
            int i2;
            int i1 = o1.length();
            if (i1 == (i2 = o2.length())) {
                return StringBuilderComparator.CASE_INSENSITIVE_ORDER.compare(o1, o2);
            }
            return i1 < i2 ? 1 : -1;
        }
    }

    private class ReversingTwoConsecutiveLetters
    extends Thread {
        public ReversingTwoConsecutiveLetters() {
            super("ReversingTwoConsecutiveLetters");
        }

        @Override
        public void run() {
            for (int i = 0; i < DidYouMean.this.wordLen - 1; ++i) {
                StringBuilder ts = new StringBuilder(DidYouMean.this.word.length() + 1).append(DidYouMean.this.word.substring(0, i)).append(DidYouMean.this.word.charAt(i + 1)).append(DidYouMean.this.word.charAt(i)).append(DidYouMean.this.word.substring(i + 2));
                DidYouMean.this.test(ts);
                if (System.currentTimeMillis() <= DidYouMean.this.timeLimit) continue;
                return;
            }
        }
    }

    private class AddingOneLetter
    extends Thread {
        public AddingOneLetter() {
            super("AddingOneLetter");
        }

        @Override
        public void run() {
            for (int i = 0; i <= DidYouMean.this.wordLen; ++i) {
                for (char c : DidYouMean.this.alphabet) {
                    StringBuilder ts = new StringBuilder(DidYouMean.this.word.length() + 1).append(DidYouMean.this.word.substring(0, i)).append(c).append(DidYouMean.this.word.substring(i));
                    DidYouMean.this.test(ts);
                    if (System.currentTimeMillis() <= DidYouMean.this.timeLimit) continue;
                    return;
                }
            }
        }
    }

    private class DeletingOneLetter
    extends Thread {
        public DeletingOneLetter() {
            super("DeletingOneLetter");
        }

        @Override
        public void run() {
            for (int i = 0; i < DidYouMean.this.wordLen; ++i) {
                StringBuilder ts = new StringBuilder(DidYouMean.this.word.length() + 1).append(DidYouMean.this.word.substring(0, i)).append(DidYouMean.this.word.substring(i + 1));
                DidYouMean.this.test(ts);
                if (System.currentTimeMillis() <= DidYouMean.this.timeLimit) continue;
                return;
            }
        }
    }

    public class ChangingOneLetter
    extends Thread {
        public ChangingOneLetter() {
            super("ChangingOneLetter");
        }

        @Override
        public void run() {
            for (int i = 0; i < DidYouMean.this.wordLen; ++i) {
                char m = DidYouMean.this.word.charAt(i);
                for (char c : DidYouMean.this.alphabet) {
                    if (m != c) {
                        StringBuilder ts = new StringBuilder(DidYouMean.this.word.length() + 1).append(DidYouMean.this.word.substring(0, i)).append(c).append(DidYouMean.this.word.substring(i + 1));
                        DidYouMean.this.test(ts);
                    }
                    if (System.currentTimeMillis() <= DidYouMean.this.timeLimit) continue;
                    return;
                }
            }
        }
    }
}

