/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.protocol.ftp.FTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.crawler.retrieval.StreamResponse;
import net.yacy.document.TextParser;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;

public class SMBLoader {
    public static final long DEFAULT_MAXFILESIZE = 0xA00000L;
    private final Switchboard sb;
    private final ConcurrentLog log;
    private final long maxFileSize;

    public SMBLoader(Switchboard sb, ConcurrentLog log) {
        this.sb = sb;
        this.log = log;
        this.maxFileSize = sb.getConfigLong("crawler.smb.maxFileSize", -1L);
    }

    public Response load(Request request, boolean acceptOnlyParseable) throws IOException {
        StreamResponse streamResponse = this.openInputStream(request, acceptOnlyParseable);
        byte[] content = FileUtils.read(streamResponse.getContentStream());
        Response response = streamResponse.getResponse();
        response.setContent(content);
        return response;
    }

    public StreamResponse openInputStream(Request request, boolean acceptOnlyParseable) throws IOException {
        long size;
        String ur;
        DigestURL url = request.url();
        if (!url.getProtocol().equals("smb")) {
            throw new IOException("wrong loader for SMBLoader: " + url.getProtocol());
        }
        RequestHeader requestHeader = null;
        if (request.referrerhash() != null && (ur = this.sb.getURL(request.referrerhash())) != null) {
            requestHeader = new RequestHeader();
            requestHeader.put("Referer", ur);
        }
        String[] l = null;
        try {
            l = url.list();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (l != null) {
            String u = url.toNormalform(true);
            ArrayList<String> list2 = new ArrayList<String>();
            for (String s : l) {
                SmbFile sf;
                if (s.startsWith(".")) continue;
                if (!(s = MultiProtocolURL.escape(s).toString()).endsWith("/") && !s.endsWith("\\") && (sf = new SmbFile(u + s)).isDirectory()) {
                    s = s + "/";
                }
                list2.add(u + s);
            }
            StringBuilder content = FTPClient.dirhtml(u, null, null, null, list2, true);
            ResponseHeader responseHeader = new ResponseHeader(200);
            responseHeader.put("Last-Modified", HeaderFramework.formatRFC1123(new Date(url.lastModified())));
            responseHeader.put("Content-Type", "text/html");
            CrawlProfile profile2 = this.sb.crawler.get(ASCII.getBytes(request.profileHandle()));
            Response response = new Response(request, requestHeader, responseHeader, profile2, false, null);
            return new StreamResponse(response, new ByteArrayInputStream(UTF8.getBytes(content.toString())));
        }
        String mime = Classification.ext2mime(MultiProtocolURL.getFileExtension(url.getFileName()));
        ResponseHeader responseHeader = new ResponseHeader(200);
        responseHeader.put("Last-Modified", HeaderFramework.formatRFC1123(new Date(url.lastModified())));
        responseHeader.put("Content-Type", mime);
        try {
            size = url.length();
        }
        catch (Exception e) {
            size = -1L;
        }
        String parserError = null;
        if (acceptOnlyParseable && (parserError = TextParser.supports(url, mime)) != null || size > this.maxFileSize && this.maxFileSize >= 0L) {
            if (parserError != null) {
                this.log.info("No parser available in SMB crawler: '" + parserError + "' for URL " + request.url().toString() + ": parsing only metadata");
            } else {
                this.log.info("Too big file in SMB crawler with size = " + size + " Bytes for URL " + request.url().toString() + ": parsing only metadata");
            }
            responseHeader.put("Content-Type", "text/plain");
            CrawlProfile profile3 = this.sb.crawler.get(request.profileHandle().getBytes());
            Response response = new Response(request, requestHeader, responseHeader, profile3, false, null);
            return new StreamResponse(response, new ByteArrayInputStream(url.toTokens().getBytes()));
        }
        InputStream is = url.getInputStream(ClientIdentification.yacyInternetCrawlerAgent);
        CrawlProfile profile4 = this.sb.crawler.get(request.profileHandle().getBytes());
        Response response = new Response(request, requestHeader, responseHeader, profile4, false, null);
        return new StreamResponse(response, is);
    }

    public static void main(String[] args) {
        try {
            SmbFile sf = new SmbFile(args[0]);
            if (sf.isDirectory()) {
                String[] s;
                for (String t : s = sf.list()) {
                    System.out.println(t);
                }
            } else {
                int n;
                SmbFileInputStream in = new SmbFileInputStream(sf);
                byte[] b = new byte[8192];
                while ((n = in.read(b)) > 0) {
                    System.out.write(b, 0, n);
                }
            }
        }
        catch (SmbException e) {
            ConcurrentLog.logException(e);
        }
        catch (MalformedURLException e) {
            ConcurrentLog.logException(e);
        }
        catch (UnknownHostException e) {
            ConcurrentLog.logException(e);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }
}

