/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.feed.RSSReader;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.storage.ARC;
import net.yacy.cora.storage.ComparableARC;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.crawler.HarvestProcess;
import net.yacy.crawler.retrieval.Response;
import net.yacy.kelondro.blob.Tables;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import org.apache.commons.lang.StringUtils;

public class RSSLoader
extends Thread {
    public static final ARC<byte[], Date> indexTriggered = new ComparableARC<byte[], Date>(1000, Base64Order.enhancedCoder);
    private final DigestURL urlf;
    private final Switchboard sb;
    private final Map<String, Pattern> collections;
    private final ClientIdentification.Agent agent;

    public RSSLoader(Switchboard sb, DigestURL urlf, Map<String, Pattern> collections, ClientIdentification.Agent agent) {
        super("RSSLoader(" + urlf != null ? urlf.toNormalform(true) : ")");
        this.sb = sb;
        this.urlf = urlf;
        this.collections = collections;
        this.agent = agent;
    }

    @Override
    public void run() {
        RSSReader rss = null;
        try {
            Response response = this.sb.loader.load(this.sb.loader.request(this.urlf, true, false), CacheStrategy.NOCACHE, Integer.MAX_VALUE, Blacklist.BlacklistType.CRAWLER, this.agent);
            byte[] resource = response == null ? null : response.getContent();
            rss = resource == null ? null : RSSReader.parse(10000, resource);
        }
        catch (MalformedURLException e) {
            ConcurrentLog.warn("Load_RSS", "rss loading for url '" + this.getName().substring(9) + "' failed: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            ConcurrentLog.warn("Load_RSS", "rss loading for url '" + this.urlf.toNormalform(true) + "' failed: " + e.getMessage());
            return;
        }
        if (rss == null) {
            ConcurrentLog.warn("Load_RSS", "no rss for url " + this.urlf.toNormalform(true));
            return;
        }
        RSSFeed feed2 = rss.getFeed();
        RSSLoader.indexAllRssFeed(this.sb, this.urlf, feed2, this.collections);
        RSSLoader.recordAPI(this.sb, null, this.urlf, feed2, 7, "seldays");
    }

    public static void indexAllRssFeed(Switchboard sb, DigestURL feedUrl, RSSFeed feed2, Map<String, Pattern> collections) {
        int loadCount = 0;
        HashMap<String, DigestURL> urlmap = new HashMap<String, DigestURL>();
        for (Object message2 : feed2) {
            String enclosureStr;
            String string = ((RSSMessage)message2).getLink();
            if (StringUtils.isNotBlank((String)string)) {
                try {
                    DigestURL messageurl = new DigestURL(string);
                    if (indexTriggered.containsKey(messageurl.hash())) continue;
                    urlmap.put(ASCII.String(messageurl.hash()), messageurl);
                }
                catch (MalformedURLException e1) {
                    ConcurrentLog.warn("Load_RSS", "Malformed feed item link URL : " + string);
                }
            }
            if (!StringUtils.isNotBlank((String)(enclosureStr = ((RSSMessage)message2).getEnclosure()))) continue;
            try {
                DigestURL enclosureUrl = new DigestURL(enclosureStr);
                if (indexTriggered.containsKey(enclosureUrl.hash())) continue;
                urlmap.put(ASCII.String(enclosureUrl.hash()), enclosureUrl);
            }
            catch (MalformedURLException e1) {
                ConcurrentLog.warn("Load_RSS", "Malformed feed item enclosure URL : " + enclosureStr);
            }
        }
        ArrayList<DigestURL> list2 = new ArrayList<DigestURL>();
        for (Map.Entry entry2 : urlmap.entrySet()) {
            HarvestProcess harvestProcess = sb.getHarvestProcess((String)entry2.getKey());
            if (harvestProcess != null) continue;
            list2.add((DigestURL)entry2.getValue());
            indexTriggered.insertIfAbsent(ASCII.getBytes((String)entry2.getKey()), new Date());
            ++loadCount;
        }
        sb.addToIndex(list2, null, null, collections, true);
        try {
            Tables.Data rssRow = sb.tables.select("rss", feedUrl.hash());
            if (rssRow == null) {
                rssRow = new Tables.Data();
            }
            Date date = rssRow.get("last_load_date", new Date(0L));
            long deltaTime = Math.min(System.currentTimeMillis() - date.getTime(), 86400000L);
            int allLoadCount = rssRow.get("all_load_count", 0);
            int lastAvg = rssRow.get("avg_upd_per_day", 0);
            long thisAvg = 86400000L / deltaTime * (long)loadCount;
            long nextAvg = lastAvg == 0 ? thisAvg : (thisAvg + (long)(lastAvg * 2)) / 3L;
            rssRow.put("url", UTF8.getBytes(feedUrl.toNormalform(true)));
            rssRow.put("title", feed2.getChannel().getTitle());
            rssRow.put("last_load_date", new Date());
            rssRow.put("last_load_count", loadCount);
            rssRow.put("all_load_count", allLoadCount + loadCount);
            rssRow.put("avg_upd_per_day", nextAvg);
            sb.tables.update("rss", feedUrl.hash(), rssRow);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
    }

    public static void recordAPI(Switchboard sb, String apicall_pk, DigestURL url, RSSFeed feed2, int repeat_time, String repeat_unit) {
        byte[] pk = null;
        serverObjects post = new serverObjects();
        post.put("url", url.toNormalform(true));
        post.put("indexAllItemContent", "");
        if (apicall_pk != null) {
            post.put("apicall_pk", apicall_pk);
        }
        pk = repeat_time > 0 ? sb.tables.recordAPICall(post, "Load_RSS_p.html", "crawler", "import feed " + url.toNormalform(true), repeat_time, repeat_unit.substring(3)) : sb.tables.recordAPICall(post, "Load_RSS_p.html", "crawler", "import feed " + url.toNormalform(true));
        assert (pk != null);
        Tables.Data rssRow = new Tables.Data();
        rssRow.put("url", UTF8.getBytes(url.toNormalform(true)));
        rssRow.put("title", feed2.getChannel().getTitle());
        rssRow.put("api_pk", pk);
        try {
            sb.tables.update("rss", url.hash(), rssRow);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }
}

