/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.FailCategory;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.HTTPInputStream;
import net.yacy.cora.util.StrictLimitInputStream;
import net.yacy.crawler.CrawlSwitchboard;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.Latency;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.crawler.retrieval.StreamResponse;
import net.yacy.kelondro.io.ByteCount;
import net.yacy.kelondro.util.Formatter;
import net.yacy.peers.SeedDB;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import org.apache.http.StatusLine;

public final class HTTPLoader {
    private static final String DEFAULT_ENCODING = "gzip,deflate";
    private static final String DEFAULT_LANGUAGE = "en-us,en;q=0.5";
    private static final String DEFAULT_CHARSET = "ISO-8859-1,utf-8;q=0.7,*;q=0.7";
    public static final String DEFAULT_ACCEPT = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
    public static final int DEFAULT_MAXFILESIZE = 0xA00000;
    public static final int DEFAULT_CRAWLING_RETRY_COUNT = 5;
    private final int socketTimeout;
    private final Switchboard sb;
    private final ConcurrentLog log;

    public HTTPLoader(Switchboard sb, ConcurrentLog theLog) {
        this.sb = sb;
        this.log = theLog;
        this.socketTimeout = (int)sb.getConfigLong("crawler.clientTimeout", 30000L);
    }

    public Response load(Request entry2, CrawlProfile profile2, int maxFileSize, Blacklist.BlacklistType blacklistType, ClientIdentification.Agent agent) throws IOException {
        Latency.updateBeforeLoad(entry2.url());
        long start = System.currentTimeMillis();
        Response doc = this.load(entry2, profile2, 5, maxFileSize, blacklistType, agent);
        Latency.updateAfterLoad(entry2.url(), System.currentTimeMillis() - start);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamResponse openInputStream(Request request, CrawlProfile profile2, int retryCount, int maxFileSize, Blacklist.BlacklistType blacklistType, ClientIdentification.Agent agent) throws IOException {
        String yAddress;
        if (retryCount < 0) {
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, "retry counter exceeded", -1);
            throw new IOException("retry counter exceeded for URL " + request.url().toString() + ". Processing aborted.$");
        }
        DigestURL url = request.url();
        String host = url.getHost();
        if (host == null || host.length() < 2) {
            throw new IOException("host is not well-formed: '" + host + "'");
        }
        String path = url.getFile();
        int port = url.getPort();
        boolean ssl = url.getProtocol().equals("https");
        if (port < 0) {
            port = ssl ? 443 : 80;
        }
        String hostlow = host.toLowerCase(Locale.ROOT);
        if (blacklistType != null && Switchboard.urlBlacklist.isListed(blacklistType, hostlow, path)) {
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.FINAL_LOAD_CONTEXT, "url in blacklist", -1);
            throw new IOException("CRAWLER Rejecting URL '" + request.url().toString() + "'. URL is in blacklist.$");
        }
        SeedDB yacyResolver = this.sb.peers;
        if (yacyResolver != null && (yAddress = yacyResolver.resolve(host)) != null) {
            url = new DigestURL(url.getProtocol() + "://" + yAddress + path);
        }
        RequestHeader requestHeader = this.createRequestheader(request, agent);
        try (HTTPClient client = new HTTPClient(agent);){
            client.setRedirecting(false);
            client.setTimout(this.socketTimeout);
            client.setHeader(requestHeader.entrySet());
            client.GET(url, false);
            StatusLine statusline = client.getHttpResponse().getStatusLine();
            int statusCode = statusline.getStatusCode();
            ResponseHeader responseHeader = new ResponseHeader(statusCode, client.getHttpResponse().getAllHeaders());
            String requestURLString = request.url().toNormalform(true);
            if (statusCode > 299 && statusCode < 310) {
                DigestURL redirectionUrl = this.extractRedirectURL(request, profile2, url, statusline, responseHeader, requestURLString);
                if (this.sb.getConfigBool("crawler.http.FollowRedirects", true)) {
                    if (profile2 != null && !CrawlSwitchboard.DEFAULT_PROFILES.contains(profile2.name())) {
                        Request redirectedRequest = new Request(request.initiator(), redirectionUrl, request.referrerhash(), request.name(), request.appdate(), request.profileHandle(), request.depth(), request.timezoneOffset());
                        String rejectReason = this.sb.crawlStacker.stackCrawl(redirectedRequest);
                        if (rejectReason != null) {
                            throw new IOException("CRAWLER Redirect of URL=" + requestURLString + " aborted. Reason : " + rejectReason);
                        }
                        throw new IOException("CRAWLER Redirect of URL=" + requestURLString + " to " + redirectionUrl.toNormalform(false) + " placed on crawler queue for double-check");
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.FINAL_LOAD_CONTEXT, "server shutdown", statusCode);
                        throw new IOException("CRAWLER Redirect of URL=" + requestURLString + " aborted because of server shutdown.$");
                    }
                    if (redirectionUrl.equals(url)) {
                        this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, "redirect to same url", -1);
                        throw new IOException("retry counter exceeded for URL " + request.url().toString() + ". Processing aborted.$");
                    }
                    request.redirectURL(redirectionUrl);
                    StreamResponse streamResponse = this.openInputStream(request, profile2, retryCount - 1, maxFileSize, blacklistType, agent);
                    return streamResponse;
                }
                this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, "redirection not wanted", statusCode);
                throw new IOException("REJECTED UNWANTED REDIRECTION '" + statusline + "' for URL '" + requestURLString + "'$");
            }
            if (statusCode == 200 || statusCode == 203) {
                InputStream contentStream;
                long contentLength = client.getHttpResponse().getEntity().getContentLength();
                if (profile2 != null && profile2.storeHTCache() && contentLength > 0L && contentLength < 0xA00000L && !url.isLocal()) {
                    byte[] content = null;
                    try {
                        content = HTTPClient.getByteArray(client.getHttpResponse().getEntity(), maxFileSize);
                        Cache.store(url, responseHeader, content);
                    }
                    catch (IOException e) {
                        this.log.warn("cannot write " + url + " to Cache (3): " + e.getMessage(), e);
                    }
                    contentStream = new ByteArrayInputStream(content);
                } else {
                    if (maxFileSize >= 0 && contentLength > (long)maxFileSize) {
                        throw new IOException("Content to download exceed maximum value of " + maxFileSize + " bytes");
                    }
                    contentStream = new HTTPInputStream(client);
                    if (maxFileSize >= 0) {
                        contentStream = new StrictLimitInputStream(contentStream, maxFileSize, "Content to download exceed maximum value of " + Formatter.bytesToString(maxFileSize));
                    }
                }
                StreamResponse streamResponse = new StreamResponse(new Response(request, requestHeader, responseHeader, profile2, false, null), contentStream);
                return streamResponse;
            }
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, "wrong http status code", statusCode);
            throw new IOException("REJECTED WRONG STATUS TYPE '" + statusline + "' for URL '" + requestURLString + "'$");
        }
    }

    private DigestURL extractRedirectURL(Request request, CrawlProfile profile2, DigestURL url, StatusLine statusline, ResponseHeader responseHeader, String requestURLString) throws IOException {
        String redirectionUrlString = (String)responseHeader.get("Location");
        String string = redirectionUrlString = redirectionUrlString == null ? "" : redirectionUrlString.trim();
        if (redirectionUrlString.isEmpty()) {
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, "no redirection url provided, field 'Location' is empty", statusline.getStatusCode());
            throw new IOException("REJECTED EMTPY REDIRECTION '" + statusline + "' for URL '" + requestURLString + "'$");
        }
        DigestURL redirectionUrl = DigestURL.newURL(request.url(), redirectionUrlString);
        this.log.info("CRAWLER Redirection detected ('" + statusline + "') for URL " + requestURLString);
        this.log.info("CRAWLER ..Redirecting request to: " + redirectionUrl.toNormalform(false));
        this.sb.webStructure.generateCitationReference(url, redirectionUrl);
        if (this.sb.getConfigBool("crawler.http.RecordRedirects", true)) {
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.FINAL_REDIRECT_RULE, "redirect to " + redirectionUrlString, statusline.getStatusCode());
        }
        return redirectionUrl;
    }

    private RequestHeader createRequestheader(Request request, ClientIdentification.Agent agent) throws IOException {
        String refererURL;
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.put("User-Agent", agent.userAgent);
        if (request.referrerhash() != null && (refererURL = this.sb.getURL(request.referrerhash())) != null) {
            requestHeader.put("Referer", refererURL);
        }
        requestHeader.put("Accept", this.sb.getConfig("crawler.http.accept", DEFAULT_ACCEPT));
        requestHeader.put("Accept-Language", this.sb.getConfig("crawler.http.acceptLanguage", DEFAULT_LANGUAGE));
        requestHeader.put("Accept-Charset", this.sb.getConfig("crawler.http.acceptCharset", DEFAULT_CHARSET));
        requestHeader.put("Accept-Encoding", this.sb.getConfig("crawler.http.acceptEncoding", DEFAULT_ENCODING));
        return requestHeader;
    }

    private Response load(Request request, CrawlProfile profile2, int retryCount, int maxFileSize, Blacklist.BlacklistType blacklistType, ClientIdentification.Agent agent) throws IOException {
        String yAddress;
        if (retryCount < 0) {
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, "retry counter exceeded", -1);
            throw new IOException("retry counter exceeded for URL " + request.url().toString() + ". Processing aborted.$");
        }
        DigestURL url = request.url();
        String host = url.getHost();
        if (host == null || host.length() < 2) {
            throw new IOException("host is not well-formed: '" + host + "'");
        }
        String path = url.getFile();
        int port = url.getPort();
        boolean ssl = url.getProtocol().equals("https");
        if (port < 0) {
            port = ssl ? 443 : 80;
        }
        String hostlow = host.toLowerCase(Locale.ROOT);
        if (blacklistType != null && Switchboard.urlBlacklist.isListed(blacklistType, hostlow, path)) {
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.FINAL_LOAD_CONTEXT, "url in blacklist", -1);
            throw new IOException("CRAWLER Rejecting URL '" + request.url().toString() + "'. URL is in blacklist.$");
        }
        SeedDB yacyResolver = this.sb.peers;
        if (yacyResolver != null && (yAddress = yacyResolver.resolve(host)) != null) {
            url = new DigestURL(url.getProtocol() + "://" + yAddress + path);
        }
        Response response = null;
        RequestHeader requestHeader = this.createRequestheader(request, agent);
        try (HTTPClient client = new HTTPClient(agent);){
            client.setRedirecting(false);
            client.setTimout(this.socketTimeout);
            client.setHeader(requestHeader.entrySet());
            byte[] responseBody = client.GETbytes(url, this.sb.getConfig("adminAccountUserName", "admin"), this.sb.getConfig("adminAccountBase64MD5", ""), maxFileSize, false);
            int statusCode = client.getHttpResponse().getStatusLine().getStatusCode();
            ResponseHeader responseHeader = new ResponseHeader(statusCode, client.getHttpResponse().getAllHeaders());
            String requestURLString = request.url().toNormalform(true);
            if (statusCode > 299 && statusCode < 310) {
                DigestURL redirectionUrl = this.extractRedirectURL(request, profile2, url, client.getHttpResponse().getStatusLine(), responseHeader, requestURLString);
                if (this.sb.getConfigBool("crawler.http.FollowRedirects", true)) {
                    if (profile2 != null && !CrawlSwitchboard.DEFAULT_PROFILES.contains(profile2.name())) {
                        Request redirectedRequest = new Request(request.initiator(), redirectionUrl, request.referrerhash(), request.name(), request.appdate(), request.profileHandle(), request.depth(), request.timezoneOffset());
                        String rejectReason = this.sb.crawlStacker.stackCrawl(redirectedRequest);
                        if (rejectReason != null) {
                            throw new IOException("CRAWLER Redirect of URL=" + requestURLString + " aborted. Reason : " + rejectReason);
                        }
                        throw new IOException("CRAWLER Redirect of URL=" + requestURLString + " to " + redirectionUrl.toNormalform(false) + " placed on crawler queue for double-check");
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.FINAL_LOAD_CONTEXT, "server shutdown", statusCode);
                        throw new IOException("CRAWLER Redirect of URL=" + requestURLString + " aborted because of server shutdown.$");
                    }
                    request.redirectURL(redirectionUrl);
                    Response response2 = this.load(request, profile2, retryCount - 1, maxFileSize, blacklistType, agent);
                    return response2;
                }
                this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, "redirection not wanted", statusCode);
                throw new IOException("REJECTED UNWANTED REDIRECTION '" + client.getHttpResponse().getStatusLine() + "' for URL '" + requestURLString + "'$");
            }
            if (responseBody == null) {
                this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, "no response body", statusCode);
                throw new IOException("REJECTED EMPTY RESPONSE BODY '" + client.getHttpResponse().getStatusLine() + "' for URL '" + requestURLString + "'$");
            }
            if (statusCode == 200 || statusCode == 203) {
                long contentLength = responseBody.length;
                ByteCount.addAccountCount("CRAWLER", contentLength);
                if (maxFileSize >= 0 && contentLength > (long)maxFileSize) {
                    this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.FINAL_PROCESS_CONTEXT, "file size limit exceeded", statusCode);
                    throw new IOException("REJECTED URL " + request.url() + " because file size '" + contentLength + "' exceeds max filesize limit of " + maxFileSize + " bytes. (GET)$");
                }
                Response response3 = response = new Response(request, requestHeader, responseHeader, profile2, false, responseBody);
                return response3;
            }
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, "wrong http status code", statusCode);
            throw new IOException("REJECTED WRONG STATUS TYPE '" + client.getHttpResponse().getStatusLine() + "' for URL '" + requestURLString + "'$");
        }
    }

    public static Response load(Request request, ClientIdentification.Agent agent) throws IOException {
        return HTTPLoader.load(request, agent, 3);
    }

    private static Response load(Request request, ClientIdentification.Agent agent, int retryCount) throws IOException {
        Response response;
        block16: {
            if (retryCount < 0) {
                throw new IOException("Redirection counter exceeded for URL " + request.url().toString() + ". Processing aborted.");
            }
            String host = request.url().getHost();
            if (host == null || host.length() < 2) {
                throw new IOException("host is not well-formed: '" + host + "'");
            }
            String path = request.url().getFile();
            int port = request.url().getPort();
            boolean ssl = request.url().getProtocol().equals("https");
            if (port < 0) {
                port = ssl ? 443 : 80;
            }
            String hostlow = host.toLowerCase(Locale.ROOT);
            if (Switchboard.urlBlacklist != null && Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.CRAWLER, hostlow, path)) {
                throw new IOException("CRAWLER Rejecting URL '" + request.url().toString() + "'. URL is in blacklist.");
            }
            response = null;
            RequestHeader requestHeader = new RequestHeader();
            requestHeader.put("User-Agent", agent.userAgent);
            requestHeader.put("Accept-Language", DEFAULT_LANGUAGE);
            requestHeader.put("Accept-Charset", DEFAULT_CHARSET);
            requestHeader.put("Accept-Encoding", DEFAULT_ENCODING);
            try (HTTPClient client = new HTTPClient(agent);){
                client.setTimout(20000);
                client.setHeader(requestHeader.entrySet());
                byte[] responseBody = client.GETbytes(request.url(), null, null, false);
                int code = client.getHttpResponse().getStatusLine().getStatusCode();
                ResponseHeader header = new ResponseHeader(code, client.getHttpResponse().getAllHeaders());
                if (responseBody != null && (code == 200 || code == 203)) {
                    ByteCount.addAccountCount("CRAWLER", responseBody.length);
                    Response response2 = response = new Response(request, requestHeader, header, null, false, responseBody);
                    return response2;
                }
                if (code > 299 && code < 310) {
                    if (header.containsKey("Location")) {
                        String redirectionUrlString = (String)header.get("Location");
                        if ((redirectionUrlString = redirectionUrlString.trim()).isEmpty()) {
                            throw new IOException("CRAWLER Redirection of URL=" + request.url().toString() + " aborted. Location header is empty.");
                        }
                        DigestURL redirectionUrl = DigestURL.newURL(request.url(), redirectionUrlString);
                        if (Thread.currentThread().isInterrupted()) {
                            throw new IOException("CRAWLER Retry of URL=" + request.url().toString() + " aborted because of server shutdown.");
                        }
                        request.redirectURL(redirectionUrl);
                        Response response3 = HTTPLoader.load(request, agent, retryCount - 1);
                        return response3;
                    }
                    break block16;
                }
                throw new IOException("REJECTED WRONG STATUS TYPE '" + client.getHttpResponse().getStatusLine() + "' for URL " + request.url().toString());
            }
        }
        return response;
    }
}

