/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.FailCategory;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.protocol.ftp.FTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.Latency;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.crawler.retrieval.StreamResponse;
import net.yacy.document.TextParser;
import net.yacy.search.Switchboard;

public class FTPLoader {
    public static final long DEFAULT_MAXFILESIZE = 0xA00000L;
    private final Switchboard sb;
    private final ConcurrentLog log;
    private final long maxFileSize;

    public FTPLoader(Switchboard sb, ConcurrentLog log) {
        this.sb = sb;
        this.log = log;
        this.maxFileSize = sb.getConfigLong("crawler.ftp.maxFileSize", -1L);
    }

    public Response load(Request request, boolean acceptOnlyParseable) throws IOException {
        String path;
        String file;
        Latency.updateBeforeLoad(request.url());
        long start = System.currentTimeMillis();
        DigestURL entryUrl = request.url();
        String fullPath = this.getPath(entryUrl);
        Response response = null;
        if (fullPath.endsWith("/")) {
            file = "";
            path = fullPath;
        } else {
            int pos = fullPath.lastIndexOf("/");
            if (pos == -1) {
                file = fullPath;
                path = "/";
            } else {
                path = fullPath.substring(0, pos + 1);
                file = fullPath.substring(pos + 1);
            }
        }
        assert (path.endsWith("/")) : "FTPLoader: path is not a path: '" + path + "'";
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        FTPClient ftpClient = new FTPClient();
        CrawlProfile profile2 = this.sb.crawler.get(ASCII.getBytes(request.profileHandle()));
        if (this.openConnection(ftpClient, entryUrl)) {
            if (file.length() > 0) {
                ftpClient.exec("cd \"" + path + "\"", false);
                boolean isFolder = ftpClient.isFolder(file);
                if (isFolder) {
                    path = fullPath + "/";
                    file = "";
                }
            }
            if (file.isEmpty()) {
                StringBuilder dirList;
                String u;
                RequestHeader requestHeader = null;
                if (request.referrerhash() != null && (u = this.sb.getURL(request.referrerhash())) != null) {
                    requestHeader = new RequestHeader();
                    requestHeader.put("Referer", u);
                }
                if ((dirList = ftpClient.dirhtml(path)) == null) {
                    response = null;
                } else {
                    ResponseHeader responseHeader = new ResponseHeader(200);
                    responseHeader.put("Last-Modified", HeaderFramework.formatRFC1123(new Date()));
                    responseHeader.put("Content-Type", "text/html");
                    response = new Response(request, requestHeader, responseHeader, profile2, false, UTF8.getBytes(dirList.toString()));
                }
            } else {
                try {
                    response = this.getFile(ftpClient, request, acceptOnlyParseable);
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                    new PrintStream(berr).print(e.getMessage());
                }
            }
            this.closeConnection(ftpClient);
        }
        if (berr.size() > 0 || response == null) {
            String detail = berr.size() > 0 ? "Errorlog: " + berr.toString() : "";
            this.sb.crawlQueues.errorURL.push(request.url(), request.depth(), profile2, FailCategory.TEMPORARY_NETWORK_FAILURE, " ftp server download, " + detail, -1);
            throw new IOException("FTPLoader: Unable to download URL '" + request.url().toString() + "': " + detail);
        }
        Latency.updateAfterLoad(request.url(), System.currentTimeMillis() - start);
        return response;
    }

    public StreamResponse openInputStream(Request request, boolean acceptOnlyParseable) throws IOException {
        Response response = this.load(request, acceptOnlyParseable);
        StreamResponse streamResponse = response.getContent() != null ? new StreamResponse(response, new ByteArrayInputStream(response.getContent())) : new StreamResponse(response, new ByteArrayInputStream(UTF8.getBytes(request.url().toTokens())));
        return streamResponse;
    }

    private void closeConnection(FTPClient ftpClient) {
        ftpClient.exec("close", false);
        ftpClient.exec("exit", false);
    }

    private boolean openConnection(FTPClient ftpClient, DigestURL entryUrl) {
        int pos;
        String userInfo = entryUrl.getUserInfo();
        String userName = "anonymous";
        String userPwd = "anomic";
        if (userInfo != null && (pos = userInfo.indexOf(58, 0)) != -1) {
            userName = userInfo.substring(0, pos);
            userPwd = userInfo.substring(pos + 1);
        }
        String host = entryUrl.getHost();
        int port = entryUrl.getPort();
        if (port == -1) {
            ftpClient.exec("open " + host, false);
        } else {
            ftpClient.exec("open " + host + " " + port, false);
        }
        if (ftpClient.notConnected()) {
            return false;
        }
        ftpClient.exec("user " + userName + " " + userPwd, false);
        if (!ftpClient.isLoggedIn()) {
            return false;
        }
        ftpClient.exec("binary", false);
        return true;
    }

    private Response getFile(FTPClient ftpClient, Request request, boolean acceptOnlyParseable) throws IOException {
        String refurl;
        DigestURL url = request.url();
        String mime = TextParser.mimeOf(url);
        String path = this.getPath(url);
        Date fileDate = ftpClient.entryDate(path);
        RequestHeader requestHeader = null;
        if (request.referrerhash() != null && (refurl = this.sb.getURL(request.referrerhash())) != null) {
            requestHeader = new RequestHeader();
            requestHeader.put("Referer", refurl);
        }
        ResponseHeader responseHeader = new ResponseHeader(200);
        responseHeader.put("Last-Modified", HeaderFramework.formatRFC1123(fileDate));
        responseHeader.put("Content-Type", mime);
        long size = ftpClient.fileSize(path);
        responseHeader.put("Content-Length", String.valueOf(size));
        String parserError = null;
        if (acceptOnlyParseable && (parserError = TextParser.supports(url, mime)) != null || size > this.maxFileSize && this.maxFileSize >= 0L) {
            if (parserError != null) {
                this.log.info("No parser available in FTP crawler: '" + parserError + "' for URL " + request.url().toNormalform(true) + ": parsing only metadata");
            } else {
                this.log.info("Too big file in FTP crawler with size = " + size + " Bytes for URL " + request.url().toNormalform(true) + ": parsing only metadata");
            }
            responseHeader.put("Content-Type", "text/plain");
            CrawlProfile profile2 = this.sb.crawler.get(ASCII.getBytes(request.profileHandle()));
            Response response = new Response(request, requestHeader, responseHeader, profile2, false, null);
            return response;
        }
        byte[] b = ftpClient.get(path);
        CrawlProfile profile3 = this.sb.crawler.get(ASCII.getBytes(request.profileHandle()));
        Response response = new Response(request, requestHeader, responseHeader, profile3, false, b);
        return response;
    }

    private String getPath(MultiProtocolURL entryUrl) {
        return MultiProtocolURL.unescape(entryUrl.getPath()).replace("\"", "\"\"");
    }
}

