/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.index.Fulltext;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.common.SolrDocument;

public class Snapshots {
    private File storageLocation;
    private Map<String, TreeMap<Integer, TreeSet<String>>> directory;

    public Snapshots(File location) {
        this.storageLocation = location;
        this.storageLocation.mkdirs();
        this.directory = new HashMap<String, TreeMap<Integer, TreeSet<String>>>();
        for (String hostport : location.list()) {
            TreeMap domaindepth = new TreeMap();
            this.directory.put(hostport, domaindepth);
            File domaindir = new File(location, hostport);
            if (domaindir.isDirectory()) {
                for (String depth : domaindir.list()) {
                    TreeSet<String> dateid = new TreeSet<String>();
                    Integer depthi = -1;
                    try {
                        depthi = Integer.parseInt(depth);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    domaindepth.put(depthi, dateid);
                    File sharddir = new File(domaindir, depth);
                    if (sharddir.isDirectory()) {
                        for (String shard : sharddir.list()) {
                            File snapshotdir = new File(sharddir, shard);
                            if (!snapshotdir.isDirectory()) continue;
                            for (String snapshotfile : snapshotdir.list()) {
                                if (!snapshotfile.endsWith(".xml")) continue;
                                String s = snapshotfile.substring(0, snapshotfile.length() - 4);
                                int p = s.indexOf(46);
                                assert (p == 12);
                                if (p <= 0) continue;
                                String key = s.substring(p + 1) + '.' + s.substring(0, p);
                                dateid.add(key);
                            }
                        }
                    }
                    if (dateid.size() != 0) continue;
                    domaindepth.remove(depthi);
                }
            }
            if (domaindepth.size() != 0) continue;
            this.directory.remove(hostport);
        }
    }

    public int size() {
        int c = 0;
        for (Map map : this.directory.values()) {
            for (TreeSet n : map.values()) {
                c += n.size();
            }
        }
        return c;
    }

    public Set<String> listHosts() {
        return this.directory.keySet();
    }

    public Revisions getRevisions(String urlhash) {
        if (urlhash == null || urlhash.length() == 0) {
            return null;
        }
        for (Map.Entry<String, TreeMap<Integer, TreeSet<String>>> hostportDomaindepth : this.directory.entrySet()) {
            String hostport = hostportDomaindepth.getKey();
            for (Map.Entry<Integer, TreeSet<String>> depthDateHash : hostportDomaindepth.getValue().entrySet()) {
                int depth = depthDateHash.getKey();
                for (String dateHash : depthDateHash.getValue()) {
                    if (!dateHash.endsWith(urlhash)) continue;
                    return new Revisions(hostport, depth, dateHash);
                }
            }
        }
        return null;
    }

    public TreeMap<Integer, Collection<Revisions>> listIDs(String hostport, int depth) {
        TreeMap<Integer, Collection<Revisions>> result = new TreeMap<Integer, Collection<Revisions>>();
        TreeMap<Integer, TreeSet<String>> list2 = this.directory.get(hostport);
        if (list2 != null) {
            for (Map.Entry<Integer, TreeSet<String>> entry2 : list2.entrySet()) {
                if (depth != -1 && entry2.getKey() != depth) continue;
                ArrayList<Revisions> r = new ArrayList<Revisions>(entry2.getValue().size());
                for (String datehash : entry2.getValue()) {
                    r.add(new Revisions(hostport, entry2.getKey(), datehash));
                }
                result.put(entry2.getKey(), r);
            }
        }
        return result;
    }

    public int listIDsSize(String hostport, int depth) {
        int count = 0;
        TreeMap<Integer, TreeSet<String>> list2 = this.directory.get(hostport);
        if (list2 != null) {
            for (Map.Entry<Integer, TreeSet<String>> entry2 : list2.entrySet()) {
                if (depth != -1 && entry2.getKey() != depth) continue;
                count += entry2.getValue().size();
            }
        }
        return count;
    }

    public File definePath(DigestURL url, int depth, Date date, String ext) {
        String id = ASCII.String(url.hash());
        String ds = GenericFormatter.SHORT_MINUTE_FORMATTER.format(date);
        return new File(this.pathToShard(url, depth), id + "." + ds + "." + ext);
    }

    public void announceStorage(DigestURL url, int depth, Date date) {
        TreeSet<String> dateid;
        String id = ASCII.String(url.hash());
        String ds = GenericFormatter.SHORT_MINUTE_FORMATTER.format(date);
        String pathToHostPortDir = this.pathToHostPortDir(url.getHost(), url.getPort());
        TreeMap<Integer, TreeSet<String>> domaindepth = this.directory.get(pathToHostPortDir);
        if (domaindepth == null) {
            domaindepth = new TreeMap();
            this.directory.put(this.pathToHostPortDir(url.getHost(), url.getPort()), domaindepth);
        }
        if ((dateid = domaindepth.get(depth)) == null) {
            dateid = new TreeSet();
            domaindepth.put(depth, dateid);
        }
        dateid.add(ds + '.' + id);
    }

    public Set<Date> announceDeletion(DigestURL url, int depth) {
        HashSet<Date> dates = new HashSet<Date>();
        String id = ASCII.String(url.hash());
        String pathToHostPortDir = this.pathToHostPortDir(url.getHost(), url.getPort());
        TreeMap<Integer, TreeSet<String>> domaindepth = this.directory.get(pathToHostPortDir);
        if (domaindepth == null) {
            return dates;
        }
        TreeSet<String> dateid = domaindepth.get(depth);
        if (dateid == null) {
            return dates;
        }
        Iterator<String> i = dateid.iterator();
        while (i.hasNext()) {
            String dis = i.next();
            if (!dis.endsWith("." + id)) continue;
            String d = dis.substring(0, dis.length() - id.length() - 1);
            Date date = Snapshots.parseDate(d);
            if (date != null) {
                dates.add(date);
            }
            i.remove();
        }
        if (dateid.size() == 0) {
            domaindepth.remove(depth);
        }
        if (domaindepth.size() == 0) {
            this.directory.remove(pathToHostPortDir);
        }
        return dates;
    }

    public LinkedHashMap<String, Revisions> select(String host, Integer depth, Order order, int maxcount) {
        Iterator i;
        String hostport;
        TreeSet<String> ids;
        TreeMap<String, String[]> dateIdResult = new TreeMap<String, String[]>();
        if (host == null && depth == null) {
            block0: for (Map.Entry<String, TreeMap<Integer, TreeSet<String>>> hostportDepths : this.directory.entrySet()) {
                for (Map.Entry<Integer, TreeSet<String>> entry2 : hostportDepths.getValue().entrySet()) {
                    for (String id : entry2.getValue()) {
                        dateIdResult.put(id, new String[]{hostportDepths.getKey(), Integer.toString(entry2.getKey())});
                        if (order != Order.ANY || dateIdResult.size() < maxcount) continue;
                        break block0;
                    }
                }
            }
        }
        if (host == null && depth != null) {
            block3: for (Map.Entry<String, TreeMap<Integer, TreeSet<String>>> hostportDepths : this.directory.entrySet()) {
                ids = hostportDepths.getValue().get(depth);
                if (ids == null) continue;
                for (String string : ids) {
                    dateIdResult.put(string, new String[]{hostportDepths.getKey(), Integer.toString(depth)});
                    if (order != Order.ANY || dateIdResult.size() < maxcount) continue;
                    break block3;
                }
            }
        }
        if (host != null && depth == null) {
            hostport = this.pathToHostPortDir(host, 80);
            TreeMap<Integer, TreeSet<String>> depthIdsMap = this.directory.get(hostport);
            if (depthIdsMap == null && this.isIpv6AddrHost(host)) {
                hostport = this.pathToHostPortDir(host, 80, false);
                depthIdsMap = this.directory.get(hostport);
            }
            if (depthIdsMap != null) {
                ids = depthIdsMap.entrySet().iterator();
                block5: while (ids.hasNext()) {
                    Map.Entry entry3 = (Map.Entry)ids.next();
                    for (String id : (TreeSet)entry3.getValue()) {
                        dateIdResult.put(id, new String[]{hostport, Integer.toString((Integer)entry3.getKey())});
                        if (order != Order.ANY || dateIdResult.size() < maxcount) continue;
                        break block5;
                    }
                }
            }
        }
        if (host != null && depth != null) {
            hostport = this.pathToHostPortDir(host, 80);
            TreeMap<Integer, TreeSet<String>> domaindepth = this.directory.get(hostport);
            if (domaindepth == null && this.isIpv6AddrHost(host)) {
                hostport = this.pathToHostPortDir(host, 80, false);
                domaindepth = this.directory.get(hostport);
            }
            if (domaindepth != null && (ids = domaindepth.get(depth)) != null) {
                for (String string : ids) {
                    dateIdResult.put(string, new String[]{hostport, Integer.toString(depth)});
                    if (order != Order.ANY || dateIdResult.size() < maxcount) continue;
                    break;
                }
            }
        }
        LinkedHashMap<String, Revisions> result = new LinkedHashMap<String, Revisions>();
        Iterator iterator = i = order == Order.LATESTFIRST ? dateIdResult.descendingMap().entrySet().iterator() : dateIdResult.entrySet().iterator();
        while (i.hasNext() && result.size() < maxcount) {
            Map.Entry entry2 = i.next();
            String string = (String)entry2.getKey();
            int n = string.indexOf(46);
            assert (n >= 0);
            Revisions r = new Revisions(((String[])entry2.getValue())[0], Integer.parseInt(((String[])entry2.getValue())[1]), string);
            result.put(string.substring(n + 1), r);
        }
        return result;
    }

    private static Date parseDate(String d) {
        try {
            return GenericFormatter.SHORT_MINUTE_FORMATTER.parse(d, 0).getTime();
        }
        catch (ParseException e) {
            try {
                return GenericFormatter.SHORT_DAY_FORMATTER.parse(d, 0).getTime();
            }
            catch (ParseException ee) {
                return null;
            }
        }
    }

    public int getDepth(DigestURL url, Fulltext fulltext) {
        Integer depth = null;
        if (fulltext.getDefaultConfiguration().contains(CollectionSchema.crawldepth_i)) {
            try {
                SolrDocument doc = fulltext.getDefaultConnector().getDocumentById(ASCII.String(url.hash()), CollectionSchema.crawldepth_i.getSolrFieldName());
                if (doc != null) {
                    depth = (Integer)doc.getFieldValue(CollectionSchema.crawldepth_i.getSolrFieldName());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return depth == null ? 0 : depth;
    }

    public Collection<File> findPaths(DigestURL url, String ext) {
        for (int i = 0; i < 100; ++i) {
            Collection<File> paths = this.findPaths(url, i, ext);
            if (paths.size() <= 0) continue;
            return paths;
        }
        return new ArrayList<File>(0);
    }

    public Collection<File> findPaths(DigestURL url, int depth, String ext) {
        String id = ASCII.String(url.hash());
        File pathToShard = this.pathToShard(url, depth);
        if (!pathToShard.exists() && this.isIpv6AddrHost(url.getHost())) {
            pathToShard = this.pathToShard(this.pathToHostPortDir(url.getHost(), url.getPort(), false), ASCII.String(url.hash()), depth);
        }
        String[] list2 = pathToShard.exists() && pathToShard.isDirectory() ? pathToShard.list() : null;
        ArrayList<File> paths = new ArrayList<File>();
        if (list2 != null) {
            for (String f : list2) {
                if (!f.startsWith(id) || ext != null && !f.endsWith(ext)) continue;
                paths.add(new File(pathToShard, f));
            }
        }
        return paths;
    }

    private File pathToShard(DigestURL url, int depth) {
        return this.pathToShard(this.pathToHostPortDir(url.getHost(), url.getPort()), ASCII.String(url.hash()), depth);
    }

    private File pathToShard(String hostport, String urlhash, int depth) {
        File pathToHostDir = new File(this.storageLocation, hostport);
        File pathToDepthDir = new File(pathToHostDir, this.pathToDepthDir(depth));
        File pathToShard = new File(pathToDepthDir, this.pathToShard(urlhash));
        return pathToShard;
    }

    private boolean isIpv6AddrHost(String host) {
        return host != null && host.startsWith("[") && host.endsWith("]") && host.contains(":");
    }

    private String pathToHostPortDir(String host, int port) {
        return this.pathToHostPortDir(host, port, true);
    }

    private String pathToHostPortDir(String host, int port, boolean encodeIpv6) {
        String encodedHost = host;
        if (encodeIpv6 && this.isIpv6AddrHost(host)) {
            try {
                encodedHost = URLEncoder.encode(host, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return encodedHost + "." + port;
    }

    private String pathToDepthDir(int depth) {
        return depth < 10 ? "0" + depth : Integer.toString(depth);
    }

    private String pathToShard(String urlhash) {
        return urlhash.substring(0, 2);
    }

    public static enum Order {
        ANY,
        OLDESTFIRST,
        LATESTFIRST;

    }

    public final class Revisions {
        public final int depth;
        public final Date[] dates;
        public final String urlhash;
        public final String url;
        public final File[] pathtoxml;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Revisions(String hostport, int depth, String datehash) {
            this.depth = depth;
            int p = datehash.indexOf(46);
            this.dates = new Date[1];
            String datestring = datehash.substring(0, p);
            this.dates[0] = Snapshots.parseDate(datestring);
            this.urlhash = datehash.substring(p + 1);
            this.pathtoxml = new File[1];
            this.pathtoxml[0] = new File(Snapshots.this.pathToShard(hostport, this.urlhash, depth), this.urlhash + "." + datestring + ".xml");
            String u = null;
            if (this.pathtoxml[0].exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.pathtoxml[0])));
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("<str name=\"sku\">")) continue;
                        u = line.substring(16, line.length() - 6);
                        break;
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.warn("SNAPSHOTS", "Error while reading file " + this.pathtoxml[0]);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ignored) {
                            ConcurrentLog.warn("SNAPSHOTS", "Could not close input stream on file " + this.pathtoxml[0]);
                        }
                    }
                }
            }
            this.url = u;
        }
    }
}

