/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.data;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.robots.RobotsTxt;
import net.yacy.crawler.robots.RobotsTxtEntry;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.search.Switchboard;

public class Latency {
    private static final int mapMaxSize = 1000;
    private static final ConcurrentHashMap<String, Host> map = new ConcurrentHashMap();

    public static void updateAfterSelection(DigestURL url, long robotsCrawlDelay) {
        String host = url.getHost();
        if (host == null) {
            return;
        }
        String hosthash = url.hosthash();
        Host h = map.get(hosthash);
        if (h == null) {
            h = new Host(host, Switchboard.getSwitchboard().getConfigInt("crawler.defaultAverageLatency", 500), robotsCrawlDelay);
            if (map.size() > 1000 || MemoryControl.shortStatus()) {
                map.clear();
            }
            map.put(hosthash, h);
        }
    }

    public static void updateBeforeLoad(DigestURL url) {
        String host = url.getHost();
        if (host == null) {
            return;
        }
        String hosthash = url.hosthash();
        Host h = map.get(hosthash);
        if (h == null) {
            h = new Host(host, 500L, 0L);
            if (map.size() > 1000 || MemoryControl.shortStatus()) {
                map.clear();
            }
            map.put(hosthash, h);
        } else {
            h.update();
        }
    }

    public static void updateAfterLoad(DigestURL url, long time) {
        String host = url.getHost();
        if (host == null) {
            return;
        }
        String hosthash = url.hosthash();
        Host h = map.get(hosthash);
        if (h == null) {
            h = new Host(host, time, 0L);
            if (map.size() > 1000 || MemoryControl.shortStatus()) {
                map.clear();
            }
            map.put(hosthash, h);
        } else {
            h.update(time);
        }
    }

    private static Host host(DigestURL url) {
        String host = url.getHost();
        if (host == null) {
            return null;
        }
        return map.get(url.hosthash());
    }

    public static Iterator<Map.Entry<String, Host>> iterator() {
        return map.entrySet().iterator();
    }

    public static int waitingRobots(MultiProtocolURL url, RobotsTxt robots2, ClientIdentification.Agent agent) {
        int robotsDelay;
        RobotsTxtEntry robotsEntry = robots2.getEntry(url, agent);
        int n = robotsDelay = robotsEntry == null ? 0 : robotsEntry.getCrawlDelayMillis();
        if (robotsEntry != null && robotsDelay == 0 && robotsEntry.getAgentName() != null) {
            return -1;
        }
        return robotsDelay;
    }

    private static int waitingRobots(String hostport, RobotsTxt robots2, ClientIdentification.Agent agent, boolean fetchOnlineIfNotAvailableOrNotFresh) {
        int robotsDelay;
        RobotsTxtEntry robotsEntry = robots2.getEntry(hostport, agent, fetchOnlineIfNotAvailableOrNotFresh);
        int n = robotsDelay = robotsEntry == null ? 0 : robotsEntry.getCrawlDelayMillis();
        if (robotsEntry != null && robotsDelay == 0 && robotsEntry.getAgentName() != null) {
            return -1;
        }
        return robotsDelay;
    }

    public static int waitingRemainingGuessed(String hostname, int port, String hosthash, RobotsTxt robots2, ClientIdentification.Agent agent) {
        Host host = map.get(hosthash);
        if (host == null) {
            return Integer.MIN_VALUE;
        }
        int waiting = agent.minimumDelta;
        waiting += host.flux(waiting);
        waiting = Math.max(waiting, (int)((float)host.average() * Switchboard.getSwitchboard().getConfigFloat("crawler.latencyFactor", 0.5f)));
        if (Switchboard.getSwitchboard().crawlQueues.hostcount(hostname) > Switchboard.getSwitchboard().getConfigInt("crawler.MaxSameHostInQueue", 20)) {
            waiting += 3000;
        }
        int timeSinceLastAccess = (int)(System.currentTimeMillis() - host.lastacc());
        if (robots2 != null) {
            int robotsDelay = Latency.waitingRobots(hostname + ":" + port, robots2, agent, false);
            if (robotsDelay < 0) {
                return -timeSinceLastAccess;
            }
            waiting = Math.max(waiting, robotsDelay);
        }
        return waiting - timeSinceLastAccess;
    }

    public static int waitingRemaining(DigestURL url, RobotsTxt robots2, ClientIdentification.Agent agent) {
        Host host = Latency.host(url);
        if (host == null) {
            return Integer.MIN_VALUE;
        }
        boolean local = url.isLocal();
        int waiting = agent.minimumDelta;
        if (!local) {
            waiting += host.flux(waiting);
        }
        waiting = Math.max(waiting, (int)((float)host.average() * Switchboard.getSwitchboard().getConfigFloat("crawler.latencyFactor", 0.5f)));
        if (Switchboard.getSwitchboard().crawlQueues.hostcount(url.getHost()) > Switchboard.getSwitchboard().getConfigInt("crawler.MaxSameHostInQueue", 20)) {
            waiting += 3000;
        }
        int timeSinceLastAccess = (int)(System.currentTimeMillis() - host.lastacc());
        int robotsDelay = Latency.waitingRobots(url, robots2, agent);
        if (robotsDelay < 0) {
            return -timeSinceLastAccess;
        }
        waiting = Math.max(waiting, robotsDelay);
        return waiting - timeSinceLastAccess;
    }

    public static String waitingRemainingExplain(DigestURL url, RobotsTxt robots2, ClientIdentification.Agent agent) {
        int robotsDelay;
        Host host = Latency.host(url);
        if (host == null) {
            return "host " + host + " never accessed before -> Integer.MIN_VALUE";
        }
        boolean local = url.isLocal();
        StringBuilder s = new StringBuilder(50);
        int waiting = agent.minimumDelta;
        s.append("minimumDelta = ").append(waiting);
        if (!local) {
            int flux = host.flux(waiting);
            waiting += flux;
            s.append(", flux = ").append(flux);
        }
        s.append(", host.average = ").append(host.average());
        waiting = Math.max(waiting, (int)((float)host.average() * Switchboard.getSwitchboard().getConfigFloat("crawler.latencyFactor", 0.5f)));
        int hostcount = Switchboard.getSwitchboard().crawlQueues.hostcount(url.getHost());
        if (hostcount > Switchboard.getSwitchboard().getConfigInt("crawler.MaxSameHostInQueue", 20)) {
            s.append(", hostcount = ").append(hostcount);
            waiting += 3000;
        }
        if ((robotsDelay = Latency.waitingRobots(url, robots2, agent)) < 0) {
            return "no waiting for exclusive granted peer";
        }
        waiting = Math.max(waiting, robotsDelay);
        s.append(", robots.delay = ").append(robotsDelay);
        long timeSinceLastAccess = System.currentTimeMillis() - host.lastacc();
        s.append(", ((waitig = ").append(waiting);
        s.append(") - (timeSinceLastAccess = ").append(timeSinceLastAccess).append(")) = ");
        s.append((long)waiting - timeSinceLastAccess);
        return s.toString();
    }

    public static long getDomainSleepTime(RobotsTxt robots2, CrawlProfile profileEntry, DigestURL crawlURL) {
        if (profileEntry == null) {
            return 0L;
        }
        long sleeptime = profileEntry.cacheStrategy() == CacheStrategy.CACHEONLY || profileEntry.cacheStrategy() == CacheStrategy.IFEXIST && Cache.has(crawlURL.hash()) ? Integer.MIN_VALUE : (long)Latency.waitingRemaining(crawlURL, robots2, profileEntry.getAgent());
        return sleeptime;
    }

    public static long getRobotsTime(RobotsTxt robots2, DigestURL crawlURL, ClientIdentification.Agent agent) {
        long sleeptime = Latency.waitingRobots(crawlURL, robots2, agent);
        return sleeptime < 0L ? 0L : sleeptime;
    }

    public static final class Host {
        private final AtomicLong timeacc;
        private final AtomicLong lastacc;
        private final AtomicInteger count;
        private final String host;
        private final long robotsMinDelay;

        private Host(String host, long time, long robotsMinDelay) {
            this.host = host;
            this.timeacc = new AtomicLong(time);
            this.count = new AtomicInteger(1);
            this.lastacc = new AtomicLong(System.currentTimeMillis());
            this.robotsMinDelay = robotsMinDelay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(long time) {
            if (this.count.get() > 100) {
                Host host = this;
                synchronized (host) {
                    this.timeacc.set(this.timeacc.get() / (long)this.count.get());
                    this.count.set(1);
                }
            }
            this.lastacc.set(System.currentTimeMillis());
            this.timeacc.addAndGet(Math.min(30000L, time));
            this.count.incrementAndGet();
        }

        private void update() {
            this.lastacc.set(System.currentTimeMillis());
        }

        public int count() {
            return this.count.get();
        }

        public int average() {
            return (int)(this.timeacc.get() / (long)this.count.get());
        }

        public long lastacc() {
            return this.lastacc.get();
        }

        public String host() {
            return this.host;
        }

        public long robotsDelay() {
            return this.robotsMinDelay;
        }

        public int flux(int range) {
            return this.count.get() >= 10000 ? range >> 1 : range * this.count.get() / 10000 >> 1;
        }
    }
}

