/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.data;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.ArrayStack;
import net.yacy.kelondro.blob.Compressor;
import net.yacy.kelondro.blob.MapHeap;
import net.yacy.kelondro.index.RowHandleSet;

public final class Cache {
    protected static final int DEFAULT_BACKEND_BUFFER_SIZE = 0x200000;
    protected static final int DEFAULT_COMPRESSOR_BUFFER_SIZE = 0x600000;
    protected static final int DEFAULT_RESPONSE_HEADER_BUFFER_SIZE = 2048;
    private static final String RESPONSE_HEADER_DB_NAME = "responseHeader.heap";
    private static final String FILE_DB_NAME = "file.array";
    private static MapHeap responseHeaderDB = null;
    private static Compressor fileDB = null;
    private static ArrayStack fileDBunbuffered = null;
    private static volatile long maxCacheSize = Long.MAX_VALUE;
    private static AtomicLong totalRequests = new AtomicLong(0L);
    private static AtomicLong hits = new AtomicLong(0L);
    private static File cachePath = null;
    private static String prefix;
    public static final ConcurrentLog log;

    public static void init(File htCachePath, String peerSalt, long cacheSizeMax, long lockTimeout, int compressionLevel) {
        block11: {
            block10: {
                cachePath = htCachePath;
                maxCacheSize = cacheSizeMax;
                prefix = peerSalt;
                totalRequests.set(0L);
                hits.set(0L);
                if (!htCachePath.exists()) {
                    htCachePath.mkdirs();
                }
                File dbfile = new File(cachePath, RESPONSE_HEADER_DB_NAME);
                try {
                    responseHeaderDB = new MapHeap(dbfile, 12, Base64Order.enhancedCoder, 2048, 100, ' ');
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                    if (!dbfile.exists()) break block10;
                    dbfile.delete();
                    try {
                        responseHeaderDB = new MapHeap(dbfile, 12, Base64Order.enhancedCoder, 2048, 100, ' ');
                    }
                    catch (IOException ee) {
                        ConcurrentLog.logException(e);
                    }
                }
            }
            try {
                fileDBunbuffered = new ArrayStack(new File(cachePath, FILE_DB_NAME), prefix, Base64Order.enhancedCoder, 12, 0x200000, false, true);
                fileDBunbuffered.setMaxSize(maxCacheSize);
                fileDB = new Compressor(fileDBunbuffered, 0x600000L, lockTimeout, compressionLevel);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                if (!cachePath.exists()) break block11;
                cachePath.delete();
                try {
                    fileDBunbuffered = new ArrayStack(new File(cachePath, FILE_DB_NAME), prefix, Base64Order.enhancedCoder, 12, 0x200000, false, true);
                    fileDBunbuffered.setMaxSize(maxCacheSize);
                    fileDB = new Compressor(fileDBunbuffered, 0x600000L, lockTimeout, compressionLevel);
                }
                catch (IOException ee) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        ConcurrentLog.info("Cache", "initialized cache database responseHeaderDB.size() = " + (responseHeaderDB == null ? "NULL" : Integer.valueOf(responseHeaderDB.size())) + ", fileDB.size() = " + (fileDB == null ? "NULL" : Integer.valueOf(fileDB.size())));
        if (responseHeaderDB.size() != fileDB.size()) {
            ConcurrentLog.warn("Cache", "file and metadata size is not equal, starting a cleanup thread...");
            Thread startupCleanup = new Thread("Cache startupCleanup"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BlockingQueue<byte[]> q = responseHeaderDB.keyQueue(1000);
                    RowHandleSet delkeys = new RowHandleSet(12, (ByteOrder)Base64Order.enhancedCoder, 1);
                    ConcurrentLog.info("Cache", "started cleanup thread to remove unused cache metadata");
                    try {
                        byte[] k;
                        while ((k = q.take()) != MapHeap.POISON_QUEUE_ENTRY) {
                            if (fileDB.containsKey(k)) continue;
                            try {
                                delkeys.put(k);
                            }
                            catch (SpaceExceededException e) {
                                // empty catch block
                                break;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        ConcurrentLog.info("Cache", "cleanup thread collected " + delkeys.size() + " unused metadata entries; now deleting them from the file...");
                        for (byte[] k : delkeys) {
                            try {
                                responseHeaderDB.delete(k);
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    finally {
                        ConcurrentLog.info("Cache", "cleanup thread collected " + delkeys.size() + " unused metadata entries; now deleting them from the file...");
                        for (byte[] k : delkeys) {
                            try {
                                responseHeaderDB.delete(k);
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    ConcurrentLog.info("Cache", "running check to remove unused file cache data");
                    delkeys.clear();
                    for (byte[] k : fileDB) {
                        if (responseHeaderDB.containsKey(k)) continue;
                        try {
                            delkeys.put(k);
                        }
                        catch (SpaceExceededException e) {
                            break;
                        }
                    }
                    ConcurrentLog.info("Cache", "cleanup thread collected " + delkeys.size() + " unused cache entries; now deleting them from the file...");
                    for (byte[] k : delkeys) {
                        try {
                            fileDB.delete(k);
                        }
                        catch (IOException iOException) {}
                    }
                    ConcurrentLog.info("Cache", "terminated cleanup thread; responseHeaderDB.size() = " + responseHeaderDB.size() + ", fileDB.size() = " + fileDB.size());
                }
            };
            startupCleanup.start();
        }
    }

    public static void commit() {
        fileDB.flushAll();
    }

    public static void clear() {
        responseHeaderDB.clear();
        try {
            fileDB.clear();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        try {
            fileDBunbuffered.clear();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        totalRequests.set(0L);
        hits.set(0L);
    }

    public static void setMaxCacheSize(long newCacheSize) {
        maxCacheSize = newCacheSize;
        fileDBunbuffered.setMaxSize(maxCacheSize);
    }

    public static long getActualCacheSize() {
        return fileDBunbuffered.length();
    }

    public static long getActualCacheDocCount() {
        return fileDBunbuffered.size();
    }

    public static void setCompressionLevel(int newCompressionLevel) {
        fileDB.setCompressionLevel(newCompressionLevel);
    }

    public static void setLockTimeout(long lockTimeout) {
        fileDB.setLockTimeout(lockTimeout);
    }

    public static void close() {
        responseHeaderDB.close();
        fileDB.close(true);
    }

    public static void store(DigestURL url, ResponseHeader responseHeader, byte[] file) throws IOException {
        if (maxCacheSize == 0L) {
            return;
        }
        if (responseHeader == null) {
            throw new IOException("Cache.store of url " + url.toNormalform(false) + " not possible: responseHeader == null");
        }
        if (responseHeader.getXRobotsTag().contains("noarchive")) {
            return;
        }
        if (file == null) {
            throw new IOException("Cache.store of url " + url.toNormalform(false) + " not possible: file == null");
        }
        log.info("storing content of url " + url.toNormalform(false) + ", " + file.length + " bytes");
        try {
            fileDB.insert(url.hash(), file);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Cache.store: cannot write to fileDB (1): " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("Cache.store: cannot write to fileDB (2): " + e.getMessage());
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.putAll(responseHeader);
        hm.put("@@URL", url.toNormalform(true));
        try {
            responseHeaderDB.insert(url.hash(), hm);
        }
        catch (Exception e) {
            fileDB.delete(url.hash());
            throw new IOException("Cache.store: cannot write to headerDB: " + e.getMessage());
        }
        if (log.isFine()) {
            log.fine("stored in cache: " + url.toNormalform(true));
        }
    }

    public static boolean has(byte[] urlhash) {
        totalRequests.incrementAndGet();
        boolean headerExists = responseHeaderDB.containsKey(urlhash);
        boolean fileExists = fileDB.containsKey(urlhash);
        if (headerExists && fileExists) {
            hits.incrementAndGet();
            return true;
        }
        if (!headerExists && !fileExists) {
            return false;
        }
        if (headerExists) {
            try {
                log.warn("header but not content of urlhash " + ASCII.String(urlhash) + " in cache; cleaned up");
                responseHeaderDB.delete(urlhash);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fileExists) {
            try {
                fileDB.delete(urlhash);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static ResponseHeader getResponseHeader(byte[] hash) {
        totalRequests.incrementAndGet();
        Map<String, String> hdb = null;
        try {
            hdb = responseHeaderDB.get(hash);
        }
        catch (IOException e) {
            return null;
        }
        catch (SpaceExceededException e) {
            return null;
        }
        if (hdb == null) {
            return null;
        }
        hits.incrementAndGet();
        return new ResponseHeader(hdb);
    }

    public static byte[] getContent(byte[] hash) {
        totalRequests.incrementAndGet();
        try {
            byte[] b = fileDB.get(hash);
            if (b == null) {
                return null;
            }
            hits.incrementAndGet();
            return b;
        }
        catch (UnsupportedEncodingException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        catch (OutOfMemoryError e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public static boolean hasContent(byte[] hash) {
        totalRequests.incrementAndGet();
        try {
            boolean result = fileDB.containsKey(hash);
            if (result) {
                hits.incrementAndGet();
            }
            return result;
        }
        catch (OutOfMemoryError e) {
            ConcurrentLog.logException(e);
            return false;
        }
    }

    public static void delete(byte[] hash) throws IOException {
        responseHeaderDB.delete(hash);
        fileDB.delete(hash);
    }

    public static long getTotalRequests() {
        return totalRequests.get();
    }

    public static long getHits() {
        return hits.get();
    }

    public static double getHitRate() {
        long total = totalRequests.get();
        return total > 0L ? (double)Cache.getHits() / (double)total : 0.0;
    }

    static {
        log = new ConcurrentLog("HTCACHE");
    }
}

