/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.storage.HandleMap;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.crawler.Balancer;
import net.yacy.crawler.CrawlSwitchboard;
import net.yacy.crawler.HostQueue;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.Latency;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.robots.RobotsTxt;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.index.RowHandleMap;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.util.FileUtils;

public class HostBalancer
implements Balancer {
    private static final ConcurrentLog log = new ConcurrentLog("HostBalancer");
    public static final HandleMap depthCache = new RowHandleMap(12, Word.commonHashOrder, 2, 0x800000, "HostBalancer.DepthCache");
    private final File hostsPath;
    private final boolean exceed134217727;
    private final ConcurrentHashMap<String, HostQueue> queues;
    private final Set<String> roundRobinHostHashes;
    private final int onDemandLimit;

    public HostBalancer(File hostsPath, int onDemandLimit, boolean exceed134217727) {
        this(hostsPath, onDemandLimit, exceed134217727, true);
    }

    public HostBalancer(File hostsPath, int onDemandLimit, boolean exceed134217727, boolean asyncInit) {
        this.hostsPath = hostsPath;
        this.onDemandLimit = onDemandLimit;
        this.exceed134217727 = exceed134217727;
        if (!hostsPath.exists()) {
            hostsPath.mkdirs();
        }
        this.queues = new ConcurrentHashMap();
        this.roundRobinHostHashes = new HashSet<String>();
        this.init(asyncInit);
    }

    private void init(boolean async) {
        if (async) {
            Thread t = new Thread("HostBalancer.init"){

                @Override
                public void run() {
                    HostBalancer.this.runInit();
                }
            };
            t.start();
        } else {
            this.runInit();
        }
    }

    private void runInit() {
        String[] hostlist;
        for (String hoststr : hostlist = this.hostsPath.list()) {
            try {
                File queuePath = new File(this.hostsPath, hoststr);
                HostQueue queue = new HostQueue(queuePath, this.queues.size() > this.onDemandLimit, this.exceed134217727);
                if (queue.isEmpty()) {
                    queue.close();
                    FileUtils.deletedelete(queuePath);
                    continue;
                }
                this.queues.put(queue.getHostHash(), queue);
            }
            catch (RuntimeException | MalformedURLException e) {
                log.warn("delete queue due to init error for " + this.hostsPath.getName() + " host=" + hoststr + " " + e.getLocalizedMessage());
                FileUtils.deletedelete(new File(this.hostsPath, hoststr));
            }
        }
    }

    @Override
    public synchronized void close() {
        log.info("closing all HostBalancer queues (" + this.queues.size() + ") for hostPath " + this.hostsPath);
        if (depthCache != null) {
            depthCache.clear();
        }
        for (HostQueue queue : this.queues.values()) {
            queue.close();
        }
        this.queues.clear();
    }

    @Override
    public void clear() {
        if (depthCache != null) {
            depthCache.clear();
        }
        for (HostQueue queue : this.queues.values()) {
            queue.clear();
        }
        this.queues.clear();
    }

    @Override
    public Request get(byte[] urlhash) throws IOException {
        String hosthash = ASCII.String(urlhash, 6, 6);
        HostQueue queue = this.queues.get(hosthash);
        if (queue == null) {
            return null;
        }
        return queue.get(urlhash);
    }

    @Override
    public int removeAllByProfileHandle(String profileHandle, long timeout) throws IOException, SpaceExceededException {
        int c = 0;
        for (HostQueue queue : this.queues.values()) {
            c += queue.removeAllByProfileHandle(profileHandle, timeout);
        }
        return c;
    }

    @Override
    public int removeAllByHostHashes(Set<String> hosthashes) {
        int c = 0;
        for (String h : hosthashes) {
            HostQueue hq = this.queues.get(h);
            if (hq == null) continue;
            c += hq.removeAllByHostHashes(hosthashes);
        }
        Iterator i = depthCache.iterator();
        ArrayList<String> deleteHashes = new ArrayList<String>();
        while (i.hasNext()) {
            String h = ASCII.String((byte[])((Map.Entry)i.next()).getKey());
            if (!hosthashes.contains(h.substring(6))) continue;
            deleteHashes.add(h);
        }
        for (String h : deleteHashes) {
            depthCache.remove(ASCII.getBytes(h));
        }
        return c;
    }

    @Override
    public synchronized int remove(HandleSet urlHashes) throws IOException {
        ConcurrentHashMap<String, HandleSet> removeLists = new ConcurrentHashMap<String, HandleSet>();
        for (byte[] urlhash : urlHashes) {
            depthCache.remove(urlhash);
            String hosthash = ASCII.String(urlhash, 6, 6);
            HandleSet removeList = (HandleSet)removeLists.get(hosthash);
            if (removeList == null) {
                removeList = new RowHandleSet(12, (ByteOrder)Base64Order.enhancedCoder, 100);
                removeLists.put(hosthash, removeList);
            }
            try {
                removeList.put(urlhash);
            }
            catch (SpaceExceededException spaceExceededException) {}
        }
        int c = 0;
        for (Map.Entry entry2 : removeLists.entrySet()) {
            HostQueue queue = this.queues.get(entry2.getKey());
            if (queue == null) continue;
            c += queue.remove((HandleSet)entry2.getValue());
        }
        return c;
    }

    @Override
    public boolean has(byte[] urlhashb) {
        if (depthCache.has(urlhashb)) {
            return true;
        }
        String hosthash = ASCII.String(urlhashb, 6, 6);
        HostQueue queue = this.queues.get(hosthash);
        if (queue == null) {
            return false;
        }
        return queue.has(urlhashb);
    }

    @Override
    public int size() {
        int c = 0;
        for (HostQueue queue : this.queues.values()) {
            c += queue.size();
        }
        return c;
    }

    @Override
    public boolean isEmpty() {
        for (HostQueue queue : this.queues.values()) {
            if (queue.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getOnDemandLimit() {
        return this.onDemandLimit;
    }

    @Override
    public boolean getExceed134217727() {
        return this.exceed134217727;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String push(Request entry2, CrawlProfile profile2, RobotsTxt robots2) throws IOException, SpaceExceededException {
        if (this.has(entry2.url().hash())) {
            return "double occurrence";
        }
        depthCache.put(entry2.url().hash(), entry2.depth());
        String hosthash = entry2.url().hosthash();
        HostQueue queue = this.queues.get(hosthash);
        if (queue != null) {
            return queue.push(entry2, profile2, robots2);
        }
        HostBalancer hostBalancer = this;
        synchronized (hostBalancer) {
            queue = this.queues.get(hosthash);
            if (queue == null) {
                queue = new HostQueue(this.hostsPath, entry2.url(), this.queues.size() > this.onDemandLimit, this.exceed134217727);
                this.queues.put(hosthash, queue);
                robots2.ensureExist(entry2.url(), profile2 == null ? ClientIdentification.yacyInternetCrawlerAgent : profile2.getAgent(), true);
            }
            return queue.push(entry2, profile2, robots2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request pop(boolean delay, CrawlSwitchboard cs, RobotsTxt robots2) throws IOException {
        while (true) {
            try {
                Request request;
                while (true) {
                    HostQueue rhq = null;
                    String rhh = null;
                    HostBalancer hostBalancer = this;
                    synchronized (hostBalancer) {
                        if (this.roundRobinHostHashes.size() == 0) {
                            this.roundRobinHostHashes.addAll(this.queues.keySet());
                            boolean smallStacksExist = false;
                            boolean singletonStacksExist = false;
                            for (String s : this.roundRobinHostHashes) {
                                HostQueue hq = this.queues.get(s);
                                if (hq == null) continue;
                                int size = hq.size();
                                if (size == 1) {
                                    singletonStacksExist = true;
                                    break;
                                }
                                if (size > 10) continue;
                                smallStacksExist = true;
                                break;
                            }
                            ArrayList<String> arrayList = new ArrayList<String>();
                            ArrayList<String> removehosts = new ArrayList<String>();
                            Iterator<String> i = this.roundRobinHostHashes.iterator();
                            while (i.hasNext() && this.roundRobinHostHashes.size() > 10) {
                                String hosthash = i.next();
                                HostQueue hq = this.queues.get(hosthash);
                                if (hq == null) {
                                    removehosts.add(hosthash);
                                    i.remove();
                                    continue;
                                }
                                int delta = Latency.waitingRemainingGuessed(hq.getHost(), hq.getPort(), hosthash, robots2, ClientIdentification.yacyInternetCrawlerAgent);
                                if (delta == Integer.MIN_VALUE) {
                                    arrayList.add(hosthash);
                                    i.remove();
                                    continue;
                                }
                                if (!singletonStacksExist && !smallStacksExist || delta < 0) continue;
                                if (delta >= 1000) {
                                    removehosts.add(hosthash);
                                    i.remove();
                                    continue;
                                }
                                int size = hq.size();
                                if (singletonStacksExist) {
                                    if (size == 1) continue;
                                    removehosts.add(hosthash);
                                    i.remove();
                                    continue;
                                }
                                if (size <= 10) continue;
                                removehosts.add(hosthash);
                                i.remove();
                            }
                            Random r = new Random();
                            if (arrayList.size() > 0) {
                                this.roundRobinHostHashes.add((String)arrayList.remove(r.nextInt(arrayList.size())));
                            }
                            while (this.roundRobinHostHashes.size() < 100 && removehosts.size() > 0) {
                                this.roundRobinHostHashes.add((String)removehosts.remove(r.nextInt(removehosts.size())));
                            }
                            while (this.roundRobinHostHashes.size() < 100 && arrayList.size() > 0) {
                                this.roundRobinHostHashes.add((String)arrayList.remove(r.nextInt(arrayList.size())));
                            }
                            if (this.roundRobinHostHashes.size() == 1) {
                                if (log.isFine()) {
                                    log.fine("(re-)initialized the round-robin queue with one host");
                                }
                            } else {
                                log.info("(re-)initialized the round-robin queue; " + this.roundRobinHostHashes.size() + " hosts.");
                            }
                        }
                        if (this.roundRobinHostHashes.size() == 0) {
                            return null;
                        }
                        if (this.roundRobinHostHashes.size() == 1) {
                            rhh = this.roundRobinHostHashes.iterator().next();
                            rhq = this.queues.get(rhh);
                        }
                        if (rhq == null) {
                            List lastEntries;
                            TreeMap<Integer, ArrayList<String>> fastTree = new TreeMap<Integer, ArrayList<String>>();
                            for (String string : this.roundRobinHostHashes) {
                                ArrayList<String> queueHashes;
                                HostQueue hq = this.queues.get(string);
                                if (hq == null) continue;
                                int delta = Latency.waitingRemainingGuessed(hq.getHost(), hq.getPort(), string, robots2, ClientIdentification.yacyInternetCrawlerAgent) / 200;
                                if (delta < 0) {
                                    delta = 0;
                                }
                                if ((queueHashes = (ArrayList<String>)fastTree.get(delta)) == null) {
                                    queueHashes = new ArrayList<String>(2);
                                    fastTree.put(delta, queueHashes);
                                }
                                queueHashes.add(string);
                                List firstEntries = (List)fastTree.firstEntry().getValue();
                                if (firstEntries.size() <= 1) continue;
                                int largest = Integer.MIN_VALUE;
                                for (String hh : firstEntries) {
                                    int s;
                                    HostQueue hhq = this.queues.get(hh);
                                    if (hhq == null || (s = hhq.size()) <= largest) continue;
                                    largest = s;
                                    rhh = hh;
                                }
                                rhq = this.queues.get(rhh);
                                break;
                            }
                            if (rhq == null && fastTree.size() > 0) {
                                List firstEntries = (List)fastTree.firstEntry().getValue();
                                assert (firstEntries.size() == 1);
                                rhh = (String)firstEntries.get(0);
                                rhq = this.queues.get(rhh);
                            }
                            List list2 = lastEntries = fastTree.size() > 0 ? (List)fastTree.lastEntry().getValue() : null;
                            if (lastEntries != null) {
                                for (String h2 : lastEntries) {
                                    this.roundRobinHostHashes.remove(h2);
                                }
                            }
                        }
                    }
                    if (rhq == null) {
                        this.roundRobinHostHashes.clear();
                        continue;
                    }
                    this.roundRobinHostHashes.remove(rhh);
                    long timestamp = System.currentTimeMillis();
                    request = rhq.pop(delay, cs, robots2);
                    long l = System.currentTimeMillis() - timestamp;
                    if (l > 1000L) {
                        HostBalancer hostBalancer2 = this;
                        synchronized (hostBalancer2) {
                            Iterator<String> i = this.roundRobinHostHashes.iterator();
                            while (i.hasNext() && this.roundRobinHostHashes.size() > 3) {
                                String s = i.next();
                                HostQueue hq = this.queues.get(s);
                                if (hq == null) {
                                    i.remove();
                                    continue;
                                }
                                int delta = Latency.waitingRemainingGuessed(hq.getHost(), hq.getPort(), s, robots2, ClientIdentification.yacyInternetCrawlerAgent);
                                if (delta < 0) continue;
                                i.remove();
                            }
                        }
                    }
                    if (rhq.isEmpty()) {
                        HostBalancer hostBalancer3 = this;
                        synchronized (hostBalancer3) {
                            this.queues.remove(rhh);
                        }
                        rhq.close();
                    }
                    if (request != null) break;
                }
                return request;
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
                throw new IOException(e.getMessage());
            }
            break;
        }
    }

    @Override
    public Iterator<Request> iterator() throws IOException {
        final Iterator<HostQueue> hostsIterator = this.queues.values().iterator();
        final Iterator[] hostIterator = (Iterator[])Array.newInstance(Iterator.class, 1);
        hostIterator[0] = null;
        return new Iterator<Request>(){

            @Override
            public boolean hasNext() {
                return hostsIterator.hasNext() || hostIterator[0] != null && hostIterator[0].hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Request next() {
                HostBalancer hostBalancer = HostBalancer.this;
                synchronized (hostBalancer) {
                    while (hostIterator[0] == null || !hostIterator[0].hasNext()) {
                        try {
                            HostQueue entry2 = (HostQueue)hostsIterator.next();
                            hostIterator[0] = entry2.iterator();
                        }
                        catch (IOException iOException) {}
                    }
                    if (!hostIterator[0].hasNext()) {
                        return null;
                    }
                    return (Request)hostIterator[0].next();
                }
            }

            @Override
            public void remove() {
                hostIterator[0].remove();
            }
        };
    }

    @Override
    public Map<String, Integer[]> getDomainStackHosts(RobotsTxt robots2) {
        TreeMap<String, Integer[]> map = new TreeMap<String, Integer[]>();
        for (HostQueue hq : this.queues.values()) {
            int delta = Latency.waitingRemainingGuessed(hq.getHost(), hq.getPort(), hq.getHostHash(), robots2, ClientIdentification.yacyInternetCrawlerAgent);
            map.put(hq.getHost() + ":" + hq.getPort(), new Integer[]{hq.size(), delta});
        }
        return map;
    }

    @Override
    public List<Request> getDomainStackReferences(String host, int maxcount, long maxtime) {
        if (host == null) {
            return Collections.emptyList();
        }
        try {
            HostQueue hq = this.queues.get(DigestURL.hosthash(host, host.startsWith("ftp.") ? 21 : 80));
            if (hq == null) {
                hq = this.queues.get(DigestURL.hosthash(host, 443));
            }
            return hq == null ? new ArrayList(0) : hq.getDomainStackReferences(host, maxcount, maxtime);
        }
        catch (MalformedURLException e) {
            ConcurrentLog.logException(e);
            return Collections.emptyList();
        }
    }
}

