/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class ConcurrentLog {
    private static final Logger ConcurrentLogLogger = Logger.getLogger("ConcurrentLog");
    private static final Message POISON_MESSAGE = new Message();
    private static final BlockingQueue<Message> logQueue = new ArrayBlockingQueue<Message>(2000);
    private static Worker logRunnerThread = null;
    public static boolean backgroundRunner = false;
    private final Logger theLogger;

    public static void ensureWorkerIsRunning() {
        if (backgroundRunner && (logRunnerThread == null || !logRunnerThread.isAlive())) {
            logRunnerThread = new Worker();
            logRunnerThread.start();
            ConcurrentLogLogger.log(Level.INFO, "started ConcurrentLog.Worker.");
        }
    }

    public ConcurrentLog(String appName) {
        this.theLogger = Logger.getLogger(appName);
    }

    public final void setLevel(Level newLevel) {
        this.theLogger.setLevel(newLevel);
    }

    public final void severe(String message2) {
        ConcurrentLog.enQueueLog(this.theLogger, Level.SEVERE, message2);
    }

    public final void severe(String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(this.theLogger, Level.SEVERE, message2, thrown);
    }

    public final boolean isSevere() {
        return this.theLogger.isLoggable(Level.SEVERE);
    }

    public final void warn(String message2) {
        ConcurrentLog.enQueueLog(this.theLogger, Level.WARNING, message2);
    }

    public final void warn(Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(this.theLogger, Level.WARNING, thrown.getMessage(), thrown);
    }

    public final void warn(String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(this.theLogger, Level.WARNING, message2, thrown);
    }

    public final boolean isWarn() {
        return this.theLogger.isLoggable(Level.WARNING);
    }

    public final void config(String message2) {
        ConcurrentLog.enQueueLog(this.theLogger, Level.CONFIG, message2);
    }

    public final void config(String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(this.theLogger, Level.CONFIG, message2, thrown);
    }

    public final boolean isConfig() {
        return this.theLogger.isLoggable(Level.CONFIG);
    }

    public final void info(String message2) {
        ConcurrentLog.enQueueLog(this.theLogger, Level.INFO, message2);
    }

    public final void info(String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(this.theLogger, Level.INFO, message2, thrown);
    }

    public boolean isInfo() {
        return this.theLogger.isLoggable(Level.INFO);
    }

    public final void fine(String message2) {
        ConcurrentLog.enQueueLog(this.theLogger, Level.FINE, message2);
    }

    public final void fine(String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(this.theLogger, Level.FINE, message2, thrown);
    }

    public final boolean isFine() {
        return this.theLogger.isLoggable(Level.FINE);
    }

    public final void finer(String message2) {
        ConcurrentLog.enQueueLog(this.theLogger, Level.FINER, message2);
    }

    public final void finer(String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(this.theLogger, Level.FINER, message2, thrown);
    }

    public final boolean isFiner() {
        return this.theLogger.isLoggable(Level.FINER);
    }

    public final void finest(String message2) {
        ConcurrentLog.enQueueLog(this.theLogger, Level.FINEST, message2);
    }

    public final void finest(String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(this.theLogger, Level.FINEST, message2, thrown);
    }

    public final boolean isFinest() {
        return this.theLogger.isLoggable(Level.FINEST);
    }

    public final boolean isLoggable(Level level) {
        return this.theLogger.isLoggable(level);
    }

    public static final void logException(Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog("ConcurrentLog", Level.WARNING, thrown.toString(), thrown);
    }

    public static final void severe(String appName, String message2) {
        ConcurrentLog.enQueueLog(appName, Level.SEVERE, message2);
    }

    public static final void severe(String appName, String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(appName, Level.SEVERE, message2, thrown);
    }

    public static final void warn(String appName, String message2) {
        ConcurrentLog.enQueueLog(appName, Level.WARNING, message2);
    }

    public static final void warn(String appName, String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(appName, Level.WARNING, message2, thrown);
    }

    public static final void config(String appName, String message2) {
        ConcurrentLog.enQueueLog(appName, Level.CONFIG, message2);
    }

    public static final void config(String appName, String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(appName, Level.CONFIG, message2, thrown);
    }

    public static final void info(String appName, String message2) {
        ConcurrentLog.enQueueLog(appName, Level.INFO, message2);
    }

    public static final void info(String appName, String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(appName, Level.INFO, message2, thrown);
    }

    public static final void fine(String appName, String message2) {
        ConcurrentLog.enQueueLog(appName, Level.FINE, message2);
    }

    public static final void fine(String appName, String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(appName, Level.FINE, message2, thrown);
    }

    public static final boolean isFine(String appName) {
        return Logger.getLogger(appName).isLoggable(Level.FINE);
    }

    public static final void finer(String appName, String message2) {
        ConcurrentLog.enQueueLog(appName, Level.FINER, message2);
    }

    public static final void finer(String appName, String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(appName, Level.FINER, message2, thrown);
    }

    public static final void finest(String appName, String message2) {
        ConcurrentLog.enQueueLog(appName, Level.FINEST, message2);
    }

    public static final void finest(String appName, String message2, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        ConcurrentLog.enQueueLog(appName, Level.FINEST, message2, thrown);
    }

    public static final boolean isFinest(String appName) {
        return Logger.getLogger(appName).isLoggable(Level.FINEST);
    }

    private static final void enQueueLog(Logger logger, Level level, String message2, Throwable thrown) {
        if (!logger.isLoggable(level)) {
            return;
        }
        if (!backgroundRunner || logRunnerThread == null || !logRunnerThread.isAlive()) {
            if (thrown == null) {
                logger.log(level, "* " + message2);
            } else {
                logger.log(level, "* " + message2, thrown);
            }
        } else {
            try {
                if (thrown == null) {
                    logQueue.put(new Message(logger, level, message2));
                } else {
                    logQueue.put(new Message(logger, level, message2, thrown));
                }
            }
            catch (InterruptedException e) {
                if (thrown == null) {
                    logger.log(level, message2);
                }
                logger.log(level, message2, thrown);
            }
        }
    }

    private static final void enQueueLog(Logger logger, Level level, String message2) {
        if (!logger.isLoggable(level)) {
            return;
        }
        if (!backgroundRunner || logRunnerThread == null || !logRunnerThread.isAlive()) {
            logger.log(level, "* " + message2);
        } else {
            try {
                logQueue.put(new Message(logger, level, message2));
            }
            catch (InterruptedException e) {
                logger.log(level, message2);
            }
        }
    }

    private static final void enQueueLog(String loggername, Level level, String message2, Throwable thrown) {
        if (!backgroundRunner || logRunnerThread == null || !logRunnerThread.isAlive()) {
            if (thrown == null) {
                Logger.getLogger(loggername).log(level, "* " + message2);
            } else {
                Logger.getLogger(loggername).log(level, "* " + message2, thrown);
            }
        } else {
            try {
                if (thrown == null) {
                    logQueue.put(new Message(loggername, level, message2));
                } else {
                    logQueue.put(new Message(loggername, level, message2, thrown));
                }
            }
            catch (InterruptedException e) {
                if (thrown == null) {
                    Logger.getLogger(loggername).log(level, message2);
                }
                Logger.getLogger(loggername).log(level, message2, thrown);
            }
        }
    }

    private static final void enQueueLog(String loggername, Level level, String message2) {
        if (!backgroundRunner || logRunnerThread == null || !logRunnerThread.isAlive()) {
            Logger.getLogger(loggername).log(level, "* " + message2);
        } else {
            try {
                logQueue.put(new Message(loggername, level, message2));
            }
            catch (InterruptedException e) {
                Logger.getLogger(loggername).log(level, message2);
            }
        }
    }

    public static final void configureLogging(File dataPath, File loggingConfigFile) throws SecurityException, FileNotFoundException, IOException {
        System.out.println("STARTUP: Trying to load logging configuration from file " + loggingConfigFile.toString());
        try (FileInputStream fileIn = new FileInputStream(loggingConfigFile);){
            File logFile;
            String logFilePatternKey = "java.util.logging.FileHandler.pattern";
            Properties logProperties = new Properties();
            logProperties.load(fileIn);
            String logFilePattern = logProperties.getProperty("java.util.logging.FileHandler.pattern", "%h/java%u.log");
            if (logFilePattern.startsWith("%h")) {
                logFile = new File(System.getProperty("user.home") + logFilePattern.substring(2));
            } else if (logFilePattern.startsWith("%t")) {
                String tmpDir = System.getProperty("java.io.tmpdir");
                if (tmpDir == null) {
                    tmpDir = System.getProperty("user.home");
                }
                logFile = new File(tmpDir, logFilePattern.substring(2));
            } else {
                logFile = new File(logFilePattern);
                if (!logFile.isAbsolute()) {
                    logFile = new File(dataPath, logFilePattern);
                    logFilePattern = logFile.getAbsolutePath();
                    logProperties.setProperty("java.util.logging.FileHandler.pattern", logFilePattern);
                }
            }
            File logDirectory = logFile.getParentFile();
            if (logDirectory != null) {
                if (!logDirectory.exists()) {
                    if (!logDirectory.mkdirs()) {
                        System.err.println("STARTUP: Could not create the logs directory at " + logDirectory.getAbsolutePath());
                    }
                } else if (!logDirectory.isDirectory()) {
                    System.err.println("STARTUP: Log file parent path at " + logDirectory.getAbsolutePath() + "is not a directory");
                }
            }
            ByteArrayOutputStream propsStream = new ByteArrayOutputStream();
            logProperties.store(propsStream, null);
            LogManager logManager = LogManager.getLogManager();
            logManager.readConfiguration(new ByteArrayInputStream(propsStream.toByteArray()));
            final ConcurrentLog exceptionLog = new ConcurrentLog("UNCAUGHT-EXCEPTION");
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (e == null) {
                        return;
                    }
                    String msg = String.format("Thread %s: %s", t.getName(), e.getMessage());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(baos);
                    e.printStackTrace(ps);
                    ps.close();
                    exceptionLog.severe(msg + "\n" + baos.toString(), e);
                    ConcurrentLogLogger.log(Level.SEVERE, e.getMessage(), e);
                    if (e instanceof InvocationTargetException) {
                        Throwable target = ((InvocationTargetException)e).getTargetException();
                        ConcurrentLogLogger.log(Level.SEVERE, target.getMessage(), target);
                    }
                }
            });
        }
    }

    public static final void shutdown() {
        if (logRunnerThread == null || !logRunnerThread.isAlive()) {
            ConcurrentLogLogger.log(Level.INFO, "shutdown of ConcurrentLog.Worker void because it was not running.");
            return;
        }
        try {
            ConcurrentLogLogger.log(Level.INFO, "shutdown of ConcurrentLog.Worker: injection of poison message");
            logQueue.put(POISON_MESSAGE);
            logRunnerThread.join(2000L);
            ConcurrentLogLogger.log(Level.INFO, "shutdown of ConcurrentLog.Worker: terminated");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String stackTrace() {
        Throwable t = new Throwable();
        StackTraceElement[] e = t.getStackTrace();
        StringBuilder sb = new StringBuilder(80);
        for (int i = 2; i < e.length - 1; ++i) {
            sb.append(e[i].toString()).append(" -> ");
        }
        sb.append(e[e.length - 1].toString());
        return sb.toString();
    }

    static {
        ConcurrentLog.ensureWorkerIsRunning();
    }

    protected static final class Worker
    extends Thread {
        public Worker() {
            super("Log Worker");
        }

        @Override
        public void run() {
            HashMap<String, Logger> loggerCache = new HashMap<String, Logger>();
            try {
                Message entry2;
                while ((entry2 = (Message)logQueue.take()) != POISON_MESSAGE) {
                    if (entry2.logger == null) {
                        assert (entry2.loggername != null);
                        Logger l = (Logger)loggerCache.get(entry2.loggername);
                        if (l == null) {
                            l = Logger.getLogger(entry2.loggername);
                            loggerCache.put(entry2.loggername, l);
                        }
                        if (entry2.thrown == null) {
                            l.log(entry2.level, entry2.message);
                            continue;
                        }
                        l.log(entry2.level, entry2.message, entry2.thrown);
                        continue;
                    }
                    assert (entry2.loggername == null);
                    if (entry2.thrown == null) {
                        entry2.logger.log(entry2.level, entry2.message);
                        continue;
                    }
                    entry2.logger.log(entry2.level, entry2.message, entry2.thrown);
                }
            }
            catch (Throwable e) {
                ConcurrentLogLogger.log(Level.SEVERE, "ConcurrentLog.Worker has terminated", e);
            }
            ConcurrentLogLogger.log(Level.INFO, "terminating ConcurrentLog.Worker with " + logQueue.size() + " cached loglines.");
        }
    }

    protected static final class Message {
        private final Level level;
        private final String message;
        private Logger logger;
        private String loggername;
        private Throwable thrown;

        private Message(Level level, String message2) {
            this.level = level;
            this.message = message2 == null || message2.length() <= 4096 ? message2 : message2.substring(0, 4096);
        }

        public Message(Logger logger, Level level, String message2, Throwable thrown) {
            this(level, message2);
            this.logger = logger;
            this.loggername = null;
            this.thrown = thrown;
        }

        public Message(Logger logger, Level level, String message2) {
            this(level, message2);
            this.logger = logger;
            this.loggername = null;
            this.thrown = null;
        }

        public Message(String loggername, Level level, String message2, Throwable thrown) {
            this(level, message2);
            this.logger = null;
            this.loggername = loggername;
            this.thrown = thrown;
        }

        public Message(String loggername, Level level, String message2) {
            this(level, message2);
            this.logger = null;
            this.loggername = loggername;
            this.thrown = null;
        }

        public Message() {
            this.logger = null;
            this.loggername = null;
            this.level = null;
            this.message = null;
            this.thrown = null;
        }
    }
}

