/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZIPWriter
extends AbstractMap<String, ZipEntry>
implements Map<String, ZipEntry>,
Iterable<Map.Entry<String, ZipEntry>> {
    private final HashMap<String, ZipEntry> backup;
    private final ZipOutputStream zos;

    public ZIPWriter(File file) throws IOException {
        if (file.exists()) {
            throw new IOException("ZIPWriter can only be used for new files");
        }
        this.backup = new HashMap();
        this.zos = new ZipOutputStream(new FileOutputStream(file));
    }

    @Override
    public ZipEntry put(String key, ZipEntry value) {
        assert (!this.backup.containsKey(key));
        try {
            this.zos.putNextEntry(value);
            this.backup.put(key, value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ZipEntry get(Object key) {
        return this.backup.get(key);
    }

    @Override
    public Iterator<Map.Entry<String, ZipEntry>> iterator() {
        return this.backup.entrySet().iterator();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, ZipEntry>> entrySet() {
        return this.backup.entrySet();
    }

    public void close() throws IOException {
        this.zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File inputDir, File zipOut) throws IOException {
        URI base = inputDir.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(inputDir);
        byte[] buffer = new byte[1024];
        try (FileOutputStream out = new FileOutputStream(zipOut);
             ZipOutputStream zout = new ZipOutputStream(out);){
            while (!queue.isEmpty()) {
                inputDir = (File)queue.pop();
                for (File lf : inputDir.listFiles()) {
                    String name = base.relativize(lf.toURI()).getPath();
                    if (lf.isDirectory()) {
                        queue.push(lf);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    try (FileInputStream in = new FileInputStream(lf);){
                        int readCount;
                        while ((readCount = ((InputStream)in).read(buffer)) > 0) {
                            zout.write(buffer, 0, readCount);
                        }
                    }
                    zout.closeEntry();
                }
            }
        }
    }
}

