/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class Files {
    public static final String POISON_LINE = "__@POISON__";

    public static InputStream read(File f) throws IOException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(f));
        if (f.toString().endsWith(".bz2")) {
            is = new BZip2CompressorInputStream((InputStream)is);
        }
        if (f.toString().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    public static BlockingQueue<String> concurentLineReader(File f) throws IOException {
        final LinkedBlockingQueue<String> q = new LinkedBlockingQueue<String>();
        final InputStream is = Files.read(f);
        final BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        Thread t = new Thread("Files.concurrentLineReader:" + f){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        q.put(line);
                    }
                }
                catch (IOException e) {
                }
                catch (InterruptedException e) {
                }
                finally {
                    try {
                        q.put(Files.POISON_LINE);
                        try {
                            br.close();
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (InterruptedException e) {
                        q.add(Files.POISON_LINE);
                        try {
                            br.close();
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        t.start();
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        if (!from.exists()) {
            throw new IOException("Can not find source: " + from.getAbsolutePath() + ".");
        }
        if (!from.canRead()) {
            throw new IOException("No right to source: " + from.getAbsolutePath() + ".");
        }
        if (from.isDirectory()) {
            if (!to.exists() && !to.mkdirs()) {
                throw new IOException("Could not create directory: " + to.getAbsolutePath() + ".");
            }
            for (String f : from.list()) {
                Files.copy(new File(from, f), new File(to, f));
            }
        } else {
            if (to.isDirectory()) {
                throw new IOException("Cannot copy a file to an existing directory");
            }
            if (to.exists()) {
                to.delete();
            }
            byte[] buffer = new byte[4096];
            InputStream in = null;
            OutputStream out = null;
            try {
                int bytesRead;
                in = new BufferedInputStream(new FileInputStream(from));
                out = new BufferedOutputStream(new FileOutputStream(to));
                while ((bytesRead = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }
}

