/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.storage.Files;

public class Configuration
extends TreeMap<String, Entry>
implements Serializable {
    private static final long serialVersionUID = -5961730809008841258L;
    private final File file;
    protected boolean lazy;

    public Configuration() {
        this.file = null;
        this.lazy = false;
    }

    public Configuration(File file) throws IOException {
        this.file = file;
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new FileReader(this.file));
            String comment = null;
            while ((s = br.readLine()) != null) {
                String value;
                String key;
                int i;
                boolean enabled;
                if (s.startsWith("##") || s.isEmpty()) {
                    if (!s.startsWith("##")) continue;
                    comment = s.substring(2);
                    continue;
                }
                if (s.startsWith("#")) {
                    enabled = false;
                    s = s.substring(1).trim();
                } else {
                    enabled = true;
                }
                if (s.contains("#")) {
                    i = s.indexOf("#");
                    comment = s.substring(i + 1);
                    s = s.substring(0, i).trim();
                }
                if (s.contains("=")) {
                    i = s.indexOf("=");
                    key = s.substring(0, i).trim();
                    value = s.substring(i + 1).trim();
                    if (value.isEmpty()) {
                        value = null;
                    }
                } else {
                    key = s.trim();
                    value = null;
                }
                if (key.isEmpty()) continue;
                Entry entry2 = new Entry(key, value, enabled);
                if (comment != null) {
                    entry2.setComment(comment);
                    comment = null;
                }
                this.put(key, entry2);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean contains(String key) {
        if (key == null) {
            return false;
        }
        Entry e = (Entry)this.get(key);
        return e == null ? false : e.enabled();
    }

    public boolean containsDisabled(String o) {
        if (o == null) {
            return false;
        }
        Entry e = (Entry)this.get(o);
        return e == null ? false : !e.enabled();
    }

    public boolean add(String key) {
        return this.add(key, null);
    }

    public boolean add(String key, String comment) {
        return this.add(key, comment, true);
    }

    public boolean add(String key, String comment, boolean enabled) {
        boolean modified = false;
        Entry entry2 = (Entry)this.get(key);
        if (entry2 == null) {
            entry2 = new Entry(key, enabled);
            if (comment != null) {
                entry2.setComment(comment);
            }
            this.put(key, entry2);
            modified = true;
        } else {
            if (entry2.enabled() != enabled) {
                entry2.setEnable(enabled);
                modified = true;
            }
            if (comment != null && !comment.equals(entry2.getComment())) {
                entry2.setComment(comment);
                modified = true;
            }
        }
        try {
            if (modified) {
                this.commit();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return modified;
    }

    public void commit() throws IOException {
        if (this.file == null) {
            return;
        }
        File bakfile = new File(this.file.getAbsolutePath() + ".bak");
        try {
            Files.copy(this.file, bakfile);
        }
        catch (IOException e) {
            this.file.createNewFile();
        }
        TreeMap tclone = (TreeMap)this.clone();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
        try {
            String sorig;
            BufferedReader reader = new BufferedReader(new FileReader(bakfile));
            while ((sorig = reader.readLine()) != null) {
                String key;
                int i;
                if (sorig.startsWith("##") || sorig.isEmpty()) {
                    writer.write(sorig + "\n");
                    continue;
                }
                String s = sorig.startsWith("#") ? sorig.substring(1).trim() : sorig;
                if (s.contains("#")) {
                    i = s.indexOf("#");
                    s = s.substring(0, i).trim();
                }
                if (s.contains("=")) {
                    i = s.indexOf("=");
                    key = s.substring(0, i).trim();
                } else {
                    key = s.trim();
                }
                if (!key.isEmpty()) {
                    Entry e = (Entry)this.get(key);
                    if (e != null) {
                        writer.write(e.toString());
                        tclone.remove(key);
                    }
                    writer.write("\n");
                    continue;
                }
                writer.write(sorig + "\n");
            }
            reader.close();
            bakfile.delete();
        }
        catch (IOException reader) {
            // empty catch block
        }
        for (Map.Entry e : tclone.entrySet()) {
            writer.write(e.toString() + "\n");
        }
        writer.close();
    }

    public Iterator<Entry> entryIterator() {
        return this.values().iterator();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        File f = new File(args[0]);
        try {
            Entry k;
            Configuration cs = new Configuration(f);
            Iterator<Entry> i = cs.entryIterator();
            System.out.println("\nall activated attributes:");
            while (i.hasNext()) {
                k = i.next();
                if (!k.enabled()) continue;
                System.out.println(k.toString());
            }
            i = cs.entryIterator();
            System.out.println("\nall deactivated attributes:");
            while (i.hasNext()) {
                k = i.next();
                if (k.enabled()) continue;
                System.out.println(k.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Entry {
        private final String key;
        private String value;
        private boolean enabled;
        private String comment;

        public Entry(String key, boolean enabled) {
            this.enabled = enabled;
            if (key.contains("=")) {
                int i = key.indexOf("=");
                this.key = key.substring(0, i).trim();
                this.value = key.substring(i + 1).trim();
            } else {
                this.key = key;
                this.value = null;
            }
        }

        public Entry(String key, String value, boolean enabled) {
            this.enabled = enabled;
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public void setValue(String theValue) {
            this.value = theValue != null && theValue.isEmpty() ? null : theValue;
        }

        public String getValue() {
            return this.value;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        public void setEnable(boolean value) {
            this.enabled = value;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public String toString() {
            return (this.enabled ? "" : "#") + (this.value != null ? this.key + " = " + this.value : this.key) + (this.comment != null ? "  #" + this.comment : "");
        }
    }
}

