/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.sorting;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import net.yacy.cora.sorting.AbstractScoreMap;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.storage.OutOfLimitsException;

public final class ClusteredScoreMap<E>
extends AbstractScoreMap<E>
implements ReversibleScoreMap<E> {
    private final Map<E, Long> map;
    private final TreeMap<Long, E> pam;
    private long gcount;
    private int encnt;

    public ClusteredScoreMap(boolean sortedKeys) {
        this.map = sortedKeys ? new TreeMap() : new LinkedHashMap();
        this.pam = new TreeMap();
        this.gcount = 0L;
        this.encnt = 0;
    }

    public ClusteredScoreMap(Comparator<E> c) {
        this.map = new TreeMap<E, Long>(c);
        this.pam = new TreeMap();
        this.gcount = 0L;
        this.encnt = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
        this.pam.clear();
        this.gcount = 0L;
        this.encnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int shrinkToMaxSize(int maxsize) {
        if (maxsize < 0) {
            return 0;
        }
        int deletedNb = 0;
        ClusteredScoreMap clusteredScoreMap = this;
        synchronized (clusteredScoreMap) {
            Long key;
            while (this.map.size() > maxsize && (key = this.pam.firstKey()) != null) {
                this.map.remove(this.pam.remove(key));
                ++deletedNb;
            }
        }
        return deletedNb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int shrinkToMinScore(int minScore) {
        int deletedNb = 0;
        ClusteredScoreMap clusteredScoreMap = this;
        synchronized (clusteredScoreMap) {
            int score;
            Long key;
            while (!this.pam.isEmpty() && (key = this.pam.firstKey()) != null && (score = (int)((key & 0xFFFFFFFF00000000L) >> 32)) < minScore) {
                this.map.remove(this.pam.remove(key));
                ++deletedNb;
            }
        }
        return deletedNb;
    }

    private long scoreKey(int elementNr, int elementCount) {
        return ((long)elementCount & 0xFFFFFFFFL) << 32 | (long)elementNr & 0xFFFFFFFFL;
    }

    private synchronized long totalCount() {
        return this.gcount;
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public boolean sizeSmaller(int size) {
        return this.map.size() < size;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized void inc(E obj) {
        this.inc(obj, 1);
    }

    @Override
    public synchronized void dec(E obj) {
        this.inc(obj, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(E obj, int newScore) {
        if (obj == null) {
            return;
        }
        ClusteredScoreMap clusteredScoreMap = this;
        synchronized (clusteredScoreMap) {
            Long usk = this.map.remove(obj);
            if (newScore < 0) {
                throw new OutOfLimitsException(newScore);
            }
            if (usk == null) {
                usk = this.scoreKey(this.encnt++, newScore);
                this.map.put(obj, usk);
                this.pam.put(usk, obj);
            } else {
                this.pam.remove(usk);
                long c = usk;
                int oldScore = (int)((c & 0xFFFFFFFF00000000L) >> 32);
                int oldHandle = (int)(c & 0xFFFFFFFFL);
                this.gcount -= (long)oldScore;
                usk = this.scoreKey(oldHandle, newScore);
                this.map.put(obj, usk);
                this.pam.put(usk, obj);
            }
        }
        this.gcount += (long)newScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inc(E obj, int incrementScore) {
        if (obj == null) {
            return;
        }
        ClusteredScoreMap clusteredScoreMap = this;
        synchronized (clusteredScoreMap) {
            Long usk = this.map.remove(obj);
            if (usk == null) {
                if (incrementScore < 0) {
                    throw new OutOfLimitsException(incrementScore);
                }
                usk = this.scoreKey(this.encnt++, incrementScore);
                this.map.put(obj, usk);
                this.pam.put(usk, obj);
            } else {
                this.pam.remove(usk);
                long c = usk;
                int oldScore = (int)((c & 0xFFFFFFFF00000000L) >> 32);
                int oldHandle = (int)(c & 0xFFFFFFFFL);
                int newValue = oldScore + incrementScore;
                if (newValue < 0) {
                    throw new OutOfLimitsException(newValue);
                }
                usk = this.scoreKey(oldHandle, newValue);
                this.map.put(obj, usk);
                this.pam.put(usk, obj);
            }
        }
        this.gcount += (long)incrementScore;
    }

    @Override
    public void dec(E obj, int incrementScore) {
        this.inc(obj, -incrementScore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(E obj) {
        Long usk;
        if (obj == null) {
            return 0;
        }
        ClusteredScoreMap clusteredScoreMap = this;
        synchronized (clusteredScoreMap) {
            usk = this.map.remove(obj);
            if (usk == null) {
                return 0;
            }
            this.pam.remove(usk);
        }
        int oldScore = (int)((usk & 0xFFFFFFFF00000000L) >> 32);
        this.gcount -= (long)oldScore;
        return oldScore;
    }

    @Override
    public synchronized boolean containsKey(E obj) {
        return this.map.containsKey(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(E obj) {
        Long cs;
        if (obj == null) {
            return 0;
        }
        ClusteredScoreMap clusteredScoreMap = this;
        synchronized (clusteredScoreMap) {
            cs = this.map.get(obj);
        }
        if (cs == null) {
            return 0;
        }
        return (int)((cs & 0xFFFFFFFF00000000L) >> 32);
    }

    @Override
    public synchronized int getMaxScore() {
        if (this.map.isEmpty()) {
            return -1;
        }
        return (int)((this.pam.lastKey() & 0xFFFFFFFF00000000L) >> 32);
    }

    @Override
    public synchronized int getMinScore() {
        if (this.map.isEmpty()) {
            return -1;
        }
        return (int)((this.pam.firstKey() & 0xFFFFFFFF00000000L) >> 32);
    }

    @Override
    public synchronized E getMaxKey() {
        if (this.map.isEmpty()) {
            return null;
        }
        return this.pam.get(this.pam.lastKey());
    }

    @Override
    public synchronized E getMinKey() {
        if (this.map.isEmpty()) {
            return null;
        }
        return this.pam.get(this.pam.firstKey());
    }

    @Override
    public synchronized Iterator<E> keys(boolean up) {
        if (up) {
            return new simpleScoreIterator();
        }
        return new reverseScoreIterator();
    }

    public static void main(String[] args) {
        System.out.println("Test for Score: start");
        ClusteredScoreMap<String> s = new ClusteredScoreMap<String>(false);
        long c = 0L;
        long time = System.currentTimeMillis();
        Random random = new Random(1234L);
        int count = 20;
        for (int x = 0; x < 100000; ++x) {
            for (int i = 0; i < 20; ++i) {
                int r = Math.abs(random.nextInt(100));
                s.inc("score#" + r, r);
                c += (long)r;
            }
            for (int i = 0; i < 10; ++i) {
                int p = Math.abs(random.nextInt(1000));
                if (!s.containsKey("score#" + p)) continue;
                c -= (long)s.delete("score#" + p);
            }
        }
        System.out.println("finished create. time = " + (System.currentTimeMillis() - time));
        System.out.println("result:");
        Iterator i = s.keys(true);
        while (i.hasNext()) {
            System.out.println("up: " + (String)i.next());
        }
        i = s.keys(false);
        while (i.hasNext()) {
            System.out.println("down: " + (String)i.next());
        }
        System.out.println("total=" + super.totalCount() + ", elements=" + s.size() + ", redundant count=" + c);
    }

    private class simpleScoreIterator<A extends E>
    implements Iterator<E> {
        Iterator<Map.Entry<Long, E>> ii;
        Map.Entry<Long, E> entry;

        public simpleScoreIterator() {
            this.ii = ClusteredScoreMap.this.pam.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ii.hasNext();
        }

        @Override
        public E next() {
            this.entry = this.ii.next();
            return this.entry.getValue();
        }

        @Override
        public void remove() {
            this.ii.remove();
            if (this.entry.getValue() != null) {
                ClusteredScoreMap.this.map.remove(this.entry.getValue());
            }
        }
    }

    private class reverseScoreIterator<A extends E>
    implements Iterator<E> {
        SortedMap<Long, E> view;
        Long key;

        public reverseScoreIterator() {
            this.view = ClusteredScoreMap.this.pam;
        }

        @Override
        public boolean hasNext() {
            return !this.view.isEmpty();
        }

        @Override
        public E next() {
            this.key = this.view.lastKey();
            this.view = this.view.headMap(this.key);
            Object value = ClusteredScoreMap.this.pam.get(this.key);
            return value;
        }

        @Override
        public void remove() {
            Object val = ClusteredScoreMap.this.pam.remove(this.key);
            if (val != null) {
                ClusteredScoreMap.this.map.remove(val);
            }
        }
    }
}

