/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.sorting;

import java.util.ArrayList;
import java.util.Random;
import net.yacy.cora.sorting.Sortable;

public class Array {
    public static <A> void sort(Sortable<A> x) {
        Array.sort(x, 0, x.size(), x.buffer(), 0);
    }

    private static <A> void sort(Sortable<A> x, int o, int l, A f, int depth) {
        int s1;
        int c;
        int a;
        if (l < 7) {
            for (int i = o; i < l + o; ++i) {
                for (int j = i; j > o && x.compare(x.get(j, false), x.get(j - 1, false)) < 0; --j) {
                    x.swap(j, j - 1, f);
                }
            }
            return;
        }
        int m = o + (l >> 1);
        if (l > 7) {
            int k = o;
            int n = o + l - 1;
            if (l > 40) {
                int s = l / 8;
                k = Array.med3(x, k, k + s, k + 2 * s);
                m = Array.med3(x, m - s, m, m + s);
                n = Array.med3(x, n - 2 * s, n - s, n);
            }
            m = Array.med3(x, k, m, n);
        }
        A p = x.get(m, true);
        int b = a = o;
        int d = c = o + l - 1;
        while (true) {
            A _v;
            if (c >= b && x.compare(p, _v = x.get(b, false)) >= 0) {
                if (x.compare(_v, p) == 0) {
                    x.swap(a++, b, f);
                }
                ++b;
                continue;
            }
            while (c >= b && x.compare(_v = x.get(c, false), p) >= 0) {
                if (x.compare(_v, p) == 0) {
                    x.swap(c, d--, f);
                }
                --c;
            }
            if (b > c) break;
            x.swap(b++, c--, f);
        }
        int n = o + l;
        int s = Math.min(a - o, b - a);
        Array.swap(x, o, b - s, s, f);
        s = Math.min(d - c, n - d - 1);
        Array.swap(x, b, n - s, s, f);
        int s0 = b - a;
        if (s0 > 1) {
            Array.sort(x, o, s0, f, depth + 1);
        }
        if ((s1 = d - c) > 1) {
            Array.sort(x, n - s1, s1, x.buffer(), depth + 1);
        }
    }

    private static <A> void swap(Sortable<A> x, int a, int b, int n, A buffer) {
        if (n == 1) {
            x.swap(a, b, buffer);
        } else {
            int i = 0;
            while (i < n) {
                x.swap(a, b, buffer);
                ++i;
                ++a;
                ++b;
            }
        }
    }

    private static <A> int med3(Sortable<A> x, int a, int b, int c) {
        A _a = x.get(a, false);
        A _b = x.get(b, false);
        A _c = x.get(c, false);
        return x.compare(_a, _b) < 0 ? (x.compare(_b, _c) < 0 ? b : (x.compare(_a, _c) < 0 ? c : a)) : (x.compare(_c, _b) < 0 ? b : (x.compare(_c, _a) < 0 ? c : a));
    }

    public static <A> void uniq(Sortable<A> x) {
        if (x.size() < 2) {
            return;
        }
        int i = x.size() - 1;
        A a = x.get(i--, true);
        while (i >= 0) {
            A b = x.get(i, true);
            if (x.compare(a, b) == 0) {
                x.delete(i);
            } else {
                a = b;
            }
            --i;
        }
    }

    public static void main(String[] args) {
        int i;
        int count = 1000000;
        P test2 = new P();
        Random r = new Random(0L);
        for (i = 0; i < 1000000; ++i) {
            test2.add(r.nextInt());
        }
        r = new Random(0L);
        for (i = 0; i < 1000000; ++i) {
            test2.add(r.nextInt());
        }
        long t0 = System.currentTimeMillis();
        Array.sort(test2);
        long t1 = System.currentTimeMillis();
        System.out.println("sort = " + (t1 - t0) + "ms");
        long t2 = System.currentTimeMillis();
        System.out.println("uniq = " + (t2 - t1) + "ms");
        System.out.println("result: " + test2.size());
    }

    private static class P
    extends ArrayList<Integer>
    implements Sortable<Integer> {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }

        @Override
        public Integer buffer() {
            return 0;
        }

        @Override
        public void swap(int i, int j, Integer buffer) {
            buffer = (Integer)this.get(i);
            this.set(i, (Integer)this.get(j));
            this.set(j, buffer);
        }

        @Override
        public void delete(int i) {
            this.remove(i);
        }

        @Override
        public Integer get(int i, boolean clone) {
            return (Integer)this.get(i);
        }
    }
}

