/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.ConnectionInfo;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.http.GzipCompressingEntity;
import net.yacy.cora.protocol.http.GzipRequestInterceptor;
import net.yacy.cora.protocol.http.GzipResponseInterceptor;
import net.yacy.cora.protocol.http.NonClosingInputStreamEntity;
import net.yacy.cora.protocol.http.ProxySettings;
import net.yacy.cora.protocol.http.auth.YaCyDigestSchemeFactory;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.Memory;
import net.yacy.kelondro.util.Formatter;
import net.yacy.kelondro.util.NamePrefixThreadFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.IdleConnectionEvictor;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.EntityUtils;

public class HTTPClient
implements Closeable {
    private static final int default_timeout = 6000;
    private static final int maxcon = 200;
    private static final int DEFAULT_CONNECTION_EVICTOR_SLEEP_TIME = 5;
    private static final int DEFAULT_POOLED_CONNECTION_TIME_TO_LIVE = 30;
    private static RequestConfig DFLTREQUESTCONFIG = HTTPClient.initRequestConfig(6000);
    private static final Lookup<AuthSchemeProvider> AUTHSCHEMEREGISTRY = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new YaCyDigestSchemeFactory()).build();
    public static final PoolingHttpClientConnectionManager CONNECTION_MANAGER = HTTPClient.initPoolingConnectionManager();
    public static final boolean ENABLE_SNI_EXTENSION_DEFAULT = true;
    public static final AtomicBoolean ENABLE_SNI_EXTENSION = new AtomicBoolean(Boolean.parseBoolean(System.getProperty("jsse.enableSNIExtension", Boolean.toString(true))));
    private static final IdleConnectionEvictor EXPIRED_CONNECTIONS_EVICTOR = new IdleConnectionEvictor((HttpClientConnectionManager)CONNECTION_MANAGER, 5L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
    private static final HttpClientBuilder clientBuilder;
    private final RequestConfig.Builder reqConfBuilder;
    private Set<Map.Entry<String, String>> headers = null;
    private long upbytes = 0L;
    private String host = null;
    private final long timeout;
    private static ExecutorService executor;
    private CloseableHttpClient client = null;
    private CloseableHttpResponse httpResponse = null;
    private HttpUriRequest currentRequest = null;

    public HTTPClient(ClientIdentification.Agent agent) {
        this.timeout = agent.clientTimeout;
        clientBuilder.setUserAgent(agent.userAgent);
        this.reqConfBuilder = RequestConfig.copy((RequestConfig)DFLTREQUESTCONFIG);
        this.setTimout(agent.clientTimeout);
    }

    public HTTPClient(ClientIdentification.Agent agent, int timeout) {
        this.timeout = timeout;
        clientBuilder.setUserAgent(agent.userAgent);
        this.reqConfBuilder = RequestConfig.copy((RequestConfig)DFLTREQUESTCONFIG);
        this.setTimout(timeout);
    }

    private static RequestConfig initRequestConfig(int timeout) {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setExpectContinueEnabled(false);
        builder.setConnectionRequestTimeout(timeout);
        builder.setConnectTimeout(timeout);
        builder.setSocketTimeout(timeout);
        builder.setCookieSpec("ignoreCookies");
        builder.setRedirectsEnabled(true);
        builder.setRelativeRedirectsAllowed(true);
        return builder.build();
    }

    private static HttpClientBuilder initClientBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setConnectionManager((HttpClientConnectionManager)CONNECTION_MANAGER);
        builder.setConnectionManagerShared(true);
        builder.setDefaultRequestConfig(DFLTREQUESTCONFIG);
        builder.setUserAgent(ClientIdentification.yacyInternetCrawlerAgent.userAgent);
        builder.setDefaultCookieStore(null);
        builder.disableCookieManagement();
        builder.setKeepAliveStrategy(HTTPClient.customKeepAliveStrategy());
        builder.addInterceptorLast((HttpRequestInterceptor)new GzipRequestInterceptor());
        builder.addInterceptorLast((HttpResponseInterceptor)new GzipResponseInterceptor());
        builder.setRoutePlanner(ProxySettings.RoutePlanner);
        builder.setDefaultCredentialsProvider(ProxySettings.CredsProvider);
        return builder;
    }

    private static PoolingHttpClientConnectionManager initPoolingConnectionManager() {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)HTTPClient.getSSLSocketFactory()).build();
        PoolingHttpClientConnectionManager pooling = new PoolingHttpClientConnectionManager(registry, null, null, new DnsResolver(){

            public InetAddress[] resolve(String host0) throws UnknownHostException {
                InetAddress ip = Domains.dnsResolve(host0);
                if (ip == null) {
                    throw new UnknownHostException(host0);
                }
                return new InetAddress[]{ip};
            }
        }, 30L, TimeUnit.SECONDS);
        HTTPClient.initPoolMaxConnections(pooling, 200);
        pooling.setValidateAfterInactivity(6000);
        SocketConfig socketConfig = SocketConfig.custom().setSoReuseAddress(true).setSoTimeout(6000).setTcpNoDelay(false).build();
        pooling.setDefaultSocketConfig(socketConfig);
        return pooling;
    }

    public static void initPoolMaxConnections(PoolingHttpClientConnectionManager pool, int maxConnections) {
        if (pool == null) {
            throw new IllegalArgumentException("pool parameter must not be null");
        }
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("maxConnections parameter must be greater than zero");
        }
        pool.setMaxTotal(maxConnections);
        ConnectionInfo.setMaxcount(maxConnections);
        pool.setDefaultMaxPerRoute((int)(2L * Memory.cores()));
        HttpHost localhost = new HttpHost("localhost");
        pool.setMaxPerRoute(new HttpRoute(localhost), maxConnections);
    }

    public static void closeConnectionManager() throws InterruptedException {
        try {
            if (EXPIRED_CONNECTIONS_EVICTOR != null) {
                EXPIRED_CONNECTIONS_EVICTOR.shutdown();
                EXPIRED_CONNECTIONS_EVICTOR.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        finally {
            if (CONNECTION_MANAGER != null) {
                CONNECTION_MANAGER.shutdown();
            }
        }
    }

    public void setHeader(Set<Map.Entry<String, String>> entrys) {
        this.headers = entrys;
    }

    public void setTimout(int timeout) {
        this.reqConfBuilder.setSocketTimeout(timeout);
        this.reqConfBuilder.setConnectTimeout(timeout);
        this.reqConfBuilder.setConnectionRequestTimeout(timeout);
        DFLTREQUESTCONFIG = HTTPClient.initRequestConfig(timeout);
    }

    public void setUserAgent(ClientIdentification.Agent agent) {
        clientBuilder.setUserAgent(agent.userAgent);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setRedirecting(boolean redirecting) {
        this.reqConfBuilder.setRedirectsEnabled(redirecting);
        this.reqConfBuilder.setRelativeRedirectsAllowed(redirecting);
    }

    public byte[] GETbytes(String uri, String username, String pass, boolean concurrent) throws IOException {
        return this.GETbytes(uri, username, pass, Integer.MAX_VALUE, concurrent);
    }

    public byte[] GETbytes(MultiProtocolURL url, String username, String pass, boolean concurrent) throws IOException {
        return this.GETbytes(url, username, pass, Integer.MAX_VALUE, concurrent);
    }

    public byte[] GETbytes(String uri, String username, String pass, int maxBytes, boolean concurrent) throws IOException {
        return this.GETbytes(new MultiProtocolURL(uri), username, pass, maxBytes, concurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] GETbytes(MultiProtocolURL url, String username, String pass, int maxBytes, boolean concurrent) throws IOException {
        boolean localhost = Domains.isLocalhost(url.getHost());
        String urix = url.toNormalform(true);
        try {
            this.currentRequest = new HttpGet(urix);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        if (!localhost) {
            this.setHost(url.getHost());
        }
        if (!localhost || pass == null) {
            return this.getContentBytes(maxBytes, concurrent);
        }
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope("localhost", url.getPort()), (Credentials)new UsernamePasswordCredentials(username, pass));
        try (CloseableHttpClient httpclient = clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultAuthSchemeRegistry(AUTHSCHEMEREGISTRY).build();){
            this.httpResponse = httpclient.execute(this.currentRequest);
            HttpEntity httpEntity = this.httpResponse.getEntity();
            if (httpEntity != null && this.getStatusCode() == 200) {
                if (maxBytes >= 0 && httpEntity.getContentLength() > (long)maxBytes) {
                    throw new IOException("Content to download exceed maximum value of " + Formatter.bytesToString(maxBytes));
                }
                byte[] byArray = HTTPClient.getByteArray(httpEntity, maxBytes);
                return byArray;
            }
        }
        finally {
            this.close();
        }
        return null;
    }

    public void GET(String uri, boolean concurrent) throws IOException {
        this.GET(new MultiProtocolURL(uri), concurrent);
    }

    public void GET(MultiProtocolURL url, boolean concurrent) throws IOException {
        if (this.currentRequest != null) {
            throw new IOException("Client is in use!");
        }
        String urix = url.toNormalform(true);
        try {
            this.currentRequest = new HttpGet(urix);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        this.setHost(url.getHost());
        this.execute(concurrent);
    }

    public HttpResponse HEADResponse(String uri, boolean concurrent) throws IOException {
        return this.HEADResponse(new MultiProtocolURL(uri), concurrent);
    }

    public HttpResponse HEADResponse(MultiProtocolURL url, boolean concurrent) throws IOException {
        this.currentRequest = new HttpHead(url.toNormalform(true));
        this.setHost(url.getHost());
        this.execute(concurrent);
        return this.httpResponse;
    }

    public void POST(MultiProtocolURL url, InputStream instream, long length, boolean concurrent) throws IOException {
        if (this.currentRequest != null) {
            throw new IOException("Client is in use!");
        }
        this.currentRequest = new HttpPost(url.toNormalform(true));
        String host = url.getHost();
        if (host == null) {
            host = "localhost";
        }
        this.setHost(host);
        NonClosingInputStreamEntity inputStreamEntity = new NonClosingInputStreamEntity(instream, length);
        this.upbytes = length;
        ((HttpPost)this.currentRequest).setEntity((HttpEntity)inputStreamEntity);
        this.execute(concurrent);
    }

    public byte[] POSTbytes(MultiProtocolURL url, String vhost, Map<String, ContentBody> post, boolean usegzip, boolean concurrent) throws IOException {
        return this.POSTbytes(url, vhost, post, null, null, usegzip, concurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] POSTbytes(MultiProtocolURL url, String vhost, Map<String, ContentBody> post, String userName, String password, boolean usegzip, boolean concurrent) throws IOException {
        this.currentRequest = new HttpPost(url.toNormalform(true));
        boolean localhost = Domains.isLocalhost(url.getHost());
        if (!localhost) {
            this.setHost(url.getHost());
        }
        if (vhost == null) {
            this.setHost("localhost");
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (Map.Entry<String, ContentBody> part : post.entrySet()) {
            entityBuilder.addPart(part.getKey(), part.getValue());
        }
        HttpEntity multipartEntity = entityBuilder.build();
        this.upbytes = multipartEntity.getContentLength();
        if (usegzip) {
            ((HttpPost)this.currentRequest).setEntity((HttpEntity)new GzipCompressingEntity(multipartEntity));
        } else {
            ((HttpPost)this.currentRequest).setEntity(multipartEntity);
        }
        if (!localhost || password == null) {
            return this.getContentBytes(Integer.MAX_VALUE, concurrent);
        }
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope("localhost", url.getPort()), (Credentials)new UsernamePasswordCredentials(userName, password));
        try (CloseableHttpClient httpclient = clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultAuthSchemeRegistry(AUTHSCHEMEREGISTRY).build();){
            this.httpResponse = httpclient.execute(this.currentRequest);
            HttpEntity httpEntity = this.httpResponse.getEntity();
            if (httpEntity != null && this.getStatusCode() == 200) {
                byte[] byArray = HTTPClient.getByteArray(httpEntity, Integer.MAX_VALUE);
                return byArray;
            }
        }
        finally {
            this.close();
        }
        return null;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public String getMimeType() {
        int pos;
        Header contentType;
        String mimeType = null;
        if (this.httpResponse != null && (contentType = this.httpResponse.getFirstHeader("Content-Type")) != null && (mimeType = contentType.getValue()) != null && (pos = (mimeType = mimeType.trim().toLowerCase(Locale.ROOT)).indexOf(59)) >= 0) {
            mimeType = mimeType.substring(0, pos);
        }
        return mimeType;
    }

    public String getCharacterEncoding() {
        String[] parts;
        String contentType;
        Header contentTypeHeader;
        String charsetName = null;
        if (this.httpResponse != null && (contentTypeHeader = this.httpResponse.getFirstHeader("Content-Type")) != null && (contentType = contentTypeHeader.getValue()) != null && (parts = CommonPattern.SEMICOLON.split(contentType)) != null && parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                String param = parts[i].trim();
                if (!param.startsWith("charset=")) continue;
                String charset = param.substring("charset=".length()).trim();
                if (charset.length() > 0 && (charset.charAt(0) == '\"' || charset.charAt(0) == '\'')) {
                    charset = charset.substring(1);
                }
                if (charset.endsWith("\"") || charset.endsWith("'")) {
                    charset = charset.substring(0, charset.length() - 1);
                }
                charsetName = charset.trim();
            }
        }
        return charsetName;
    }

    public InputStream getContentstream() throws IOException {
        HttpEntity httpEntity;
        if (this.httpResponse != null && this.currentRequest != null && (httpEntity = this.httpResponse.getEntity()) != null) {
            try {
                return httpEntity.getContent();
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
        return null;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        HttpEntity httpEntity;
        if (this.httpResponse != null && this.currentRequest != null && (httpEntity = this.httpResponse.getEntity()) != null) {
            try {
                httpEntity.writeTo(outputStream);
                outputStream.flush();
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)this.httpResponse.getEntity());
                this.httpResponse.close();
            }
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            if (this.currentRequest != null) {
                ConnectionInfo.removeConnection(this.currentRequest.hashCode());
                this.currentRequest.abort();
                this.currentRequest = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getContentBytes(int maxBytes, boolean concurrent) throws IOException {
        try {
            this.execute(concurrent);
            if (this.httpResponse == null) {
                byte[] byArray = null;
                return byArray;
            }
            HttpEntity httpEntity = this.httpResponse.getEntity();
            if (httpEntity != null && this.getStatusCode() == 200) {
                if (maxBytes >= 0 && httpEntity.getContentLength() > (long)maxBytes) {
                    throw new IOException("Content to download exceed maximum value of " + Formatter.bytesToString(maxBytes));
                }
                byte[] byArray = HTTPClient.getByteArray(httpEntity, maxBytes);
                return byArray;
            }
        }
        finally {
            this.close();
        }
        return null;
    }

    private void execute(boolean concurrent) throws IOException {
        final HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(this.reqConfBuilder.build());
        if (this.host != null) {
            context.setTargetHost(new HttpHost(this.host));
        }
        this.setHeaders();
        this.storeConnectionInfo();
        if (this.currentRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest hrequest = (HttpEntityEnclosingRequest)this.currentRequest;
            HttpEntity entity = hrequest.getEntity();
            assert (entity != null);
            assert (!hrequest.expectContinue());
        }
        String initialThreadName = Thread.currentThread().getName();
        String uri = this.currentRequest.getURI().toString();
        Thread.currentThread().setName("HTTPClient-" + uri);
        long time = System.currentTimeMillis();
        try {
            this.client = clientBuilder.build();
            if (concurrent) {
                FutureTask<CloseableHttpResponse> t = new FutureTask<CloseableHttpResponse>(new Callable<CloseableHttpResponse>(){

                    @Override
                    public CloseableHttpResponse call() throws ClientProtocolException, IOException {
                        CloseableHttpResponse response = HTTPClient.this.client.execute(HTTPClient.this.currentRequest, (HttpContext)context);
                        return response;
                    }
                });
                executor.execute(t);
                try {
                    this.httpResponse = t.get(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    t.cancel(true);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (this.httpResponse == null) {
                    throw new IOException("timout to client after " + this.timeout + "ms for url " + uri);
                }
            } else {
                this.httpResponse = this.client.execute(this.currentRequest, (HttpContext)context);
            }
            this.httpResponse.setHeader("ResponseTimeMillis", Long.toString(System.currentTimeMillis() - time));
        }
        catch (Throwable e) {
            long runtime = System.currentTimeMillis() - time;
            this.close();
            throw new IOException("Client can't execute: " + (e.getCause() == null ? e.getMessage() : e.getCause().getMessage()) + ", timeout=" + this.timeout + ", duration=" + Long.toString(runtime) + ", concurrent=" + Boolean.toString(concurrent) + ", url=" + uri);
        }
        finally {
            Thread.currentThread().setName(initialThreadName);
        }
    }

    public static byte[] getByteArray(HttpEntity entity, int maxBytes) throws IOException {
        try {
            byte[] byArray;
            block20: {
                InputStream instream;
                block18: {
                    byte[] byArray2;
                    block19: {
                        instream = entity.getContent();
                        if (instream != null) break block18;
                        byArray2 = null;
                        if (instream == null) break block19;
                        instream.close();
                    }
                    return byArray2;
                }
                try {
                    long contentLength = entity.getContentLength();
                    if (maxBytes < 0) {
                        maxBytes = Integer.MAX_VALUE;
                    }
                    if (contentLength > (long)maxBytes) {
                        throw new IOException("Content to download exceed maximum value of " + Formatter.bytesToString(maxBytes));
                    }
                    int initialSize = Math.min(maxBytes, (int)contentLength);
                    if (initialSize < 0) {
                        initialSize = 4096;
                    }
                    ByteArrayBuffer buffer = new ByteArrayBuffer(initialSize);
                    byte[] tmp = new byte[4096];
                    int l = 0;
                    long sum = 0L;
                    while ((l = instream.read(tmp)) != -1) {
                        if ((sum += (long)l) > (long)maxBytes) {
                            throw new IOException("Download exceeded maximum value of " + Formatter.bytesToString(maxBytes));
                        }
                        buffer.append(tmp, 0, l);
                    }
                    byArray = buffer.toByteArray();
                    if (instream == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (instream != null) {
                            try {
                                instream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (OutOfMemoryError e) {
                        throw new IOException(e.toString());
                    }
                }
                instream.close();
            }
            return byArray;
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    private void setHeaders() {
        if (this.headers != null) {
            for (Map.Entry<String, String> entry2 : this.headers) {
                this.currentRequest.setHeader(entry2.getKey(), entry2.getValue());
            }
        }
        if (this.host != null) {
            this.currentRequest.setHeader("Host", this.host);
        }
        this.currentRequest.setHeader("Connection", "close");
    }

    private void storeConnectionInfo() {
        int port = this.currentRequest.getURI().getPort();
        String thost = this.currentRequest.getURI().getHost();
        ConnectionInfo.addConnection(new ConnectionInfo(this.currentRequest.getURI().getScheme(), port == -1 ? thost : thost + ":" + port, this.currentRequest.getMethod() + " " + this.currentRequest.getURI().getPath(), this.currentRequest.hashCode(), System.currentTimeMillis(), this.upbytes));
    }

    private static SSLConnectionSocketFactory getSSLSocketFactory() {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
        return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier()){

            protected void prepareSocket(SSLSocket socket) throws IOException {
                if (!ENABLE_SNI_EXTENSION.get()) {
                    SSLParameters sslParams = socket.getSSLParameters();
                    sslParams.setServerNames(Collections.emptyList());
                    socket.setSSLParameters(sslParams);
                }
            }
        };
    }

    private static ConnectionKeepAliveStrategy customKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long keepAlive = super.getKeepAliveDuration(response, context);
                return Math.min(Math.max(keepAlive, 5000L), 25000L);
            }
        };
    }

    public static void main(String[] args) {
        String url = null;
        HTTPClient client = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);
        client.setRedirecting(false);
        for (String string : args) {
            url = string;
            if (!url.toUpperCase().startsWith("HTTP://")) {
                url = "http://" + url;
            }
            try {
                System.out.println(UTF8.String(client.GETbytes(url, null, null, true)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String string : client.getHttpResponse().getAllHeaders()) {
            System.out.println("Header " + string.getName() + " : " + string.getValue());
        }
        System.out.println(client.getHttpResponse().getProtocolVersion());
        System.out.println(client.getHttpResponse().getStatusLine());
        try {
            client.close();
            HTTPClient.closeConnectionManager();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        EXPIRED_CONNECTIONS_EVICTOR.start();
        clientBuilder = HTTPClient.initClientBuilder();
        executor = Executors.newCachedThreadPool(new NamePrefixThreadFactory(HTTPClient.class.getSimpleName() + ".execute"));
    }
}

