/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.lod.vocabulary;

import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.lod.Literal;
import net.yacy.cora.lod.Vocabulary;

public enum CreativeCommons implements Vocabulary
{
    permits(new Literal[]{PermitLiteral.Reproduction, PermitLiteral.Distribution, PermitLiteral.DerivativeWorks, PermitLiteral.Sharing}),
    requires(new Literal[]{RequirementLiteral.Notice, RequirementLiteral.Attribution, RequirementLiteral.ShareAlike, RequirementLiteral.SourceCode, RequirementLiteral.Copyleft, RequirementLiteral.LesserCopyleft}),
    prohibits(new Literal[]{ProhibitionLiteral.CommercialUse, ProhibitionLiteral.HighIncomeNationUse}),
    jurisdiction,
    legalcode,
    deprecatedOn,
    license,
    morePermissions,
    attributionName,
    attributionURL,
    useGuidelines;

    public static final String IDENTIFIER = "http://creativecommons.org/ns#";
    public static final String PREFIX = "cc";
    private final String predicate = "http://creativecommons.org/ns#" + this.name();
    private final Set<Literal> literals;

    private CreativeCommons() {
        this.literals = null;
    }

    private CreativeCommons(Literal[] literals) {
        this.literals = new HashSet<Literal>();
        for (Literal l : literals) {
            this.literals.add(l);
        }
    }

    @Override
    public String getNamespace() {
        return IDENTIFIER;
    }

    @Override
    public String getNamespacePrefix() {
        return PREFIX;
    }

    @Override
    public Set<Literal> getLiterals() {
        return null;
    }

    @Override
    public String getPredicate() {
        return this.predicate;
    }

    @Override
    public String getURIref() {
        return "cc:" + this.name();
    }

    static enum ProhibitionLiteral implements Literal
    {
        CommercialUse("Commercial Use", "http://creativecommons.org/ns#Prohibition", ".*"),
        HighIncomeNationUse("High Income Nation Use", "http://creativecommons.org/ns#Prohibition", ".*");

        String terminal;
        MultiProtocolURL subject;
        Pattern discoveryPattern;

        private ProhibitionLiteral(String terminal, String subject, String discoveryPattern) {
            this.terminal = terminal;
            try {
                this.subject = subject == null ? null : new MultiProtocolURL(subject);
            }
            catch (MalformedURLException e) {
                this.subject = null;
            }
            this.discoveryPattern = Pattern.compile(discoveryPattern == null ? ".*" : discoveryPattern);
        }

        @Override
        public String getTerminal() {
            return this.terminal;
        }

        @Override
        public MultiProtocolURL getSubject() {
            return this.subject;
        }

        @Override
        public Pattern getDiscoveryPattern() {
            return this.discoveryPattern;
        }
    }

    static enum RequirementLiteral implements Literal
    {
        Notice("Notice", "http://creativecommons.org/ns#Requirement", ".*"),
        Attribution("Attribution", "http://creativecommons.org/ns#Requirement", ".*"),
        ShareAlike("Share Alike", "http://creativecommons.org/ns#Requirement", ".*"),
        SourceCode("Source Code", "http://creativecommons.org/ns#Requirement", ".*"),
        Copyleft("Copyleft", "http://creativecommons.org/ns#Requirement", ".*"),
        LesserCopyleft("Lesser Copyleft", "http://creativecommons.org/ns#Requirement", ".*");

        String terminal;
        MultiProtocolURL subject;
        Pattern discoveryPattern;

        private RequirementLiteral(String terminal, String subject, String discoveryPattern) {
            this.terminal = terminal;
            try {
                this.subject = subject == null ? null : new MultiProtocolURL(subject);
            }
            catch (MalformedURLException e) {
                this.subject = null;
            }
            this.discoveryPattern = Pattern.compile(discoveryPattern == null ? ".*" : discoveryPattern);
        }

        @Override
        public String getTerminal() {
            return this.terminal;
        }

        @Override
        public MultiProtocolURL getSubject() {
            return this.subject;
        }

        @Override
        public Pattern getDiscoveryPattern() {
            return this.discoveryPattern;
        }
    }

    static enum PermitLiteral implements Literal
    {
        Reproduction("Reproduction", "http://creativecommons.org/ns#Permission", ".*"),
        Distribution("Distribution", "http://creativecommons.org/ns#Permission", ".*"),
        DerivativeWorks("Derivative Works", "http://creativecommons.org/ns#Permission", ".*"),
        Sharing("Sharing", "http://creativecommons.org/ns#Permission", ".*");

        String terminal;
        MultiProtocolURL subject;
        Pattern discoveryPattern;

        private PermitLiteral(String terminal, String subject, String discoveryPattern) {
            this.terminal = terminal;
            try {
                this.subject = subject == null ? null : new MultiProtocolURL(subject);
            }
            catch (MalformedURLException e) {
                this.subject = null;
            }
            this.discoveryPattern = Pattern.compile(discoveryPattern == null ? ".*" : discoveryPattern);
        }

        @Override
        public String getTerminal() {
            return this.terminal;
        }

        @Override
        public MultiProtocolURL getSubject() {
            return this.subject;
        }

        @Override
        public Pattern getDiscoveryPattern() {
            return this.discoveryPattern;
        }
    }
}

