/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.geo;

import net.yacy.cora.geo.GeoPoint;

public class IntegerGeoPoint
implements GeoPoint {
    private final long latlon;
    private static final double maxint = 2.147483647E9;
    private static final double upscale = 5965232.352777778;

    public IntegerGeoPoint(double lat, double lon) {
        this.latlon = (long)IntegerGeoPoint.coord2int(lat) << 32 | (long)IntegerGeoPoint.coord2int(lon);
    }

    public IntegerGeoPoint(int lat, int lon) {
        this.latlon = (long)IntegerGeoPoint.coord2int((double)lat / 1000000.0) << 32 | (long)IntegerGeoPoint.coord2int((double)lon / 1000000.0);
    }

    @Override
    public double lat() {
        return IntegerGeoPoint.int2coord((int)(this.latlon >>> 32));
    }

    @Override
    public double lon() {
        return IntegerGeoPoint.int2coord((int)(this.latlon & Integer.MAX_VALUE));
    }

    @Override
    public double accuracyLat() {
        return Math.abs(IntegerGeoPoint.int2coord(1) - IntegerGeoPoint.int2coord(2));
    }

    @Override
    public double accuracyLon() {
        return Math.abs(IntegerGeoPoint.int2coord(1) - IntegerGeoPoint.int2coord(2));
    }

    private static final int coord2int(double coord) {
        return (int)((coord + 180.0) * 5965232.352777778);
    }

    private static final double int2coord(int z) {
        return (double)z / 5965232.352777778 - 180.0;
    }

    @Override
    public int hashCode() {
        return (int)((this.latlon & Integer.MAX_VALUE) >> 1) + (int)(this.latlon >> 33);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IntegerGeoPoint)) {
            return false;
        }
        IntegerGeoPoint oo = (IntegerGeoPoint)o;
        return this.latlon == oo.latlon;
    }

    @Override
    public String toString() {
        return "[" + this.lat() + "," + this.lon() + "]";
    }

    public static void main(String[] args) {
        double lat = 13.419444;
        double lon = 52.548611;
        IntegerGeoPoint c = new IntegerGeoPoint(13.419444, 52.548611);
        System.out.println(c.toString() + " #" + c.hashCode());
        System.out.println("error: lat: " + Math.abs(c.lat() - 13.419444) / 9.0E-6 + " meter; lon: " + Math.abs(c.lon() - 52.548611) / 9.0E-6 + " meter");
        System.out.println("accuracyLat = " + c.accuracyLat() / 9.0E-6 + " meter, accuracyLon = " + c.accuracyLon() / 9.0E-6 + " meter");
    }
}

