/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.responsewriter.OpensearchResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.SolrjResponseWriter;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.Response;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.json.JSONObject;

public class YJsonResponseWriter
implements QueryResponseWriter,
SolrjResponseWriter {
    private static final Map<String, String> field2tag = new HashMap<String, String>();
    private String title;

    public void setTitle(String searchPageTitle) {
        this.title = searchPageTitle;
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/json; charset=UTF-8";
    }

    public void init(NamedList n) {
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse rsp) throws IOException {
        NamedList values = rsp.getValues();
        Object responseObj = rsp.getResponse();
        this.write(writer, request, values, responseObj);
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, String coreName, QueryResponse rsp) throws IOException {
        NamedList values = rsp.getResponse();
        SolrDocumentList documents = rsp.getResults();
        this.write(writer, request, values, documents);
    }

    private void write(Writer writer, SolrQueryRequest request, NamedList<?> values, Object responseObj) throws IOException {
        int i;
        DocList documents;
        assert (values.get("response") != null);
        SimpleOrderedMap facetCounts = (SimpleOrderedMap)values.get("facet_counts");
        SimpleOrderedMap facetFields = facetCounts == null || facetCounts.size() == 0 ? null : (SimpleOrderedMap)facetCounts.get("facet_fields");
        Object highlightingObj = values.get("highlighting");
        HashMap<String, Collection<String>> snippets = highlightingObj instanceof NamedList ? OpensearchResponseWriter.snippetsFromHighlighting((NamedList)highlightingObj) : new HashMap();
        OpensearchResponseWriter.ResHead resHead = new OpensearchResponseWriter.ResHead();
        resHead.rows = request.getOriginalParams().getLong("rows", -1L);
        String jsonp = request.getParams().get("callback");
        if (jsonp != null) {
            writer.write(jsonp.toCharArray());
            writer.write("([".toCharArray());
        }
        if (responseObj instanceof ResultContext) {
            documents = ((ResultContext)responseObj).getDocList();
            resHead.offset = documents.offset();
            resHead.numFound = documents.matches();
            this.writeHeader(writer, resHead);
            this.writeDocs(writer, documents, request, snippets);
        } else if (responseObj instanceof SolrDocumentList) {
            documents = (SolrDocumentList)responseObj;
            resHead.offset = documents.getStart();
            resHead.numFound = documents.getNumFound();
            this.writeHeader(writer, resHead);
            this.writeDocs(writer, (SolrDocumentList)documents, snippets);
        } else {
            throw new IOException("Unable to process Solr response format");
        }
        writer.write("],\n".toCharArray());
        writer.write("\"navigation\":[\n");
        NamedList domains = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.host_s.getSolrFieldName());
        NamedList filetypes = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.url_file_ext_s.getSolrFieldName());
        NamedList protocols = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.url_protocol_s.getSolrFieldName());
        NamedList authors = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.author_sxt.getSolrFieldName());
        NamedList collections = facetFields == null ? null : (NamedList)facetFields.get(CollectionSchema.collection_sxt.getSolrFieldName());
        int facetcount = 0;
        if (domains != null) {
            writer.write(facetcount > 0 ? ",\n" : "\n");
            writer.write("{\"facetname\":\"domains\",\"displayname\":\"Provider\",\"type\":\"String\",\"min\":\"0\",\"max\":\"0\",\"mean\":\"0\",\"elements\":[\n".toCharArray());
            for (i = 0; i < domains.size(); ++i) {
                YJsonResponseWriter.facetEntry(writer, "site", domains.getName(i), Integer.toString((Integer)domains.getVal(i)));
                if (i < domains.size() - 1) {
                    writer.write(44);
                }
                writer.write("\n");
            }
            writer.write("]}".toCharArray());
            ++facetcount;
        }
        if (filetypes != null) {
            writer.write(facetcount > 0 ? ",\n" : "\n");
            writer.write("{\"facetname\":\"filetypes\",\"displayname\":\"Filetypes\",\"type\":\"String\",\"min\":\"0\",\"max\":\"0\",\"mean\":\"0\",\"elements\":[\n".toCharArray());
            ArrayList<Map.Entry> l = new ArrayList<Map.Entry>();
            for (Map.Entry e : filetypes) {
                if (((String)e.getKey()).length() <= 6) {
                    l.add(e);
                }
                if (l.size() < 16) continue;
                break;
            }
            for (int i2 = 0; i2 < l.size(); ++i2) {
                Map.Entry e;
                e = (Map.Entry)l.get(i2);
                YJsonResponseWriter.facetEntry(writer, "filetype", (String)e.getKey(), Integer.toString((Integer)e.getValue()));
                if (i2 < l.size() - 1) {
                    writer.write(44);
                }
                writer.write("\n");
            }
            writer.write("]}".toCharArray());
            ++facetcount;
        }
        if (protocols != null) {
            writer.write(facetcount > 0 ? ",\n" : "\n");
            writer.write("{\"facetname\":\"protocols\",\"displayname\":\"Protocol\",\"type\":\"String\",\"min\":\"0\",\"max\":\"0\",\"mean\":\"0\",\"elements\":[\n".toCharArray());
            for (i = 0; i < protocols.size(); ++i) {
                YJsonResponseWriter.facetEntry(writer, "protocol", protocols.getName(i), Integer.toString((Integer)protocols.getVal(i)));
                if (i < protocols.size() - 1) {
                    writer.write(44);
                }
                writer.write("\n");
            }
            writer.write("]}".toCharArray());
            ++facetcount;
        }
        if (authors != null) {
            writer.write(facetcount > 0 ? ",\n" : "\n");
            writer.write("{\"facetname\":\"authors\",\"displayname\":\"Authors\",\"type\":\"String\",\"min\":\"0\",\"max\":\"0\",\"mean\":\"0\",\"elements\":[\n".toCharArray());
            for (i = 0; i < authors.size(); ++i) {
                YJsonResponseWriter.facetEntry(writer, "author", authors.getName(i), Integer.toString((Integer)authors.getVal(i)));
                if (i < authors.size() - 1) {
                    writer.write(44);
                }
                writer.write("\n");
            }
            writer.write("]}".toCharArray());
            ++facetcount;
        }
        if (collections != null) {
            writer.write(facetcount > 0 ? ",\n" : "\n");
            writer.write("{\"facetname\":\"collections\",\"displayname\":\"Collections\",\"type\":\"String\",\"min\":\"0\",\"max\":\"0\",\"mean\":\"0\",\"elements\":[\n".toCharArray());
            for (i = 0; i < collections.size(); ++i) {
                YJsonResponseWriter.facetEntry(writer, "collection", collections.getName(i), Integer.toString((Integer)collections.getVal(i)));
                if (i < collections.size() - 1) {
                    writer.write(44);
                }
                writer.write("\n");
            }
            writer.write("]}".toCharArray());
            ++facetcount;
        }
        writer.write("\n]}]}\n".toCharArray());
        if (jsonp != null) {
            writer.write("])".toCharArray());
        }
    }

    private void writeHeader(Writer writer, OpensearchResponseWriter.ResHead resHead) throws IOException {
        writer.write("{\"channels\": [{\n".toCharArray());
        YJsonResponseWriter.solitaireTag(writer, "totalResults", Long.toString(resHead.numFound));
        YJsonResponseWriter.solitaireTag(writer, "startIndex", Long.toString(resHead.offset));
        YJsonResponseWriter.solitaireTag(writer, "itemsPerPage", Long.toString(resHead.rows));
        YJsonResponseWriter.solitaireTag(writer, "title", this.title);
        YJsonResponseWriter.solitaireTag(writer, "description", "Search Result");
        writer.write("\"items\": [\n".toCharArray());
    }

    private void writeDocs(Writer writer, DocList documents, SolrQueryRequest request, Map<String, Collection<String>> snippets) throws IOException {
        SolrIndexSearcher searcher = request.getSearcher();
        DocIterator iterator = documents.iterator();
        int writtenDocs = 0;
        while (iterator.hasNext()) {
            if (writtenDocs > 0) {
                writer.write(",\n".toCharArray());
            }
            try {
                writer.write("{\n".toCharArray());
                int id = iterator.nextDoc();
                Document doc = searcher.doc(id, OpensearchResponseWriter.SOLR_FIELDS);
                MultiProtocolURL url = null;
                String urlhash = null;
                ArrayList<String> descriptions = new ArrayList<String>();
                String docTitle = "";
                StringBuilder path = new StringBuilder(80);
                ArrayList<Object> imagesProtocolObjs = new ArrayList<Object>();
                ArrayList<String> imagesStubs = new ArrayList<String>();
                for (IndexableField value : doc.getFields()) {
                    String fieldName = value.name();
                    String stag = field2tag.get(fieldName);
                    if (stag != null) {
                        YJsonResponseWriter.solitaireTag(writer, stag, value.stringValue());
                        continue;
                    }
                    if (CollectionSchema.sku.getSolrFieldName().equals(fieldName)) {
                        url = this.writeLink(writer, value.stringValue());
                        continue;
                    }
                    if (CollectionSchema.title.getSolrFieldName().equals(fieldName)) {
                        docTitle = value.stringValue();
                        continue;
                    }
                    if (CollectionSchema.description_txt.getSolrFieldName().equals(fieldName)) {
                        String description = value.stringValue();
                        descriptions.add(description);
                        continue;
                    }
                    if (CollectionSchema.id.getSolrFieldName().equals(fieldName)) {
                        urlhash = value.stringValue();
                        YJsonResponseWriter.solitaireTag(writer, "guid", urlhash);
                        continue;
                    }
                    if (CollectionSchema.url_paths_sxt.getSolrFieldName().equals(fieldName)) {
                        path.append('/').append(value.stringValue());
                        continue;
                    }
                    if (CollectionSchema.last_modified.getSolrFieldName().equals(fieldName)) {
                        Date d = new Date(Long.parseLong(value.stringValue()));
                        YJsonResponseWriter.solitaireTag(writer, "pubDate", HeaderFramework.formatRFC1123(d));
                        continue;
                    }
                    if (CollectionSchema.size_i.getSolrFieldName().equals(fieldName)) {
                        int size = value.stringValue() != null && value.stringValue().length() > 0 ? Integer.parseInt(value.stringValue()) : -1;
                        this.writeSize(writer, size);
                        continue;
                    }
                    if (CollectionSchema.images_protocol_sxt.getSolrFieldName().equals(fieldName)) {
                        imagesProtocolObjs.add(value.stringValue());
                        continue;
                    }
                    if (!CollectionSchema.images_urlstub_sxt.getSolrFieldName().equals(fieldName)) continue;
                    imagesStubs.add(value.stringValue());
                }
                this.writeDocEnd(writer, snippets, url, urlhash, descriptions, docTitle, path, imagesProtocolObjs, imagesStubs);
            }
            catch (Exception ee) {
                ConcurrentLog.logException(ee);
                writer.write("\"description\":\"\"\n}\n");
            }
            ++writtenDocs;
        }
    }

    private void writeDocs(Writer writer, SolrDocumentList documents, Map<String, Collection<String>> snippets) throws IOException {
        int writtenDocs = 0;
        for (SolrDocument doc : documents) {
            if (writtenDocs > 0) {
                writer.write(",\n".toCharArray());
            }
            try {
                writer.write("{\n".toCharArray());
                MultiProtocolURL url = null;
                String urlhash = null;
                ArrayList<String> descriptions = new ArrayList<String>();
                String docTitle = "";
                StringBuilder path = new StringBuilder(80);
                ArrayList<Object> imagesProtocolObjs = new ArrayList<Object>();
                ArrayList<String> imagesStubs = new ArrayList<String>();
                for (Map.Entry fieldEntry : doc) {
                    String fieldName = (String)fieldEntry.getKey();
                    Object value = fieldEntry.getValue();
                    if (value == null) continue;
                    String stag = field2tag.get(fieldName);
                    if (stag != null) {
                        YJsonResponseWriter.solitaireTag(writer, stag, value.toString());
                        continue;
                    }
                    if (CollectionSchema.sku.getSolrFieldName().equals(fieldName)) {
                        url = this.writeLink(writer, value.toString());
                        continue;
                    }
                    if (CollectionSchema.title.getSolrFieldName().equals(fieldName)) {
                        if (value instanceof Iterable) {
                            for (Object valueItem : (Iterable)value) {
                                docTitle = valueItem.toString();
                            }
                            continue;
                        }
                        docTitle = value.toString();
                        continue;
                    }
                    if (CollectionSchema.description_txt.getSolrFieldName().equals(fieldName)) {
                        if (value instanceof Iterable) {
                            for (Object valueItem : (Iterable)value) {
                                String description = valueItem.toString();
                                descriptions.add(description);
                            }
                            continue;
                        }
                        String description = value.toString();
                        descriptions.add(description);
                        continue;
                    }
                    if (CollectionSchema.id.getSolrFieldName().equals(fieldName)) {
                        urlhash = value.toString();
                        YJsonResponseWriter.solitaireTag(writer, "guid", urlhash);
                        continue;
                    }
                    if (CollectionSchema.url_paths_sxt.getSolrFieldName().equals(fieldName)) {
                        if (value instanceof Iterable) {
                            for (Object valueItem : (Iterable)value) {
                                path.append('/').append(valueItem.toString());
                            }
                            continue;
                        }
                        path.append('/').append(value.toString());
                        continue;
                    }
                    if (CollectionSchema.last_modified.getSolrFieldName().equals(fieldName) && value instanceof Date) {
                        YJsonResponseWriter.solitaireTag(writer, "pubDate", HeaderFramework.formatRFC1123((Date)value));
                        continue;
                    }
                    if (CollectionSchema.size_i.getSolrFieldName().equals(fieldName) && value instanceof Integer) {
                        this.writeSize(writer, (Integer)value);
                        continue;
                    }
                    if (CollectionSchema.images_protocol_sxt.getSolrFieldName().equals(fieldName)) {
                        if (value instanceof Iterable) {
                            for (Object valueItem : (Iterable)value) {
                                imagesProtocolObjs.add(valueItem.toString());
                            }
                            continue;
                        }
                        imagesProtocolObjs.add(value.toString());
                        continue;
                    }
                    if (!CollectionSchema.images_urlstub_sxt.getSolrFieldName().equals(fieldName)) continue;
                    if (value instanceof Iterable) {
                        for (Object valueItem : (Iterable)value) {
                            imagesStubs.add(valueItem.toString());
                        }
                        continue;
                    }
                    imagesStubs.add(value.toString());
                }
                this.writeDocEnd(writer, snippets, url, urlhash, descriptions, docTitle, path, imagesProtocolObjs, imagesStubs);
            }
            catch (Exception ee) {
                ConcurrentLog.logException(ee);
                writer.write("\"description\":\"\"\n}\n");
            }
            ++writtenDocs;
        }
    }

    private void writeSize(Writer writer, int size) throws IOException {
        int sizekb = size / 1024;
        int sizemb = sizekb / 1024;
        YJsonResponseWriter.solitaireTag(writer, "size", Integer.toString(size));
        YJsonResponseWriter.solitaireTag(writer, "sizename", sizemb > 0 ? Integer.toString(sizemb) + " mbyte" : (sizekb > 0 ? Integer.toString(sizekb) + " kbyte" : Integer.toString(size) + " byte"));
    }

    private MultiProtocolURL writeLink(Writer writer, String sku) throws IOException {
        MultiProtocolURL url;
        try {
            url = new MultiProtocolURL(sku);
            String filename = url.getFileName();
            YJsonResponseWriter.solitaireTag(writer, "link", sku);
            YJsonResponseWriter.solitaireTag(writer, "file", filename);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }

    private void writeDocEnd(Writer writer, Map<String, Collection<String>> snippets, MultiProtocolURL url, String urlhash, List<String> descriptions, String docTitle, StringBuilder path, List<Object> imagesProtocolObjs, List<String> imagesStubs) throws IOException {
        String snippetstring;
        Collection<String> snippet;
        if (Math.min(imagesProtocolObjs.size(), imagesStubs.size()) > 0) {
            List<String> imagesProtocols = CollectionConfiguration.indexedList2protocolList(imagesProtocolObjs, imagesStubs.size());
            String imageurl = imagesProtocols.get(0) + "://" + imagesStubs.get(0);
            YJsonResponseWriter.solitaireTag(writer, "image", imageurl);
        } else if (url != null && Response.docTypeExt(MultiProtocolURL.getFileExtension(url.getFile()).toLowerCase(Locale.ROOT)) == 'i') {
            YJsonResponseWriter.solitaireTag(writer, "image", url.toNormalform(true));
        }
        YJsonResponseWriter.solitaireTag(writer, "path", path.toString());
        YJsonResponseWriter.solitaireTag(writer, "title", docTitle.length() == 0 ? path.toString() : docTitle.replaceAll("\"", "'"));
        Collection<String> collection = snippet = urlhash == null ? null : snippets.get(urlhash);
        if (snippet == null) {
            snippet = new LinkedHashSet<String>();
            snippet.addAll(descriptions);
        }
        OpensearchResponseWriter.removeSubsumedTitle(snippet, docTitle);
        String string = snippet == null || snippet.size() == 0 ? (descriptions.size() > 0 ? descriptions.get(0) : "") : (snippetstring = OpensearchResponseWriter.getLargestSnippet(snippet));
        if (snippetstring != null && snippetstring.length() > 140) {
            int sp = (snippetstring = snippetstring.substring(0, 140)).lastIndexOf(32);
            snippetstring = sp >= 0 ? snippetstring.substring(0, sp) + " ..." : snippetstring + "...";
        }
        writer.write("\"description\":");
        writer.write(JSONObject.quote(snippetstring));
        writer.write("\n}\n");
    }

    public static void solitaireTag(Writer writer, String tagname, String value) throws IOException {
        if (value == null) {
            return;
        }
        writer.write(34);
        writer.write(tagname);
        writer.write("\":");
        writer.write(JSONObject.quote(value));
        writer.write(44);
        writer.write(10);
    }

    private static void facetEntry(Writer writer, String modifier, String propname, String value) throws IOException {
        modifier = modifier.replaceAll("\"", "'").trim();
        propname = propname.replaceAll("\"", "'").trim();
        writer.write("{\"name\":");
        writer.write(JSONObject.quote(propname));
        writer.write(",\"count\":");
        writer.write(JSONObject.quote(value.replaceAll("\"", "'").trim()));
        writer.write(",\"modifier\":");
        writer.write(JSONObject.quote(modifier + "%3A" + propname));
        writer.write("}");
    }

    static {
        field2tag.put(CollectionSchema.url_protocol_s.getSolrFieldName(), "protocol");
        field2tag.put(CollectionSchema.host_s.getSolrFieldName(), "host");
        field2tag.put(CollectionSchema.url_file_ext_s.getSolrFieldName(), "ext");
    }
}

