/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.logic;

import net.yacy.cora.federate.solr.logic.AbstractOperations;
import net.yacy.cora.federate.solr.logic.Operations;
import net.yacy.cora.federate.solr.logic.Term;
import net.yacy.cora.federate.solr.logic.TermTools;
import org.apache.solr.common.SolrDocument;

public class Conjunction
extends AbstractOperations
implements Operations {
    public Conjunction() {
        super("AND");
    }

    public Conjunction(Term t1, Term t2) {
        super("AND");
        this.addOperand(t1);
        this.addOperand(t2);
    }

    public Object clone() {
        Conjunction c = new Conjunction();
        for (Term t : this.terms) {
            c.addOperand(t);
        }
        return c;
    }

    @Override
    public boolean equals(Object otherTerm) {
        if (!(otherTerm instanceof Conjunction)) {
            return false;
        }
        Conjunction o = (Conjunction)otherTerm;
        for (Term t : this.terms) {
            if (TermTools.isIn(t, o.getOperands())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(SolrDocument doc) {
        for (Term term : this.terms) {
            if (term.matches(doc)) continue;
            return false;
        }
        return true;
    }
}

