/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.instance;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.instance.SolrInstance;
import net.yacy.cora.protocol.http.StrictSizeLimitResponseInterceptor;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Memory;
import net.yacy.kelondro.util.MemoryControl;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class RemoteInstance
implements SolrInstance {
    private static final int DEFAULT_POOLED_CONNECTION_TIME_TO_LIVE = 30;
    private static final int DEFAULT_POOL_MAX_TOTAL = 100;
    public static final PoolingClientConnectionManager CONNECTION_MANAGER = RemoteInstance.buildConnectionManager();
    public static final boolean ENABLE_SNI_EXTENSION_DEFAULT = true;
    public static final AtomicBoolean ENABLE_SNI_EXTENSION = new AtomicBoolean(Boolean.parseBoolean(System.getProperty("jsse.enableSNIExtension", Boolean.toString(true))));
    private static final SchemeRegistry SCHEME_REGISTRY = RemoteInstance.buildTrustSelfSignedSchemeRegistry();
    private String solrurl;
    private final HttpClient client;
    private final String defaultCoreName;
    private final SolrClient defaultServer;
    private final Collection<String> coreNames;
    private final Map<String, SolrClient> server;
    private final int timeout;
    private final boolean concurrentUpdates;

    public static ArrayList<RemoteInstance> getShardInstances(String urlList, Collection<String> coreNames, String defaultCoreName, int timeout, boolean trustSelfSignedOnAuthenticatedServer) throws IOException {
        urlList.replace(' ', ',');
        String[] urls2 = CommonPattern.COMMA.split(urlList);
        ArrayList<RemoteInstance> instances = new ArrayList<RemoteInstance>();
        for (String u : urls2) {
            RemoteInstance instance = new RemoteInstance(u, coreNames, defaultCoreName, timeout, trustSelfSignedOnAuthenticatedServer);
            instances.add(instance);
        }
        return instances;
    }

    public RemoteInstance(String url, Collection<String> coreNames, String defaultCoreName, int timeout, boolean trustSelfSignedOnAuthenticatedServer) throws IOException {
        this(url, coreNames, defaultCoreName, timeout, trustSelfSignedOnAuthenticatedServer, Long.MAX_VALUE, true);
    }

    public RemoteInstance(String url, Collection<String> coreNames, String defaultCoreName, int timeout, boolean trustSelfSignedOnAuthenticatedServer, long maxBytesPerResponse, boolean concurrentUpdates) throws IOException {
        String solrpw;
        String solraccount;
        MultiProtocolURL u;
        this.timeout = timeout;
        this.concurrentUpdates = concurrentUpdates;
        this.server = new HashMap<String, SolrClient>();
        this.solrurl = url == null ? "http://127.0.0.1:8983/solr/" : url;
        ArrayList arrayList = this.coreNames = coreNames == null ? new ArrayList() : coreNames;
        if (this.coreNames.size() == 0) {
            this.coreNames.add("collection1");
            this.coreNames.add("webgraph");
        }
        String string = this.defaultCoreName = defaultCoreName == null ? "collection1" : defaultCoreName;
        if (!this.coreNames.contains(this.defaultCoreName)) {
            this.coreNames.add(this.defaultCoreName);
        }
        if (this.solrurl.endsWith("/")) {
            if (this.solrurl.endsWith(this.defaultCoreName + "/")) {
                this.solrurl = this.solrurl.substring(0, this.solrurl.length() - this.defaultCoreName.length() - 1);
            }
        } else {
            this.solrurl = this.solrurl.endsWith(this.defaultCoreName) ? this.solrurl.substring(0, this.solrurl.length() - this.defaultCoreName.length()) : this.solrurl + "/";
        }
        try {
            u = new MultiProtocolURL(this.solrurl + this.defaultCoreName);
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        String host = u.getHost();
        String userinfo = u.getUserInfo();
        if (userinfo == null || userinfo.isEmpty()) {
            solraccount = "";
            solrpw = "";
        } else {
            int p = userinfo.indexOf(58);
            if (p < 0) {
                solraccount = userinfo;
                solrpw = "";
            } else {
                solraccount = userinfo.substring(0, p);
                solrpw = userinfo.substring(p + 1);
            }
        }
        if (solraccount.length() > 0) {
            this.client = RemoteInstance.buildCustomHttpClient(timeout, u, solraccount, solrpw, host, trustSelfSignedOnAuthenticatedServer, maxBytesPerResponse);
        } else if (u.isHTTPS()) {
            this.client = RemoteInstance.buildCustomHttpClient(timeout, u, solraccount, solrpw, host, true, maxBytesPerResponse);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("followRedirects", false);
            params.set("allowCompression", true);
            params.set("connTimeout", this.timeout);
            params.set("socketTimeout", this.timeout);
            this.client = HttpClientUtil.createClient((SolrParams)params);
            if (this.client instanceof DefaultHttpClient) {
                if (this.client.getParams() != null) {
                    HttpClientParams.setConnectionManagerTimeout((HttpParams)this.client.getParams(), (long)timeout);
                }
                if (maxBytesPerResponse >= 0L && maxBytesPerResponse < Long.MAX_VALUE) {
                    ((DefaultHttpClient)this.client).addResponseInterceptor((HttpResponseInterceptor)new StrictSizeLimitResponseInterceptor(maxBytesPerResponse), ((DefaultHttpClient)this.client).getResponseInterceptorCount());
                }
            }
        }
        this.defaultServer = this.getServer(this.defaultCoreName);
        if (this.defaultServer == null) {
            throw new IOException("cannot connect to url " + url + " and connect core " + defaultCoreName);
        }
    }

    public static void initPoolMaxConnections(PoolingClientConnectionManager pool, int maxConnections) {
        if (pool == null) {
            throw new IllegalArgumentException("pool parameter must not be null");
        }
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("maxConnections parameter must be greater than zero");
        }
        pool.setMaxTotal(maxConnections);
        pool.setDefaultMaxPerRoute((int)(2L * Memory.cores()));
    }

    private static PoolingClientConnectionManager buildConnectionManager() {
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), 30L, TimeUnit.SECONDS);
        RemoteInstance.initPoolMaxConnections(cm, 100);
        return cm;
    }

    private static SchemeRegistry buildTrustSelfSignedSchemeRegistry() {
        SchemeRegistry registry = null;
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build();
            registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(sslContext, (X509HostnameVerifier)AllowAllHostnameVerifier.INSTANCE){

                protected void prepareSocket(SSLSocket socket) throws IOException {
                    if (!ENABLE_SNI_EXTENSION.get()) {
                        SSLParameters sslParams = socket.getSSLParameters();
                        sslParams.setServerNames(Collections.emptyList());
                        socket.setSSLParameters(sslParams);
                    }
                }
            }));
        }
        catch (Exception e) {
            ConcurrentLog.warn("RemoteInstance", "Error when initializing SSL context trusting self-signed certificates.", e);
            registry = null;
        }
        return registry;
    }

    private static HttpClient buildCustomHttpClient(int timeout, final MultiProtocolURL u, String solraccount, String solrpw, String host, final boolean trustSelfSignedCertificates, long maxBytesPerResponse) {
        DefaultHttpClient result = new DefaultHttpClient((ClientConnectionManager)CONNECTION_MANAGER){

            protected HttpContext createHttpContext() {
                HttpContext context = super.createHttpContext();
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                HttpHost targetHost = new HttpHost(u.getHost(), u.getPort(), u.getProtocol());
                authCache.put(targetHost, (AuthScheme)basicAuth);
                context.setAttribute("http.auth.auth-cache", (Object)authCache);
                if (trustSelfSignedCertificates && SCHEME_REGISTRY != null) {
                    context.setAttribute("http.scheme-registry", (Object)SCHEME_REGISTRY);
                }
                this.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
                return context;
            }
        };
        HttpParams params = result.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        HttpClientParams.setConnectionManagerTimeout((HttpParams)params, (long)timeout);
        result.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws IOException {
                if (!request.containsHeader("Accept-Encoding")) {
                    request.addHeader("Accept-Encoding", "gzip");
                }
                if (!request.containsHeader("Connection")) {
                    request.addHeader("Connection", "close");
                }
            }
        });
        result.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws IOException {
                Header ceheader;
                HttpEntity entity = response.getEntity();
                if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                    HeaderElement[] codecs;
                    for (HeaderElement codec : codecs = ceheader.getElements()) {
                        if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                }
            }
        });
        if (solraccount != null && !solraccount.isEmpty()) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(host, -1), (Credentials)new UsernamePasswordCredentials(solraccount, solrpw));
            result.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        if (maxBytesPerResponse >= 0L && maxBytesPerResponse < Long.MAX_VALUE) {
            result.addResponseInterceptor((HttpResponseInterceptor)new StrictSizeLimitResponseInterceptor(maxBytesPerResponse), result.getResponseInterceptorCount());
        }
        return result;
    }

    public int hashCode() {
        return this.solrurl.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RemoteInstance && ((RemoteInstance)o).solrurl.equals(this.solrurl);
    }

    public String getAdminInterface(boolean toExternalAddress, String externalHost) {
        String u = this.solrurl;
        if (toExternalAddress && externalHost != null && !externalHost.trim().isEmpty()) {
            try {
                MultiProtocolURL url = new MultiProtocolURL(u);
                if (url.isLocal()) {
                    url = url.ofNewHost(externalHost);
                    u = url.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return u;
    }

    @Override
    public String getDefaultCoreName() {
        return this.defaultCoreName;
    }

    @Override
    public Collection<String> getCoreNames() {
        return this.coreNames;
    }

    @Override
    public SolrClient getDefaultServer() {
        return this.defaultServer;
    }

    @Override
    public SolrClient getServer(String name) {
        ConcurrentUpdateSolrClient.Builder builder;
        String solrServerURL;
        MultiProtocolURL u;
        SolrClient s = this.server.get(name);
        if (s != null) {
            return s;
        }
        try {
            u = new MultiProtocolURL(this.solrurl + name);
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)u.getUserInfo())) {
            String host = u.getHost();
            int port = u.getPort();
            String solrpath = u.getPath();
            solrServerURL = u.getProtocol() + "://" + host + ":" + port + solrpath;
            ConcurrentLog.info("RemoteSolrConnector", "connecting Solr authenticated with url : " + u);
        } else {
            solrServerURL = u.toString();
            ConcurrentLog.info("RemoteSolrConnector", "connecting Solr with url : " + u);
        }
        if (this.concurrentUpdates) {
            builder = new ConcurrentUpdateSolrClient.Builder(solrServerURL);
            builder.withHttpClient(this.client);
            builder.withQueueSize(RemoteInstance.queueSizeByMemory());
            builder.withThreadCount(Runtime.getRuntime().availableProcessors());
            s = builder.build();
        } else {
            builder = new HttpSolrClient.Builder(solrServerURL);
            builder.withHttpClient(this.client);
            s = builder.build();
        }
        this.server.put(name, s);
        return s;
    }

    @Override
    public void close() {
        for (SolrClient solrClient : this.server.values()) {
            try {
                solrClient.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void closeConnectionManager() {
        if (CONNECTION_MANAGER != null) {
            CONNECTION_MANAGER.shutdown();
        }
    }

    public static int queueSizeByMemory() {
        return (int)Math.min(30L, Math.max(1L, MemoryControl.maxMemory() / 1024L / 1024L / 12L));
    }
}

