/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.instance;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.federate.solr.instance.SolrInstance;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.MemoryControl;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;

public class EmbeddedInstance
implements SolrInstance {
    private static final String[] confFiles = new String[]{"solrconfig.xml", "schema.xml", "stopwords.txt", "synonyms.txt", "protwords.txt", "currency.xml", "elevate.xml", "xslt/example.xsl", "xslt/json.xsl", "lang/"};
    private CoreContainer coreContainer;
    private final String defaultCoreName;
    private final SolrCore defaultCore;
    private final SolrClient defaultCoreServer;
    private final File containerPath;
    private final Map<String, SolrCore> cores;
    private final Map<String, SolrClient> server;

    public EmbeddedInstance(File solr_config, File containerPath, String givenDefaultCoreName, String[] initializeCoreNames) throws IOException {
        File indexDir;
        this.containerPath = containerPath;
        File defaultCorePath = new File(containerPath, givenDefaultCoreName);
        if (!defaultCorePath.exists()) {
            defaultCorePath.mkdirs();
        }
        File oldConf = new File(containerPath, "conf");
        File confDir = new File(defaultCorePath, "conf");
        if (oldConf.exists()) {
            oldConf.renameTo(confDir);
        }
        File oldData = new File(containerPath, "data");
        File dataDir = new File(defaultCorePath, "data");
        if (oldData.exists()) {
            oldData.renameTo(dataDir);
        }
        if (!(indexDir = new File(dataDir, "index")).exists()) {
            indexDir.mkdirs();
        }
        for (String coreName : initializeCoreNames) {
            EmbeddedInstance.initializeCoreConf(solr_config, containerPath, coreName);
        }
        File configFile = new File(solr_config, "solr.xml");
        this.coreContainer = CoreContainer.createAndLoad((Path)containerPath.toPath(), (Path)configFile.toPath());
        if (this.coreContainer == null) {
            throw new IOException("cannot create core container dir = " + containerPath + ", configFile = " + configFile);
        }
        this.defaultCoreName = givenDefaultCoreName;
        ConcurrentLog.info("SolrEmbeddedInstance", "detected default solr core: " + this.defaultCoreName);
        this.defaultCore = this.coreContainer.getCore(this.defaultCoreName);
        assert (givenDefaultCoreName.equals(this.defaultCore.getName())) : "givenDefaultCoreName = " + givenDefaultCoreName + ", this.defaultCore.getName() = " + this.defaultCore.getName();
        if (this.defaultCore == null) {
            throw new IOException("cannot get the default core; available = " + MemoryControl.available() + ", free = " + MemoryControl.free());
        }
        this.defaultCoreServer = new EmbeddedSolrServer(this.coreContainer, this.defaultCoreName);
        this.cores = new ConcurrentHashMap<String, SolrCore>();
        this.cores.put(this.defaultCoreName, this.defaultCore);
        this.server = new ConcurrentHashMap<String, SolrClient>();
        this.server.put(this.defaultCoreName, this.defaultCoreServer);
    }

    public int hashCode() {
        return this.containerPath.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof EmbeddedInstance && this.containerPath.equals(((EmbeddedInstance)o).containerPath);
    }

    private static void initializeCoreConf(File solr_config, File containerPath, String coreName) {
        File target;
        File source;
        File core_properties;
        File corePath = new File(containerPath, coreName);
        if (!corePath.exists()) {
            corePath.mkdirs();
        }
        if (!(core_properties = new File(corePath, "core.properties")).exists()) {
            try (FileOutputStream fos = new FileOutputStream(core_properties);){
                fos.write(ASCII.getBytes("name=" + coreName + "\n"));
                fos.write(ASCII.getBytes("shard=${shard:}\n"));
                fos.write(ASCII.getBytes("collection=${collection:" + coreName + "}\n"));
                fos.write(ASCII.getBytes("config=${solrconfig:solrconfig.xml}\n"));
                fos.write(ASCII.getBytes("schema=${schema:schema.xml}\n"));
                fos.write(ASCII.getBytes("coreNodeName=${coreNodeName:}\n"));
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        File conf = new File(corePath, "conf");
        conf.mkdirs();
        File data = new File(corePath, "data");
        data.mkdirs();
        for (String cf : confFiles) {
            source = new File(solr_config, cf);
            if (source.isDirectory()) {
                target = new File(conf, cf);
                target.mkdirs();
                for (String cfl : source.list()) {
                    try {
                        Files.copy((File)new File(source, cfl), (File)new File(target, cfl));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            target = new File(conf, cf);
            target.getParentFile().mkdirs();
            try {
                Files.copy((File)source, (File)target);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String os = System.getProperty("os.arch");
        if (os.contains("64")) {
            source = new File(solr_config, "solrcore.properties");
        } else {
            source = new File(solr_config, "solrcore.x86.properties");
            if (!source.exists()) {
                source = new File(solr_config, "solrcore.properties");
            }
        }
        target = new File(conf, "solrcore.properties");
        if (source.exists()) {
            try {
                Files.copy((File)source, (File)target);
                ConcurrentLog.fine("initializeCoreConf", "overwrite " + target.getAbsolutePath() + " with " + source.getAbsolutePath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public File getContainerPath() {
        return this.containerPath;
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public String getDefaultCoreName() {
        return this.defaultCoreName;
    }

    @Override
    public Collection<String> getCoreNames() {
        return this.coreContainer.getAllCoreNames();
    }

    @Override
    public SolrClient getDefaultServer() {
        return this.defaultCoreServer;
    }

    @Override
    public SolrClient getServer(String coreName) {
        SolrClient s = this.server.get(coreName);
        if (s != null) {
            return s;
        }
        s = new EmbeddedSolrServer(this.coreContainer, coreName);
        this.server.put(coreName, s);
        return s;
    }

    public SolrCore getDefaultCore() {
        return this.defaultCore;
    }

    public SolrCore getCore(String name) {
        SolrCore c = this.cores.get(name);
        if (c != null) {
            return c;
        }
        c = this.coreContainer.getCore(name);
        this.cores.put(name, c);
        return c;
    }

    @Override
    public synchronized void close() {
        for (SolrCore core : this.cores.values()) {
            core.close();
        }
        if (this.coreContainer != null) {
            try {
                this.coreContainer.shutdown();
                this.coreContainer = null;
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
            }
        }
    }
}

