/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.connector;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.yacy.cora.federate.solr.connector.AbstractSolrConnector;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.federate.solr.instance.ServerShard;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public abstract class SolrServerConnector
extends AbstractSolrConnector
implements SolrConnector {
    protected static final ConcurrentLog log = new ConcurrentLog(SolrServerConnector.class.getName());
    public static final CharArrayMap<Byte> classLoaderSynchro = new CharArrayMap(0, true);
    protected SolrClient server = null;
    private int useluke = 0;

    protected SolrServerConnector() {
    }

    protected void init(SolrClient server) {
        this.server = server;
    }

    public SolrClient getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean softCommit) {
        if (this.server == null) {
            return;
        }
        SolrClient solrClient = this.server;
        synchronized (solrClient) {
            try {
                this.server.commit(true, true, softCommit);
            }
            catch (Throwable e) {
                this.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize(int maxSegments) {
        if (this.server == null) {
            return;
        }
        SolrClient solrClient = this.server;
        synchronized (solrClient) {
            try {
                new UpdateRequest().setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, true, true, maxSegments, true).process(this.server);
            }
            catch (Throwable e) {
                this.clearCaches();
                ConcurrentLog.logException(e);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.server == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.server == null) {
            return;
        }
        try {
            SolrClient solrClient;
            if (this.server instanceof EmbeddedSolrServer) {
                solrClient = this.server;
                synchronized (solrClient) {
                    this.server.commit(true, true, false);
                }
            }
            solrClient = this.server;
            synchronized (solrClient) {
                this.server.close();
            }
            this.server = null;
        }
        catch (Throwable e) {
            ConcurrentLog.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        if (this.server == null) {
            return;
        }
        SolrClient solrClient = this.server;
        synchronized (solrClient) {
            try {
                this.server.deleteByQuery("*:*");
                this.server.commit(true, true, false);
            }
            catch (Throwable e) {
                this.clearCaches();
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String id) throws IOException {
        if (this.server == null) {
            return;
        }
        SolrClient solrClient = this.server;
        synchronized (solrClient) {
            try {
                this.server.deleteById(id, -1);
            }
            catch (Throwable e) {
                this.clearCaches();
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByIds(Collection<String> ids) throws IOException {
        if (this.server == null) {
            return;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String s : ids) {
            l.add(s);
        }
        SolrClient solrClient = this.server;
        synchronized (solrClient) {
            try {
                this.server.deleteById(l, -1);
            }
            catch (Throwable e) {
                this.clearCaches();
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByQuery(String querystring) throws IOException {
        if (this.server == null) {
            return;
        }
        SolrClient solrClient = this.server;
        synchronized (solrClient) {
            try {
                this.server.deleteByQuery(querystring, -1);
            }
            catch (Throwable e) {
                this.clearCaches();
                throw new IOException(e);
            }
        }
    }

    public void add(File file, String solrId) throws IOException {
        ContentStreamUpdateRequest up = new ContentStreamUpdateRequest("/update/extract");
        up.addFile(file, "application/octet-stream");
        up.setParam("literal.id", solrId);
        up.setParam("uprefix", "attr_");
        up.setParam("fmap.content", "attr_content");
        up.setCommitWithin(-1);
        try {
            this.server.request((SolrRequest)up);
        }
        catch (Throwable e) {
            this.clearCaches();
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SolrInputDocument solrdoc) throws IOException, SolrException {
        if (this.server == null) {
            return;
        }
        if (solrdoc.containsKey((Object)"_version_")) {
            solrdoc.setField("_version_", (Object)0L);
        }
        SolrClient solrClient = this.server;
        synchronized (solrClient) {
            try {
                this.server.add(solrdoc);
            }
            catch (Throwable e) {
                this.clearCaches();
                ConcurrentLog.logException(e);
                try {
                    this.server.deleteById((String)solrdoc.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                }
                catch (SolrServerException e1) {
                    ConcurrentLog.logException(e1);
                }
                try {
                    this.server.commit();
                }
                catch (Throwable eee) {
                    ConcurrentLog.logException(eee);
                }
                try {
                    this.server.add(solrdoc);
                }
                catch (Throwable ee) {
                    ConcurrentLog.logException(ee);
                    try {
                        this.server.commit();
                    }
                    catch (Throwable eee) {
                        ConcurrentLog.logException(eee);
                    }
                    try {
                        this.server.add(solrdoc);
                    }
                    catch (Throwable eee) {
                        ConcurrentLog.logException(eee);
                        throw new IOException(eee);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Collection<SolrInputDocument> solrdocs) throws IOException, SolrException {
        if (this.server == null) {
            return;
        }
        for (SolrInputDocument solrdoc : solrdocs) {
            if (!solrdoc.containsKey((Object)"_version_")) continue;
            solrdoc.setField("_version_", (Object)0L);
        }
        SolrClient solrClient = this.server;
        synchronized (solrClient) {
            try {
                this.server.add(solrdocs);
            }
            catch (Throwable e) {
                this.clearCaches();
                ConcurrentLog.logException(e);
                ArrayList<String> ids = new ArrayList<String>();
                for (SolrInputDocument solrdoc : solrdocs) {
                    ids.add((String)solrdoc.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                }
                try {
                    this.server.deleteById(ids);
                }
                catch (SolrServerException e1) {
                    ConcurrentLog.logException(e1);
                }
                try {
                    this.server.commit();
                }
                catch (Throwable eee) {
                    ConcurrentLog.logException(eee);
                }
                try {
                    this.server.add(solrdocs);
                }
                catch (Throwable ee) {
                    ConcurrentLog.logException(ee);
                    ids = new ArrayList();
                    for (SolrInputDocument solrdoc : solrdocs) {
                        ids.add((String)solrdoc.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                    }
                    log.warn(e.getMessage() + " IDs=" + ((Object)ids).toString());
                    throw new IOException(ee);
                }
            }
        }
    }

    @Override
    public SolrDocumentList getDocumentListByParams(ModifiableSolrParams params) throws IOException {
        if (this.server == null) {
            throw new IOException("server disconnected");
        }
        String q = params.get("q");
        String fq = params.get("fq");
        String sort = params.get("sort");
        String fl = params.get("fl");
        String threadname = Thread.currentThread().getName();
        int retry = 0;
        Throwable error = null;
        while (retry++ < 10) {
            try {
                if (q != null) {
                    Thread.currentThread().setName("solr query: q = " + q + (fq == null ? "" : ", fq = " + fq) + (sort == null ? "" : ", sort = " + sort) + "; retry = " + retry + "; fl = " + fl);
                }
                QueryResponse rsp = this.server.query((SolrParams)params);
                if (q != null) {
                    Thread.currentThread().setName(threadname);
                }
                if (rsp != null && log.isFine()) {
                    log.fine(rsp.getResults().getNumFound() + " results for q=" + q);
                }
                return rsp.getResults();
            }
            catch (SolrServerException e) {
                error = e;
            }
            catch (Throwable e) {
                error = e;
                this.clearCaches();
            }
            ConcurrentLog.severe("SolrServerConnector", "Failed to query remote Solr: " + error.getMessage() + ", query:" + q + (fq == null ? "" : ", fq = " + fq));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new IOException("Error executing query", error);
    }

    public Collection<LukeResponse.FieldInfo> getFields() throws SolrServerException {
        return this.getIndexBrowser(false).getFieldInfo().values();
    }

    @Override
    public int getSegmentCount() {
        if (this.server == null) {
            return 0;
        }
        try {
            LukeResponse lukeResponse = this.getIndexBrowser(false);
            NamedList info = lukeResponse.getIndexInfo();
            if (info == null) {
                return 0;
            }
            Integer segmentCount = (Integer)info.get("segmentCount");
            if (segmentCount == null) {
                return 1;
            }
            return segmentCount;
        }
        catch (Throwable e) {
            this.clearCaches();
            log.warn(e);
            return 0;
        }
    }

    @Override
    public long getSize() {
        if (this.server == null) {
            return 0L;
        }
        if (this.server instanceof ServerShard) {
            if (this.useluke == 1) {
                return this.getSizeLukeRequest();
            }
            if (this.useluke == -1) {
                return this.getSizeQueryRequest();
            }
            long ls = this.getSizeLukeRequest();
            long qs = this.getSizeQueryRequest();
            if (ls == 0L && qs == 0L) {
                return 0L;
            }
            if (ls == qs) {
                this.useluke = 1;
                return ls;
            }
            this.useluke = -1;
            return qs;
        }
        return this.getSizeLukeRequest();
    }

    private long getSizeQueryRequest() {
        if (this.server == null) {
            return 0L;
        }
        try {
            QueryResponse rsp = this.getResponseByParams((ModifiableSolrParams)AbstractSolrConnector.catchSuccessQuery);
            if (rsp == null) {
                return 0L;
            }
            SolrDocumentList docs = rsp.getResults();
            if (docs == null) {
                return 0L;
            }
            return docs.getNumFound();
        }
        catch (Throwable e) {
            log.warn(e);
            return 0L;
        }
    }

    private long getSizeLukeRequest() {
        if (this.server == null) {
            return 0L;
        }
        try {
            LukeResponse lukeResponse = this.getIndexBrowser(false);
            if (lukeResponse == null) {
                return 0L;
            }
            Integer numDocs = lukeResponse.getNumDocs();
            if (numDocs == null) {
                return 0L;
            }
            return numDocs.longValue();
        }
        catch (Throwable e) {
            this.clearCaches();
            log.warn(e);
            return 0L;
        }
    }

    private LukeResponse getIndexBrowser(boolean showSchema) throws SolrServerException {
        LukeRequest lukeRequest = new LukeRequest();
        lukeRequest.setResponseParser((ResponseParser)new XMLResponseParser());
        lukeRequest.setNumTerms(0);
        lukeRequest.setShowSchema(showSchema);
        LukeResponse lukeResponse = null;
        try {
            lukeResponse = (LukeResponse)lukeRequest.process(this.server);
        }
        catch (IOException e) {
            throw new SolrServerException(e.getMessage());
        }
        return lukeResponse;
    }

    static {
        assert (classLoaderSynchro != null);
    }
}

