/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.connector;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.yacy.cora.federate.solr.connector.ShardSelection;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.federate.solr.connector.SolrServerConnector;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.federate.solr.instance.ShardInstance;
import net.yacy.cora.federate.solr.instance.SolrInstance;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class RemoteSolrConnector
extends SolrServerConnector
implements SolrConnector {
    private final SolrInstance instance;
    private final String corename;
    private final boolean useBinaryResponseWriter;

    public RemoteSolrConnector(SolrInstance instance, boolean useBinaryResponseWriter) throws IOException {
        this.instance = instance;
        this.useBinaryResponseWriter = useBinaryResponseWriter;
        this.corename = this.instance.getDefaultCoreName();
        SolrClient s = instance.getServer(this.corename);
        super.init(s);
    }

    public RemoteSolrConnector(SolrInstance instance, boolean useBinaryResponseWriter, String corename) {
        this.instance = instance;
        this.useBinaryResponseWriter = useBinaryResponseWriter;
        this.corename = corename == null ? this.instance.getDefaultCoreName() : corename;
        SolrClient s = instance.getServer(this.corename);
        super.init(s);
    }

    public int hashCode() {
        return this.instance.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RemoteSolrConnector && ((RemoteSolrConnector)o).instance.equals(this.instance);
    }

    public SolrInstance getInstance() {
        return this.instance;
    }

    @Override
    public synchronized void close() {
        super.close();
    }

    @Override
    public int bufferSize() {
        return 0;
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public QueryResponse getResponseByParams(ModifiableSolrParams params) throws IOException {
        String q = params.get("q");
        String fq = params.get("fq");
        String threadname = Thread.currentThread().getName();
        if (q != null) {
            Thread.currentThread().setName("Remote solr query: q = " + q + (fq == null ? "" : ", fq = " + fq));
        }
        QueryRequest request = new QueryRequest((SolrParams)params);
        BinaryResponseParser responseParser = this.useBinaryResponseWriter ? new BinaryResponseParser() : new XMLResponseParser();
        request.setResponseParser((ResponseParser)responseParser);
        long t = System.currentTimeMillis();
        NamedList result = null;
        try {
            result = this.server.request((SolrRequest)request);
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage());
        }
        QueryResponse response = new QueryResponse(result, this.server);
        response.setElapsedTime(System.currentTimeMillis() - t);
        if (q != null) {
            Thread.currentThread().setName(threadname);
        }
        return response;
    }

    public static void main(String[] args) {
        try {
            RemoteInstance instance = new RemoteInstance("http://127.0.0.1:8983/solr/", null, "collection1", 10000, false);
            ArrayList<RemoteInstance> instances = new ArrayList<RemoteInstance>();
            instances.add(instance);
            RemoteSolrConnector solr = new RemoteSolrConnector(new ShardInstance(instances, ShardSelection.Method.MODULO_HOST_MD5, true), true, "solr");
            solr.clear();
            File exampleDir = new File("test/parsertest/");
            long a = 0L;
            int c = 0;
            System.out.println("push files in " + exampleDir.getAbsolutePath() + " to Solr");
            for (String s : exampleDir.list()) {
                if (s.startsWith(".")) continue;
                long t = System.currentTimeMillis();
                solr.add(new File(exampleDir, s), s);
                long t0 = System.currentTimeMillis() - t;
                a += t0;
                ++c;
                System.out.println("pushed file " + s + " to solr, " + t0 + " milliseconds");
            }
            System.out.println("pushed " + c + " files in " + a + " milliseconds, " + a / (long)c + " milliseconds average; " + 60000L / a * (long)c + " PPM");
            solr.commit(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

