/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.connector;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.federate.solr.connector.AbstractSolrConnector;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.federate.solr.connector.SolrServerConnector;
import net.yacy.cora.federate.solr.instance.EmbeddedInstance;
import net.yacy.cora.federate.solr.instance.SolrInstance;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RefCounted;

public class EmbeddedSolrConnector
extends SolrServerConnector
implements SolrConnector {
    public static final String SELECT = "/select";
    public static final String CONTEXT = "/solr";
    private final SearchHandler requestHandler;
    private final EmbeddedInstance instance;
    private final SolrCore core;
    private final Map<String, SchemaField> schemaFieldCache = new ConcurrentHashMap<String, SchemaField>();

    public EmbeddedSolrConnector(EmbeddedInstance instance) {
        this.instance = instance;
        this.core = this.instance.getDefaultCore();
        this.requestHandler = new SearchHandler();
        this.requestHandler.init(new NamedList());
        this.requestHandler.inform(this.core);
        super.init(this.instance.getDefaultServer());
    }

    public EmbeddedSolrConnector(EmbeddedInstance instance, String coreName) {
        this.instance = instance;
        this.core = this.instance.getCore(coreName);
        this.requestHandler = new SearchHandler();
        this.requestHandler.init(new NamedList());
        this.requestHandler.inform(this.core);
        super.init(this.instance.getServer(coreName));
    }

    public int hashCode() {
        return this.instance.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof EmbeddedSolrConnector && this.instance.equals(((EmbeddedSolrConnector)o).instance);
    }

    @Override
    public int bufferSize() {
        return 0;
    }

    @Override
    public void clearCaches() {
        SolrCache documentCache;
        SolrCache queryResultCache;
        SolrCache filterCache;
        SolrCache fieldValueCache;
        SolrConfig solrConfig = this.core.getSolrConfig();
        SolrCache solrCache = fieldValueCache = solrConfig.fieldValueCacheConfig == null ? null : solrConfig.fieldValueCacheConfig.newInstance();
        if (fieldValueCache != null) {
            fieldValueCache.clear();
        }
        SolrCache solrCache2 = filterCache = solrConfig.filterCacheConfig == null ? null : solrConfig.filterCacheConfig.newInstance();
        if (filterCache != null) {
            filterCache.clear();
        }
        SolrCache solrCache3 = queryResultCache = solrConfig.queryResultCacheConfig == null ? null : solrConfig.queryResultCacheConfig.newInstance();
        if (queryResultCache != null) {
            queryResultCache.clear();
        }
        SolrCache solrCache4 = documentCache = solrConfig.documentCacheConfig == null ? null : solrConfig.documentCacheConfig.newInstance();
        if (documentCache != null) {
            documentCache.clear();
        }
    }

    public SolrInstance getInstance() {
        return this.instance;
    }

    public SolrCore getCore() {
        return this.core;
    }

    public SolrConfig getConfig() {
        return this.core.getSolrConfig();
    }

    @Override
    public boolean isClosed() {
        return this.core == null || this.core.isClosed();
    }

    @Override
    public synchronized void close() {
        if (this.core != null && !this.core.isClosed()) {
            try {
                this.commit(false);
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
            }
        }
        try {
            super.close();
        }
        catch (Throwable e) {
            ConcurrentLog.logException(e);
        }
    }

    @Override
    public long getSize() {
        RefCounted refCountedIndexSearcher = this.core.getSearcher();
        SolrIndexSearcher searcher = (SolrIndexSearcher)refCountedIndexSearcher.get();
        DirectoryReader reader = searcher.getIndexReader();
        long numDocs = reader.numDocs();
        refCountedIndexSearcher.decref();
        return numDocs;
    }

    public SolrQueryRequest request(SolrParams params) {
        SolrQueryRequestBase req = new SolrQueryRequestBase(this.core, params){};
        req.getContext().put("path", SELECT);
        req.getContext().put("webapp", CONTEXT);
        return req;
    }

    public SolrQueryResponse query(SolrQueryRequest req) throws SolrException {
        long startTime = System.currentTimeMillis();
        String threadname = Thread.currentThread().getName();
        String ql = "";
        try {
            ql = URLDecoder.decode(req.getParams().toString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Thread.currentThread().setName("Embedded solr query: " + ql);
        ConcurrentLog.fine("EmbeddedSolrConnector.query", "QUERY: " + ql);
        SolrQueryResponse rsp = new SolrQueryResponse();
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        responseHeader.add("params", (Object)req.getOriginalParams().toNamedList());
        rsp.add("responseHeader", (Object)responseHeader);
        this.requestHandler.handleRequest(req, rsp);
        Exception exception = rsp.getException();
        int status = exception == null ? 0 : (exception instanceof SolrException ? ((SolrException)((Object)exception)).code() : 500);
        responseHeader.add("status", (Object)status);
        responseHeader.add("QTime", (Object)((int)(System.currentTimeMillis() - startTime)));
        Thread.currentThread().setName(threadname);
        return rsp;
    }

    public SolrDocumentList SolrQueryResponse2SolrDocumentList(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrDocumentList sdl = new SolrDocumentList();
        NamedList nl = rsp.getValues();
        ResultContext resultContext = (ResultContext)nl.get("response");
        DocSlice response = resultContext == null ? new DocSlice(0, 0, new int[0], new float[0], 0L, 0.0f, TotalHits.Relation.EQUAL_TO) : resultContext.getDocList();
        sdl.setNumFound(response == null ? 0L : response.matches());
        sdl.setStart(response == null ? 0L : (long)response.offset());
        String originalName = Thread.currentThread().getName();
        if (response != null) {
            try {
                SolrIndexSearcher searcher = req.getSearcher();
                int responseCount = response.size();
                DocIterator iterator = response.iterator();
                for (int i = 0; i < responseCount; ++i) {
                    int docid = iterator.nextDoc();
                    Thread.currentThread().setName("EmbeddedSolrConnector.SolrQueryResponse2SolrDocumentList: " + docid);
                    Document responsedoc = searcher.doc(docid, (Set)null);
                    SolrDocument sordoc = this.doc2SolrDoc(responsedoc);
                    sdl.add((Object)sordoc);
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        Thread.currentThread().setName(originalName);
        return sdl;
    }

    private final SchemaField getSchemaField(String fieldName) {
        SchemaField sf = this.schemaFieldCache.get(fieldName);
        if (sf == null) {
            sf = this.core.getLatestSchema().getFieldOrNull(fieldName);
            this.schemaFieldCache.put(fieldName, sf);
        }
        return sf;
    }

    public SolrDocument doc2SolrDoc(Document doc) {
        SolrDocument solrDoc = new SolrDocument();
        for (IndexableField field : doc) {
            String fieldName = field.name();
            SchemaField sf = this.getSchemaField(fieldName);
            Object val = null;
            try {
                FieldType ft = null;
                if (sf != null) {
                    ft = sf.getType();
                }
                if (ft == null) {
                    BytesRef bytesRef = field.binaryValue();
                    if (bytesRef != null) {
                        if (bytesRef.offset == 0 && bytesRef.length == bytesRef.bytes.length) {
                            val = bytesRef.bytes;
                        } else {
                            byte[] bytes = new byte[bytesRef.length];
                            System.arraycopy(bytesRef.bytes, bytesRef.offset, bytes, 0, bytesRef.length);
                            val = bytes;
                        }
                    } else {
                        val = field.stringValue();
                    }
                } else {
                    val = ft.toObject(field);
                }
            }
            catch (Throwable e) {
                continue;
            }
            if (sf != null && sf.multiValued() && !solrDoc.containsKey((Object)fieldName)) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(val);
                solrDoc.addField(fieldName, l);
                continue;
            }
            solrDoc.addField(fieldName, val);
        }
        return solrDoc;
    }

    @Override
    public QueryResponse getResponseByParams(ModifiableSolrParams params) throws IOException {
        if (this.server == null) {
            throw new IOException("server disconnected");
        }
        String threadname = Thread.currentThread().getName();
        String ql = "";
        try {
            ql = URLDecoder.decode(params.toString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException | IllegalStateException e) {
            e.printStackTrace();
        }
        Thread.currentThread().setName("Embedded.getResponseByParams solr query: q=" + ql);
        ConcurrentLog.info("EmbeddedSolrConnector.getResponseByParams", "QUERY: " + ql);
        try {
            QueryResponse rsp = this.server.query((SolrParams)params);
            Thread.currentThread().setName(threadname);
            if (rsp != null && log.isFine()) {
                log.fine(rsp.getResults().getNumFound() + " results for " + ql);
            }
            return rsp;
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
        catch (Throwable e) {
            throw new IOException("Error executing query", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SolrDocumentList getDocumentListByParams(ModifiableSolrParams params) throws IOException, SolrException {
        SolrQueryRequest req = this.request((SolrParams)params);
        SolrQueryResponse response = null;
        String q = params.get("q");
        String fq = params.get("fq");
        String sort = params.get("sort");
        String threadname = Thread.currentThread().getName();
        try {
            if (q != null) {
                Thread.currentThread().setName("Embedded.getDocumentListByParams solr query: q = " + q + (fq == null ? "" : ", fq = " + fq) + (sort == null ? "" : ", sort = " + sort));
            }
            response = this.query(req);
            if (q != null) {
                Thread.currentThread().setName(threadname);
            }
            if (response == null) {
                throw new IOException("response == null");
            }
            SolrDocumentList solrDocumentList = this.SolrQueryResponse2SolrDocumentList(req, response);
            return solrDocumentList;
        }
        finally {
            req.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCountByQuery(String querystring) {
        long numFound = 0L;
        try (DocListSearcher docListSearcher = null;){
            docListSearcher = new DocListSearcher(querystring, null, 0, 0, CollectionSchema.id.getSolrFieldName());
            numFound = docListSearcher.response.matches();
        }
        return numFound;
    }

    @Override
    public boolean exists(String id) {
        String query2 = "{!cache=false raw f=" + CollectionSchema.id.getSolrFieldName() + "}" + id;
        DocListSearcher docListSearcher = new DocListSearcher(query2, null, 0, 0, CollectionSchema.id.getSolrFieldName());
        try {
            boolean bl = docListSearcher.response.matches() > 0L;
            docListSearcher.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    docListSearcher.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
                return false;
            }
        }
    }

    @Override
    public String getURL(String id) throws IOException {
        int responseCount = 0;
        try (DocListSearcher docListSearcher = null;){
            DocIterator iterator;
            docListSearcher = new DocListSearcher("{!cache=false raw f=" + CollectionSchema.id.getSolrFieldName() + "}" + id, null, 0, 1, CollectionSchema.id.getSolrFieldName(), CollectionSchema.load_date_dt.getSolrFieldName());
            responseCount = docListSearcher.response.size();
            if (responseCount == 0) {
                String string = null;
                return string;
            }
            SolrIndexSearcher searcher = docListSearcher.request.getSearcher();
            Document doc = searcher.doc((iterator = docListSearcher.response.iterator()).nextDoc(), AbstractSolrConnector.SOLR_ID_and_LOAD_DATE_FIELDS);
            if (doc == null) {
                String string = null;
                return string;
            }
            String string = AbstractSolrConnector.getURL(doc);
            return string;
        }
    }

    private class DocListSearcher
    implements AutoCloseable {
        private SolrQueryRequest request;
        private DocList response;

        public DocListSearcher(String querystring, String sort, int offset, int count, String ... fields) {
            SolrQuery params = AbstractSolrConnector.getSolrQuery(querystring, sort, offset, count, fields);
            this.request = EmbeddedSolrConnector.this.request((SolrParams)params);
            SolrQueryResponse rsp = EmbeddedSolrConnector.this.query(this.request);
            NamedList nl = rsp.getValues();
            ResultContext resultContext = (ResultContext)nl.get("response");
            if (resultContext == null) {
                SolrServerConnector.log.warn("DocListSearcher: no response for query '" + querystring + "'");
            }
            this.response = resultContext == null ? new DocSlice(0, 0, new int[0], new float[0], 0L, 0.0f, TotalHits.Relation.EQUAL_TO) : resultContext.getDocList();
        }

        @Override
        public void close() {
            if (this.request != null) {
                this.request.close();
            }
            this.request = null;
            this.response = null;
        }
    }
}

