/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr;

import net.yacy.cora.federate.solr.SchemaDeclaration;

public final class SolrType
extends Enum<SolrType> {
    public static final /* enum */ SolrType string = new SolrType("s", "sxt");
    public static final /* enum */ SolrType text_general = new SolrType("t", "txt");
    public static final /* enum */ SolrType text_en_splitting_tight = new SolrType(null, null);
    public static final /* enum */ SolrType location = new SolrType("p", null);
    public static final /* enum */ SolrType date = new SolrType("dt", "dts");
    public static final /* enum */ SolrType bool = new SolrType("b", "bs", "boolean");
    public static final /* enum */ SolrType num_integer = new SolrType("i", "val", "int");
    public static final /* enum */ SolrType num_long = new SolrType("l", "ls", "long");
    public static final /* enum */ SolrType num_float = new SolrType("f", "fs", "float");
    public static final /* enum */ SolrType num_double = new SolrType("d", "ds", "double");
    public static final /* enum */ SolrType coordinate = new SolrType("coordinate", "coordinatex", "tdouble");
    private String printName;
    private String singlevalExt;
    private String multivalExt;
    private static final /* synthetic */ SolrType[] $VALUES;

    public static SolrType[] values() {
        return (SolrType[])$VALUES.clone();
    }

    public static SolrType valueOf(String name) {
        return Enum.valueOf(SolrType.class, name);
    }

    private SolrType(String singlevalExt, String multivalExt) {
        this.printName = this.name();
        this.singlevalExt = singlevalExt;
        this.multivalExt = multivalExt;
    }

    private SolrType(String singlevalExt, String multivalExt, String printName) {
        this.printName = printName;
        this.singlevalExt = singlevalExt;
        this.multivalExt = multivalExt;
    }

    public String printName() {
        return this.printName;
    }

    public boolean appropriateName(SchemaDeclaration collectionSchema) {
        boolean ok;
        String field = collectionSchema.name();
        int p = field.indexOf(95);
        if (p < 0 || field.length() - p > 4) {
            return true;
        }
        String ext = field.substring(p + 1);
        boolean bl = ok = collectionSchema.isMultiValued() ? this.multivalExt.equals(ext) : this.singlevalExt.equals(ext);
        assert (ok) : "SolrType = " + this.name() + ", field = " + field + ", ext = " + ext + ", multivalue = " + Boolean.toString(collectionSchema.isMultiValued()) + ", singlevalExt = " + this.singlevalExt + ", multivalExt = " + this.multivalExt;
        if (!ok) {
            return ok;
        }
        boolean bl2 = ok = !"s".equals(this.singlevalExt) || collectionSchema.isMultiValued() || field.endsWith("s");
        assert (ok) : "SolrType = " + this.name() + ", field = " + field + ", ext = " + ext + ", multivalue = " + Boolean.toString(collectionSchema.isMultiValued()) + ", singlevalExt = " + this.singlevalExt + ", multivalExt = " + this.multivalExt;
        if (!ok) {
            return ok;
        }
        boolean bl3 = ok = !"sxt".equals(this.singlevalExt) || !collectionSchema.isMultiValued() || field.endsWith("sxt");
        assert (ok) : "SolrType = " + this.name() + ", field = " + field + ", ext = " + ext + ", multivalue = " + Boolean.toString(collectionSchema.isMultiValued()) + ", singlevalExt = " + this.singlevalExt + ", multivalExt = " + this.multivalExt;
        if (!ok) {
            return ok;
        }
        boolean bl4 = ok = !"t".equals(this.singlevalExt) || collectionSchema.isMultiValued() || field.endsWith("t");
        assert (ok) : "SolrType = " + this.name() + ", field = " + field + ", ext = " + ext + ", multivalue = " + Boolean.toString(collectionSchema.isMultiValued()) + ", singlevalExt = " + this.singlevalExt + ", multivalExt = " + this.multivalExt;
        if (!ok) {
            return ok;
        }
        return ok;
    }

    static {
        $VALUES = new SolrType[]{string, text_general, text_en_splitting_tight, location, date, bool, num_integer, num_long, num_float, num_double, coordinate};
    }
}

