/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.opensearch;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.feed.RSSReader;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.AbstractFederateSearchConnector;
import net.yacy.cora.federate.FederateSearchConnector;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.TextParser;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.Switchboard;
import net.yacy.search.query.QueryParams;
import net.yacy.search.schema.CollectionSchema;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class OpenSearchConnector
extends AbstractFederateSearchConnector
implements FederateSearchConnector {
    private Properties htmlMapping;

    public static String htmlMappingFileName(String instanceName) {
        return instanceName + ".html.map.properties";
    }

    public OpenSearchConnector(String urlTemplate) {
        this.baseurl = urlTemplate;
        this.htmlMapping = new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(String name, String cfgFileName) {
        this.instancename = name;
        this.localcfg = null;
        this.htmlMapping.clear();
        if (cfgFileName != null && !cfgFileName.isEmpty()) {
            BufferedInputStream cfgFileStream = null;
            try {
                cfgFileStream = new BufferedInputStream(new FileInputStream(cfgFileName));
                this.htmlMapping.load(cfgFileStream);
            }
            catch (IOException e) {
                ConcurrentLog.config("OpenSearchConnector." + this.instancename, "Error reading html mapping file : " + cfgFileName, e);
            }
            finally {
                if (cfgFileStream != null) {
                    try {
                        cfgFileStream.close();
                    }
                    catch (IOException e) {
                        ConcurrentLog.config("OpenSearchConnector." + this.instancename, "Error closing html mapping file : " + cfgFileName, e);
                    }
                }
            }
        }
        return true;
    }

    private String parseSearchTemplate(String searchurltemplate, String query2, int start, int rows) {
        String tmps = searchurltemplate.replaceAll("\\?}", "}");
        tmps = tmps.replace("{startIndex}", Integer.toString(start));
        tmps = tmps.replace("{startPage}", "");
        tmps = tmps.replace("{count}", Integer.toString(rows));
        tmps = tmps.replace("{language}", "");
        tmps = tmps.replace("{inputEncoding}", StandardCharsets.UTF_8.name());
        tmps = tmps.replace("{outputEncoding}", StandardCharsets.UTF_8.name());
        return tmps.replace("{searchTerms}", query2);
    }

    protected URIMetadataNode htmlLinkToMetadataNode(Element linkElement) {
        URIMetadataNode doc = null;
        String absoluteURL = linkElement.absUrl("href");
        try {
            if (!absoluteURL.isEmpty()) {
                String mime;
                String targetLang;
                DigestURL uri = new DigestURL(absoluteURL);
                doc = new URIMetadataNode(uri);
                if (linkElement.hasText() && !this.htmlMapping.containsKey("title")) {
                    doc.setField(CollectionSchema.title.getSolrFieldName(), linkElement.text());
                }
                if ((targetLang = linkElement.attr("hreflang")) != null && !targetLang.isEmpty()) {
                    doc.setField(CollectionSchema.language_s.getSolrFieldName(), targetLang);
                }
                if ((mime = TextParser.mimeOf(uri)) != null) {
                    doc.setField(CollectionSchema.content_type.getSolrFieldName(), mime);
                }
                doc.setField(CollectionSchema.collection_sxt.getSolrFieldName(), "dht");
            }
        }
        catch (MalformedURLException e) {
            ConcurrentLog.fine("OpenSearchConnector." + this.instancename, "Malformed url : " + absoluteURL);
        }
        return doc;
    }

    protected List<URIMetadataNode> parseHTMLResult(InputStream resultStream, String charsetName) throws IOException {
        ArrayList<URIMetadataNode> docs = new ArrayList<URIMetadataNode>();
        String resultSelector = this.htmlMapping.getProperty("_result");
        String skuSelector = this.htmlMapping.getProperty("_sku");
        if (resultSelector == null || skuSelector == null) {
            ConcurrentLog.warn("OpenSearchConnector." + this.instancename, "HTML mapping is incomplete!");
            return docs;
        }
        Document jsoupDoc = Jsoup.parse((InputStream)resultStream, (String)charsetName, (String)this.baseurl);
        Elements results = jsoupDoc.select(resultSelector);
        for (Element result : results) {
            URIMetadataNode newDoc;
            Elements links;
            Elements skuNodes = result.select(skuSelector);
            if (skuNodes.isEmpty()) continue;
            Element skuNode = skuNodes.first();
            if (!"a".equals(skuNode.tagName()) && !(links = skuNode.select("a[href]")).isEmpty()) {
                skuNode = links.first();
            }
            if (!skuNode.hasAttr("href") || (newDoc = this.htmlLinkToMetadataNode(skuNode)) == null) continue;
            this.htmlResultToFields(result, newDoc);
            docs.add(newDoc);
        }
        return docs;
    }

    private void htmlResultToFields(Element resultNode, URIMetadataNode newdoc) {
        for (Map.Entry<Object, Object> entry2 : this.htmlMapping.entrySet()) {
            Element node;
            String value;
            CollectionSchema est;
            if (!(entry2.getKey() instanceof String) || !(entry2.getValue() instanceof String)) continue;
            String yacyFieldName = (String)entry2.getKey();
            String selector = (String)entry2.getValue();
            if (yacyFieldName.startsWith("_") || Switchboard.getSwitchboard() != null && Switchboard.getSwitchboard().index != null && !Switchboard.getSwitchboard().index.fulltext().getDefaultConfiguration().contains(yacyFieldName)) continue;
            Elements nodes = resultNode.select(selector);
            try {
                est = CollectionSchema.valueOf(yacyFieldName);
            }
            catch (IllegalArgumentException e) {
                ConcurrentLog.config("OpenSearchConnector." + this.instancename, "Ignored " + yacyFieldName + " field mapping : not a field of this schema.");
                continue;
            }
            if (est.isMultiValued()) {
                if (nodes.isEmpty()) continue;
                for (Element node2 : nodes) {
                    String value2 = node2.text();
                    if (value2.isEmpty()) continue;
                    newdoc.addField(yacyFieldName, value2);
                }
                continue;
            }
            if (nodes.isEmpty() || (value = (node = nodes.first()).text()).isEmpty()) continue;
            try {
                if (est.getType() == SolrType.num_integer) {
                    newdoc.setField(yacyFieldName, Integer.parseInt(value));
                    continue;
                }
                newdoc.setField(yacyFieldName, value);
            }
            catch (NumberFormatException ex) {
            }
        }
    }

    @Override
    public List<URIMetadataNode> query(QueryParams query2) {
        return this.query(query2.getQueryGoal().getQueryString(false), 0, query2.itemsPerPage);
    }

    public List<URIMetadataNode> query(String searchTerms, int startIndex, int count) {
        List<URIMetadataNode> docs = new ArrayList<URIMetadataNode>();
        String searchurl = this.parseSearchTemplate(this.baseurl, searchTerms, startIndex, count);
        try {
            DigestURL aurl = new DigestURL(searchurl);
            try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);){
                this.lastaccesstime = System.currentTimeMillis();
                byte[] result = httpClient.GETbytes(aurl, null, null, false);
                if (result == null) {
                    String details = httpClient.getHttpResponse() != null && httpClient.getHttpResponse().getStatusLine() != null ? " HTTP status code : " + httpClient.getStatusCode() : "";
                    throw new IOException("Could not get a response." + details);
                }
                if ("text/html".equals(httpClient.getMimeType())) {
                    if (this.htmlMapping.isEmpty()) {
                        ConcurrentLog.warn("OpenSearchConnector." + this.instancename, "Received HTML result but mapping is not configured!");
                    } else {
                        docs = this.parseHTMLResult(new ByteArrayInputStream(result), httpClient.getCharacterEncoding());
                    }
                } else {
                    RSSFeed feed2;
                    RSSReader rssReader = RSSReader.parse(10000, result);
                    if (rssReader != null && (feed2 = rssReader.getFeed()) != null) {
                        for (RSSMessage item : feed2) {
                            try {
                                DigestURL uri = new DigestURL(item.getLink());
                                URIMetadataNode doc = new URIMetadataNode(uri);
                                doc.setField(CollectionSchema.charset_s.getSolrFieldName(), StandardCharsets.UTF_8.name());
                                doc.setField(CollectionSchema.author.getSolrFieldName(), item.getAuthor());
                                doc.setField(CollectionSchema.title.getSolrFieldName(), item.getTitle());
                                doc.setField(CollectionSchema.language_s.getSolrFieldName(), item.getLanguage());
                                doc.setField(CollectionSchema.last_modified.getSolrFieldName(), item.getPubDate());
                                String mime = TextParser.mimeOf(uri);
                                if (mime != null) {
                                    doc.setField(CollectionSchema.content_type.getSolrFieldName(), mime);
                                }
                                if (item.getCategory().isEmpty()) {
                                    doc.setField(CollectionSchema.keywords.getSolrFieldName(), Arrays.toString(item.getSubject()));
                                } else {
                                    doc.setField(CollectionSchema.keywords.getSolrFieldName(), Arrays.toString(item.getSubject()) + " " + item.getCategory());
                                }
                                doc.setField(CollectionSchema.publisher_t.getSolrFieldName(), item.getCopyright());
                                doc.setField(CollectionSchema.text_t.getSolrFieldName(), item.getDescriptions());
                                doc.setField(CollectionSchema.collection_sxt.getSolrFieldName(), "dht");
                                if (item.getLat() != 0.0 && item.getLon() != 0.0) {
                                    doc.setField(CollectionSchema.coordinate_p.getSolrFieldName(), item.getLat() + "," + item.getLon());
                                }
                                if (item.getSize() > 0L) {
                                    doc.setField(CollectionSchema.size_i.getSolrFieldName(), item.getSize());
                                }
                                docs.add(doc);
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                        ConcurrentLog.info("OpenSearchConnector." + this.instancename, "received " + docs.size() + " results from " + this.instancename);
                    }
                }
            }
            catch (IOException ex) {
                ConcurrentLog.logException(ex);
                ConcurrentLog.info("OpenSearchConnector." + this.instancename, "no connection to " + searchurl);
            }
        }
        catch (MalformedURLException ee) {
            ConcurrentLog.warn("OpenSearchConnector." + this.instancename, "malformed url " + searchurl);
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            List<URIMetadataNode> docs;
            if (args.length < 2) {
                System.out.println("Usage : java " + OpenSearchConnector.class.getCanonicalName() + " <templateURL> <\"searchTerms\"> [htmlMappingFile]");
                return;
            }
            OpenSearchConnector connector = new OpenSearchConnector(args[0]);
            String htmlMappingFile = args.length > 2 ? args[2] : null;
            connector.init("testConnector", htmlMappingFile);
            String searchTerms = args[1];
            if (searchTerms.length() > 2 && searchTerms.startsWith("\"") && searchTerms.endsWith("\"")) {
                searchTerms = searchTerms.substring(1, searchTerms.length() - 1);
            }
            if ((docs = connector.query(searchTerms, 0, 20)).isEmpty()) {
                System.out.println("No results");
            } else {
                for (URIMetadataNode doc : docs) {
                    System.out.println("title : " + doc.getFieldValue(CollectionSchema.title.getSolrFieldName()));
                    System.out.println("sku : " + doc.getFieldValue(CollectionSchema.sku.getSolrFieldName()));
                    System.out.println("Description : " + doc.getFieldValue(CollectionSchema.description_txt.getSolrFieldName()) + "\n");
                }
            }
        }
        finally {
            Domains.close();
            try {
                HTTPClient.closeConnectionManager();
            }
            catch (InterruptedException interruptedException) {}
            ConcurrentLog.shutdown();
        }
    }
}

