/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.id;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.CommonPattern;

public class DigestURL
extends MultiProtocolURL
implements Serializable {
    public static final DigestURL POISON = new DigestURL();
    private static final long serialVersionUID = -1173233022912141885L;
    private byte[] hash;
    private int hashCache = Integer.MIN_VALUE;

    public static String hosthash(String host, int port) throws MalformedURLException {
        DigestURL url;
        String h = host;
        if (h.indexOf("//") < 0) {
            h = port == 80 || port == 8080 || port == 8090 ? "http://" + h : (port == 443 ? "https://" + h : (port == 21 || port == 2121 ? "ftp://" + h : (port > 999 ? "http://" + h + ":" + port : "http://" + h)));
        }
        return (url = new DigestURL(h)) == null ? null : url.hosthash();
    }

    public static String hosthashes(String hostlist) throws MalformedURLException {
        String[] hs = CommonPattern.COMMA.split(hostlist);
        StringBuilder sb = new StringBuilder(hostlist.length());
        for (String h : hs) {
            if (h == null || (h = h.trim()).isEmpty() || (h = DigestURL.hosthash(h, h.startsWith("ftp.") ? 21 : 80)) == null || h.length() != 6) continue;
            sb.append(h);
        }
        return sb.toString();
    }

    public static Set<String> hosthashess(String hosthashes) {
        if (hosthashes == null || hosthashes.isEmpty()) {
            return null;
        }
        HashSet<String> h = new HashSet<String>();
        assert (hosthashes.length() % 6 == 0);
        for (int i = 0; i < hosthashes.length(); i += 6) {
            h.add(hosthashes.substring(i, i + 6));
        }
        return h;
    }

    private DigestURL() {
        this.hash = null;
    }

    public DigestURL(File file) throws MalformedURLException {
        this("file", "", -1, file.getAbsolutePath());
    }

    public DigestURL(String url) throws MalformedURLException {
        super(url);
        this.hash = null;
    }

    public DigestURL(String url, byte[] hash) throws MalformedURLException {
        super(url);
        this.hash = hash;
    }

    public DigestURL(MultiProtocolURL baseURL, byte[] hash) {
        super(baseURL);
        this.hash = hash;
    }

    public DigestURL(MultiProtocolURL baseURL, String relPath) throws MalformedURLException {
        super(baseURL, relPath);
        this.hash = null;
    }

    public DigestURL(String protocol, String host, int port, String path) throws MalformedURLException {
        super(protocol, host, port, path);
        this.hash = null;
    }

    public static DigestURL newURL(DigestURL baseURL, String relPath) throws MalformedURLException {
        if (relPath.startsWith("//")) {
            String string = relPath = baseURL == null ? "http:" + relPath : baseURL.getProtocol() + ":" + relPath;
        }
        if (baseURL == null || DigestURL.isHTTP(relPath) || DigestURL.isHTTPS(relPath) || DigestURL.isFTP(relPath) || DigestURL.isFile(relPath) || DigestURL.isSMB(relPath)) {
            return new DigestURL(relPath);
        }
        return new DigestURL((MultiProtocolURL)baseURL, relPath);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            this.hashCache = ByteArray.hashCode(this.hash());
        }
        return this.hashCache;
    }

    public static final int flagTypeID(String hash) {
        return (Base64Order.enhancedCoder.decodeByte(hash.charAt(11)) & 0x20) >> 5;
    }

    public static final int flagTLDID(String hash) {
        return (Base64Order.enhancedCoder.decodeByte(hash.charAt(11)) & 0x1C) >> 2;
    }

    public static final int flagLengthID(String hash) {
        return Base64Order.enhancedCoder.decodeByte(hash.charAt(11)) & 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] hash() {
        if (this.hash == null) {
            DigestURL digestURL = this;
            synchronized (digestURL) {
                if (this.hash == null) {
                    this.hash = this.urlHashComputation();
                }
            }
        }
        return this.hash;
    }

    public String hosthash() {
        return ASCII.String(this.hash(), 6, 6);
    }

    private final byte[] urlHashComputation() {
        int l;
        String subdom;
        String dom;
        assert (this.hash == null);
        int id = Domains.getDomainID(this.host, this.hostAddress);
        boolean isHTTP = this.isHTTP();
        int p = this.host == null || this.host.indexOf(58) >= 0 ? -1 : this.host.lastIndexOf(46);
        dom = p > 0 ? (dom = this.host.substring(0, p)) : "";
        if ((p = dom.lastIndexOf(46)) <= 0) {
            subdom = "";
        } else {
            subdom = dom.substring(0, p);
            dom = dom.substring(p + 1);
        }
        String normalizedPath = this.isFile() && this.path.indexOf(92) >= 0 ? this.path.replace('\\', '/') : this.path;
        int rootpathStart = 0;
        int rootpathEnd = normalizedPath.length() - 1;
        if (!normalizedPath.isEmpty() && normalizedPath.charAt(0) == '/') {
            rootpathStart = 1;
        }
        if (normalizedPath.endsWith("/")) {
            rootpathEnd = normalizedPath.length() - 2;
        }
        p = normalizedPath.indexOf(47, rootpathStart);
        String rootpath = "";
        if (p > 0 && p < rootpathEnd) {
            rootpath = normalizedPath.substring(rootpathStart, p);
        }
        int domlengthKey = (l = dom.length()) <= 8 ? 0 : (l <= 12 ? 1 : (l <= 16 ? 2 : 3));
        byte flagbyte = (byte)((isHTTP ? 0 : 32) | id << 2 | domlengthKey);
        StringBuilder hashs = new StringBuilder(12);
        assert (hashs.length() == 0);
        String normalform = this.toNormalform(true, true);
        String b64l = Base64Order.enhancedCoder.encode(Digest.encodeMD5Raw(normalform));
        if (b64l.length() < 5) {
            return null;
        }
        hashs.append(b64l.substring(0, 5));
        assert (hashs.length() == 5);
        hashs.append(DigestURL.subdomPortPath(subdom, this.port, rootpath));
        assert (hashs.length() == 6);
        hashs.append(DigestURL.hosthash5(this.protocol, this.host, this.port));
        assert (hashs.length() == 11);
        hashs.append(Base64Order.enhancedCoder.encodeByte(flagbyte));
        assert (hashs.length() == 12);
        byte[] b = ASCII.getBytes(hashs.toString());
        assert (b.length == 12);
        return b;
    }

    private static char subdomPortPath(String subdom, int port, String rootpath) {
        StringBuilder sb = new StringBuilder(subdom.length() + rootpath.length() + 8);
        sb.append(subdom).append(':').append(Integer.toString(port)).append(':').append(rootpath);
        return Base64Order.enhancedCoder.encode(Digest.encodeMD5Raw(sb.toString())).charAt(0);
    }

    private static final String hosthash5(String protocol, String host, int port) {
        if (host == null) {
            return Base64Order.enhancedCoder.encode(Digest.encodeMD5Raw(protocol)).substring(0, 5);
        }
        boolean isIPv6HostIP = host.indexOf(58) >= 0;
        StringBuilder sb = new StringBuilder(host.length() + 15);
        sb.append(protocol).append(':');
        if (isIPv6HostIP) {
            sb.append('[').append(host).append(']');
        } else {
            sb.append(host);
        }
        sb.append(':').append(Integer.toString(port));
        return Base64Order.enhancedCoder.encode(Digest.encodeMD5Raw(sb.toString())).substring(0, 5);
    }

    private static final String hosthash6(String protocol, String host, int port) {
        int l;
        String dom;
        StringBuilder hash = new StringBuilder(12);
        int id = Domains.getDomainID(host, null);
        int p = host.lastIndexOf(46);
        dom = p > 0 ? (dom = host.substring(0, p)) : "";
        p = dom.lastIndexOf(46);
        if (p > 0) {
            dom = dom.substring(p + 1);
        }
        int domlengthKey = (l = dom.length()) <= 8 ? 0 : (l <= 12 ? 1 : (l <= 16 ? 2 : 3));
        byte flagbyte = (byte)((protocol.equals("http") ? 0 : 32) | id << 2 | domlengthKey);
        hash.append(DigestURL.hosthash5(protocol, host, port));
        hash.append(Base64Order.enhancedCoder.encodeByte(flagbyte));
        return hash.toString();
    }

    public static final String hosthash6(String host) {
        return DigestURL.hosthash6("http", host, 80);
    }

    public static final int domLengthEstimation(byte[] urlHashBytes) {
        assert (urlHashBytes != null);
        assert (urlHashBytes.length == 12) : "urlhash = " + ASCII.String(urlHashBytes);
        byte flagbyte = Base64Order.enhancedCoder.decodeByte(urlHashBytes[11]);
        int domLengthKey = flagbyte & 3;
        switch (domLengthKey) {
            case 0: {
                return 4;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 20;
            }
        }
        return 20;
    }

    public static int domLengthNormalized(byte[] urlHashBytes) {
        return DigestURL.domLengthEstimation(urlHashBytes) << 0;
    }

    @Deprecated
    private static final int domDomain(byte[] urlHash) {
        assert (urlHash != null);
        assert (urlHash.length == 12 || urlHash.length == 6) : "urlhash = " + ASCII.String(urlHash);
        return (Base64Order.enhancedCoder.decodeByte(urlHash[urlHash.length == 12 ? 11 : 5]) & 0x1C) >> 2;
    }

    @Override
    public final boolean isLocal() {
        if (this.isFile()) {
            return true;
        }
        return Domains.isLocal(this.host, this.hostAddress);
    }

    @Deprecated
    public static final boolean isLocal(byte[] urlhash) {
        return DigestURL.domDomain(urlhash) == 7;
    }
}

