/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.id;

import java.net.MalformedURLException;
import java.util.Properties;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;

public class AnchorURL
extends DigestURL {
    private static final long serialVersionUID = 1586579902179962086L;
    private String nameProperty;
    private String relProperty;
    private String textBody;
    private DigestURL imageURL;
    private String imageAlt;

    public AnchorURL(String url) throws MalformedURLException {
        super(url);
        this.textBody = "";
        this.nameProperty = "";
        this.relProperty = "";
        this.imageURL = null;
        this.imageAlt = null;
    }

    public AnchorURL(AnchorURL url) {
        super((MultiProtocolURL)url, url.hash());
        this.textBody = url.textBody;
        this.nameProperty = url.nameProperty;
        this.relProperty = url.relProperty;
        this.imageURL = url.imageURL;
        this.imageAlt = url.imageAlt;
    }

    public AnchorURL(DigestURL url) {
        super((MultiProtocolURL)url, url.hash());
        this.textBody = "";
        this.nameProperty = "";
        this.relProperty = "";
        this.imageURL = null;
        this.imageAlt = null;
    }

    public AnchorURL(MultiProtocolURL baseURL, String relPath) throws MalformedURLException {
        super(baseURL, relPath);
        this.textBody = "";
        this.nameProperty = "";
        this.relProperty = "";
        this.imageURL = null;
        this.imageAlt = null;
    }

    public AnchorURL(String protocol, String host, int port, String path) throws MalformedURLException {
        super(protocol, host, port, path);
        this.textBody = "";
        this.nameProperty = "";
        this.relProperty = "";
        this.imageURL = null;
        this.imageAlt = null;
    }

    public AnchorURL(String protocol, String host, int port, String path, DigestURL imageURL, String imageAlt) throws MalformedURLException {
        super(protocol, host, port, path);
        this.textBody = "";
        this.nameProperty = "";
        this.relProperty = "";
        this.imageURL = imageURL;
        this.imageAlt = imageAlt;
    }

    public static AnchorURL newAnchor(DigestURL baseURL, String relPath) throws MalformedURLException {
        if (relPath.startsWith("//")) {
            String string = relPath = baseURL == null ? "http:" + relPath : baseURL.getProtocol() + ":" + relPath;
        }
        if (baseURL == null || AnchorURL.isHTTP(relPath) || AnchorURL.isHTTPS(relPath) || AnchorURL.isFTP(relPath) || AnchorURL.isFile(relPath) || AnchorURL.isSMB(relPath) || relPath.startsWith("mailto:")) {
            return new AnchorURL(relPath);
        }
        return new AnchorURL((MultiProtocolURL)baseURL, relPath);
    }

    public String getNameProperty() {
        return this.nameProperty;
    }

    public void setNameProperty(String name) {
        this.nameProperty = name;
    }

    public String getTextProperty() {
        return this.textBody;
    }

    public void setTextProperty(String text) {
        this.textBody = text;
    }

    public String getRelProperty() {
        return this.relProperty;
    }

    public void setRelProperty(String rel) {
        this.relProperty = rel;
    }

    public DigestURL getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(DigestURL imageURL) {
        this.imageURL = imageURL;
    }

    public String getImageAlt() {
        return this.imageAlt;
    }

    public void setImageAlt(String imageAlt) {
        this.imageAlt = imageAlt;
    }

    public void setAll(Properties tagopts) {
        this.nameProperty = tagopts.getProperty("name", "");
        this.textBody = tagopts.getProperty("text", "");
        this.relProperty = tagopts.getProperty("rel", "");
    }

    public Properties getAll() {
        Properties tagopts = new Properties();
        tagopts.setProperty("name", this.nameProperty);
        tagopts.setProperty("text", this.textBody);
        tagopts.setProperty("rel", this.relProperty);
        return tagopts;
    }

    public boolean attachedNofollow() {
        return this.relProperty.indexOf("nofollow") >= 0;
    }

    public String toHTML() {
        return "<a href=\"" + this.toNormalform(false) + "\"" + (this.nameProperty.length() > 0 ? " name=\"" + this.nameProperty + "\"" : "") + (this.relProperty.length() > 0 ? " rel=\"" + this.relProperty + "\"" : "") + ">" + this.textBody + "</a>";
    }
}

