/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.feed;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.util.StreamLimitException;
import net.yacy.cora.util.StrictLimitInputStream;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RSSReader
extends DefaultHandler {
    private RSSMessage item;
    private final StringBuilder buffer;
    private boolean parsingChannel;
    private boolean parsingItem;
    private final RSSFeed theChannel;
    private Type type;
    private boolean maxBytesExceeded;
    private static final ThreadLocal<SAXParser> tlSax = new ThreadLocal();

    private RSSReader(int maxsize) {
        this.theChannel = new RSSFeed(maxsize);
        this.buffer = new StringBuilder(300);
        this.item = null;
        this.parsingChannel = false;
        this.parsingItem = false;
        this.type = Type.none;
        this.maxBytesExceeded = false;
    }

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    public RSSReader(int maxsize, InputStream stream) throws IOException {
        this(maxsize);
        if (!(stream instanceof ByteArrayInputStream) && !(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        try {
            SAXParser saxParser = RSSReader.getParser();
            saxParser.getXMLReader().setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            saxParser.parse(stream, (DefaultHandler)this);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public RSSReader(int maxsize, long maxBytes, InputStream stream) throws IOException {
        this(maxsize);
        if (!(stream instanceof ByteArrayInputStream) && !(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        StrictLimitInputStream limitedSource = new StrictLimitInputStream(stream, maxBytes);
        try {
            SAXParser saxParser = RSSReader.getParser();
            saxParser.getXMLReader().setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            saxParser.parse((InputStream)limitedSource, (DefaultHandler)this);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (StreamLimitException e) {
            this.maxBytesExceeded = true;
        }
    }

    public Type getType() {
        return this.type;
    }

    public static RSSReader parse(int maxsize, byte[] a) throws IOException {
        if (a == null || a.length < 100) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(a);
        RSSReader reader = null;
        try {
            reader = new RSSReader(maxsize, bais);
        }
        catch (Exception e) {
            throw new IOException("parse exception: " + e.getMessage(), e);
        }
        try {
            bais.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return reader;
    }

    @Override
    public void startElement(String uri, String name, String tag, Attributes atts) throws SAXException {
        if ("channel".equals(tag)) {
            this.type = Type.rss;
            this.item = new RSSMessage();
            this.parsingChannel = true;
        } else if ("feed".equals(tag)) {
            this.type = Type.atom;
            this.item = new RSSMessage();
            this.parsingChannel = true;
        } else if ("item".equals(tag) || "entry".equals(tag)) {
            if (this.parsingChannel) {
                this.theChannel.setChannel(this.item);
                this.parsingChannel = false;
            }
            this.item = new RSSMessage();
            this.parsingItem = true;
        } else if (this.parsingItem) {
            String url;
            if (this.type == Type.atom) {
                if ("link".equals(tag)) {
                    String url2;
                    String linkRelation = atts.getValue("rel");
                    if (linkRelation == null || linkRelation.equals("alternate")) {
                        String url3 = atts.getValue("href");
                        if (StringUtils.isNotBlank((String)url3)) {
                            this.item.setValue(RSSMessage.Token.link, url3);
                        }
                    } else if ("enclosure".equals(linkRelation) && StringUtils.isNotBlank((String)(url2 = atts.getValue("href")))) {
                        this.item.setEnclosure(url2);
                    }
                }
            } else if (this.type == Type.rss && "enclosure".equals(tag) && StringUtils.isNotBlank((String)(url = atts.getValue("url")))) {
                this.item.setEnclosure(url);
            }
        } else if ("rss".equals(tag)) {
            this.type = Type.rss;
        }
    }

    @Override
    public void endElement(String uri, String name, String tag) throws SAXException {
        if (tag == null) {
            return;
        }
        if ("channel".equals(tag) || "feed".equals(tag)) {
            if (this.parsingChannel) {
                this.theChannel.setChannel(this.item);
            }
            this.parsingChannel = false;
        } else if ("item".equals(tag) || "entry".equals(tag)) {
            this.theChannel.addMessage(this.item);
            this.parsingItem = false;
        } else if (this.parsingItem) {
            String value = this.buffer.toString().trim();
            this.buffer.setLength(0);
            if (RSSMessage.tags.contains(tag) && value.length() > 0) {
                this.item.setValue(RSSMessage.valueOfNick(tag), value);
            }
        } else if (this.parsingChannel) {
            String value = this.buffer.toString().trim();
            this.buffer.setLength(0);
            if (RSSMessage.tags.contains(tag)) {
                this.item.setValue(RSSMessage.valueOfNick(tag), value);
            }
        } else if (this.type == Type.none) {
            throw new SAXException("response incomplete or unknown feed format");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.parsingItem || this.parsingChannel) {
            this.buffer.append(ch, start, length);
        }
    }

    public RSSFeed getFeed() {
        return this.theChannel;
    }

    public boolean isMaxBytesExceeded() {
        return this.maxBytesExceeded;
    }

    public static enum Type {
        rss,
        atom,
        rdf,
        none;

    }
}

