/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.feed;

import java.text.ParseException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.feed.Hit;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.lod.vocabulary.DublinCore;
import net.yacy.cora.lod.vocabulary.Geo;
import net.yacy.cora.lod.vocabulary.YaCyMetadata;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.util.CommonPattern;

public class RSSMessage
implements Hit,
Comparable<RSSMessage>,
Comparator<RSSMessage> {
    private static Map<String, Token> tokenNick2Token = new HashMap<String, Token>();
    private static String artificialGuidPrefix;
    private static String calculatedGuidPrefix;
    public static final RSSMessage POISON;
    public static final HashSet<String> tags;
    private final Map<String, String> map = new HashMap<String, String>();

    public static Token valueOfNick(String nick) {
        return tokenNick2Token.get(nick);
    }

    public RSSMessage(String title, String description, String link) {
        if (title.length() > 0) {
            this.map.put(Token.title.name(), title);
        }
        if (description.length() > 0) {
            this.map.put(Token.description.name(), description);
        }
        if (link.length() > 0) {
            this.map.put(Token.link.name(), link);
        }
        this.map.put(Token.pubDate.name(), HeaderFramework.formatNowRFC1123());
        this.map.put(Token.guid.name(), artificialGuidPrefix + Integer.toHexString((title + description + link).hashCode()));
    }

    public RSSMessage(String title, String description, MultiProtocolURL link, String guid) {
        if (title.length() > 0) {
            this.map.put(Token.title.name(), title);
        }
        if (description.length() > 0) {
            this.map.put(Token.description.name(), description);
        }
        this.map.put(Token.link.name(), link.toNormalform(true));
        this.map.put(Token.pubDate.name(), HeaderFramework.formatNowRFC1123());
        if (guid.length() > 0) {
            this.map.put(Token.guid.name(), guid);
        }
    }

    public RSSMessage() {
    }

    public void setValue(Token token, String value) {
        if (value.length() > 0) {
            this.map.put(token.name(), value);
        }
    }

    @Override
    public String getTitle() {
        return Token.title.valueFrom(this.map, "");
    }

    @Override
    public String getLink() {
        return Token.link.valueFrom(this.map, "");
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof RSSMessage && ((RSSMessage)o).getLink().equals(this.getLink());
    }

    public int hashCode() {
        return this.getLink().hashCode();
    }

    @Override
    public int compareTo(RSSMessage o) {
        return this.getLink().compareTo(o.getLink());
    }

    @Override
    public int compare(RSSMessage o1, RSSMessage o2) {
        return o1.compareTo(o2);
    }

    @Override
    public List<String> getDescriptions() {
        ArrayList<String> ds = new ArrayList<String>();
        String d = Token.description.valueFrom(this.map, "");
        if (d.length() > 0) {
            ds.add(d);
        }
        return ds;
    }

    @Override
    public String getAuthor() {
        return Token.author.valueFrom(this.map, "");
    }

    @Override
    public String getCopyright() {
        return Token.copyright.valueFrom(this.map, "");
    }

    @Override
    public String getCategory() {
        return Token.category.valueFrom(this.map, "");
    }

    @Override
    public String[] getSubject() {
        String subject = Token.subject.valueFrom(this.map, "");
        if (subject.indexOf(44) >= 0) {
            return CommonPattern.COMMA.split(subject);
        }
        if (subject.indexOf(59) >= 0) {
            return CommonPattern.SEMICOLON.split(subject);
        }
        return CommonPattern.SPACES.split(subject);
    }

    @Override
    public String getReferrer() {
        return Token.referrer.valueFrom(this.map, "");
    }

    @Override
    public String getLanguage() {
        return Token.language.valueFrom(this.map, "");
    }

    @Override
    public Date getPubDate() {
        String dateString = Token.pubDate.valueFrom(this.map, "");
        if (!dateString.isEmpty()) {
            Date date;
            try {
                date = Date.from(ZonedDateTime.parse(dateString, HeaderFramework.RFC1123_FORMATTER).toInstant());
            }
            catch (RuntimeException e) {
                try {
                    date = GenericFormatter.SHORT_SECOND_FORMATTER.parse(dateString, 0).getTime();
                }
                catch (ParseException e1) {
                    date = HeaderFramework.parseHTTPDate(dateString);
                }
            }
            return date;
        }
        return null;
    }

    @Override
    public String getGuid() {
        String guid = Token.guid.valueFrom(this.map, "");
        if ((guid.isEmpty() || guid.startsWith(artificialGuidPrefix)) && (this.map.containsKey("title") || this.map.containsKey("description") || this.map.containsKey("link"))) {
            guid = calculatedGuidPrefix + Integer.toHexString(this.getTitle().hashCode() + this.getDescriptions().hashCode() + this.getLink().hashCode());
            this.map.put("guid", guid);
        }
        return guid;
    }

    @Override
    public String getEnclosure() {
        return Token.enclosure.valueFrom(this.map, "");
    }

    public String getTTL() {
        return Token.ttl.valueFrom(this.map, "");
    }

    @Override
    public String getDocs() {
        return Token.docs.valueFrom(this.map, "");
    }

    @Override
    public long getSize() {
        String size = Token.size.valueFrom(this.map, "-1");
        return size == null || size.isEmpty() ? -1L : Long.parseLong(size);
    }

    public String getFulltext() {
        StringBuilder sb = new StringBuilder(300);
        for (String s : this.map.values()) {
            sb.append(s).append(' ');
        }
        return sb.toString();
    }

    @Override
    public double getLon() {
        return Double.parseDouble(Token.lon.valueFrom(this.map, "0.0"));
    }

    @Override
    public double getLat() {
        return Double.parseDouble(Token.lat.valueFrom(this.map, "0.0"));
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withItemTag) {
        StringBuilder sb = new StringBuilder();
        if (withItemTag) {
            sb.append("<item>\n");
        }
        if (this.map.containsKey(Token.title.name())) {
            sb.append("<title>").append(this.map.get(Token.title.name())).append("</title>\n");
        }
        if (this.map.containsKey(Token.link.name())) {
            sb.append("<link>").append(this.map.get(Token.link.name())).append("</link>\n");
        }
        if (this.map.containsKey(Token.description.name())) {
            sb.append("<description>").append(this.map.get(Token.description.name())).append("</description>\n");
        }
        if (this.map.containsKey(Token.pubDate.name())) {
            sb.append("<pubDate>").append(this.map.get(Token.pubDate.name())).append("</pubDate>\n");
        }
        if (this.map.containsKey(Token.guid.name())) {
            sb.append("<guid isPermaLink=\"false\">").append(this.map.get(Token.guid.name())).append("</guid>\n");
        }
        if (withItemTag) {
            sb.append("</item>\n");
        }
        return sb.toString();
    }

    @Override
    public void setAuthor(String author) {
        this.setValue(Token.author, author);
    }

    @Override
    public void setCategory(String category) {
        this.setValue(Token.category, category);
    }

    @Override
    public void setCopyright(String copyright) {
        this.setValue(Token.copyright, copyright);
    }

    @Override
    public void setSubject(String[] tags) {
        StringBuilder sb = new StringBuilder(tags.length * 10);
        for (String tag : tags) {
            sb.append(tag).append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        this.setValue(Token.subject, sb.toString());
    }

    @Override
    public void setDescription(String description) {
        this.setValue(Token.description, description);
    }

    @Override
    public void setDocs(String docs) {
        this.setValue(Token.docs, docs);
    }

    @Override
    public void setGuid(String guid) {
        this.setValue(Token.guid, guid);
    }

    @Override
    public void setEnclosure(String enclosure) {
        this.setValue(Token.enclosure, enclosure);
    }

    @Override
    public void setLanguage(String language) {
        this.setValue(Token.language, language);
    }

    @Override
    public void setLink(String link) {
        this.setValue(Token.link, link);
    }

    @Override
    public void setPubDate(Date pubdate) {
        this.setValue(Token.pubDate, HeaderFramework.formatNowRFC1123());
    }

    @Override
    public void setReferrer(String referrer) {
        this.setValue(Token.referrer, referrer);
    }

    @Override
    public void setSize(long size) {
        this.setValue(Token.size, Long.toString(size));
    }

    @Override
    public void setTitle(String title) {
        this.setValue(Token.title, title);
    }

    public static String sizename(int size) {
        if (size < 1024) {
            return size + " bytes";
        }
        if ((size /= 1024) < 1024) {
            return size + " kbyte";
        }
        if ((size /= 1024) < 1024) {
            return size + " mbyte";
        }
        return (size /= 1024) + " gbyte";
    }

    static {
        for (Token t : Token.values()) {
            for (String nick : t.keys) {
                tokenNick2Token.put(nick, t);
            }
        }
        artificialGuidPrefix = "c0_";
        calculatedGuidPrefix = "c1_";
        POISON = new RSSMessage("", "", "");
        tags = new HashSet();
        for (Token token : Token.values()) {
            tags.addAll(token.keys());
        }
    }

    public static enum Token {
        title(new String[]{"title", "atom:title", "rss:title", DublinCore.Title.getURIref()}),
        link(new String[]{"link", "atom:link", "rss:link"}),
        description(new String[]{"description", "subtitle", "atom:subtitle", "rss:description", DublinCore.Description.getURIref()}),
        pubDate(new String[]{"pubDate", "lastBuildDate", "updated", "rss:lastBuildDate", "rss:updated"}),
        copyright(new String[]{"copyright", "publisher", DublinCore.Publisher.getURIref()}),
        author(new String[]{"author", "creator", DublinCore.Creator.getURIref()}),
        subject(new String[]{"subject", DublinCore.Subject.getURIref()}),
        category(new String[]{"category"}),
        referrer(new String[]{"referrer", "referer"}),
        language(new String[]{"language", DublinCore.Language.getURIref()}),
        guid(new String[]{"guid"}),
        enclosure(new String[]{"enclosure"}),
        ttl(new String[]{"ttl"}),
        docs(new String[]{"docs"}),
        size(new String[]{"size", "length", YaCyMetadata.size.getURIref()}),
        lon(new String[]{Geo.Long.getURIref(), "geo:lon"}),
        lat(new String[]{Geo.Lat.getURIref()});

        private Set<String> keys = new HashSet<String>();

        private Token(String[] keylist) {
            this.keys.addAll(Arrays.asList(keylist));
            this.keys.add(this.name());
        }

        public String valueFrom(Map<String, String> map, String dflt) {
            for (String key : this.keys) {
                String value = map.get(key);
                if (value == null) continue;
                return value;
            }
            return dflt;
        }

        public Set<String> keys() {
            return this.keys;
        }

        public String toString() {
            return this.keys.size() == 0 ? "" : this.keys.iterator().next();
        }
    }
}

