/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.feed;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.id.MultiProtocolURL;

public class RSSFeed
implements Iterable<RSSMessage> {
    public static final int DEFAULT_MAXSIZE = 10000;
    private RSSMessage channel = null;
    private final Map<String, RSSMessage> messages = Collections.synchronizedMap(new LinkedHashMap());
    private final int maxsize;
    private boolean maxSizeExceeded;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<rss version=\"2.0\"\n");
        sb.append("  xmlns:opensearch=\"http://a9.com/-/spec/opensearch/1.1/\"\n");
        sb.append("  xmlns:atom=\"http://www.w3.org/2005/Atom\"\n");
        sb.append(">\n");
        sb.append("<channel>\n");
        if (this.channel != null) {
            sb.append(this.channel.toString(false));
        }
        sb.append("<opensearch:startIndex>0</opensearch:startIndex>\n");
        sb.append("<opensearch:itemsPerPage>" + this.size() + "</opensearch:itemsPerPage>\n");
        sb.append("<opensearch:totalResults>" + this.size() + "</opensearch:totalResults>\n");
        for (RSSMessage item : this.messages.values()) {
            sb.append(item.toString());
        }
        sb.append("</channel>\n");
        sb.append("</rss>\n");
        return sb.toString();
    }

    public RSSFeed(int maxsize) {
        this.maxsize = maxsize;
        this.maxSizeExceeded = false;
    }

    public RSSFeed(Set<MultiProtocolURL> links, String source) {
        this(Integer.MAX_VALUE);
        for (MultiProtocolURL uri : links) {
            String u = uri.toNormalform(true);
            RSSMessage message2 = new RSSMessage(u, "", u);
            message2.setAuthor(source);
            this.addMessage(message2);
        }
    }

    public void setChannel(RSSMessage channelItem) {
        this.channel = channelItem;
    }

    public RSSMessage getChannel() {
        if (this.channel == null) {
            this.channel = new RSSMessage();
        }
        return this.channel;
    }

    public Set<MultiProtocolURL> getLinks() {
        HashSet<MultiProtocolURL> links = new HashSet<MultiProtocolURL>();
        for (RSSMessage message2 : this.messages.values()) {
            try {
                links.add(new MultiProtocolURL(message2.getLink()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return links;
    }

    public void addMessage(RSSMessage item) {
        String guid = item.getGuid();
        this.messages.put(guid, item);
        while (this.messages.size() > this.maxsize) {
            this.maxSizeExceeded = true;
            this.pollMessage();
        }
    }

    public RSSMessage getMessage(String guid) {
        return this.messages.get(guid);
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isMaxSizeExceeded() {
        return this.maxSizeExceeded;
    }

    @Override
    public Iterator<RSSMessage> iterator() {
        return new messageIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSSMessage pollMessage() {
        Map<String, RSSMessage> map = this.messages;
        synchronized (map) {
            String nextGUID;
            if (this.messages.isEmpty()) {
                return null;
            }
            String string = nextGUID = this.messages.keySet().size() == 0 ? null : this.messages.keySet().iterator().next();
            if (nextGUID == null) {
                return null;
            }
            return this.messages.remove(nextGUID);
        }
    }

    public class messageIterator
    implements Iterator<RSSMessage> {
        Iterator<String> GUIDiterator;
        String lastGUID;
        int t;

        public messageIterator() {
            this.t = RSSFeed.this.messages.size();
            this.GUIDiterator = RSSFeed.this.messages.keySet().iterator();
            this.lastGUID = null;
        }

        @Override
        public boolean hasNext() {
            if (this.t <= 0) {
                return false;
            }
            return this.GUIDiterator.hasNext();
        }

        @Override
        public RSSMessage next() {
            --this.t;
            try {
                this.lastGUID = this.GUIDiterator.next();
            }
            catch (ConcurrentModificationException e) {
                this.lastGUID = null;
            }
            if (this.lastGUID == null) {
                return null;
            }
            return (RSSMessage)RSSFeed.this.messages.get(this.lastGUID);
        }

        @Override
        public void remove() {
            if (this.lastGUID == null) {
                return;
            }
            this.GUIDiterator.remove();
            RSSFeed.this.messages.remove(this.lastGUID);
        }
    }
}

